/* This file was generated by scm2c from source file "handle.scm" */
/*  "handle.scm" WB-tree File Based Associative String Data Base System. */
/*  Copyright (C) 1991, 1992, 1993, 2000, 2007, 2010 Free Software Foundation, Inc. */
/*  */
/*  This program is free software: you can redistribute it and/or modify */
/*  it under the terms of the GNU Lesser General Public License as */
/*  published by the Free Software Foundation, either version 3 of the */
/*  License, or (at your option) any later version. */
/*  */
/*  This program is distributed in the hope that it will be useful, but */
/*  WITHOUT ANY WARRANTY; without even the implied warranty of */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU */
/*  Lesser General Public License for more details. */
/*  */
/*  You should have received a copy of the GNU Lesser General Public */
/*  License along with this program.  If not, see */
/*  <http://www.gnu.org/licenses/>. */

/*  routines in this file return success codes */


#include "wbsys.h"


int clever_cache_enable_P = !0;


int han_error_P(HAND *han,char *caller)
{
  if (!(han))
    {
      dprintf((diagout,
	 ">>>>ERROR<<<< %s: called with NULL handle.\n",
	 caller));
      return !0;
    }
  else if (!(han_seg(han)))
    {
      dprintf((diagout,
	 ">>>>ERROR<<<< %s: called with handle having NULL segment.\n",
	 caller));
      return !0;
    }
  else return 0;
}


int key_error_P(unsigned char *key_str,int k_len,int xcpt,char *caller)
{
  if ((xcpt)==(k_len))
    return 0;
  else if (!((0<=(k_len))
        && ((k_len)<=0xff)))
    {
      dprintf((diagout,
	 "\
>>>>ERROR<<<< %s: key-length, %d, was out of range 0 <= 255.\n",
	 caller,
	 k_len));
      return !0;
    }
  else if ((0 < (k_len))
      && (0xff==((((unsigned char*)(key_str))[0]))))
    {
      dprintf((diagout,
	 ">>>>ERROR<<<< %s: first byte of key must not be 255.\n",
	 caller));
      return !0;
    }
  else return 0;
}


int bt_get(HAND *han,unsigned char *key_str,int k_len,unsigned char *ans_str)
{
  int pkt[pkt_size];
  ENTRY *ent = 0;
  if (key_error_P(key_str, k_len, 0, "bt_get"))
    return keyerr;
  else if (han_error_P(han, "bt_get"))
    return argerr;
  else {
    ent = chain_find_ent(han, accread, key_str, k_len, pkt);
    if (!(ent))
      {
	get_fct = 0x1L+(get_fct);
	return unkerr;
      }
    else if ((pkt_match_type(pkt))!=(match))
      {
	get_ct = 0x1L+(get_ct);
	release_ent(ent, accread);
	return notpres;
      }
    else {
      int alen = get_this_val(ent_blk(ent), pkt_match_pos(pkt), ans_str);
      get_ct = 0x1L+(get_ct);
      release_ent(ent, accread);
      return alen;
    }
  }
}


int bt_next(HAND *han,unsigned char *key_str,int k_len,unsigned char *ans_str)
{
  int pkt[pkt_size];
  ENTRY *ent = 0;
  if (key_error_P(key_str, k_len,  -2, "bt_next"))
    return keyerr;
  else if (han_error_P(han, "bt_next"))
    return argerr;
  else {
    ent = chain_find_ent(han, accread, key_str, k_len, pkt);
    if (!(ent))
      {
	next_fct = 0x1L+(next_fct);
	return unkerr;
      }
    else {
      next_ct = 0x1L+(next_ct);
      {
	int res = chain_next(ent, key_str, k_len, ans_str, pkt);
	if (clever_cache_enable_P)
	  han_set_last(han, pkt_blk_to_cache(pkt));
	return res;
      }
    }
  }
}


int bt_prev(HAND *han,unsigned char *key_str,int k_len,unsigned char *ans_str)
{
  int pkt[pkt_size];
  ENTRY *ent = 0;
  if (key_error_P(key_str, k_len,  -1, "bt_prev"))
    return keyerr;
  else if (han_error_P(han, "bt_prev"))
    return argerr;
  else {
    ent = chain_find_prev_ent(han, accread, key_str, k_len, pkt);
    if (ent)
      ent = prev_prev_k_ent(ent, key_str, k_len, leaf, pkt);
    if (!(ent))
      {
	prev_fct = 0x1L+(prev_fct);
	return unkerr;
      }
    else {
      prev_ct = 0x1L+(prev_ct);
      if (!(pkt_match_pos(pkt)))
	{
	  release_ent(ent, accread);
	  return notpres;
	}
      else {
	int k_len2 = recon_this_key(ent_blk(ent), pkt_match_pos(pkt), ans_str, 0, 0x100);
	han_set_last(han, ent_id(ent));
	release_ent(ent, accread);
	return k_len2;
      }
    }
  }
}


int bt_rem(HAND *han,unsigned char *key_str,int k_len,unsigned char *ans_str)
{
  int pkt[pkt_size];
  ENTRY *ent = 0;
  if (key_error_P(key_str, k_len, 0, "bt_rem"))
    return keyerr;
  else if (han_error_P(han, "bt_rem"))
    return argerr;
  else {
    ent = chain_find_ent(han, accwrite, key_str, k_len, pkt);
    if (!(ent))
      {
	rem_fct = 0x1L+(rem_fct);
	return unkerr;
      }
    else {
      rem_ct = 0x1L+(rem_ct);
      {
	int ans = del_chain_rem(ent, key_str, k_len, ans_str, pkt, han_wcb(han));
	release_ent(ent, accwrite);
	return ans;
      }
    }
  }
}

/*  To make possible bounded-time operation, @0 will purge at most */
/*  BLK-LIMIT blocks at a time; passing BLK-LIMIT of -1 imposes no */
/*  limit. */


int bt_rem_range(HAND *han,unsigned char *key_str,int k_len,unsigned char *key2_str,int k2_len)
{
  int respkt[pkt_size];
  pkt_set_skey_count(respkt, 0);
  return bt_scan(han, rem_scan, key_str, k_len, key2_str, k2_len, 0, 0, respkt,  -1);
}


int bt_put(HAND *han,unsigned char *key_str,int k_len,unsigned char *val_str,int v_len)
{
  ENTRY *ent = 0;
  int pkt[pkt_size];
  if (key_error_P(key_str, k_len, 0, "bt_put"))
    return keyerr;
  else if (han_error_P(han, "bt_put"))
    return argerr;
  else if (!((0<=(v_len))
        && ((v_len)<=0xff)))
    return argerr;
  else {
    ent = chain_find_ent(han, accwrite, key_str, k_len, pkt);
    if (!(ent))
      return unkerr;
    else {
      int res_P = chain_put(ent, key_str, k_len, val_str, v_len, pkt, 0, han_wcb(han));
      if (res_P)
	{
	  if (clever_cache_enable_P)
	    han_set_last(han, pkt_blk_to_cache(pkt));
	  put_ct = 0x1L+(put_ct);
	  return success;
	}
      else {
	put_fct = 0x1L+(put_fct);
	return unkerr;
      }
    }
  }
}


int bt_write(HAND *han,unsigned char *key_str,int k_len,unsigned char *val_str,int v_len)
{
  ENTRY *ent = 0;
  int pkt[pkt_size];
  if (key_error_P(key_str, k_len, 0, "bt_write"))
    return keyerr;
  else if (han_error_P(han, "bt_write"))
    return argerr;
  else if (!((0<=(v_len))
        && ((v_len)<=0xff)))
    return argerr;
  else {
    ent = chain_find_ent(han, accwrite, key_str, k_len, pkt);
    if (!(ent))
      return unkerr;
    else if ((pkt_match_type(pkt))==(match))
      {
	release_ent(ent, accwrite);
	return notpres;
      }
    else {
      int res_P = chain_put(ent, key_str, k_len, val_str, v_len, pkt, 0, han_wcb(han));
      if (res_P)
	{
	  if (clever_cache_enable_P)
	    han_set_last(han, pkt_blk_to_cache(pkt));
	  put_ct = 0x1L+(put_ct);
	  return success;
	}
      else {
	put_fct = 0x1L+(put_fct);
	return unkerr;
      }
    }
  }
}
