dnl Copyright (C) 1999-2001 Open Source Telecom Corporation.
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

AC_DEFUN(OST_OPENH323,[
	OPENH323_FLAGS=
	OPENH323_LIBS=
	ost_cv_openh323=false
	AC_MSG_CHECKING([for openh323 libraries])
	if test -z "$OPENH323DIR" ; then
		if test -d /usr/openh323 ; then
			export OPENH323DIR=/usr/openh323
		elif test -d /usr/include/openh323 ; then
			export OPENH323DIR=/usr/include/openh323
		else
			export OPENH323DIR=~/openh323
		fi
	fi
	if test -z "$PWLIBDIR" ; then
		if test -d /usr/share/pwlib ; then
			export PWLIBDIR=~/pwlib
		else
			export PWLIBDIR=~/pwlib
		fi
		if test -d $PWLIBDIR/include ; then
			OPENH323_FLAGS="-I$PWLIBDIR/include/unix -I$PWLIBDIR/include"
		elif test -d /usr/include/ptlib ; then
			OPENH323_FLAGS="-I/usr/include/ptlib/unix -I/usr/include/ptlib"
		fi
	elif test -d $PWLIBDIR/include ; then
			OPENH323_FLAGS="-I$PWLIB/include/unix -I$PWLIBDIR/include"
	fi
	if test -d "$OPENH323DIR" ; then
		ost_cv_openh323=true
		if test -d /usr/include/openh323 ; then
 			OPENH323_FLAGS="$OPENH323_FLAGS -I/usr/include/openh323"
		else
			OPENH323_FLAGS="$OPENH323_FLAGS -I$OPENH323DIR/include"
		fi
		OPENH323_FLAGS="$OPENH323_FLAGS"
		if test -d $OPENH323DIR/lib ; then
			OPENH323_LIBS="$OPENH323_LIBS -L$OPENH323DIR/lib"
			libh323="-lh323_"`ls $OPENH323_LIBS/lib/libh* | sed -e "s/.*libh323_//" -e "s/[.]so.*$//" -e"s/_s.a*$//"   | uniq`
		else
			if test -f /usr/lib/libopenh323.so ; then
				libh323="-lopenh323"
			else
				libh323="-lh323_"`ls /usr/lib/libh323_* | sed -e "s/.*libh323_//" -e "s/[.]so.*$//" | uniq` 
			fi
		fi
		if test -d $PWLIBDIR/lib/obj* ; then
			OPENH323_LIBS="$OPENH323_LIBS -L"`echo $PWLIBDIR/lib/obj*`
		fi
		if test -d $PWLIBDIR/lib ; then
			libpt="-lpt" `ls $PWLIBDIR/lib/libpt* | sed -e "s/.*libpt//" -e "s/.so.*$//" -e"s/_s.a*$//" | uniq`
		else
			libpt="-lpt"
		fi
		OPENH323_LIBS="$OPENH323_LIBS $libh323 $libpt"
	fi
	if test $ost_cv_openh323 = true ; then
		AC_MSG_RESULT(found)
	else
		AC_MSG_RESULT(missing)
	fi
	AC_SUBST(OPENH323_FLAGS)
	AC_SUBST(OPENH323_LIBS)
])


