#ifndef INET6DEF_H
#define INET6DEF_H

/* on some machines the AF_INET6 definition is needed, on most systems not */
#include <sys/socket.h>
#include <netinet/in.h>

#ifndef INET_ADDRSTRLEN 
#define INET_ADDRSTRLEN   16
#endif

#ifndef INET6_ADDRSTRLEN 
#define INET6_ADDRSTRLEN   46
#endif

#ifndef AF_INET6 
#define AF_INET6        24              /* Internet Protocol version 6 */
#endif

int inet_pton(int af, const char *src, void *dst);
const char *inet_ntop(int af, const void *src, char *dst, size_t size);


#endif /* INET6DEF_H */
