/***************************************
  $Revision: 1.16 $

  Authentication utilities 

  Status: NOT REVIEWED, TESTED

  Author(s):      Engin Gunduz 

  ******************/ /******************
  Modification History:
        engin (05/04/2000) Created.
  ******************/ /******************
  Copyright (c) 2000                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 ***************************************/

#include "AU_util.h"

extern char *crypt(const char *key, const char *salt);

/* AU_crypt is a wrapper around crypt(3) */
char * AU_crypt(const char *key, const char *setting){

  return crypt(key, setting);

}

/* takes a list of passwords and a crypted password. If any
   of the passwords in the list is the plaintext of crypted
   text, then it immediately returns 1. Otherwise, it returns
   0 */
int au_check_password(char * crypted_password, GSList * password_list){

  GSList * next = NULL;

  for(next = password_list; next != NULL; next = g_slist_next(next)){
    /* if the password is correct, return 1 */
    if(strcmp(crypt((char *)next->data, crypted_password), crypted_password) == 0){
      //printf("DEBUG: au_check_password returning 1\n");
      return(1);
    }
  }
  /* we couldn't find any correct password. So, return 0 */
  //printf("DEBUG: au_check_password returning 0\n");  
  return(0);  
}




/* simply compares auth_pgpkeyID & mesg_pgpkeyID and
   returns 1 if they are the same. */
int au_check_PGPkey(char * auth_pgpkeyID, /*char * mesg_pgpkeyID*/GSList * mesg_pgpkeyIDs){

  GSList * next = NULL;

  for(next = mesg_pgpkeyIDs; next != NULL; next = g_slist_next(next)){
    /* if auth_pgpkeyID & mesg_pgpkeyID are the same, return 1 */
    if(strcmp(auth_pgpkeyID, (char *)next->data) == 0){
      return(1);
    }
  }
  /* If we reached here, we couldn't find a matching keyID, so return 0 */
  return(0);
}



/* Compares the 'From' address of the message to the regular
   expression in the 'auth' attribute of the maintainer*/
int au_check_from_address(char * regexp, char * from_address){
       
   int status;
   regex_t re;

   if(from_address == NULL){
     return(0);
   }
   if (regcomp(&re, regexp, REG_EXTENDED|REG_NOSUB|REG_ICASE) != 0) {
     //printf("DEBUG: au_check_from_address  returns 0 (couldn't compile)\n");
     return(0);      /* couldn't compile the regexp, return false */
   }
   
   status = regexec(&re, from_address, (size_t) 0, NULL, 0);
   regfree(&re);
   if (status != 0) {
     //printf("DEBUG: au_check_from_address returns 0 (regexp doesn't match)\n\t[regexp:%s][from:%s]\n",
     //       regexp, from_address);
     return(0);      /* failed */
   }
   /* OK, the regexp matches */
   //printf("DEBUG: au_check_from_address returns 1\n");
   return(1);
}








/* Gets a auth_vector, and  credentials_struct (which is extracted
   from the update message) and returns 0 if all of the auth
   methods fail, and returns the index of the succeeding auth_struct in the auth_vector 
   if any one of them succeeds. */
int AU_authorise(GSList * auth_vector, credentials_struct credentials){

  GSList * next = NULL;
  auth_struct * temp = NULL;
  int result = 0;

  /* if the linked list contains no members, then return 1*/
  if(g_slist_length(auth_vector) == 0){
    return(1);
  }

  for(next = auth_vector; next != NULL; next = g_slist_next(next)){
    temp = (auth_struct *)next->data;
    if( temp != NULL ){
      switch (temp->type){
        case AU_NONE: return temp->index; /* NONE, immediately returns true */
        case AU_MAIL_FROM: if(au_check_from_address(temp->auth, credentials.from)){
                             result = temp->index;
                           }
                           break;
        case AU_CRYPT_PW:  if(au_check_password(temp->auth, credentials.password_list)){ 
                             result = temp->index;
                           }
                           break;
        case AU_PGP: //printf("DEBUG: AU_authorise: will call au_check_PGPkey\n");
                     //printf("DEBUG: AU_authorise:   with temp->auth=[%s]\n", temp->auth);
                     //printf("DEBUG: AU_authorise:   and credentials.pgp_struct=[%s]\n", credentials.pgp_struct);
                     if(au_check_PGPkey(temp->auth, credentials.pgp_key_list)){
                       result = temp->index;
                     }
                     break;
        default: ;/* this mustn't happen */
      }
      if(result > 0){
        return(result);
      }
    }
  }
  /* we couldn't find any credential which passes, so returning 0 */
  return 0;  

}
