/***************************************
  $Revision: 1.1 $

  Radix tree (rx).  er_PM_errors.h - definition of errors for the radix module

  Status: NOT REVUED, TESTED, 

  Design and implementation by: Andrei Robachevsky

  ******************/ /******************
  Copyright (c) 1999                              RIPE NCC
 
  All Rights Reserved
  
  Permission to use, copy, modify, and distribute this software and its
  documentation for any purpose and without fee is hereby granted,
  provided that the above copyright notice appear in all copies and that
  both that copyright notice and this permission notice appear in
  supporting documentation, and that the name of the author not be
  used in advertising or publicity pertaining to distribution of the
  software without specific, written prior permission.
  
  THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
  AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
  DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
  OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
  ***************************************/

#define UD_TAG " "

/* step 1 */

typedef enum {
	 LOW_UD_OK=0,
	 LOW_UD_MEM,
	 LOW_UD_SQL,
	 LOW_UD_FS,
	 LOW_UD_BUG

} UD_err_code_t;

/* step 2 */

#define UD_OK		ER_SEV_I + (FAC_UD<<16) + LOW_UD_OK
#define UD_MEM          ER_SEV_F + (FAC_UD<<16) + LOW_UD_MEM
#define UD_SQL          ER_SEV_F + (FAC_UD<<16) + LOW_UD_SQL
#define UD_FS           ER_SEV_F + (FAC_UD<<16) + LOW_UD_FS
#define UD_BUG          ER_SEV_F + (FAC_UD<<16) + LOW_UD_BUG

/* step 3 */

#ifdef ER_IMPL

er_list_t UD_mod_err[]={
  { ERDUP(UD_OK),  	"OK" },
  { ERDUP(UD_MEM),  	"Memory allocation error" },
  { ERDUP(UD_SQL),      "Database SQL query error" }, 
  { ERDUP(UD_FS),      "File system related error" },
  { ERDUP(UD_BUG),      "Software bug - contact developer" },
  ER_LASTTXT
};

#endif /* ER_IMPL */



