
#       indexdb - generate a DBM file from an ASCII dbase file
#
#	$RCSfile: indexdb.pl,v $
#	$Revision: 2.0 $
#	$Author: ripe-dbm $
#	$Date: 1996/08/08 10:47:30 $

PERL5OPTIONS

@INC = ("LIBDIR", @INC);

require "getopts.pl";

require "rconf.pl";
require "donetdbm.pl";

&Getopts('cs:t:T:V');

local($conffile) = $ENV{"RIPEDBCNF"};
$conffile = "DEFCONFIG" unless $conffile;

&rconf($conffile);

#
# run on low priority, whois server queries have an
# higher priority

system("$RENICECMD 10 $$ > /dev/null 2>/dev/null");

local($error)=0;
local(@splitdbs)=split(/,/, $opt_T) if ($opt_T);
local(@dbfiles)=();
local(@classlessoptions)=();

if (@ARGV) {
   
   if (($opt_s) || ($opt_T)) {
      
      print STDERR "You cannot use option -s and/or -T together with file arguments\n";
   
      $error=7;
      
   }
   else {
      local(@dbfiles)=grep(! -f $_, @ARGV);
   
      if (@dbfiles) {
      
         if (scalar(@dbfiles)>1) {
            print STDERR "Files (", join(" ", @dbfiles), ") don\'t exist.\n";
         }  
         else {
            print STDERR "File ($dbfiles[0]) doesn\'t exist.\n";
         }
      
         $error=1;
      
      }
      
   }
   
}
else {
   
   if (($opt_s) && (!$DBFILE{$opt_s})) {
   
      print STDERR "Source ($opt_s) doesn\'t exist.\n";
   
      $error=2;
   
   }
   elsif (($opt_T) && (!$SPLIT{$opt_s})) {
       
      print STDERR "Cannot use option -T for non split databases\n";
   
      $error=3;
      
   }
   elsif (grep(!$OBJATSQ{$_}, @splitdbs)) {
      
      print STDERR "Object type(s) (", join(" ", @splitdbs), ") do(es)n\'t exist.\n";
      
      $error=4;
      
   }
   
   
}

if ($opt_t) {

   if ($opt_c) {
      
      print STDERR "You cannot use the -t and -c options together\n";
      
      $error=5;
   
   }
   elsif (! -d $opt_t) {
   
      print STDERR "Directory $opt_t doesn\'t exist\n";
      
      $error=6;
   
   }

}

if (($error) ||
    ((!@ARGV) && (!$opt_s)) ||
    ((@ARGV) && (($opt_s) || ($opt_T)))) {
    
    print <<"EOF";

usage: $PROGRAMNAME [-c|-t todir] < -s source [-T types] | filename [filename [ ... ] >

where:

-c                     also clean the database
-t todir               move the databases and indices to "todir" after indexing
-s source              index database with source "source"
-T type[[,type] ... ]  only index split databases with type "type"
filename               index database file "filename"

EOF
	exit($error);
}


local($options)=0;

$options=$options | $CLEANOPTION if ($opt_c);

if ($opt_s) {
   
   if (!$SPLIT{$opt_s}) {
      # print STDERR "nonsplit\n";
      @dbfiles=($DBFILE{$opt_s});
      @classlessoptions=($CLASSLESSDBS{$opt_s});
   }
   else {
      
      #
      # note: the grep's change @splitdbs, so we have to do 
      #       the classless option search first!
      
      if ($opt_T) {
         # print STDERR "optT: ", join("-", @splitdbs);
         foreach (@splitdbs) {
            push(@classlessoptions, $CLASSLESSDBS{$_});
            push(@dbfiles, $DBFILE{$opt_s}.".".$_);
         }
      }   
      else {
         # print STDERR "!optT: ", join("-", @splitdbs);
         foreach (keys %OBJATSQ) {
            push(@classlessoptions, $CLASSLESSDBS{$_});
            push(@dbfiles, $DBFILE{$opt_s}.".".$_);
         }
      }   
   }
   
}
else {
   @dbfiles=@ARGV;
   
   local(%entry,$type);
   foreach $file (@dbfiles) {
      
      if (open(TESTSOURCE, "<".$file)) {
         
         while (($type=&enread(TESTSOURCE, *entry, -1)) && (!$OBJATSQ{$type})) {};
         
         # print STDERR $type, keys %entry, $entry{"so"}, $CLASSLESSDBS{$entry{"so"}};
         
         if ($SPLIT{$entry{"so"}}) {
            push(@classlessoptions, $CLASSLESSDBS{&entype(*entry)});
         }
         else {
            push(@classlessoptions, $CLASSLESSDBS{$entry{"so"}});
         }
         
         close(TESTSOURCE);
         
      }
      else {
         die "Couldn\'t open $file";
      }
   }
   
}

#
# change to the right option number

grep($_=($_?$CLASSLESSOPTION:0), @classlessoptions);

# print STDERR join("*",@dbfiles),"\n", join("*",@classlessoptions),"\n";

foreach $file (@dbfiles) {
   
   if (! -f $file) {
      print STDERR "Warning: database file ($file) doesn\'t exist.\n";
      shift(@classlessoptions);
      next;
   }
   
   &donetdbm($file, $opt_t, $options | shift(@classlessoptions));
}

1;

# end of indexdb