#include "crysball.hpp"
#include "cbvgap.h"

double qbrt(double root)
{
	if(root > 0.0) return pow(root, double(1.0/3.0));
    else return 0.0;
}

void ConstructPath(char szBuff[150], char szHelper[150], char szFile[10], char szExt[5], long nro)
{
	char 	szPath[150];
	int		mylen;

	mylen = strlen(szHelper) - 1;
	if(mylen > 0)	while(mylen > 0 && szHelper[mylen] == ' ') {
		szHelper[mylen] = 0;
		mylen--;
	}

	if(strlen(szHelper) > 0 && szHelper[strlen(szHelper)-1] == '\\') wsprintf(szPath, "%s%s", szHelper, szFile);
	else wsprintf(szPath, "%s\\%s", szHelper, szFile);

	if(nro == 0) wsprintf(szBuff, "%s.%s", szPath, szExt);
	else wsprintf(szBuff, "%s%ld.%s", szPath, nro, szExt);
}

long IsMiddle(long lowval, long dest, long highval)
{
	long	retval;

	retval = dest;
	if(retval < lowval) retval = lowval;
	if(retval > highval) retval = highval;
	return(retval);
}

long Scalar(int Scala, int Screen)
{

	long	retval, myhelp;

	switch(Scala) {
		case 1:     myhelp = 20L; break;
		case 2:     myhelp = 10L; break;
		case 3:     myhelp = 5L; break;
		default:	myhelp = 40L; break;
	}
	retval = (myhelp * long(Screen))/100L;
	return retval;
}

long InvCalcX(long x, int S, int Screen) { return ((100L * (x - long(Screen/2))) / Scalar(S, Screen));}
long InvCalcY(long y, int S, int Screen) { return ((100L * (long(Screen/2) - y)) / Scalar(S, Screen));}
long CalcX(long x, long Ox, int S, int Screen) { return (long(Screen/2) + long(((x - Ox) * Scalar(S, Screen))/100L));}
long CalcY(long y, long Oy, int S, int Screen) { return (long(Screen/2) - long(((y - Oy) * Scalar(S, Screen))/100L));}

int strpos(char *strline, char *justpart)
{
	char    szStrline[1000];
	int     retval, i, j, k, l;
	retval = -1;
	strncpy(szStrline, strline, 998); szStrline[998] = 0;
	strlwr(szStrline);
	strlwr(justpart);
	l = strlen(justpart);
	k = (strlen(szStrline) - l) + 1;
	for(i = 0; retval < 0 && i < k; i++) {
		for(j = 0; szStrline[i + j] == justpart[j] && j < l; j++);
		if(j == l) retval = i;
    }
	return(retval);
}

long strvaluel(char *strline, char *justpart, int adju, long oli)
{
    int     i;
	long    retval;
    char    *kota;
	retval = 0L;
	i = strpos(strline, justpart);
	if((i > -1) && (strlen(strline) > (i + adju))) {
		kota = &strline[i + adju];
		retval = atol(kota);
    }
	if(retval < oli) retval = oli;
	return(retval);
}

void strvalues(char destination[], char *strline, char *justpart, int adju, int maxle, char stopit)
{
    int     i, j;
	i = strpos(strline, justpart);
	strcpy(destination, "");
    if(i > -1) {
			j = 0;
			while((j < maxle-1) && (strline[i + adju + j] != stopit) && (strline[i + adju + j] != 13)) { destination[j] = strline[i + adju + j]; j++; }
			destination[j] = 0;
        }
}

mdatap HandleMessage(char *mymsg)
{
	mdatap  retval;
	int     i;

	for(i = 0; i < 5; i++) retval.structures[i] = retval.ore[i] = 0L;
	retval.name[0] = retval.race[0] = retval.fcode[0] = retval.temp = 0;
	retval.natives = retval.clan = retval.id = 0L;
	retval.x = retval.y = retval.u = 0L;
	retval.starbase = 0;

	strvalues(retval.name, mymsg,  "at:", 3, 21, 0);
	strvalues(retval.fcode, mymsg, "friendly code is", 19, 4, 0);
	retval.id = strvaluel(mymsg,   "planet ID number", 16, retval.id);
	retval.id = strvaluel(mymsg,   "planet id#", 10, retval.id);
	retval.id = strvaluel(mymsg,   "planet id# :", 12, retval.id);
	retval.id = strvaluel(mymsg,   "Mine field ID Number", 22, retval.id);
	retval.id = strvaluel(mymsg,   "field ID#", 9, retval.id);
	if(retval.name[0] != 0 && retval.id == 0) retval.id = 1000;
	retval.temp = strvaluel(mymsg, "temp:", 5, 0L);

	strvalues(retval.race, mymsg, "part of the", 12, 21);
	if(retval.race[0] == 0) strvalues(retval.race, mymsg, "sensors show there", 29, 21);
	if(retval.race[0] == 0) strvalues(retval.race, mymsg, "i have a feeling", 32, 21);
	if(retval.race[0] == 0) strvalues(retval.race, mymsg, "They are", 9, 21);

	retval.natives = strvaluel(mymsg, "natives  :", 10, 0L);
	retval.clan = strvaluel(mymsg, "show that there are", 20, 0L);
	retval.clan = strvaluel(mymsg, "colonists:", 10, retval.clan);
	retval.ore[0] = strvaluel(mymsg, "content to be:", 15, 0L);
	retval.ore[1] = strvaluel(mymsg, "Neutronium", 11, 0L);
	retval.ore[2] = strvaluel(mymsg, "Duranium", 9, 0L);
	retval.ore[3] = strvaluel(mymsg, "Tritanium", 10, 0L);
	retval.ore[0] = strvaluel(mymsg, "n:", 2, retval.ore[0]);
	retval.ore[1] = strvaluel(mymsg, "d:", 2, retval.ore[1]);
	retval.ore[2] = strvaluel(mymsg, " t:", 3, retval.ore[2]);
	retval.ore[3] = strvaluel(mymsg, " m:", 3, retval.ore[3]);
	retval.ore[4] = strvaluel(mymsg, "credits :", 9, 0L);
	retval.structures[0] = strvaluel(mymsg, "magacredits", 12, 0L);
	retval.structures[1] = strvaluel(mymsg, "mineral mines", 14, 0L);
	retval.structures[2] = strvaluel(mymsg, "factories", 10, 0L);

	retval.x = strvaluel(mymsg, "We are scanning our mines", 30, 0L);
	retval.x = strvaluel(mymsg, "in a field centered", 24, retval.x);
	retval.x = strvaluel(mymsg, "Enemy Mine field", 31, retval.x);
	retval.x = strvaluel(mymsg, "a starship at:", 16, retval.x);
	retval.y = strvaluel(mymsg, "We are scanning our mines", 37, 0L);
	retval.y = strvaluel(mymsg, "in a field centered", 31, retval.y);
	retval.y = strvaluel(mymsg, "Enemy Mine field", 38, retval.y);
	retval.y = strvaluel(mymsg, "a starship at:", 23, retval.y);
	retval.u = strvaluel(mymsg, "Mine field contain", 19, 0L);
	retval.u = strvaluel(mymsg, "now contains", 13, retval.u);
	retval.u = strvaluel(mymsg, "in a field centered", 40, retval.u);
	retval.u = strvaluel(mymsg, "with beam weapons", 19, retval.u);
	retval.u = strvaluel(mymsg, "have been destroyed", 21, retval.u);
	retval.u = strvaluel(mymsg, "has no beam weapons", 21, retval.u);

	if(strpos(mymsg, "have a starbase") > -1) retval.starbase = 1;
	if(strpos(mymsg, "call and explosion") > -1) retval.id = 2000L;
	if(strpos(mymsg, "hissssing") > -1) retval.id = 3000;
	if(strpos(mymsg, "we are eating") > -1) retval.id = 3000;
	if(strpos(mymsg, "colonists are rioting") > -1) retval.id = 3000;
	if(strpos(mymsg, "climate is killing") > -1) retval.id = 3000;
	if(strpos(mymsg, "landed saboteurs") > -1) retval.id = 3000;
	return(retval);
}

scripti ParseScript(scripti kome, char *szScr)
{
	int		i;
	char    *myptr, szHelper[120];

	strcpy(szHelper, szScr);
    strlwr(szScr);
	for(i = 0; i < 14; i++) {
    	switch(i) {
			case 	0:	myptr = strstr(szScr, "r=");
						if(myptr) kome.red = atoi(myptr+2);
						else {
							myptr = strstr(szScr, "r =");
							if(myptr) kome.red = atoi(myptr+3);
						}
                        if(kome.red < 0) kome.red = 0;
						if(kome.red > 255) kome.red = 255;
						break;
			case 	1:	myptr = strstr(szScr, "b=");
						if(myptr) kome.blue = atoi(myptr+2);
						else {
							myptr = strstr(szScr, "b =");
							if(myptr) kome.blue = atoi(myptr+3);
						}
						if(kome.blue < 0) kome.blue = 0;
						if(kome.blue > 255) kome.blue = 255;
						break;
			case 	2:	myptr = strstr(szScr, "g=");
						if(myptr) kome.green = atoi(myptr+2);
						else {
							myptr = strstr(szScr, "g =");
							if(myptr) kome.green = atoi(myptr+3);
						}
						if(kome.green < 0) kome.green = 0;
						if(kome.green > 255) kome.green = 255;
						break;
			case 	3:	myptr = strstr(szScr, "d=");
						if(myptr) kome.r = atol(myptr+2);
						else {
							myptr = strstr(szScr, "d =");
							if(myptr) kome.r = atol(myptr+3);
						}
						break;
			case 	4:	myptr = strstr(szScr, "x=");
						if(myptr) kome.x = atol(myptr+2);
						else {
							myptr = strstr(szScr, "x =");
							if(myptr) kome.x = atol(myptr+3);
						}
						break;
			case 	5:	myptr = strstr(szScr, "y=");
						if(myptr) kome.y = atol(myptr+2);
						else {
							myptr = strstr(szScr, "y =");
							if(myptr) kome.y = atol(myptr+3);
						}
						break;
			case 	6:	myptr = strstr(szHelper, "t=");
						if(myptr) {
							strncpy(kome.txt, myptr+2, 40);
                            kome.txt[40] = 0;
						} else {
							myptr = strstr(szScr, "t =");
							if(myptr) {
								strncpy(kome.txt, myptr+3, 40);
								kome.txt[40] = 0;
                            }
						}
						break;
			case 	7:	myptr = strstr(szHelper, "T=");
						if(myptr) {
							strncpy(kome.txt, myptr+2, 40);
                            kome.txt[40] = 0;
						} else {
							myptr = strstr(szScr, "T =");
							if(myptr) {
								strncpy(kome.txt, myptr+3, 40);
								kome.txt[40] = 0;
                            }
						}
						break;
			case 	8:	myptr = strstr(szScr, "pen"); 	if(myptr) kome.cmd = 1; break;
			case 	9:	myptr = strstr(szScr, "moveto"); 	if(myptr) kome.cmd = 2; break;
			case   10:	myptr = strstr(szScr, "lineto"); 	if(myptr) kome.cmd = 3; break;
			case   11:	myptr = strstr(szScr, "circle"); 	if(myptr) kome.cmd = 4; break;
			case   12:	myptr = strstr(szScr, "text"); 	if(myptr) kome.cmd = 5; break;
			case   13:	myptr = strstr(szScr, "brush"); 	if(myptr) kome.cmd = 6; break;
		}
	}
    return kome;
}

//
//	To use RACEPROP.DBV
//

vprprop::vprprop(char *fname)
{
    status = 0;
    if(strlen(fname) < 128)
        strcpy(fnm, fname);
    else status = -99;
    current = -1;
	strcpy(Info.line1, "");
    strcpy(Info.line2, "");
    strcpy(Info.line3, "");
    strcpy(Info.line4, "");
}

int vprprop::read(int no)
{
    ifstream    dat;
    long        positio;

	if(status > -10) {
        if(no != current) {
			strcpy(Info.line1, "");
			strcpy(Info.line2, "");
			strcpy(Info.line3, "");
			strcpy(Info.line4, "");
			if(no>0 && no<12) {
                dat.open(fnm, ios::binary);
                if(dat) {
                    positio = ((no-1) * sizeof(Info));
                    dat.seekg(positio);
                    if(dat.read((char *) &Info, sizeof(Info)) && !dat.eof()) {
                        status = current = no;
                    } else status = -2;
                    dat.close();
                } else status = -90;
            } else if(no == 0) {
				status = 0;
            } else status = -1;
        } else status = current;
    }
    return(status);
}

char *vprprop::Line(int no)
{
	char * retval;

	switch(no) {
		case 2:	retval = Info.line2; break;
		case 3: retval = Info.line3; break;
		case 4: retval = Info.line4; break;
		default: retval = Info.line1; break;
	}
	return retval;
}
//
//	TMainWindow
//

TMainWindow::TMainWindow(PTWindowsObject Parent, LPSTR Title, LPSTR szCmdLine)
    : TWindow(Parent, Title)
{
	int			myhelp, myhelpx, myhelpy, testaus;
	char		szBuff[250], szHelper[150];
	ifstream 	fromfile;

	Attr.Style = WS_POPUP | WS_BORDER | WS_SYSMENU | WS_CAPTION | WS_GROUP | WS_MINIMIZEBOX;
	Attr.X = GetPrivateProfileInt("General", "X", 0, "crysball.ini");
	Attr.Y = GetPrivateProfileInt("General", "Y", 0, "crysball.ini");
	myhelp = GetPrivateProfileInt("General", "ScreenSize", 0, "crysball.ini");
	switch(myhelp) {
		case 1:	ScreenSize = 520; break;
		case 2:	ScreenSize = 680; break;
		default: ScreenSize = 400; break;
    }
	Attr.W = ScreenSize + 240;
	Attr.H = ScreenSize + 80;

	strcpy(gameini, szCmdLine);
	testaus = GetPrivateProfileInt("General", "Origin.X", -100, gameini);
	if(testaus < 0)	strcpy(gameini, ".\\cbgame.ini");

	GetPrivateProfileString("Files", "Working.Directory", ".\\", szHelper, 128, gameini);
	chdir(szHelper);

	vaaka = new TScrollBar(this, ID_VAAKA, 10, 	ScreenSize + 14, ScreenSize + 3, 0, TRUE);
	pysty = new TScrollBar(this, ID_PYSTY, 		ScreenSize + 14, 10, 0, ScreenSize + 3, FALSE);

	myhelpy = 110; myhelpx = 35;
	new TButton(this, ID_LAYE1, "&1", 					ScreenSize + myhelpx, myhelpy + 125, 24, 24, FALSE);
	new TButton(this, ID_LAYE2, "&2", 					ScreenSize + myhelpx + 25, myhelpy + 125, 24, 24, FALSE);
	new TButton(this, ID_LAYE3, "&3", 					ScreenSize + myhelpx + 50, myhelpy + 125, 24, 24, FALSE);
	new TButton(this, ID_LAYE4, "&4", 					ScreenSize + myhelpx + 75, myhelpy + 125, 24, 24, FALSE);
	new TButton(this, ID_MCENT, "&><",					ScreenSize + myhelpx + 170, myhelpy + 125, 24, 24, FALSE);
	zooseli = new TBStatic(this, ID_ZOOSELI, "Zoom: 3", ScreenSize + myhelpx, myhelpy + 155, 95, 20, 8);
	new TButton(this, ID_REREAD, "&Reread", 			ScreenSize + myhelpx, myhelpy + 185, 95, 24, FALSE);
	new TButton(this, ID_OWNRACE, "&Own race", 			ScreenSize + myhelpx, myhelpy + 215, 95, 24, FALSE);
	new TButton(this, ID_ALLPL, "&Planets", 			ScreenSize + myhelpx, myhelpy + 245, 95, 24, FALSE);
	new TButton(this, ID_ALLSH, "S&hips", 				ScreenSize + myhelpx, myhelpy + 270, 95, 24, FALSE);
	toimi = new TButton(this, ID_COORD, "Sticky", 		ScreenSize + myhelpx, myhelpy + 300, 95, 24, FALSE);

	myhelpx = 135;
	zoomi = new TScrollBar(this, ID_ZOOMI, 				ScreenSize + myhelpx, myhelpy + 155, 95, 0, TRUE);
	new TButton(this, ID_SCORE, "&Score", 				ScreenSize + myhelpx, myhelpy + 185, 95, 24, FALSE);
	new TButton(this, ID_ENEMY, "&Follow", 				ScreenSize + myhelpx, myhelpy + 215, 95, 24, FALSE);
	new TButton(this, ID_MFIELD, "Mi&nes", 				ScreenSize + myhelpx, myhelpy + 245, 95, 24, FALSE);
	new TButton(this, ID_EXIT, "E&xit", 				ScreenSize + myhelpx, myhelpy + 300, 95, 24, TRUE);

//	Layer 1 alkaa
	myhelpy = 10; myhelpx = 35;
	gbmater = new TBGroupBox(this, ID_RAWMAT, "Resources", 		ScreenSize + myhelpx +  0, myhelpy +   0, 195, 220);
	llevel[1]  = new TBStatic(  this, ID_LAYT1, "1", 			ScreenSize + myhelpx +180, myhelpy +   2, 10, 20, 2);
	cbmater[4] = new TBCheckBox(this, ID_MONEY, "Money",		ScreenSize + myhelpx + 20, myhelpy +  18, 160, 18, gbmater);
	cbmater[7] = new TBCheckBox(this, ID_SUPPL, "Supplies", 	ScreenSize + myhelpx + 20, myhelpy +  36, 160, 18, gbmater);
	cbmater[5] = new TBCheckBox(this, ID_COLON, "Colonists", 	ScreenSize + myhelpx + 20, myhelpy +  54, 160, 18, gbmater);
	cbmater[6] = new TBCheckBox(this, ID_NATIV, "Natives",		ScreenSize + myhelpx + 20, myhelpy +  72, 160, 18, gbmater);
	cbmater[0] = new TBCheckBox(this, ID_NEUTR, "Neutronium",	ScreenSize + myhelpx + 20, myhelpy +  90, 160, 18, gbmater);
	cbmater[1] = new TBCheckBox(this, ID_TRITA, "Tritanium", 	ScreenSize + myhelpx + 20, myhelpy + 108, 160, 18, gbmater);
	cbmater[2] = new TBCheckBox(this, ID_DURAN, "Duranium", 	ScreenSize + myhelpx + 20, myhelpy + 126, 160, 18, gbmater);
	cbmater[3] = new TBCheckBox(this, ID_MOLYB, "Molybdenum",	ScreenSize + myhelpx + 20, myhelpy + 144, 160, 18, gbmater);
	cbmater[8] = new TBCheckBox(this, ID_STOOL, "In stock",		ScreenSize + myhelpx + 20, myhelpy + 176, 160, 18, gbmater);
//	Layer 1 loppuu

//	Layer 2 alkaa
	myhelpy = 10; myhelpx = 35;
	gbshowi = new TBGroupBox(this, ID_SHOWI, "Show", 			ScreenSize + myhelpx +  0, myhelpy +  0, 195, 220);
	llevel[2]  = new TBStatic(  this, ID_LAYT2, "2", 			ScreenSize + myhelpx +180, myhelpy +   2, 10, 20, 2);
	cbshowi[2] = new TBCheckBox(this, ID_SHPLA, "Planets", 		ScreenSize + myhelpx + 20, myhelpy +  18, 160, 18, gbshowi);
	cbshowi[14] = new TBCheckBox(this, ID_SHBAS,"- starbases",	ScreenSize + myhelpx + 20, myhelpy +  36, 160, 18, gbshowi);
	cbshowi[5] = new TBCheckBox(this, ID_SHNUM, "- numbers", 	ScreenSize + myhelpx + 20, myhelpy +  54, 160, 18, gbshowi);
	cbshowi[4] = new TBCheckBox(this, ID_SHNAM, "- names", 		ScreenSize + myhelpx + 20, myhelpy +  72, 160, 18, gbshowi);
	cbshowi[19] = new TBCheckBox(this, ID_RADPL,"- radar ranges", ScreenSize + myhelpx + 20,myhelpy + 90, 160, 18, gbshowi);
	cbshowi[1] = new TBCheckBox(this, ID_SHMIN, "Minefields", 	ScreenSize + myhelpx + 20, myhelpy + 108, 160, 18, gbshowi);
//	Layer 2 loppuu

//	Layer 3 alkaa
	myhelpy = 10; myhelpx = 35;
	llevel[3]  = new TBStatic(  this, ID_LAYT3, "3", 			ScreenSize + myhelpx +180, myhelpy +   2, 10, 20, 2);
	cbshowi[3] = new TBCheckBox(this, ID_SHSHI, "Ships", 		ScreenSize + myhelpx + 20, myhelpy +  18, 160, 18, gbshowi);
	cbshowi[9] = new TBCheckBox(this, ID_TRACE, "- all traces", ScreenSize + myhelpx + 20, myhelpy +  36, 160, 18, gbshowi);
	cbshowi[7] = new TBCheckBox(this, ID_SHHYP, "- hyperwarp",  ScreenSize + myhelpx + 20, myhelpy +  54, 160, 18, gbshowi);
	cbshowi[8] = new TBCheckBox(this, ID_GRAVI, "- gravitonic", ScreenSize + myhelpx + 20, myhelpy +  72, 160, 18, gbshowi);
	cbshowi[6] = new TBCheckBox(this, ID_SHEXP, "- explosions", ScreenSize + myhelpx + 20, myhelpy +  90, 160, 18, gbshowi);
	cbshowi[10] = new TBCheckBox(this, ID_WARPC,"- warpcircles",ScreenSize + myhelpx + 20, myhelpy + 108, 160, 18, gbshowi);
	cbshowi[16] = new TBCheckBox(this, ID_DIRLI,"- direction",  ScreenSize + myhelpx + 20, myhelpy + 126, 160, 18, gbshowi);
	cbshowi[17] = new TBCheckBox(this, ID_RADSH,"- radar ranges",ScreenSize + myhelpx + 20, myhelpy+ 144, 160, 18, gbshowi);
	cbshowi[18] = new TBCheckBox(this, ID_RADEN,"- enemy radars",ScreenSize + myhelpx + 20, myhelpy+ 162, 160, 18, gbshowi);
//	Layer 3 loppuu

//	Layer 4 alkaa
	llevel[4]  = new TBStatic(  this, ID_LAYT4, "4", 				ScreenSize + myhelpx +180, myhelpy +   2, 10, 20, 2);
	cbshowi[13] = new TBCheckBox(this, ID_SHTXT,"Messages", 		ScreenSize + myhelpx +  20, myhelpy +  18, 160, 18, gbshowi);
	bshowi[0] = new TButton(this, ID_MEMII, "-", 					ScreenSize + myhelpx +  20, myhelpy +  36, 20, 24, FALSE);
	bshowi[1] = new TButton(this, ID_MEEXP, "&Dump",		   		ScreenSize + myhelpx +  41, myhelpy +  36, 58, 24, FALSE);
	bshowi[2] = new TButton(this, ID_MEPLU, "+", 			   		ScreenSize + myhelpx + 100, myhelpy +  36, 20, 24, FALSE);
	cbshowi[20] = new TBCheckBox(this, ID_SHFIL,"Filter messages", 	ScreenSize + myhelpx +  20, myhelpy +  60, 160, 18, gbshowi);
	cbshowi[12] = new TBCheckBox(this, ID_SHSCR,"Scripts", 			ScreenSize + myhelpx +  20, myhelpy +  78, 160, 18, gbshowi);
	cbshowi[0] = new TBCheckBox(this, ID_SHGRI, "Grid", 			ScreenSize + myhelpx +  20, myhelpy +  96, 160, 18, gbshowi);
	cbshowi[11] = new TBCheckBox(this, ID_MITTA,"Distance", 		ScreenSize + myhelpx +  20, myhelpy + 114, 160, 18, gbshowi);
	cbshowi[15] = new TBCheckBox(this, ID_SHZOB,"ZoomBox",  		ScreenSize + myhelpx +  20, myhelpy + 132, 160, 18, gbshowi);
//	Layer 4 loppuu

	koord = new TBStatic(this, ID_KOORD, "(2000 , 2000)", 10, ScreenSize + 35, 90, 20, 26);
	origo = new TBStatic(this, ID_ORIGO, "Origo (2000 , 2000)", 140, ScreenSize + 35, 170, 20, 20);
	dista = new TBStatic(this, ID_DISTA, "Distance: 0 LY", 470, ScreenSize + 35, 160, 20, 20);
	hyphelp = new TBStatic(this, ID_HYPHE, "(HyperWarp Help)", 340, ScreenSize + 35, 120, 20, 20);

    ActiveLayer = 1;

	// Setting up DLL (generic)
	GetPrivateProfileString("Files", "Path", ".\\", szBuff, 240, gameini);
    vpSearchPath(szBuff);
}

void TMainWindow::ShowLayer(int LayerNo)
{
	int i;

	HideLayer();
	if(LayerNo >0 && LayerNo < 5) llevel[LayerNo]->Show(SW_SHOW);
	switch(LayerNo) {
    	case 1:
			gbmater->Show(SW_SHOW);
			for(i = 0; i < 9; i++) cbmater[i]->Show(SW_SHOW);
			break;
		case 2:
			gbshowi->Show(SW_SHOW);
			cbshowi[1]->Show(SW_SHOW);
			cbshowi[2]->Show(SW_SHOW);
			cbshowi[4]->Show(SW_SHOW);
			cbshowi[5]->Show(SW_SHOW);
			cbshowi[14]->Show(SW_SHOW);
			cbshowi[19]->Show(SW_SHOW);
			break;
		case 3:
			gbshowi->Show(SW_SHOW);
			for(i = 6; i < 11; i++) cbshowi[i]->Show(SW_SHOW);
			cbshowi[3]->Show(SW_SHOW);
			cbshowi[16]->Show(SW_SHOW);
			cbshowi[17]->Show(SW_SHOW);
			cbshowi[18]->Show(SW_SHOW);
			break;
		case 4:
			for(i = 11; i < 14; i++) cbshowi[i]->Show(SW_SHOW);
			cbshowi[0]->Show(SW_SHOW);
			cbshowi[15]->Show(SW_SHOW);
			cbshowi[20]->Show(SW_SHOW);
			for(i = 0; i < 3; i++) bshowi[i]->Show(SW_SHOW);
			gbshowi->Show(SW_SHOW);
			break;
		default: LayerNo = ActiveLayer; break;
	}
	ActiveLayer = LayerNo;
}

void TMainWindow::HideLayer(void)
{
	int		i;

	if(ActiveLayer > 0) {
		llevel[ActiveLayer]->Show(SW_HIDE);
		switch(ActiveLayer) {
			case 1:
				for(i = 0; i < 9; i++) cbmater[i]->Show(SW_HIDE);
				gbmater->Show(SW_HIDE);
				break;
			case 2:
				gbshowi->Show(SW_HIDE);
				cbshowi[1]->Show(SW_HIDE);
				cbshowi[2]->Show(SW_HIDE);
				cbshowi[4]->Show(SW_HIDE);
				cbshowi[5]->Show(SW_HIDE);
				cbshowi[14]->Show(SW_HIDE);
				cbshowi[19]->Show(SW_HIDE);
				break;
			case 3:
				gbshowi->Show(SW_HIDE);
				for(i = 6; i < 11; i++) cbshowi[i]->Show(SW_HIDE);
				cbshowi[3]->Show(SW_HIDE);
				cbshowi[16]->Show(SW_HIDE);
				cbshowi[17]->Show(SW_HIDE);
				cbshowi[18]->Show(SW_HIDE);
				break;
			case 4:
				for(i = 11; i < 14; i++) cbshowi[i]->Show(SW_HIDE);
				cbshowi[0]->Show(SW_HIDE);
				cbshowi[15]->Show(SW_HIDE);
				cbshowi[20]->Show(SW_HIDE);
				for(i = 0; i < 3; i++) bshowi[i]->Show(SW_HIDE);
				gbshowi->Show(SW_HIDE);
				break;
		}
    }
    ActiveLayer = 0;
}

void TMainWindow::GetWindowClass(WNDCLASS& AWndClass)
{
    TWindow::GetWindowClass(AWndClass);
	AWndClass.hIcon = LoadIcon(AWndClass.hInstance, MAKEINTRESOURCE(MainIcon));
	AWndClass.style |= CS_SAVEBITS | CS_DBLCLKS | CS_BYTEALIGNCLIENT;
	AWndClass.hbrBackground = (HBRUSH) GetStockObject(LTGRAY_BRUSH);
}

void TMainWindow::SetupWindow()
{
	TWindow::SetupWindow();

	char		szCaption[150], szHelper[30];
	int			j;

	CanSave = FALSE;

	strcpy(szCaption, "Crystal Ball (Starting)");
	SetCaption(szCaption);

	ruutu = new TSpaceWindow(this, "CrystalBall", gameini);
	GetModule()->MakeWindow(ruutu);
	ruutu->Show(SW_SHOW);

    EnableKBHandler();

	zooseli->Attr.Style = zooseli->Attr.Style & SS_GRAYRECT;

	((TSpaceWindow *)ruutu)->ScreenSize = ScreenSize;

	Scale = GetPrivateProfileInt("General", "Scale", 3, gameini);
	Ox = long(GetPrivateProfileInt("General", "Origin.X", 2000, gameini));
	Oy = long(GetPrivateProfileInt("General", "Origin.Y", 2000, gameini));

	zoomi->SetRange(0 , 3);
	zoomi->SetPosition(Scale);
	zoomi->LineMagnitude = 1;
	zoomi->PageMagnitude = 1;

	SetBars();

	for(j = 0; j < 9; j++) {
		wsprintf(szHelper, "Resource.%d", j+1);
		((TSpaceWindow *)ruutu)->Mater[j] = GetPrivateProfileInt("General", szHelper, 0, gameini);
		if(((TSpaceWindow *)ruutu)->Mater[j]) cbmater[j]->Check();
	}

	for(j = 0; j < 21; j++) {
		wsprintf(szHelper, "Show.%d", j+1);
		((TSpaceWindow *)ruutu)->Shows[j] = GetPrivateProfileInt("General", szHelper, 0, gameini);
		if(((TSpaceWindow *)ruutu)->Shows[j]) cbshowi[j]->Check();
	}

	ActiveLayer = 4; HideLayer();
	ActiveLayer = 3; HideLayer();
	ActiveLayer = 2; HideLayer();
	ActiveLayer = 1;

	CanSave = TRUE;
}

BOOL TMainWindow::CanClose(void)
{
	char	szBuff[20];

	wsprintf(szBuff, "%d", Attr.X);
	WritePrivateProfileString("General", "X", szBuff, "crysball.ini");
	wsprintf(szBuff, "%d", Attr.Y);
	WritePrivateProfileString("General", "Y", szBuff, "crysball.ini");
	wsprintf(szBuff, "%d", Scale);
	WritePrivateProfileString("General", "Scale", szBuff, gameini);
	wsprintf(szBuff, "%ld", Ox);
	WritePrivateProfileString("General", "Origin.X", szBuff, gameini);
	wsprintf(szBuff, "%ld", Oy);
	WritePrivateProfileString("General", "Origin.Y", szBuff, gameini);

	vpFree();
	return TRUE;
}


void TMainWindow::WMActivateLayer1(RTMessage) { ShowLayer(1); }
void TMainWindow::WMActivateLayer2(RTMessage) { ShowLayer(2); }
void TMainWindow::WMActivateLayer3(RTMessage) { ShowLayer(3); }
void TMainWindow::WMActivateLayer4(RTMessage) { ShowLayer(4); }
void TMainWindow::WMActionExit(RTMessage) { CanClose(); PostQuitMessage(0); }
void TMainWindow::WMExportM(RTMessage) { ((TSpaceWindow *)ruutu)->ExportMessage(); }

void TMainWindow::WMOwnRace(RTMessage) {
	((TSpaceWindow *)ruutu)->OwnRace();
	InvalidateRect(ruutu->HWindow, NULL, TRUE);
}

void TMainWindow::WMPrimaryEnemy(RTMessage) {
	((TSpaceWindow *)ruutu)->PrimaryEnemy();
	InvalidateRect(ruutu->HWindow, NULL, TRUE);
}

void TMainWindow::WMEditMFields(RTMessage) {
	((TSpaceWindow *)ruutu)->EditMFields();
	InvalidateRect(ruutu->HWindow, NULL, TRUE);
}

void TMainWindow::WMMsgNext(RTMessage) {
	int	iCurre;

	if(!((TSpaceWindow *)ruutu)->Shows[13]) {
		((TSpaceWindow *)ruutu)->Shows[13] = 1;
		cbshowi[13]->Check();
	} else {
		iCurre = msgStatus();
		msgNext();
		while(	((TSpaceWindow *)ruutu)->Shows[20] && iCurre != msgStatus() &&
				((TSpaceWindow *)ruutu)->iMsg[msgStatus()])
					msgNext(); 
		InvalidateRect(ruutu->HWindow, NULL, TRUE);
	}
}

void TMainWindow::WMMsgPrev(RTMessage) {
	int	iCurre;

	if(!((TSpaceWindow *)ruutu)->Shows[13]) {
		((TSpaceWindow *)ruutu)->Shows[13] = 1;
		cbshowi[13]->Check();
	} else {
		iCurre = msgStatus();
		msgPrev();
		while(	((TSpaceWindow *)ruutu)->Shows[20] && iCurre != msgStatus() &&
				((TSpaceWindow *)ruutu)->iMsg[msgStatus()])
					msgPrev();
		InvalidateRect(ruutu->HWindow, NULL, TRUE);
    }
}

void TMainWindow::WMActionTurn(RTMessage)
{
	((TSpaceWindow *)ruutu)->UpdateAllData();
	InvalidateRect(ruutu->HWindow, NULL, TRUE);
}

void TMainWindow::WMActionXY(RTMessage)
{
	switch(((TSpaceWindow *)ruutu)->Action) {
    	case 1:	
			((TSpaceWindow *)ruutu)->Action = 2;
			toimi->SetCaption("Info");
			InvalidateRect(ruutu->HWindow, NULL, TRUE);
			break;
		case 2:
			((TSpaceWindow *)ruutu)->Action = 3;
			((TSpaceWindow *)ruutu)->meC = -1;
			toimi->SetCaption("Coord"); break;
        case 3:
			((TSpaceWindow *)ruutu)->Action = 1;
			toimi->SetCaption("Sticky"); break;
	}
}

void TMainWindow::WMMater(RTMessage)
{
	char	szHelper[30], szBuff[30];
    int		i;

	for(i = 0; CanSave && i < 9; i++) {
		if(cbmater[i]->GetCheck() == BF_UNCHECKED) ((TSpaceWindow *)ruutu)->Mater[i] = FALSE;
		else ((TSpaceWindow *)ruutu)->Mater[i] = TRUE;
		wsprintf(szBuff, "%d", ((TSpaceWindow *)ruutu)->Mater[i]);
		wsprintf(szHelper, "Resource.%d", i+1);
		WritePrivateProfileString("General", szHelper, szBuff, gameini);
	}
	InvalidateRect(ruutu->HWindow, NULL, TRUE);
}

void TMainWindow::WMShows(RTMessage)
{
	char	szHelper[30], szBuff[30];
    int		i;

	for(i = 0; CanSave && i < 21; i++) {
		if(cbshowi[i]->GetCheck() == BF_UNCHECKED) ((TSpaceWindow *)ruutu)->Shows[i] = FALSE;
		else ((TSpaceWindow *)ruutu)->Shows[i] = TRUE;
		wsprintf(szBuff, "%d", ((TSpaceWindow *)ruutu)->Shows[i]);
		wsprintf(szHelper, "Show.%d", i+1);
		WritePrivateProfileString("General", szHelper, szBuff, gameini);
	}
	InvalidateRect(ruutu->HWindow, NULL, TRUE);
}

void TMainWindow::WMHandleVaaka(RTMessage) {
	Ox = 2000L + long(vaaka->GetPosition());
    SetBars();
}

void TMainWindow::WMHandlePysty(RTMessage) {
	Oy = 2000L - long(pysty->GetPosition());
	SetBars();
}

void TMainWindow::WMHandleCenter(RTMessage) {
	Ox = 2000L;
	Oy = 2000L;
	SetBars();
}

void TMainWindow::SetBars(void) {
	char	szHelper[30];
	int		mi, ma, ls, ps;
	long	tx, ty;

	wsprintf(szHelper, "Zoom: %1d", Scale);
	zooseli->SetText(szHelper);
	mi = -500; ma = 500; ls = 100; ps = 500;
	switch(Scale) {
		case 2:	mi = -750; ma = 750; ls = 200; ps = 600; break;
		case 1:	mi = -875; ma = 875; ls = 100; ps = 400; break;
		case 0:	mi = -975; ma = 975; ls =  50; ps = 200; break;
	}

	tx = Ox - 2000L; ty = 2000L - Oy;
	tx = IsMiddle(long(mi), tx, long(ma));
	ty = IsMiddle(long(mi), ty, long(ma));
	Ox = 2000L + tx; Oy = 2000L - ty;

	vaaka->SetRange(mi , ma);
	vaaka->LineMagnitude = ls;
	vaaka->PageMagnitude = ps;
	vaaka->SetPosition(int(tx));
	pysty->SetRange(mi , ma);
	pysty->LineMagnitude = ls;
	pysty->PageMagnitude = ps;
	pysty->SetPosition(int(ty));

	((TSpaceWindow *)ruutu)->Scale = Scale;
	((TSpaceWindow *)ruutu)->Ox = Ox;
	((TSpaceWindow *)ruutu)->Oy = Oy;

	wsprintf(szHelper, "Origo (%4ld , %4ld)", Ox, Oy);
	origo->SetText(szHelper);
	InvalidateRect(pysty->HWindow, NULL, TRUE);
	InvalidateRect(vaaka->HWindow, NULL, TRUE);
	InvalidateRect(ruutu->HWindow, NULL, TRUE);
}

void TMainWindow::WMHandleZoomi(RTMessage) {
	Scale = zoomi->GetPosition();
	SetBars();
}

void TMainWindow::WMRScore(RTMessage)
{
	int i, j, k, l, sko[12][2];

	for(i=0; i<11; i++) {
		sko[i][0] = i+1;
        sko[i][1] = scoreTotal(i+1);
	}

	for(i=0; i<10; i++)
		for(j=i+1; j<11; j++)
			if(sko[i][1] < sko[j][1]) {
            	k = sko[i][0];
				l = sko[i][1];
				sko[i][0] = sko[j][0];
				sko[i][1] = sko[j][1];
				sko[j][0] = k;
				sko[j][1] = l;
			}

	for(i=0; i<11; i++) {
		racenmAdjective(i+1, Pisteet.szNa[i], sizeof(Pisteet.szNa[i]));
		wsprintf(Pisteet.szSc[i], "%6d", scoreTotal(sko[i][0]));
		wsprintf(Pisteet.szBa[i], "%3d", scoreBase(sko[i][0]));
		wsprintf(Pisteet.szPl[i], "%3d", scorePlanet(sko[i][0]));
		wsprintf(Pisteet.szWS[i], "%3d", scoreWarShip(sko[i][0]));
		wsprintf(Pisteet.szCS[i], "%3d", scoreCargoShip(sko[i][0]));
	}

	if(GetModule()->ExecDialog(new TRScoreDlg(this, LPSTR MAKEINTRESOURCE(ShowScore))) == IDOK);
}

void TMainWindow::WMAllShips(RTMessage)
{
	((TSpaceWindow *)ruutu)->ActionAbove(-3000L, 2000L, 2000L);
}

void TMainWindow::WMAllPlanets(RTMessage)
{
	((TSpaceWindow *)ruutu)->ActionAbove(3000L, 2000L, 2000L);
}

//	NOTE!NOTE!NOTE!NOTE!NOTE!NOTE!NOTE!NOTE!NOTE!NOTE!NOTE!NOTE!NOTE!NOTE!NOTE!NOTE!
//
//	TSpaceWindow
//
//	NOTE!NOTE!NOTE!NOTE!NOTE!NOTE!NOTE!NOTE!NOTE!NOTE!NOTE!NOTE!NOTE!NOTE!NOTE!NOTE!

void TSpaceWindow::LogError(char *ko, char *su)
{
	ofstream	loki;
    char		lname[130];

	GetPrivateProfileString("General", "LogFile", "test.log", lname, 128, ".\\cbgame.ini");
	loki.open(lname, ios::app);

	loki << ko << " " << su << endl;
    loki.close();
}


TSpaceWindow::TSpaceWindow(PTWindowsObject Parent, LPSTR Title, LPSTR szCmdLine)
	: TWindow(Parent, Title)
{
	char	szBuff[150], szHelper[150];
    int		i;

	Attr.Style = WS_CHILD | WS_BORDER;
	ScreenSize = ((TMainWindow *)Parent)->ScreenSize;
	Attr.X = 10;
	Attr.Y = 10;
	Attr.W = ScreenSize + 3;
	Attr.H = ScreenSize + 3;

	strcpy(gameini, szCmdLine);

	for(int j = 0; j < 500; j++) {
		reso[j] = new planetres;
		base[j] = new starbase; base[j]->id = 0; base[j]->owner = -1;
		planut[j] = new planetdata;
		ships[j] = new shipdata;
	}

	i = GetPrivateProfileInt("General", "LineStyle", 0, "crysball.ini");
	DOTLineStyle = PS_DOT; DASHLineStyle = PS_DASH;
	if(i) {
		DOTLineStyle = PS_SOLID;
		DASHLineStyle = PS_SOLID;
    }

	i = GetPrivateProfileInt("General", "Player", 0, gameini);

	GetPrivateProfileString("Files", "Game.Directory", ".\\", szHelper, 128, gameini);
	ConstructPath(szBuff, szHelper, "mdata", "dat", i);
}

TSpaceWindow::~TSpaceWindow(void)
{
	for(int j = 0; j < 500; j++) {
		delete reso[j];
		delete base[j];
		delete planut[j];
		delete ships[j];
	}
}

void TSpaceWindow::GetWindowClass(WNDCLASS& AWndClass)
{
    TWindow::GetWindowClass(AWndClass);
	AWndClass.style |= CS_SAVEBITS | CS_DBLCLKS | CS_BYTEALIGNCLIENT;
	AWndClass.hbrBackground = (HBRUSH) GetStockObject(BLACK_BRUSH);
	AWndClass.hCursor = (HCURSOR) LoadCursor(GetApplication()->hInstance, LPSTR MAKEINTRESOURCE(CURINFO));
}

void TSpaceWindow::InitShipdbv(void)
{
	ifstream fromfile;
	ofstream tofile;
	int			i;
	header  	fheader;
    shipfile	ftietue;

	fromfile.open("ship.dbv", ios::binary);
	if(fromfile) fromfile.close();
    else {
		tofile.open("ship.dbv", ios::binary | ios::trunc | ios::out | ios::noreplace);
		fheader.NumOfObjects = 500;
		fheader.DeletedObjects = 0;
		fheader.Safety = 0;
		fheader.Turn = 0;
		fheader.Version = 101;
		fheader.BlockSize = sizeof(ftietue);

		tofile.write((char *) &fheader, sizeof(fheader));

		strncpy(ftietue.name, "<Name unknown>", 21);
        ftietue.name[20] = 0;
		ftietue.lastseen = ftietue.type = ftietue.warp = ftietue.course = ftietue.lastvisual = -1;
		for(i=0; i<8; i++) 
			ftietue.owner[i] = ftietue.x[i] = ftietue.y[i] = ftietue.w[i] = ftietue.turn[i]= -1;

		for(ftietue.id=1; ftietue.id<501; ftietue.id++) 
			tofile.write((char *) &ftietue, sizeof(ftietue));
		tofile.close();
	}
}

void TSpaceWindow::UpdateShipdbv(void)
{
	fstream		dbv;
	ifstream 	fromfile;

	int			i, lasku, e, k, delhist;
	long		positio;
	header		fheader;
    shipfile    ftietue;

	dbv.open("ship.dbv", ios::binary | ios::in | ios::out | ios::ate);
	dbv.seekg(0L);
	dbv.read((char *) &fheader, sizeof(fheader));
    SKierros = fheader.Turn;

    delhist = 0;
	if(fheader.Version != 101) {
		MessageBox(HWindow, "Ships aren't compatible", "Error in dbV", MB_OK | MB_ICONSTOP);
		PostQuitMessage(1);
	} else if(long(fheader.Turn) <= Kierros) {

		for(lasku = 1; lasku < 501; lasku++) {
        	delhist = 0;
			positio = sizeof(fheader) + (long(lasku-1) * long(sizeof(ftietue)));
			dbv.seekg(positio);
			dbv.read((char *) &ftietue, sizeof(ftietue));
			if(ftietue.turn[0] < Kierros && shipOwner(lasku) > 0 && shipOwner(lasku) < 12) {
				ftietue.lastseen = Kierros;
				if(shipHull(lasku) > 0) {
					ftietue.lastvisual = Kierros;
					if(ftietue.type != shipHull(lasku)) delhist = 1;
					ftietue.type = shipHull(lasku);
                    shipName(lasku, ftietue.name, sizeof(ftietue.name));
					k = 19;	while(ftietue.name[k] == 32) ftietue.name[k--] = 0;
					ftietue.warp = shipSpeed(lasku);
					ftietue.course = shipHeading(lasku);
				}
				for(e=7; e>0; e--) {
					ftietue.owner[e] 	= ftietue.owner[e-1];	
					ftietue.turn[e] 	= ftietue.turn[e-1];
					ftietue.x[e] 		= ftietue.x[e-1];
					ftietue.y[e] 		= ftietue.y[e-1];
					ftietue.w[e] 		= ftietue.w[e-1];
				}
				ftietue.owner[0] 		= shipOwner(lasku);
				ftietue.turn[0] 		= Kierros;
				ftietue.x[0] 			= shipX(lasku);
				ftietue.y[0] 			= shipY(lasku);
				ftietue.w[0] 			= shipMass(lasku);
				if(shipDestroyed(lasku)) {
					delhist = 1;
					ftietue.turn[0] 	= 0;
				}
				if(delhist)
					for(i=1; i<8; i++)
						ftietue.owner[i] = ftietue.x[i] = ftietue.y[i] =
						ftietue.w[i] = ftietue.turn[i]= -1;

				dbv.seekg(positio);
				dbv.write((char *) &ftietue, sizeof(ftietue));
			}
		}

		fheader.Turn = int(Kierros);
		dbv.seekg(0L);
		dbv.write((char *) &fheader, sizeof(fheader));
	}
	dbv.close();
}

void TSpaceWindow::InitPlanetdbv(void)
{
	ifstream 	fromfile;
	fstream 	dbv;
	int			lasku;
	long		positio;
	header  	fheader;
	planetfile	ftietue;

	fromfile.open("planet.dbv", ios::binary);
	if(fromfile) fromfile.close();
    else {
		fheader.NumOfObjects = 500;
		fheader.DeletedObjects = 0;
		fheader.Safety = 0;
		fheader.Turn = 0;
		fheader.Version = 101;
		fheader.BlockSize = sizeof(ftietue);

		wsprintf(ftietue.name, "<No name>           ");
		wsprintf(ftietue.fcode, "nil");
		ftietue.x = ftietue.y = ftietue.owner = ftietue.turn = 0;
		ftietue.mines =	ftietue.factories =	ftietue.defences = -1;
		ftietue.supply = ftietue.money = -1;
		ftietue.stock_fuel = ftietue.stock_tr = ftietue.stock_dr = ftietue.stock_mb = -1;
		ftietue.ground_fuel = ftietue.ground_tr = ftietue.ground_dr = ftietue.ground_mb = -1;
		ftietue.rate_fuel =	ftietue.rate_tr = ftietue.rate_dr = ftietue.rate_mb = -1;
		ftietue.temperature = ftietue.colonist = ftietue.natives = -1L;
		ftietue.tax_col = ftietue.feel_col = 0;
		ftietue.native_race = ftietue.native_gov = ftietue.tax_nat = ftietue.feel_nat = 0;

		dbv.open("planet.dbv", ios::binary | ios::trunc | ios::out | ios::noreplace);
		dbv.write((char *) &fheader, sizeof(fheader));
		for(ftietue.id=1; ftietue.id<501; ftietue.id++)
			dbv.write((char *) &ftietue, sizeof(ftietue));
        dbv.close();

		dbv.open("planet.dbv", ios::binary | ios::in | ios::out | ios::ate);

		for(lasku = 1; lasku < 501; lasku++) {
			positio = sizeof(fheader) + (long(lasku-1) * long(sizeof(ftietue)));
			dbv.seekg(positio);
			dbv.read((char *) &ftietue, sizeof(ftietue));
			ftietue.x = planetX(lasku);
			ftietue.y = planetY(lasku);
			planetName(lasku, ftietue.name, sizeof(ftietue.name));
			dbv.seekg(positio);
			dbv.write((char *) &ftietue, sizeof(ftietue));
		}
  		dbv.close();
	}
}

void TSpaceWindow::UpdatePlanetdbv(void)
{
	fstream 	dbv;

	int			lasku;
	long		positio;
	header  	fheader;
	planetfile	ftietue;

	dbv.open("planet.dbv", ios::binary | ios::in | ios::out | ios::ate);

	if(dbv)
	{
		dbv.seekg(0L);
		dbv.read((char *) &fheader, sizeof(fheader));
        PKierros = fheader.Turn;

		if(fheader.Version != 101) {
			MessageBox(HWindow, "Planets aren't compatible", "Error in dbV", MB_OK | MB_ICONSTOP);
			PostQuitMessage(1);
		} else if(long(fheader.Turn) <= Kierros) {
			for(lasku = 1; lasku < 501; lasku++) 
				if(lasku == planetId(lasku)) {
					positio = sizeof(fheader) + (long(lasku - 1) * long(sizeof(ftietue)));
					dbv.seekg(positio);
					dbv.read((char *) &ftietue, sizeof(ftietue));

					ftietue.turn = Kierros;
					ftietue.owner = planetOwner(lasku);
					planetFCode(lasku, ftietue.fcode, sizeof(ftietue.fcode));
					ftietue.mines = planetMines(lasku);
					ftietue.factories = planetFactories(lasku);
					ftietue.defences = planetDefence(lasku);
					ftietue.supply = planetSuppliesAvail(lasku);
					ftietue.money = planetMoneyAvail(lasku);
					ftietue.stock_fuel = planetFuelAvail(lasku);
					ftietue.stock_tr = planetTritAvail(lasku);
					ftietue.stock_dr = planetDuraAvail(lasku);
					ftietue.stock_mb = planetMolyAvail(lasku);
					ftietue.ground_fuel = planetFuelCore(lasku);
					ftietue.ground_tr = planetTritCore(lasku);
					ftietue.ground_dr = planetDuraCore(lasku);
					ftietue.ground_mb = planetMolyCore(lasku);
					ftietue.rate_fuel = planetFuelDensity(lasku);
					ftietue.rate_tr = planetTritDensity(lasku);
					ftietue.rate_dr = planetDuraDensity(lasku);
					ftietue.rate_mb = planetMolyDensity(lasku);
					ftietue.temperature = planetTemperature(lasku);
					ftietue.colonist = planetColClans(lasku);
					ftietue.natives = planetNatPopulation(lasku);
					ftietue.tax_col = planetColTax(lasku);
					ftietue.feel_col = planetColHappiness(lasku);
					ftietue.native_race = planetNatType(lasku);
					ftietue.native_gov = planetNatGovernment(lasku);
					ftietue.tax_nat = planetNatTax(lasku);
					ftietue.feel_nat = planetNatHappiness(lasku);
					dbv.seekg(positio);
					dbv.write((char *) &ftietue, sizeof(ftietue));
				}
			fheader.Turn = int(Kierros);
			dbv.seekg(0L);
			dbv.write((char *) &fheader, sizeof(fheader));
		}
		dbv.close();
	}
}

void TSpaceWindow::MessagesTOdbv(void)
{
	ifstream fromfile;
	fstream dbv;

	int			i, j, lasku, loyty;
	long		positio;
	char		rodut[50];
	header  	fheader;
	planetfile	ftietue;
	mdatap  	selva;

    for(i = 0; i < 500; i++) iMsg[i] = 0;

	dbv.open("planet.dbv", ios::binary | ios::in | ios::out | ios::ate);

	if(dbv)
	{
		dbv.seekg(0L);
		dbv.read((char *) &fheader, sizeof(fheader));

		if(fheader.Version != 101) {
			MessageBox(HWindow, "Planets aren't compatible", "Error in dbV", MB_OK | MB_ICONSTOP);
			PostQuitMessage(1);
		} else if(long(fheader.Turn) <= Kierros) {
			for(lasku = 1; lasku <= msgTotal() && lasku < 500; lasku++) {
				selva = HandleMessage(msgGet(lasku));
				iMsg[lasku] = 0;
				j = 0;
				if(selva.id == 1000L) {
                	for(i = 0; !j && i < 500; i++) {
						wsprintf(rodut, "%s", (LPSTR) planut[i]->name);
						if(strpos(rodut, selva.name) > -1) j = i + 1;
					}
					if(j) selva.id = long(j);
				}
				if(selva.x < 100L && 0L < selva.id && selva.id <= 500L) {
					positio = sizeof(fheader) + ((selva.id-1L) * long(sizeof(ftietue)));
					dbv.seekg(positio);
					dbv.read((char *) &ftietue, sizeof(ftietue));
					if(ftietue.owner != Player) {
						ftietue.turn = Kierros;
						if(strlen(selva.race)) for(i = 1; !ftietue.owner && i < 12; i++) {
							racenmAdjective(i, rodut, sizeof(rodut));
							if(strpos(rodut, selva.race) > -1) ftietue.owner = i;
						}
						if(selva.temp > 0) ftietue.temperature = selva.temp;
						if(selva.clan > 0) ftietue.colonist = selva.clan;
						if(selva.natives > 0) ftietue.natives = selva.natives;
						if(selva.fcode[0] != 0) { strncpy(ftietue.fcode, selva.fcode,3); ftietue.fcode[3] = 0; }
						if(selva.ore[4] > 0) ftietue.money = selva.ore[4];
						if(selva.ore[0] > 0) ftietue.ground_fuel = selva.ore[0];
						if(selva.ore[2] > 0) ftietue.ground_tr = selva.ore[2];
						if(selva.ore[1] > 0) ftietue.ground_dr = selva.ore[1];
						if(selva.ore[3] > 0) ftietue.ground_mb = selva.ore[3];
						if(selva.structures[0] > 0) ftietue.mines = selva.structures[0];
						if(selva.structures[1] > 0) ftietue.factories = selva.structures[1];
						if(selva.structures[2] > 0) ftietue.defences = selva.structures[2];
						if(selva.starbase) {
							planut[int(selva.id) - 1]->starbase = baseKpl;
							base[baseKpl]->id = int(selva.id);
							base[baseKpl]->owner = ftietue.owner;
							base[baseKpl]->defence = base[baseKpl]->fighters = -1;
							base[baseKpl]->etech = base[baseKpl]->htech = -1;
							base[baseKpl]->wtech = base[baseKpl]->ttech = -1;
							baseKpl++;
						}
						iMsg[lasku] = 1;
						dbv.seekg(positio);
						dbv.write((char *) &ftietue, sizeof(ftietue));
                    }
				} else {
					if(0L < selva.id && selva.id <= 500L) {
						loyty = mfieldKpl;
						for(i = 0; i < loyty; i++) if(mfield[i].id == int(selva.id)) loyty = i;
						if(loyty == mfieldKpl && mfieldKpl < 500) mfieldKpl++;
						if(!strlen(selva.race)) mfield[loyty].owner = Player;
						else {
							mfield[loyty].owner = 0;
							for(i = 1; !mfield[loyty].owner && i < 12; i++) {

								racenmAdjective(i, rodut, sizeof(rodut));
								if(strpos(rodut, selva.race) > -1) mfield[loyty].owner = i;
							}
						}
						iMsg[lasku] = 1;
						mfieldModified = TRUE;
						mfield[loyty].id = abs(int(selva.id));
						mfield[loyty].x = abs(int(selva.x));
						mfield[loyty].y = abs(int(selva.y));
						mfield[loyty].units = selva.u;
					} else if(selva.id == 2000L && exploKpl < 100) {
							iMsg[lasku] = 1;
							explo[exploKpl].x = int(selva.x);
							explo[exploKpl].y = int(selva.y);
							exploKpl++;
						}
				}
			}
			if(mfieldModified) WriteMFielddbv();
			msgGet(1);
		}
	}
}

void TSpaceWindow::WriteMFielddbv(void)
{
	ofstream	mfielddbv;

	int			i, j;

	header		fheader;
	mfieldfile  ftietue, mmyhelp;

	mfielddbv.open("mfield.dbv", ios::binary | ios::out | ios::trunc);

	if(mfielddbv) {

		for(i = 0; i < mfieldKpl; i++)
			while(mfield[i].units < 1 && i < mfieldKpl) { mfield[i] = mfield[mfieldKpl-1]; mfieldKpl--; }

		for(i = 0; i < (mfieldKpl - 1); i++)
			for(j = i + 1; j < mfieldKpl; j++)
				if(mfield[i].id > mfield[j].id) { mmyhelp = mfield[j]; mfield[j] = mfield[i]; mfield[i] = mmyhelp; }
		fheader.DeletedObjects = 0;
		fheader.Safety = 0;
		fheader.Turn = int(Kierros);
		fheader.Version = 101;
		fheader.BlockSize = sizeof(ftietue);
		fheader.NumOfObjects = mfieldKpl;
		mfielddbv.write((char *) &fheader, sizeof(fheader));
		for(i=0; i < mfieldKpl; i++)
		{
			ftietue.id = mfield[i].id;
			ftietue.owner = mfield[i].owner;
			ftietue.x = mfield[i].x;
			ftietue.y = mfield[i].y;
			ftietue.units = mfield[i].units;
			mfielddbv.write((char *) &ftietue, sizeof(ftietue));
		}
		mfielddbv.close();
    }
}

void TSpaceWindow::UpdateAllData()
{
	fstream		dbv;
	ifstream 	fromfile;
	int			lasku, i, j, k, Color[40], scli, passed;
    long		positio;
//	char 		szBuff[150];
	char 		szHelper[150], szScript[120];

	header		fheader;
	shipfile    ftietue;
	planetfile	ptietue;

    baseKpl = 1;

    SetCursor(LoadCursor(NULL, IDC_WAIT));

	wsprintf(szHelper, "Password.%d", Player);
	GetPrivateProfileString("General", szHelper, "NOPASSWORD", szPass, 11, gameini);

	passed = vpPlayer(Player, szPass);
	if(passed != 0) passed = vpPlayer(Player, "NOPASSWORD");
	if(passed != 0) {
		GetModule()->ExecDialog(new TPassWordDlg(this, LPSTR MAKEINTRESOURCE(PasswdDlg)));
		passed = vpPlayer(Player, szPass);
    }

	if(passed != 0) PostQuitMessage(0);
	else {
    	for(i = 0; i < 40; i++) Color[i] = 0;
		LineWidi = GetPrivateProfileInt("Colors", "Line.Width", 1, "crysball.ini");
        if(LineWidi < 1 || LineWidi > 2) LineWidi = 1;
		Color[0] = GetPrivateProfileInt("Colors", "Neutral.Planets", 14, "crysball.ini");
		Color[1] = GetPrivateProfileInt("Colors", "Own.Planets", 14, "crysball.ini");
		Color[2] = GetPrivateProfileInt("Colors", "Enemy.Planets", 13, "crysball.ini");
		Color[3] = GetPrivateProfileInt("Colors", "Follow.Planets", 13, "crysball.ini");
		Color[4] = GetPrivateProfileInt("Colors", "Grid", 12, "crysball.ini");
		Color[5] = GetPrivateProfileInt("Colors", "Zoom", 12, "crysball.ini");
		Color[6] = GetPrivateProfileInt("Colors", "Coordinator.Circles", 2, "crysball.ini");
		Color[7] = GetPrivateProfileInt("Colors", "Coordinator.Warp", 3, "crysball.ini");
		Color[8] = GetPrivateProfileInt("Colors", "Coordinator.Course", 4, "crysball.ini");
		Color[9] = GetPrivateProfileInt("Colors", "Coordinator.HairCross", 5, "crysball.ini");
		Color[10] = GetPrivateProfileInt("Colors", "Own.Ships", 16, "crysball.ini");
		Color[11] = GetPrivateProfileInt("Colors", "Follow.Ships", 17, "crysball.ini");
		Color[12] = GetPrivateProfileInt("Colors", "Enemy.Ships.Known", 17, "crysball.ini");
		Color[13] = GetPrivateProfileInt("Colors", "Enemy.Ships.Unknown", 18, "crysball.ini");
		Color[14] = GetPrivateProfileInt("Colors", "Own.Traces", 6, "crysball.ini");
		Color[15] = GetPrivateProfileInt("Colors", "LastShip.Trace", 13, "crysball.ini");
		Color[16] = GetPrivateProfileInt("Colors", "Enemy.Traces", 7, "crysball.ini");
		Color[17] = GetPrivateProfileInt("Colors", "Own.MineFields", 8, "crysball.ini");
		Color[18] = GetPrivateProfileInt("Colors", "Enemy.MineFields", 8, "crysball.ini");
		Color[19] = GetPrivateProfileInt("Colors", "Follow.MineFields", 8, "crysball.ini");
		Color[20] = GetPrivateProfileInt("Colors", "Explosion", 7, "crysball.ini");
		Color[21] = GetPrivateProfileInt("Colors", "Distance.Line", 17, "crysball.ini");
		Color[22] = GetPrivateProfileInt("Colors", "Materials.Neutronium", 9, "crysball.ini");
		Color[23] = GetPrivateProfileInt("Colors", "Materials.Tritanium", 11, "crysball.ini");
		Color[24] = GetPrivateProfileInt("Colors", "Materials.Duranium", 12, "crysball.ini");
		Color[25] = GetPrivateProfileInt("Colors", "Materials.Molybdenum", 13, "crysball.ini");
		Color[26] = GetPrivateProfileInt("Colors", "Money", 14, "crysball.ini");
		Color[27] = GetPrivateProfileInt("Colors", "Supplies", 14, "crysball.ini");
		Color[28] = GetPrivateProfileInt("Colors", "Colonist", 15, "crysball.ini");
		Color[29] = GetPrivateProfileInt("Colors", "Natives", 16, "crysball.ini");
		Color[30] = GetPrivateProfileInt("Colors", "Planet.Radar.Range", 16, "crysball.ini");
		Color[31] = GetPrivateProfileInt("Colors", "Ship.Radar.Range", 16, "crysball.ini");
		Color[32] = GetPrivateProfileInt("Colors", "Enemy.Radar.Range", 16, "crysball.ini");
		for(i = 0; i < 40; i++) ColorRef[i] = PALETTEINDEX(Color[i]);

		ScriptLines = 0;
		scli = GetPrivateProfileInt("Scripts", "Lines", 0, gameini);
		for(i = 1; i <= scli; i++) {
			wsprintf(szHelper, "Line.%d", i);
			GetPrivateProfileString("Scripts", szHelper, "#", szScript, 98, gameini);
			if(szScript[0] != '#' && ScriptLines < 400) {
				kome[ScriptLines].red = kome[ScriptLines].blue = kome[ScriptLines].green = kome[ScriptLines].cmd = kome[ScriptLines].txt[0] = 0; kome[ScriptLines].x = kome[ScriptLines].y = 2000L; kome[ScriptLines].r = 0L;
				kome[ScriptLines] = ParseScript(kome[ScriptLines], szScript);
                ScriptLines++;
            }
        }
		wsprintf(szHelper, "Password.%d", Player);
		WritePrivateProfileString("General", szHelper, szPass, gameini);

		GetPrivateProfileString("Files", "Game.Directory", ".\\", szHelper, 128, gameini);
		msgGet(1);

		exploKpl = mfieldKpl = 0;

		DKierros = vpTurn();
		Kierros = long(DKierros);

		InitPlanetdbv();
		InitShipdbv();

		for(k = 0; k < 2; k++) {

			mfieldKpl = 0;
			dbv.open("mfield.dbv", ios::binary | ios::in | ios::out | ios::ate);
			if(dbv) {
				dbv.seekg(0L);
				dbv.read((char *) &fheader, sizeof(fheader));
	        	if(!dbv.eof()) {
					MKierros = fheader.Turn;
					mfieldKpl = fheader.NumOfObjects;
					mfieldModified = FALSE;
					lasku = 0;
					while(dbv.read((char *) mfield+sizeof(mfield)*lasku, sizeof(mfield)) && !fromfile.eof() && lasku < mfieldKpl) lasku++;
    	    	}
				dbv.close();
            }
			shipKpl = 0;
			dbv.open("ship.dbv", ios::binary | ios::in | ios::out | ios::ate);
			dbv.seekg(0L);
			dbv.read((char *) &fheader, sizeof(fheader));
			for(i=0; i< fheader.NumOfObjects; i++) {
				positio = sizeof(fheader) + (long(i) * long(sizeof(ftietue)));
				dbv.seekg(positio);
				dbv.read((char *) &ftietue, sizeof(ftietue));

	    	    if(ftietue.turn[0] > 0) {
					for(j=0; j<8; j++) {
						ships[shipKpl]->turn[j] = ftietue.turn[j];
						ships[shipKpl]->x[j] = ftietue.x[j];
						ships[shipKpl]->y[j] = ftietue.y[j];
						ships[shipKpl]->owner[j] = ftietue.owner[j];
					}
					strncpy(ships[shipKpl]->name, ftietue.name,21);
					ships[shipKpl]->id = ftietue.id;
					ships[shipKpl]->warp = ftietue.warp;
					ships[shipKpl]->course = ftietue.course;
					ships[shipKpl]->type = ftietue.type;
					shipKpl++;
		        }
			}
			dbv.close();

			dbv.open("planet.dbv", ios::binary | ios::in | ios::out | ios::ate);
			dbv.seekg(0L);
			dbv.read((char *) &fheader, sizeof(fheader));
			for(i=0; i< fheader.NumOfObjects; i++) {
				positio = sizeof(fheader) + (long(i) * long(sizeof(ptietue)));
				dbv.seekg(positio);
				dbv.read((char *) &ptietue, sizeof(ptietue));

				if(k == 0) planut[i]->starbase = 0;
				planut[i]->x = ptietue.x;
				planut[i]->y = ptietue.y;
				planut[i]->owner = ptietue.owner;

				if(k == 1) {
					if((ptietue.stock_tr > 401L) &&	(ptietue.stock_dr > 119L) &&
					   (ptietue.stock_mb > 339L) && ((ptietue.money + ptietue.supply) >899L))
					   		planut[i]->starbase = 1000;
					reso[i]->res[0][1] = long(qbrt(double(ptietue.stock_fuel)));
					reso[i]->res[1][1] = long(qbrt(double(ptietue.stock_tr)));
					reso[i]->res[2][1] = long(qbrt(double(ptietue.stock_dr)));
					reso[i]->res[3][1] = long(qbrt(double(ptietue.stock_mb)));
					reso[i]->res[4][1] = reso[i]->res[5][1] = reso[i]->res[6][1] = reso[i]->res[7][1] = 0L;
					reso[i]->res[0][0] = long(qbrt(double(ptietue.stock_fuel + ptietue.ground_fuel)));
					reso[i]->res[1][0] = long(qbrt(double(ptietue.stock_tr + ptietue.ground_tr)));
					reso[i]->res[2][0] = long(qbrt(double(ptietue.stock_dr + ptietue.ground_dr)));
					reso[i]->res[3][0] = long(qbrt(double(ptietue.stock_mb + ptietue.ground_mb)));
					reso[i]->res[4][0] = long(qbrt(double(ptietue.money)));
					reso[i]->res[7][0] = long(qbrt(double(ptietue.supply)));
					reso[i]->res[5][0] = long(qbrt(double(ptietue.colonist)));
					reso[i]->res[6][0] = long(qbrt(double(ptietue.natives))/2.0);
                    reso[i]->native_race = ptietue.native_race;
                }

				strncpy(planut[i]->name, ptietue.name, 21);
				if(ptietue.turn != Kierros && ptietue.owner == Player) planut[i]->owner = 12;
			}
	    	planetModified = FALSE;
			dbv.close();

			if(k == 0) {
				MessagesTOdbv();
				UpdateShipdbv();
				UpdatePlanetdbv();
            }
		}

		for(i = 1; i < 501; i++) if(i == baseId(i)) {
			planut[i-1]->starbase = baseKpl;
			base[baseKpl]->id = baseId(i);
			base[baseKpl]->owner = baseOwner(i);
			base[baseKpl]->defence = baseDefence(i);
			base[baseKpl]->fighters = baseFighters(i);
			base[baseKpl]->etech = baseTLEngine(i);
			base[baseKpl]->htech = baseTLHull(i);
			base[baseKpl]->wtech = baseTLBeam(i);
			base[baseKpl]->ttech = baseTLTorp(i);
			baseKpl++;
		}
	}
	SetCursor(LoadCursor(NULL, IDC_ARROW));
}

void TSpaceWindow::SetupWindow()
{
	TWindow::SetupWindow();

	PTDialog	intro;

	intro = new TDialog(this, IntroDlg);
	GetModule()->MakeWindow(intro);
    intro->Show(SW_SHOW);

	if(vpVersion() < 71 || vpVersion() > 80) {
		MessageBox(HWindow, "CBVGAP.DLL is not compatible", "Error in DLL", MB_OK | MB_ICONSTOP);
		PostQuitMessage(1);
	} else {
		ascirc = GetPrivateProfileInt("General", "Planets.As.Circles", 0, "crysball.ini");
		Player = GetPrivateProfileInt("General", "Player", 0, gameini);
		Follow = GetPrivateProfileInt("General", "Primary.Enemy", 0, gameini);
		RadarPla = long(GetPrivateProfileInt("General", "Planet.Radar.Range", 0, gameini));
		RadarShi = long(GetPrivateProfileInt("General", "Ship.Radar.Range", 0, gameini));
		RadarEne = long(GetPrivateProfileInt("General", "Enemy.Radar.Range", 0, gameini));

		UpdateAllData();
		Scale = 3; Action = 1;
		DKierros = MKierros = SKierros = PKierros = 0;
    	baseKpl = 0;
	   	stickyT[0] = 0;
		Ox = Oy = meX = meY = oliX = oliY = savX = savY = 2000L;
	    etas = 0L;
		meT = meC = meW = -1L;
    }

	intro->CloseWindow();
}

void TSpaceWindow::WMRButtonDown(RTMessage Msg)
{
	long	Ux, Uy;

	Ux = Ox + InvCalcX(long(Msg.LP.Lo), Scale, ScreenSize);
	Uy = Oy + InvCalcY(long(Msg.LP.Hi), Scale, ScreenSize);

	((TMainWindow *)Parent)->Ox = Ux;
	((TMainWindow *)Parent)->Oy = Uy;

	((TMainWindow *)Parent)->SetBars();
}

void TSpaceWindow::WMLDClick(RTMessage Msg)
{
	DownAndDClick(Msg, 2);
}

void TSpaceWindow::WMLButtonDown(RTMessage Msg)
{
	DownAndDClick(Msg, 0);
}

void TSpaceWindow::DownAndDClick(RTMessage Msg, int TempMode)
{
	int		i, tmpAction;
	long	Ux, Uy, lx, ly, lyT, lyC, lyW, lyS;
	double	etas, lyhi;

	Ux = Ox + InvCalcX(long(Msg.LP.Lo), Scale, ScreenSize);
	Uy = Oy + InvCalcY(long(Msg.LP.Hi), Scale, ScreenSize);

	tmpAction = Action;
    if(TempMode > 0) tmpAction = TempMode;
	switch(tmpAction) {
		case 1:
			lx = ly = 9000L;
            lyT = lyC = lyW = -1L;
			lyhi = 9000.0;
			for(i = 0; i < 500; i++) {
				etas = sqrt(pow(double(Ux - planut[i]->x), 2) + pow(double(Uy - planut[i]->y), 2));
				if(etas <= lyhi) {
					lx = planut[i]->x;
					ly = planut[i]->y;
					lyS = lyT = lyC = lyW = -1L;
					lyhi = etas;
					strncpy(stickyT, planut[i]->name, 20); stickyT[20] = 0;
				}
				etas = sqrt(pow(double(Ux - ships[i]->x[0]), 2) + pow(double(Uy - ships[i]->y[0]), 2));
				if((Shows[9] || (ships[i]->turn[0] == Kierros)) &&etas < lyhi) {
					lx = ships[i]->x[0];
					ly = ships[i]->y[0];
					lyT = ships[i]->type;
					lyC = ships[i]->course;
					lyW = ships[i]->warp;
					lyS = ships[i]->id;
					lyhi = etas;
					strncpy(stickyT, ships[i]->name, 20); stickyT[20] = 0;
				}
			}
			meX = lx; meY = ly; meT = lyT; meC = lyC; meW = lyW;
            if(lyS >= 0) meS = lyS;
			InvalidateRect(HWindow, NULL, TRUE);
			break;
		case 2:
			ActionAbove((pow(Scale+1, 2) + 3), Ux, Uy);	break;
		case 3:
        	meX = Ux; meY = Uy; meT = meC = meW = -1L;
			InvalidateRect(HWindow, NULL, TRUE);
			break;
		default:
			MessageBeep(0);
	}
}

void TSpaceWindow::ActionAbove(long numes, long numex, long numey)
{
	long	raja = 1500L;

    SiirtoS = -1L;
	Siirto = numes;
	SiirtoX = numex;
	SiirtoY = numey;

	GetModule()->ExecDialog(new TInfoListDlg(this, LPSTR MAKEINTRESOURCE(InfoListDlg)));
	if(SiirtoX>200) {
    	meS = SiirtoS;
		meX = SiirtoX;
		meY = SiirtoY;
		meW = meC = -1L;
        if(Siirto > 0) {
	    	meC = long(Siirto/10L);
			meW = long(Siirto - (meC * 10L));
        }
		meT = SiirtoT;
		if(labs(numes) > 1000L){
			((TMainWindow *)Parent)->Ox = IsMiddle((2000L - raja), meX, (2000L + raja));
			((TMainWindow *)Parent)->Oy = IsMiddle((2000L - raja), meY, (2000L + raja));
			((TMainWindow *)Parent)->SetBars();
		}
		InvalidateRect(HWindow, NULL, TRUE);
	}
}

void TSpaceWindow::OwnRace(void)
{
	char szBuff[40];

	Siirto = Player;
	if(GetModule()->ExecDialog(new TRaceDlg(this, LPSTR MAKEINTRESOURCE(RaceDlg), "Select Your Own Race")) == IDOK)
	{
		Player = Siirto;
		wsprintf(szBuff, "%d", Player);
		WritePrivateProfileString("General", "Player", szBuff, gameini);
		InvalidateRect(HWindow, NULL, TRUE);
	}
}

void TSpaceWindow::PrimaryEnemy(void)
{
	char szBuff[40];

	Siirto = Follow;
	if(GetModule()->ExecDialog(new TRaceDlg(this, LPSTR MAKEINTRESOURCE(RaceDlg), "Select Race to Follow")) == IDOK)
	{
		Follow = Siirto;
		wsprintf(szBuff, "%d", Follow);
		WritePrivateProfileString("General", "Primary.Enemy", szBuff, gameini);
		InvalidateRect(HWindow, NULL, TRUE);
	}
}

void TSpaceWindow::EditMFields(void)
{
	GetModule()->ExecDialog(new TMFieldListDlg(this, LPSTR MAKEINTRESOURCE(MFieldDlg)));
	if(mfieldModified)
	{
		WriteMFielddbv();
		InvalidateRect(HWindow, NULL, TRUE);
	}
	mfieldModified = FALSE;
}

void TSpaceWindow::ExportMessage(void)
{
	ofstream	tofile;
    int			i;

	tofile.open("messages.dmp", ios::app);
	if(tofile && Shows[13] && msgTotal() > 0) {
		tofile << "==========================================" << endl;
		tofile << "        Turn #" << Kierros << ": Message " << msgStatus() << " of " << msgTotal() << endl;
		tofile << "==========================================" << endl;
		i = 1;
		while(msgGetLine(int(i))[0] != 0) {
			tofile << msgGetLine(int(i)) << endl;
			i++;
		}
		tofile << endl;
        tofile.close();
	} else MessageBeep(0);
}

void TSpaceWindow::Paint(HDC hDC, PAINTSTRUCT& ps)
{
	long	iscale;
	long	lx, rx, ty, by, dx, dy, dc;
	long	i, j, k, ex, ey, ex2, ey2, er, eka, Grid, vari, reb, gnc;
    double	kulma, kk, dox, doy, dap, opx, opy, opd;
	char	szBuff[130], szCaption[190], szHelper[80];
	int		asca, myptr;
	HPEN	OldPen;
	HBRUSH 	OldBrush;
	BOOL	naky;

	lx = long(ps.rcPaint.left - 6);
	rx = long(ps.rcPaint.right + 6);
	ty = long(ps.rcPaint.top - 6);
	by = long(ps.rcPaint.bottom + 6);

	SetCursor(LoadCursor(NULL, IDC_WAIT));

	Grid = GetPrivateProfileInt("General", "Grid", 0, gameini);

	SetBkMode(hDC, TRANSPARENT);

	SelectObject(hDC, GetStockObject(OEM_FIXED_FONT));

	if(Shows[13]) {
		ex = ScreenSize/5;

		SetTextColor(hDC, ColorRef[3]);
		if(msgTotal() > 0) {
			if(iMsg[msgStatus()])wsprintf(szHelper, "Message %d of %d (updated into map)", msgStatus(), msgTotal());
			else wsprintf(szHelper, "Message %d of %d", msgStatus(), msgTotal());
			TextOut(hDC, ex, (ex/2), szHelper, strlen(szHelper));

			SetTextColor(hDC, ColorRef[1]);
			i = 1;
			while(msgGetLine(int(i))[0] != 0) {
				TextOut(hDC, ex, (int(i + 1)*18) + (ex/2), msgGetLine(int(i)), strlen(msgGetLine(int(i))));
				i++;
			}
		} else TextOut(hDC, ex, (ex/2), "No Messages to view!", 20);
	}

	SelectObject(hDC, GetStockObject(ANSI_VAR_FONT));

	OldPen = (HPEN) SelectObject(hDC, GetStockObject(NULL_PEN));
	OldBrush = (HBRUSH) SelectObject(hDC, CreateSolidBrush(GetNearestColor(hDC, ColorRef[30])));

	if(RadarPla > 0L && !Shows[13] && Shows[2] && Shows[19])
		for(i=0; i<500; i++)
			if(planut[i]->owner == Player) {
				er = RadarPla;
				Ellipse(hDC, CalcX(long(planut[i]->x) - er, Ox, Scale, ScreenSize),
							 CalcY(long(planut[i]->y) - er, Oy, Scale, ScreenSize),
							 CalcX(long(planut[i]->x) + er, Ox, Scale, ScreenSize),
							 CalcY(long(planut[i]->y) + er, Oy, Scale, ScreenSize));
			}

	DeleteObject(SelectObject(hDC, OldBrush));

	OldBrush = (HBRUSH) SelectObject(hDC, CreateSolidBrush(GetNearestColor(hDC, ColorRef[31])));

	if(RadarShi > 0L && !Shows[13] && Shows[3] && Shows[17])
		for(i=0; i<shipKpl; i++)
			if(ships[i]->owner[0] == Player) {
				er = RadarShi;
				Ellipse(hDC, CalcX(long(ships[i]->x[0]) - er, Ox, Scale, ScreenSize),
							 CalcY(long(ships[i]->y[0]) - er, Oy, Scale, ScreenSize),
							 CalcX(long(ships[i]->x[0]) + er, Ox, Scale, ScreenSize),
							 CalcY(long(ships[i]->y[0]) + er, Oy, Scale, ScreenSize));
			}

	DeleteObject(SelectObject(hDC, OldBrush));

	OldBrush = (HBRUSH) SelectObject(hDC, CreateSolidBrush(GetNearestColor(hDC, ColorRef[32])));

	if(RadarEne > 0L && !Shows[13] && Shows[3] && Shows[18])
		for(i=0; i<shipKpl; i++)
			if(ships[i]->owner[0] == Follow) {
				er = RadarEne;
				Ellipse(hDC, CalcX(long(ships[i]->x[0]) - er, Ox, Scale, ScreenSize),
							 CalcY(long(ships[i]->y[0]) - er, Oy, Scale, ScreenSize),
							 CalcX(long(ships[i]->x[0]) + er, Ox, Scale, ScreenSize),
							 CalcY(long(ships[i]->y[0]) + er, Oy, Scale, ScreenSize));
			}

	DeleteObject(SelectObject(hDC, OldBrush));
	DeleteObject(SelectObject(hDC, OldPen));

	OldBrush = (HBRUSH) SelectObject(hDC, GetStockObject(NULL_BRUSH));

	if(!Shows[13] && Shows[0] && Grid>0) {
		OldPen = (HPEN) SelectObject(hDC, CreatePen(PS_SOLID, LineWidi, ColorRef[4]));
		for(i=1000L; i<3001L; i+=(Grid*100)) {
			ex = CalcX(i, Ox, Scale, ScreenSize);
			ey = CalcY(i, Oy, Scale, ScreenSize);
			if(ex>lx && ex<rx) {
				MoveTo(hDC, ex, CalcY(3000L, Oy, Scale, ScreenSize));
				LineTo(hDC, ex, CalcY(1000L, Oy, Scale, ScreenSize));
			}
			if(ey>ty && ey<by) {
				MoveTo(hDC, CalcX(3000L, Ox, Scale, ScreenSize), ey);
				LineTo(hDC, CalcX(1000L, Ox, Scale, ScreenSize), ey);
            }
		}
		DeleteObject(SelectObject(hDC, OldPen));
	}

	iscale = 4 - Scale;

	if(!Shows[13] && Shows[12]) {
		naky = FALSE;
		for(i = 0; i < ScriptLines; i++) {
				switch(kome[i].cmd) {
					case	1:	if(naky) DeleteObject(SelectObject(hDC, OldPen));
								gnc = long(kome[i].red) + (256L * long(kome[i].green)) + (65536L * long(kome[i].blue));
								OldPen = (HPEN) SelectObject(hDC, CreatePen(PS_SOLID, LineWidi, gnc));
								SetTextColor(hDC, gnc);
	                            naky = TRUE;
								break;
					case	2:	MoveTo(hDC, CalcX(kome[i].x, Ox, Scale, ScreenSize), CalcY(kome[i].y, Oy, Scale, ScreenSize));
								break;
					case	3:	if(naky) LineTo(hDC, CalcX(kome[i].x, Ox, Scale, ScreenSize), CalcY(kome[i].y, Oy, Scale, ScreenSize));
								else MoveTo(hDC, CalcX(kome[i].x, Ox, Scale, ScreenSize), CalcY(kome[i].y, Oy, Scale, ScreenSize));
								break;
					case	4:	Ellipse(hDC, CalcX(kome[i].x - kome[i].r, Ox, Scale, ScreenSize),
											 CalcY(kome[i].y - kome[i].r, Oy, Scale, ScreenSize),
											 CalcX(kome[i].x + kome[i].r, Ox, Scale, ScreenSize),
											 CalcY(kome[i].y + kome[i].r, Oy, Scale, ScreenSize));
								break;
					case	5:	TextOut(hDC, CalcX(long(kome[i].x), Ox, Scale, ScreenSize), CalcY(long(kome[i].y), Oy, Scale, ScreenSize), kome[i].txt, strlen(kome[i].txt));
								break;
					case	6:	DeleteObject(SelectObject(hDC, OldBrush));
								gnc = long(kome[i].red) + (256L * long(kome[i].green)) + (65536L * long(kome[i].blue));
								if(gnc == 0L) OldBrush = (HBRUSH) SelectObject(hDC, GetStockObject(NULL_BRUSH));
								else OldBrush = (HBRUSH) SelectObject(hDC, CreateSolidBrush(GetNearestColor(hDC, gnc)));
								break;
				}
			}
		if(naky) DeleteObject(SelectObject(hDC, OldPen));
	    naky = FALSE;
		DeleteObject(SelectObject(hDC, OldBrush));
	}

	OldBrush = (HBRUSH) SelectObject(hDC, GetStockObject(NULL_BRUSH));

	if(!Shows[13] &&Shows[15]) {
		OldPen = (HPEN) SelectObject(hDC, CreatePen(DOTLineStyle, LineWidi, ColorRef[5]));
		ex = ScreenSize/4;
		if(Scale>0) {
			Rectangle(hDC, ex, ex, 3 * ex, 3 * ex);
		}
		MoveTo(hDC, 2 * ex - 10, 2 * ex); LineTo(hDC, 2 * ex + 10, 2* ex);
		MoveTo(hDC, 2 * ex, 2 * ex - 10); LineTo(hDC, 2 * ex, 2 * ex + 10);
		DeleteObject(SelectObject(hDC, OldPen));
    }

//
//	Korjaa + lis
//
	er = 2 * iscale;
	for(i = 0; !Shows[13] && Shows[6] && i < exploKpl; i++) {
		OldPen = (HPEN) SelectObject(hDC, CreatePen(PS_SOLID, 7, ColorRef[20]));
		Ellipse(hDC, CalcX(long(explo[i].x) - er, Ox, Scale, ScreenSize),
					 CalcY(long(explo[i].y) - er, Oy, Scale, ScreenSize),
					 CalcX(long(explo[i].x) + er, Ox, Scale, ScreenSize),
					 CalcY(long(explo[i].y) + er, Oy, Scale, ScreenSize));
		DeleteObject(SelectObject(hDC, OldPen));
	}

	switch(ScreenSize) {
		case 640:	asca = 3; break;
		default:	asca = 2; break;
	}

	if(!Shows[13] && Shows[2] && (Shows[4] || Shows[5]) && Scale < asca)
		for(i=0; i<500; i++) {
			ex = CalcX(long(planut[i]->x), Ox, Scale, ScreenSize);
			ey = CalcY(long(planut[i]->y), Oy, Scale, ScreenSize);

			if(ex>lx && ex<rx && ey>ty && ey<by) {
				if(planut[i]->owner == 0) SetTextColor(hDC, ColorRef[0]);
				else if(planut[i]->owner == Player) SetTextColor(hDC, ColorRef[1]);
					else if(planut[i]->owner == Follow) SetTextColor(hDC, ColorRef[3]);
						else SetTextColor(hDC, ColorRef[2]);
				if(Shows[4] && Shows[5]) wsprintf(szHelper, "%ld) %s", i+1L, (LPSTR) planut[i]->name);
				if(!Shows[4] && Shows[5]) wsprintf(szHelper, "%ld", i+1L);
				if(Shows[4] && !Shows[5]) wsprintf(szHelper, "%s", (LPSTR) planut[i]->name);
				TextOut(hDC, ex + iscale + 2, ey, szHelper, strlen(szHelper));
			}
		}

	for(i=0; !Shows[13] && Shows[1] && i<mfieldKpl; i++) {
		er = long(sqrt(double(labs(mfield[i].units))));

		if(mfield[i].owner == Player) {
			OldPen = (HPEN) SelectObject(hDC, CreatePen(DOTLineStyle, LineWidi, ColorRef[17]));
			SetTextColor(hDC, ColorRef[17]);
		} else if(mfield[i].owner == Follow) {
				OldPen = (HPEN) SelectObject(hDC, CreatePen(DOTLineStyle, LineWidi, ColorRef[19]));
				SetTextColor(hDC, ColorRef[19]);
			} else {
				OldPen = (HPEN) SelectObject(hDC, CreatePen(DOTLineStyle, LineWidi, ColorRef[18]));
				SetTextColor(hDC, ColorRef[18]);
			}
		Ellipse(hDC, CalcX(long(mfield[i].x) - er, Ox, Scale, ScreenSize),
					 CalcY(long(mfield[i].y) - er, Oy, Scale, ScreenSize),
					 CalcX(long(mfield[i].x) + er, Ox, Scale, ScreenSize),
					 CalcY(long(mfield[i].y) + er, Oy, Scale, ScreenSize));
		wsprintf(szHelper, "%d", mfield[i].id);
		TextOut(hDC, CalcX(long(mfield[i].x) + er + 2, Ox, Scale, ScreenSize), CalcY(long(mfield[i].y), Oy, Scale, ScreenSize), szHelper, strlen(szHelper));
		DeleteObject(SelectObject(hDC, OldPen));
	}

	if(!Shows[13] && Shows[11] && ((meX != savX) || (meY != savY))) {
		etas = long(sqrt(pow(double(savX - meX), 2) + pow(double(savY - meY), 2)) + 0.5);
		oliX = savX; savX = meX;
		oliY = savY; savY = meY;
    }

	dx = (savX - oliX);
	dy = (savY - oliY);
	etas = long(sqrt(pow(double(dx), 2) + pow(double(dy), 2)) + 0.5);
	if(!Shows[13] && Shows[11] && Shows[7] && etas > 200) {
		if(labs(dx) > labs(dy)) {
			if(dx == 0) kk = 0.0;
			else kk = double(dy) / double(dx);
		} else {
			if(dy == 0) kk = 0.0;
			else kk = double(dx) / double(dy);
		}
		opx = opy = dox = doy = 0.0;
        dap = opd = 0.5;
		for(dc = 25L; dc < 135L; dc++) {
        	if(labs(dx) > labs(dy)) {
				if(savX > oliX) dox = double(oliX + dc);
				else dox = double(oliX - dc);
				if(savX > oliX) doy = double(oliY) + (kk * double(dc));
				else doy = double(oliY) - (kk * double(dc));
				dap = fabs(doy - double(long(doy + 0.5)));
			} else {
				if(savY > oliY) doy = double(oliY + dc);
				else doy = double(oliY - dc);
				if(savY > oliY) dox = double(oliX) + (kk * double(dc));
				else dox = double(oliX) - (kk * double(dc));
				dap = fabs(dox - double(long(dox + 0.5)));
			}
			if(opd > dap) {
				opx = dox;
				opy = doy;
                opd = dap;
            }
        }
		wsprintf(szBuff,"HWH (%4ld,%4ld)", long(opx), long(opy));
		((TMainWindow *)Parent)->hyphelp->SetCaption(szBuff);
	} else ((TMainWindow *)Parent)->hyphelp->SetCaption("(HyperWarp Help)");

	if(!Shows[13] && Shows[11] ) {
		wsprintf(szBuff,"Distance: %4ld ly", etas);
		((TMainWindow *)Parent)->dista->SetCaption(szBuff);
		OldPen = (HPEN) SelectObject(hDC, CreatePen(DOTLineStyle, LineWidi, ColorRef[21]));
		MoveTo(hDC, CalcX(oliX, Ox, Scale, ScreenSize), CalcY(oliY, Oy, Scale, ScreenSize));
		LineTo(hDC, CalcX(savX, Ox, Scale, ScreenSize), CalcY(savY, Oy, Scale, ScreenSize));
		DeleteObject(SelectObject(hDC, OldPen));
	} else ((TMainWindow *)Parent)->dista->SetCaption("Distance: 0 ly");

	if(!Shows[13] && Shows[10]) {
		reb = 10L; if((Shows[7] && meT == -1) || meT == 51 || meT == 77 || meT == 87) reb = 11L;
		for(k = 0; k < (Shows[11] + 1); k++) {
			switch(k) {
				case 0:	ex = meX; ey = meY; eka = meW;etas = meT ;break;
				case 1:	ex = oliX; ey = oliY; eka = 0; etas = -1; break;
			}
			for(i=3; i<reb; i++) {
				er = long(pow(i,2));
				if((Shows[8] && etas < 0) || (etas > 43 && etas <47)) er = 2L * er;
				if(i == 10) er = 350L;

				if(long(i) != eka) OldPen = (HPEN) SelectObject(hDC, CreatePen(DOTLineStyle, LineWidi, ColorRef[6]));
				else OldPen = (HPEN) SelectObject(hDC, CreatePen(DASHLineStyle, LineWidi, ColorRef[7]));

				Ellipse(hDC, CalcX(ex - er, Ox, Scale, ScreenSize),
							 CalcY(ey - er, Oy, Scale, ScreenSize),
							 CalcX(ex + er, Ox, Scale, ScreenSize),
							 CalcY(ey + er, Oy, Scale, ScreenSize));
				DeleteObject(SelectObject(hDC, OldPen));
			}
        }
    }

	if(!Shows[13]) {
		OldPen = (HPEN) SelectObject(hDC, CreatePen(DOTLineStyle, LineWidi, ColorRef[9]));
		er = 81; if((Shows[8] && meT < 0) || (meT > 43 && meT <47)) er = 162;
		MoveTo(hDC, CalcX(meX - er, Ox, Scale, ScreenSize), CalcY(meY, Oy, Scale, ScreenSize));
		LineTo(hDC, CalcX(meX + er, Ox, Scale, ScreenSize), CalcY(meY, Oy, Scale, ScreenSize));
		MoveTo(hDC, CalcX(meX, Ox, Scale, ScreenSize), CalcY(meY - er, Oy, Scale, ScreenSize));
		LineTo(hDC, CalcX(meX, Ox, Scale, ScreenSize), CalcY(meY + er, Oy, Scale, ScreenSize));
		DeleteObject(SelectObject(hDC, OldPen));
    }

	ex = 2 + CalcX(meX, Ox, Scale, ScreenSize);
	ey = CalcY(meY, Oy, Scale, ScreenSize);
	if(ex > 250L) ex -= 78L;
	if(ey > 250L) ey -= 16L;
	wsprintf(szBuff,"(%4ld , %4ld)", meX, meY);
	((TMainWindow *)Parent)->koord->SetCaption(szBuff);

	if(!Shows[13] && Shows[3] && meC >= 0) {
		OldPen = (HPEN) SelectObject(hDC, CreatePen(DOTLineStyle, LineWidi, ColorRef[8]));
		MoveTo(hDC, CalcX(meX, Ox, Scale, ScreenSize), CalcY(meY, Oy, Scale, ScreenSize));
		er = 2 * pow(meW, 2); if((Shows[8] && meT < 0) || (meT > 43 && meT <47)) er = 4 * pow(meW, 2);
		if((Shows[8] && meT < 0) || meT == 51 || meT == 77 || meT == 87) er = 350;
		kulma = 6.283185307 * double(meC)/360.0;
		ex = meX + long(double(er) * sin(kulma));
		ey = meY + long(double(er) * cos(kulma));
		LineTo(hDC, CalcX(ex, Ox, Scale, ScreenSize), CalcY(ey, Oy, Scale, ScreenSize));
		DeleteObject(SelectObject(hDC, OldPen));
	}

	if(!Shows[13] && Shows[2]) for(i=0; i<500; i++) {
		ex = CalcX(long(planut[i]->x), Ox, Scale, ScreenSize);
		ey = CalcY(long(planut[i]->y), Oy, Scale, ScreenSize);

		if(ex>lx && ex<rx && ey>ty && ey<by)
		{
			for(j = 0; j < 8; j++) {
				myptr = 0; if(Mater[8] && j < 4) myptr = 1;
				if(Mater[j] && reso[i]->res[j][myptr] > 0) {
					er = long(log(double(Scale + 2)) * 2.0 * double(reso[i]->res[j][myptr]));
					switch(j) {
						case 0: OldPen = (HPEN) SelectObject(hDC, CreatePen(PS_SOLID, LineWidi, ColorRef[22])); break;
						case 1: OldPen = (HPEN) SelectObject(hDC, CreatePen(PS_SOLID, LineWidi, ColorRef[23])); break;
						case 2: OldPen = (HPEN) SelectObject(hDC, CreatePen(PS_SOLID, LineWidi, ColorRef[24])); break;
						case 3: OldPen = (HPEN) SelectObject(hDC, CreatePen(PS_SOLID, LineWidi, ColorRef[25])); break;
						case 4: OldPen = (HPEN) SelectObject(hDC, CreatePen(PS_SOLID, LineWidi, ColorRef[26])); break;
						case 5: OldPen = (HPEN) SelectObject(hDC, CreatePen(PS_SOLID, LineWidi, ColorRef[28])); break;
						case 6: OldPen = (HPEN) SelectObject(hDC, CreatePen(PS_SOLID, LineWidi, ColorRef[29]));
								SetTextColor(hDC, ColorRef[10]);
								switch(reso[i]->native_race) {
									case 1: strcpy(szHelper, "Humanoid"); break;
									case 2: strcpy(szHelper, "Bovinoid"); break;
									case 3: strcpy(szHelper, "Reptian"); break;
									case 4: strcpy(szHelper, "Avian"); break;
									case 5: strcpy(szHelper, "Amorphous");
											SetTextColor(hDC, ColorRef[11]);
											break;
									case 6: strcpy(szHelper, "Insectoid"); break;
									case 7: strcpy(szHelper, "Amphibian"); break;
									case 8: strcpy(szHelper, "Ghipsodal"); break;
									case 9: strcpy(szHelper, "Siliconoid"); break;
								}
								TextOut(hDC, CalcX(long(planut[i]->x), Ox, Scale, ScreenSize) + iscale + 2, CalcY(long(planut[i]->y), Oy, Scale, ScreenSize) - 16, szHelper, strlen(szHelper));
								break;
						case 7: OldPen = (HPEN) SelectObject(hDC, CreatePen(PS_SOLID, LineWidi, ColorRef[27])); break;
						default: OldPen = (HPEN) SelectObject(hDC, CreatePen(PS_SOLID, LineWidi, ColorRef[26])); break;
					}
					Ellipse(hDC, int(CalcX((long(planut[i]->x) - er), Ox, Scale, ScreenSize)),
								 int(CalcY((long(planut[i]->y) + er), Oy, Scale, ScreenSize)),
								 int(CalcX((long(planut[i]->x) + er), Ox, Scale, ScreenSize)),
								 int(CalcY((long(planut[i]->y) - er), Oy, Scale, ScreenSize)));
					MoveTo(hDC, ex, ey);
					LineTo(hDC, ex, int(CalcY((long(planut[i]->y) + er), Oy, Scale, ScreenSize)));
					DeleteObject(SelectObject(hDC, OldPen));
				}
            }
			if(planut[i]->owner == 0 && (reso[i]->res[0][0] + reso[i]->res[1][0] + reso[i]->res[2][0]) == 0) OldPen = (HPEN) SelectObject(hDC, CreatePen(PS_SOLID, LineWidi, ColorRef[0]));
			else if(planut[i]->owner == Player) OldPen = (HPEN) SelectObject(hDC, CreatePen(PS_SOLID, LineWidi, ColorRef[1]));
				else if(planut[i]->owner == Follow) OldPen = (HPEN) SelectObject(hDC, CreatePen(PS_SOLID, LineWidi, ColorRef[3]));
					else OldPen = (HPEN) SelectObject(hDC, CreatePen(PS_SOLID, LineWidi, ColorRef[2]));

			if(ascirc) Ellipse(hDC, ex - iscale, ey - iscale, 1L + ex + iscale, 1L + ey + iscale);
			else {
				MoveTo(hDC, ex - iscale, ey - iscale);
				LineTo(hDC, 1L + ex + iscale, ey + iscale + 1L);
				MoveTo(hDC, ex - iscale, ey + iscale);
				LineTo(hDC, 1L + ex + iscale, ey - iscale - 1L);
			}
			if(Shows[14] && planut[i]->starbase) {
				MoveTo(hDC, ex - (iscale + 1), ey - (iscale + 1));
				LineTo(hDC, ex + (iscale + 1), ey - (iscale + 1));
				LineTo(hDC, ex + (iscale + 1), ey + (iscale + 1));
				if(planut[i]->starbase != 1000) {
					LineTo(hDC, ex - (iscale + 1), ey + (iscale + 1));
					LineTo(hDC, ex - (iscale + 1), ey - (iscale + 1));
                }
			}
			DeleteObject(SelectObject(hDC, OldPen));
		}
	}

	for(i=0; !Shows[13] && Shows[3] && i<shipKpl; i++)
		if((long(ships[i]->id) == meS || ships[i]->owner[0] == Follow ) && (Shows[9] || ships[i]->turn[0] == Kierros)) {
        	eka = TRUE;
			for(j=7; j>-1; j--) {
				if(ships[i]->turn[j] > 0 && (ships[i]->owner[j] == Follow || long(ships[i]->id) == meS)) {
					ex = CalcX(long(ships[i]->x[j]), Ox, Scale, ScreenSize);
					ey = CalcY(long(ships[i]->y[j]), Oy, Scale, ScreenSize);
					if(long(ships[i]->id) == meS) vari = ColorRef[15];
					else if(Follow == Player) vari = ColorRef[14];
						else vari = ColorRef[16];
					if(eka) {
						OldPen = (HPEN) SelectObject(hDC, CreatePen(PS_SOLID, LineWidi, vari));
						eka = FALSE;
						MoveTo(hDC, ex, ey+1);
						LineTo(hDC, ex, ey);
						DeleteObject(SelectObject(hDC, OldPen));
					} else {
						if((ships[i]->turn[j] - 1) == ships[i]->turn[j+1]) OldPen = (HPEN) SelectObject(hDC, CreatePen(PS_SOLID, LineWidi, vari));
						else OldPen = (HPEN) SelectObject(hDC, CreatePen(DOTLineStyle, LineWidi, vari));
						LineTo(hDC, ex, ey);
						DeleteObject(SelectObject(hDC, OldPen));
					}
				}
            }
		}

	for(i=0; !Shows[13] && Shows[16] && Shows[3] && i<shipKpl; i++) {
		if(ships[i]->course >= 0 && ships[i]->turn[0] == Kierros) {
			if(ships[i]->owner[0] == Player) OldPen = (HPEN) SelectObject(hDC, CreatePen(DOTLineStyle, LineWidi, ColorRef[10]));
			else if(ships[i]->owner[0] == Follow) OldPen = (HPEN) SelectObject(hDC, CreatePen(DOTLineStyle, LineWidi, ColorRef[11]));
				else OldPen = (HPEN) SelectObject(hDC, CreatePen(DOTLineStyle, LineWidi, ColorRef[12]));
			ex2 = ships[i]->x[0];
			ey2 = ships[i]->y[0];
			MoveTo(hDC, CalcX(ex2, Ox, Scale, ScreenSize), CalcY(ey2, Oy, Scale, ScreenSize));
			er = pow(ships[i]->warp, 2); if((Shows[8] && ships[i]->type < 0) || (ships[i]->type > 43 && ships[i]->type <47)) er = 2 * pow(ships[i]->warp, 2);
			if((Shows[8] && ships[i]->type < 0) || ships[i]->type == 51 || ships[i]->type == 77 || ships[i]->type == 87) er = 350;
			kulma = 6.283185307 * double(ships[i]->course)/360.0;
			ex = ex2 + long(double(er) * sin(kulma));
			ey = ey2 + long(double(er) * cos(kulma));
			LineTo(hDC, CalcX(ex, Ox, Scale, ScreenSize), CalcY(ey, Oy, Scale, ScreenSize));
			DeleteObject(SelectObject(hDC, OldPen));
		}
	}

	OldPen = (HPEN) SelectObject(hDC, CreatePen(PS_SOLID, LineWidi, ColorRef[10]));
	for(i=0; !Shows[13] && Shows[3] && i<shipKpl; i++) {
		if(ships[i]->owner[0] == Player && (ships[i]->turn[0] == Kierros))
        {
			ex = CalcX(long(ships[i]->x[0]), Ox, Scale, ScreenSize);
			ey = CalcY(long(ships[i]->y[0]), Oy, Scale, ScreenSize);
			if(ex>lx && ex<rx && ey>ty && ey<by) {
				MoveTo(hDC, ex - iscale, ey);
				LineTo(hDC, 1L + ex, ey);
				MoveTo(hDC, ex, ey);
				LineTo(hDC, ex, ey - iscale - 1L);
			}
        }
	}
	DeleteObject(SelectObject(hDC, OldPen));

	for(i=0; !Shows[13] && Shows[3] && i<shipKpl; i++) {
		if(ships[i]->owner[0] > 0 && ships[i]->owner[0] != Player && (ships[i]->turn[0] == Kierros)) {
			ex = CalcX(long(ships[i]->x[0]), Ox, Scale, ScreenSize);
			ey = CalcY(long(ships[i]->y[0]), Oy, Scale, ScreenSize);
			if(ex>lx && ex<rx && ey>ty && ey<by) {
				if(ships[i]->owner[0] == Follow)	OldPen = (HPEN) SelectObject(hDC, CreatePen(PS_SOLID, LineWidi, ColorRef[11]));
					else if(ships[i]->warp == -1)	OldPen = (HPEN) SelectObject(hDC, CreatePen(PS_SOLID, LineWidi, ColorRef[13]));
						else OldPen = (HPEN) SelectObject(hDC, CreatePen(PS_SOLID, LineWidi, ColorRef[12]));
				MoveTo(hDC, ex + iscale, ey);
				LineTo(hDC, ex - 1L, ey);
				MoveTo(hDC, ex, ey);
				LineTo(hDC, ex, ey + iscale + 1L);
				DeleteObject(SelectObject(hDC, OldPen));
			}
        }
	}
	DeleteObject(SelectObject(hDC, OldBrush));

	if(!Shows[13] && Action == 1) {
		SetTextColor(hDC, ColorRef[21]);
		TextOut(hDC, CalcX(meX, Ox, Scale, ScreenSize) + iscale + 2, CalcY(meY, Oy, Scale, ScreenSize), stickyT, strlen(stickyT));
	}

	GetPrivateProfileString("General", "Name", "<noname>", szBuff, 13, gameini);
	if(Kierros >= long(DKierros) && Kierros >= long(PKierros) && Kierros >= long(SKierros) && Kierros >= long(MKierros))
		wsprintf(szCaption, "Crystal Ball Legacy 2.35 - %s Turn: %ld", szBuff, Kierros);
	else wsprintf(szCaption, "Crystal Ball Legacy 2.35 - %s TurnError: (%ld >= D%d / P%d / S%d / M%d)", szBuff, Kierros, DKierros, PKierros, SKierros, MKierros);
	((TMainWindow *)Parent)->SetCaption(szCaption);

	SetCursor(LoadCursor(NULL, IDC_ARROW));
}

class TMyApp : public TApplication
{
	public:
    	char	szCommandLine[202];
		TMyApp(LPSTR Name, HINSTANCE hInst, HINSTANCE hPrev, LPSTR Cmnd, int Show);
		virtual void InitMainWindow();
};

TMyApp::TMyApp(LPSTR Name, HINSTANCE hInst, HINSTANCE hPrev, LPSTR Cmnd, int Show)
			: TApplication(Name, hInst, hPrev, Cmnd, Show)
{
	strncpy(szCommandLine, Cmnd, 200);
    szCommandLine[200] = 0;
};

void TMyApp::InitMainWindow()
{
	BWCCGetVersion();

	MainWindow = new TMainWindow(NULL, "CrysMain", szCommandLine);
}

int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrev, LPSTR Cmnd, int Show)
{
	TMyApp App("CrystalBall", hInst, hPrev, Cmnd, Show);

	App.Run();
	return App.Status;
}