#define ImageWidthTag 256
#define ImageLengthTag 257
#define StripOffsetTag 273
#define CompressionTag 259
#define NumBitsTag 258
#define PhotoMetricTag 262

#define GrayUnitTag 290
#define GrayCurveTag 291
#define ColorUnitTag 300
#define ColorCurveTag 301

#define PlanarConfigTag 284
#define ResolutionUnitTag 296
#define SamplesPerPixelTag 277
#define StripCountsTag 279
#define XResTag 282
#define RowsPerStripTag 278



struct tagData {
  short photo;			/* the photometric representation. */
  short planarConfig;		/* the planar or chunky configuration. */
  long  dimX;				/* the x dim. */
  long  dimY;				/* the y dim. */
  short min;				/* the minimum. */
  short max;				/* the max. */
  short numBits;			/* bits per pixel. */
  short samplesPixel;		/* samples per pixel. (1)*/
  long  rowsPerStrip;		/* rows per strip. */
  long  numberStrips;		/* the number of strips. */
  short compression;		/* the compressions type. */
  long datOffset;          	/* the data. */
  short GrayResponseUnit;	/* the gray response unit fraction. */
                                                        /* 1 - 1/10
							   2 - 1/100
							   3 - 1/1000
							   4 - 1/10000
							   5 - 1/100000 */
  short *GrayResponseCurve;/* is there color info provided. */
  short ColorResponseUnit;	/* the gray response unit fraction. */
  							/* 1 - 1/10
							   2 - 1/100
							   3 - 1/1000
							   4 - 1/10000
							   5 - 1/100000 */
  short *ColorResponseCurve;/* is there color info provided. */
};
  
/* the image file directory. */

struct IFDrec {
  short num;
  long  next;
};

/* the field record. */

struct infoRec {
  short tag;
  char *tagName;
  short type;
  long length;
  long val;
};
