/* hdf8to24.c
 * Convert an 8-bit HDF image to a 24-bit hdf image.
 * Peter Webb.
 */

#include "df.h"

main(ac, av)
  int ac;
  char *av[];
{
  unsigned char pal[768], *data8, *data24;
  int32 width, height;
  int has_pal;
  int i, index;
  
/* First argument is input file, second is output file */

  if (DFR8getdims(av[1], &width, &height, &has_pal) == -1)
    {
      printf("Couldn't open %s\n", av[1]);
      exit(1);
    }

/* Allocate space for the 8-bit image */

  data8 = (unsigned char *)malloc(width*height);

/* Get the 8-bit image */

  if (DFR8getimage(av[1], data8, width, height, pal) == -1)
    {
      printf("Error reading 8-bit image from %s\n", av[1]);
      exit(1);
    }

/* Allocate space for the 24-bit image */

  data24 = (unsigned char *)malloc(width*height*3);

/* Convert - for each pixel in the 8-bit image, write the RGB values from the
 * palette into the 24-bit image.
 */

  for (i=0; i<width*height; i++)
    {
      index = (*(data8+i)*3);
      *(data24+(3*i)) = pal[index];
      *(data24+(3*i)+1) = pal[index+1];
      *(data24+(3*i)+2) = pal[index+2];
    }

/* Ok, that was easy.  Now write out the 24-bit image */

  if (DF24addimage(av[2], data24, width, height) == -1)
    printf("Error writing 24-bit image to %s\n", av[2]);

/* Done. Exit */
}

