#!/usr/bin/python2.2
# GNU Solfege - ear training for GNOME
# Copyright (C) 2000, 2001, 2002, 2003, 2004  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os, sys, re
sys.path.append(".")
sys.path.append("src")
import i18n, gettext
gettext.install('solfege', 'share/locale', unicode=1)

user_docs = ('welcome',
               'ui',
               'preferences-window',
               'online-resources',
               'bug-reporting',
               'copyright'
               )
devel_docs = ('translating-solfege',
               'helpfile-format',
               'music-format',
               'lessonfiles',
               'chord-names',
               )

exercises = ('chord',
             'chord-voicing',
             'harmonic-interval',
             'melodic-interval',
             'sing-interval',
             'identify-scale',
             'id-by-name',
             'dictation',
             'twelve-tone',
             'id-tone',
             'compare-intervals',
             'sing-chord',
             'rhythm',
             'identify-bpm',
             'harmonic-progression-dictation'
             )

msg1 = _("""Because not all documents has been
<a href="translating-solfege.html">translated</a>
to LANGUAGE yet, the links go to the english version for those
untranslated sections.""")

msg2 = ""

def get_title_of_file(dir, filename, source_encoding):
    if not os.path.isfile(os.path.join(dir, filename)):
        dir = 'online-docs/C'
    try:
        s = open(os.path.join(dir, filename)).read()
        r = re.compile(".*?<title>(.*?)</title>", re.DOTALL)
        m = r.match(s)
        ret =m.groups()[0]
        if source_encoding != 'UTF-8':
            ret = unicode(ret, source_encoding).encode('UTF-8')
        return ret
    except IOError:
        return "error: file not found:", filename

def find_encoding(xmlfile):
    """
    Return a string with the encoding of a .xml file.
    """
    ifile = file(xmlfile, 'r')
    s = ifile.read()
    ifile.close()
    m = re.search('encoding="(.*?)"', s)
    return m.groups()[0]

def write_html_toc(lang):
    source_encoding = find_encoding(os.path.join(lang, "solfege.xml"))
    fn = os.path.join(lang, 'toc.html')
    f = file(fn, 'w')
    if lang == 'online-docs/C':
        msg = msg2
    else:
        msg = msg1
    f.write(("""
<html>
<head>
<style type="text/css">
h1 { font-weight: bold; font-size: 2em;    margin: 0.67em 0 0;}
h2 { font-weight: bold; font-size: 1.5em;  margin: 0.83em 0 0;}
h3 { font-weight: bold; font-size: 1.17em; margin: 1em 0 0;}
h4 { font-weight: bold;                    margin: 1.33em 0 0;}
tt { font-family: monospace; }

dd { margin-left: 50px; }

BODY {
  /* FIXME gtkhtml2 like us to give the font-family Sans, because
     it does not seem to know about sans-serif. */
  font-family : Arial,Sans,sans-serif;
  text-decoration : none;
  font-size : 14px;
  background-color: white;
  color: black;
  :link { color: #0000FF }
  :visited { color: #840084 }
  :active { color: #0000FF }
  p.c1 {font-weight: bold}

</style>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
</head>
<body>
<h1>%(apptitle)s</h1>
<h2>%(toc)s</h2>
<p>
%(msg)s
</p>

<p><a href="copyright.html">Copyright</a> <trademark class="copyright"/> 2000, 2001, 2002, 2003, 2004  Tom Cato Amundsen</p>
<hr>
<dl>
    """ % {'apptitle': _("GNU Solfege"),
           'toc': _("Table of contents"),
'msg': msg,
    }).encode('UTF-8'))
    for fn in user_docs:
        f.write('\n<dt><a href="%s.html">%s</a></dt>' % (fn, get_title_of_file(lang, fn+'.xml', source_encoding)))
    f.write('<dt></dt><dd><a href="gpl-appendix.html">GPL</a></dd>')
    f.write('<dt></dt><dd><a href="fdl-appendix.html">FDL</a></dd>')
    f.write("""
</dl>

<h4>%s</h4>
<dl>
    """ % _("Exercises").encode('UTF-8'))
    for e in exercises:
        f.write('\n <dt></dt><dd><a href="%s-help.html">%s</a></dd>' % (e, get_title_of_file(lang, e+'-help.xml', source_encoding)))
    f.write("""
</dl>
<!-- extending -->
<h4>%s</h4>
<dl>
""" % _("Extending and translating Solfege").encode("UTF-8"))
    for fn in devel_docs:
        f.write('\n <dt></dt><dd><a href="%s.html">%s</a></dd>' % (fn, get_title_of_file(lang, fn+'.xml', source_encoding)))
    f.write("""
</dl>
</body></html>
    """)
    f.close()

write_html_toc(sys.argv[1])
