#ifdef __cplusplus
extern "C" {
#endif
/*
ANSI C code generated by SmartEiffel The GNU Eiffel Compiler, Eiffel tools and libraries
Release 1.1 Release (Monday June 16th 2003) [Charlemagne]
Copyright (C), 1994-2003 - INRIA - LORIA - UHP - Nancy 2 - FRANCE
D.COLNET, S.COLLIN, O.ZENDRA, P.RIBET, C.ADRIAN - SmartEiffel@loria.fr
http://SmartEiffel.loria.fr
C Compiler options used: -pipe -O2
*/

/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/
/*
  This file (SmartEiffel/sys/runtime/base.h) contains all basic Eiffel
  type definitions.
  This file is automatically included in the header for all modes of
  compilation: -boost, -no_check, -require_check, -ensure_check, ...
  This file is also included in the header of any cecil file (when the
  -cecil option is used).
  This file is also included in the header file of C++ wrappers (when
  using the external "C++" clause).
*/

#ifndef _BASE_H
#define _BASE_H

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <signal.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#if defined __USE_POSIX || defined __unix__ || defined _POSIX_C_SOURCE
#  include <unistd.h>
#endif
#if !defined(WIN32) && \
       (defined(WINVER) || defined(_WIN32_WINNT) || defined(_WIN32) || \
	defined(__WIN32__) || defined(__TOS_WIN__) || defined(_MSC_VER))
#  define WIN32 1
#endif
#ifdef WIN32
#  include <windows.h>
#else
#  ifndef O_RDONLY
#    include <sys/file.h>
#  endif
#  ifndef O_RDONLY
#    define O_RDONLY 0000
#  endif
#endif

#if defined(_MSC_VER) && (_MSC_VER < 1400) /* MSVC older than v8 */
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed int int32_t;
typedef signed __int64 int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned int uint32_t;
typedef unsigned __int64 uint64_t;
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "d"
#  define PRId64 "I64d"
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c
#  define INT64_C(c) c ## i64
#elif defined(__WATCOMC__) && (__WATCOMC__ <= 1100) /* WATCOM 11 or lower */
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed long int int32_t;
typedef signed __int64 int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long int uint32_t;
typedef unsigned __int64 uint64_t;
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "d"
#  define PRId64 "Ld"
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c ## L
#  define INT64_C(c) c ## i64
#elif defined(__BORLANDC__) && (__BORLANDC__ < 0x600) /* Borland before 6.0 */
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed long int int32_t;
typedef signed __int64 int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long int uint32_t;
typedef unsigned __int64 uint64_t;
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "ld"
#  define PRId64 "I64Ld"
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c ## L
#  define INT64_C(c) c ## i64
#elif defined(__FreeBSD__) && (__FreeBSD__ < 5) /* FreeBSD before 5.0 */ && !defined (_SYS_INTTYPES_H_)
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed long int int32_t;
typedef signed long long int int64_t;
typedef unsigned char uint8_t;
typedef unsigned short uint16_t;
typedef unsigned long int uint32_t;
typedef unsigned long long int uint64_t;
#elif defined(__CYGWIN__) && defined(__BIT_TYPES_DEFINED__) /* Cygwin defines intxx_t in sys/types.h instead of inttypes.h */
typedef unsigned char uint8_t;
typedef __uint16_t uint16_t;
typedef __uint32_t uint32_t;
typedef __uint64_t uint64_t;
#else
#  include <inttypes.h>
#  if !defined(INT8_MAX) && defined(INT16_MAX)
/* int8_t is not mandatory */
typedef int_least8_t int8_t;
#  endif
#endif

#if !defined(PRId16)
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "ld"
#  define PRId64 "lld"
#elif !defined(PRId8)
#  define PRId8 "d"
#endif
#if !defined(INT16_C)
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c ## L
#  define INT64_C(c) c ## LL
#elif !defined(INT8_C)
#  define INT8_C(c) c
#endif
#if !defined(INT16_MIN)
#  define INT8_MIN (-INT8_C(127)-1)
#  define INT8_MAX (INT8_C(127))
#  define INT16_MIN (-INT16_C(32767)-1)
#  define INT16_MAX (INT16_C(32767))
#  define INT32_MIN (-INT32_C(2147483647)-1)
#  define INT32_MAX (INT32_C(2147483647))
#  define INT64_MIN (-INT64_C(9223372036854775807)-1)
#  define INT64_MAX (INT64_C(9223372036854775807))
#elif !defined(INT8_MIN)
#  define INT8_MIN (-INT8_C(127)-1)
#endif


/*
  Endian stuff
*/
#if defined(BSD) && (BSD >= 199103)
#  include <machine/endian.h>
#elif defined(__linux__)
#  include <endian.h>
#elif defined(__alpha__) || defined(__alpha) || defined(_M_ALPHA)
/* bi-endian processor, current mode should be find in machine/endian.h file */
#  include <machine/endian.h>
#endif



#if !defined(BYTE_ORDER) && defined(__BYTE_ORDER)
#  define BYTE_ORDER      __BYTE_ORDER
#endif

#if !defined(LITTLE_ENDIAN) && defined(__LITTLE_ENDIAN)
#  define LITTLE_ENDIAN      __LITTLE_ENDIAN
#endif

#if !defined(BIG_ENDIAN) && defined(__BIG_ENDIAN)
#  define BIG_ENDIAN      __BIG_ENDIAN
#endif

#if !defined(LITTLE_ENDIAN)
#  define LITTLE_ENDIAN   1234    /* LSB first (vax, pc) */
#endif
#if !defined(BIG_ENDIAN)
#  define BIG_ENDIAN      4321    /* MSB first (IBM, net) */
#endif
#if !defined(PDP_ENDIAN)
#  define PDP_ENDIAN      3412    /* LSB first in word, MSW first in long */
#endif

#if !defined(BYTE_ORDER) && defined(BIT_ZERO_ON_RIGHT)
#  define BYTE_ORDER      LITTLE_ENDIAN
#elif !defined(BYTE_ORDER) && defined(BIT_ZERO_ON_LEFT)
#  define BYTE_ORDER      BIG_ENDIAN
#elif !defined(BYTE_ORDER)

/* HP RISC */
#  if defined(__hppa__) || defined(__hppa) || defined(__hp9000) || \
      defined(__hp9000s300) || defined(hp9000s300) || \
      defined(__hp9000s700) || defined(hp9000s700) || \
      defined(__hp9000s800) || defined(hp9000s800) || defined(hp9000s820)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* IBM */
#  if defined(ibm032) || defined(ibm370) || defined(_IBMR2)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* Intel x86 */
#  if defined(i386) || defined(__i386__) || defined(__i386) || \
      defined(_M_IX86) || defined(_X86_) || defined(__THW_INTEL) || \
      defined(sun386)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Intel Itanium */
#  if defined(__ia64__) || defined(_IA64) || defined(__IA64__) || \
      defined(_M_IA64)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Nationnal Semiconductor 32000 serie */
#  if  defined(ns32000)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Motorola 68000 */
#  if defined(mc68000) || defined(is68k) || defined(macII) || defined(m68k)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* MIPS */
#  if defined(MIPSEL) || defined(_MIPSEL)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  elif defined(MIPSEB) || defined(_MIPSEB)
#    define BYTE_ORDER      BIG_ENDIAN
#  elif defined(__mips__) || defined(__mips) || defined(__MIPS__)
#    error "MIPS are bi-endian processors. Endianness is unknown for this system, please drop an e-mail to SmartEiffel@loria.fr"
#  endif

/* Power PC */
/* this processor is bi-endian, how to know if little-endian is set? */
#  if defined(__powerpc) || defined(__powerpc__) || defined(__POWERPC__) || \
      defined(__ppc__) || defined(__ppc) || defined(_M_PPC) || \
      defined(__PPC) || defined(__PPC__)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* Pyramid 9810 */
#  if defined(pyr)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* RS/6000 */
#  if defined(__THW_RS6000) || defined(_IBMR2) || defined(_POWER) || \
      defined(_ARCH_PWR) || defined(_ARCH_PWR2)
#    define BYTE_ORDER      _ENDIAN
#  endif

/* SPARC */
#  if defined(__sparc__) || defined(sparc) || defined(__sparc)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* CCI Tahoe */
#  if defined(tahoe)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif

/* VAX */
#  if defined(vax) || defined(VAX) || defined(__vax__) || defined(_vax_) || \
      defined(__vax) || defined(__VAX)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* ELATE is a virtual OS with a little endian Virtual Processor */
#  if defined(__ELATE__)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Miscellaneous little endian */
#  if defined(wrltitan)
#    define BYTE_ORDER      LITTLE_ENDIAN
#  endif

/* Miscellaneous big endian */
#  if defined(apollo) || defined(__convex__) || defined(_CRAY) || defined(sel)
#    define BYTE_ORDER      BIG_ENDIAN
#  endif
#endif


#if !defined(BYTE_ORDER)
#  error "Unknown byte order. Add your system in above macros once you know your system type. Please drop an e-mail to SmartEiffel@loria.fr"
#endif
#if (BYTE_ORDER != BIG_ENDIAN && BYTE_ORDER != LITTLE_ENDIAN)
#  error "Only little-endian and big-endian are valid at this time. Please drop an e-mail to SmartEiffel@loria.fr"
#endif


/*
  Byte swapping stuff
*/
extern void copy_swap_16(const uint16_t *src, uint16_t *dest, int count);


/* Because ANSI C EXIT_* are not always defined: */
#ifndef EXIT_FAILURE
#  define EXIT_FAILURE 1
#endif
#ifndef EXIT_SUCCESS
#  define EXIT_SUCCESS 0
#endif

/*
   On Linux glibc systems, we need to use sig.* versions of jmp_buf,
   setjmp and longjmp to preserve the signal handling context.
   Currently, the way I figured to detect this is if _SIGSET_H_types has
   been defined in /usr/include/setjmp.h.

   NOTE: with gcc, -ansi is used for SmartEiffel generated files EXCEPT in
   -no_split mode. ANSI only recognizes the non-sig versions.
*/
#if (defined(_SIGSET_H_types) && !defined(__STRICT_ANSI__))
#  define JMP_BUF    sigjmp_buf
#  define SETJMP(x)  sigsetjmp( (x), 1)
#  define LONGJMP    siglongjmp
#else
#  define JMP_BUF    jmp_buf
#  define SETJMP(x)  setjmp( (x) )
#  define LONGJMP    longjmp
#endif

/*
   Type to store reference objects Id:
 */
typedef int Tid;
typedef struct S0 T0;
struct S0{Tid id;};

/*
   The default channel used to print runtime error messages:
*/
#define SE_ERR stderr

/*
   Eiffel type INTEGER_8 is #1:
*/
typedef int8_t T1;
#define EIF_INTEGER_8 T1
#define M1 (INT8_C(0))
#define EIF_INTEGER_8_BITS (CHAR_BIT)
#define EIF_MINIMUM_INTEGER_8 (INT8_MIN)
#define EIF_MAXIMUM_INTEGER_8 (INT8_MAX)

/*
  Eiffel type INTEGER_16 is #10:
*/
typedef int16_t T10;
#define EIF_INTEGER_16 T10
#define M10 (INT16_C(0))
#define EIF_INTEGER_16_BITS (CHAR_BIT*sizeof(T10t))
#define EIF_MINIMUM_INTEGER_16 (INT16_MIN) /*-32768*/
#define EIF_MAXIMUM_INTEGER_16 (INT16_MAX) /*+32767*/

/*
  Eiffel type INTEGER or INTEGER_32 is #2:
*/
typedef int32_t T2;
#define EIF_INTEGER T2
#define EIF_INTEGER_32 T2
#define M2 (INT32_C(0))
#define EIF_INTEGER_BITS ((T2)(CHAR_BIT*sizeof(T2)))
#define EIF_INTEGER_32_BITS EIF_INTEGER_BITS
#define EIF_MINIMUM_INTEGER (INT32_MIN)
#define EIF_MAXIMUM_INTEGER (INT32_MAX)

/*
  Eiffel type INTEGER_64 is #11:
*/
typedef int64_t T11;
#define EIF_INTEGER_64 T11
#define M11 (INT64_C(0))
#define EIF_INTEGER_64_BITS (CHAR_BIT*sizeof(T11))
#define EIF_MINIMUM_INTEGER_64 (INT64_MIN)
#define EIF_MAXIMUM_INTEGER_64 (INT64_MAX)

/*
  Eiffel type CHARACTER is #3:
*/
typedef unsigned char T3;
#define EIF_CHARACTER T3
#define M3 (0)
#define EIF_CHARACTER_BITS (CHAR_BIT)
#define EIF_MINIMUM_CHARACTER_CODE (0)
#define EIF_MAXIMUM_CHARACTER_CODE (255)
#define T3code(x) ((T10)(x))
#define T3to_integer(x) ((signed char)(x))
#define T3to_bit(x) (x)

/*
  Eiffel type REAL is #4:
*/
typedef float T4;
#define EIF_REAL T4
#define M4 (0.0)
#define EIF_REAL_BITS (CHAR_BIT*sizeof(float))
#define EIF_MINIMUM_REAL (-(FLT_MAX))
#define EIF_MAXIMUM_REAL (FLT_MAX)

/*
  Eiffel type DOUBLE is #5:
*/
typedef double T5;
#define EIF_DOUBLE T5
#define M5 (0.0)
#define EIF_DOUBLE_BITS (CHAR_BIT*sizeof(double))
#define EIF_MINIMUM_DOUBLE (-(DBL_MAX))
#define EIF_MAXIMUM_DOUBLE (DBL_MAX)

/*
  Eiffel type BOOLEAN is #6:
*/
typedef char T6;
#define EIF_BOOLEAN T6
#define M6 (0)
#define EIF_BOOLEAN_BITS (CHAR_BIT)

/*
   Eiffel type POINTER is #8:
*/
typedef void* T8;
#define EIF_POINTER T8
/* Sometimes, NULL is defined as 0 */
#define M8 ((void*)NULL)
#define EIF_POINTER_BITS (CHAR_BIT*sizeof(void*))

/*
  To use type STRING on the C side:
*/
#define EIF_STRING T7*

/*
  Some Other EIF_* defined in ETL:
*/
#define eif_access(x) ((char*)(x))
#define EIF_REFERENCE T0*
#define EIF_OBJ T0*
#define EIF_OBJECT EIF_OBJ

/*
   Wrappers for `malloc' and `calloc':
*/
void* se_malloc(size_t size);
void* se_calloc(size_t nmemb, size_t size);


#endif /* #ifndef _BASE_H */
#define SE_BOOST 1
#define SE_EXCEPTIONS 1

/*C Header Pass 1 :*/
typedef struct S323 T323;
typedef void*T633;
typedef struct S418 T418;
typedef struct S40 T40;
typedef int T49;
typedef struct S291 T291;
typedef void*T417;
typedef struct S738 T738;
typedef struct S652 T652;
typedef struct S403 T403;
typedef struct S298 T298;
typedef struct S406 T406;
typedef struct S289 T289;
typedef struct S687 T687;
typedef void*T632;
typedef struct S260 T260;
typedef struct S590 T590;
typedef struct S45 T45;
typedef struct S736 T736;
typedef struct S145 T145;
typedef struct S301 T301;
typedef void*T601;
typedef struct S416 T416;
typedef struct S103 T103;
typedef struct S634 T634;
typedef void*T566;
typedef struct S411 T411;
typedef struct S361 T361;
typedef struct S791 T791;
typedef struct S409 T409;
typedef struct S77 T77;
typedef struct S765 T765;
typedef struct S131 T131;
typedef struct S239 T239;
typedef struct S297 T297;
typedef struct S602 T602;
typedef void*T465;
typedef struct S12 T12;
typedef struct S267 T267;
typedef struct S773 T773;
typedef struct S529 T529;
typedef void*T591;
typedef struct S174 T174;
typedef struct S253 T253;
typedef void*T434;
typedef struct S464 T464;
typedef void*T378;
typedef void*T579;
typedef struct S231 T231;
typedef struct S194 T194;
typedef struct S448 T448;
typedef struct S628 T628;
typedef void*T74;
typedef struct S102 T102;
typedef void*T711;
typedef void*T221;
typedef struct S362 T362;
typedef struct S462 T462;
typedef struct S443 T443;
typedef void*T551;
typedef struct S365 T365;
typedef struct S479 T479;
typedef void*T119;
typedef struct S574 T574;
typedef struct S129 T129;
typedef void*T322;
typedef struct S254 T254;
typedef struct S360 T360;
typedef struct S521 T521;
typedef struct S264 T264;
typedef struct S747 T747;
typedef struct S250 T250;
typedef void*T563;
typedef struct S115 T115;
typedef struct S445 T445;
typedef struct S450 T450;
typedef void*T121;
typedef void*T487;
typedef struct S724 T724;
typedef void*T504;
typedef void*T405;
typedef struct S316 T316;
typedef struct S279 T279;
typedef struct S694 T694;
typedef struct S347 T347;
typedef struct S116 T116;
typedef void*T620;
typedef struct S141 T141;
typedef struct S778 T778;
typedef struct S241 T241;
typedef struct S290 T290;
typedef struct S705 T705;
typedef struct S584 T584;
typedef struct S491 T491;
typedef struct S283 T283;
typedef struct S43 T43;
typedef struct S16 T16;
typedef struct S586 T586;
typedef void*T73;
typedef struct S614 T614;
typedef void*T558;
typedef struct S111 T111;
typedef struct S444 T444;
typedef void*T573;
typedef struct S112 T112;
typedef void*T76;
typedef struct S363 T363;
typedef struct S142 T142;
typedef void*T635;
typedef struct S151 T151;
typedef struct S780 T780;
typedef struct S359 T359;
typedef struct S567 T567;
typedef struct S568 T568;
typedef struct S608 T608;
typedef struct S767 T767;
typedef void*T410;
typedef void*T331;
typedef struct S559 T559;
typedef struct S266 T266;
typedef struct S412 T412;
typedef struct S596 T596;
typedef struct S124 T124;
typedef struct S451 T451;
typedef void*T768;
typedef struct S525 T525;
typedef struct S575 T575;
typedef struct S328 T328;
typedef struct S732 T732;
typedef struct S162 T162;
typedef struct S480 T480;
typedef struct S531 T531;
typedef struct S714 T714;
typedef struct S658 T658;
typedef struct S252 T252;
typedef void*T585;
typedef struct S630 T630;
typedef struct S545 T545;
typedef struct S146 T146;
typedef struct S557 T557;
typedef struct S293 T293;
typedef struct S251 T251;
typedef struct S717 T717;
typedef struct S195 T195;
typedef struct S449 T449;
typedef struct S783 T783;
typedef struct S38 T38;
typedef struct S629 T629;
typedef struct S219 T219;
typedef struct S280 T280;
typedef struct S232 T232;
typedef struct S553 T553;
typedef struct S31 T31;
typedef struct S729 T729;
typedef void*T108;
typedef struct S532 T532;
typedef struct S7 T7;
typedef struct S748 T748;
typedef void*T249;
typedef struct S369 T369;
typedef struct S619 T619;
typedef void*T101;
typedef struct S274 T274;
typedef struct S669 T669;
typedef struct S118 T118;
typedef struct S685 T685;
typedef struct S210 T210;
typedef struct S113 T113;
typedef struct S21 T21;
typedef struct S110 T110;
typedef void*T754;
typedef struct S354 T354;
typedef struct S390 T390;
typedef struct S173 T173;
typedef struct S592 T592;
typedef struct S695 T695;
typedef struct S693 T693;
typedef struct S709 T709;
typedef struct S243 T243;
typedef struct S117 T117;
typedef struct S501 T501;
typedef struct S481 T481;
typedef struct S688 T688;
typedef struct S109 T109;
typedef struct S612 T612;
typedef struct S303 T303;
typedef struct S442 T442;
typedef void*T607;
typedef void*T492;
typedef struct S572 T572;
typedef struct S163 T163;
typedef struct S781 T781;
typedef struct S44 T44;
typedef struct S746 T746;
typedef struct S534 T534;
typedef struct S33 T33;
typedef struct S447 T447;
typedef void*T62;
typedef struct S744 T744;
typedef struct S408 T408;
typedef void*T160;
typedef struct S306 T306;
typedef struct S272 T272;
typedef void*T357;
typedef struct S564 T564;
typedef struct S65 T65;
typedef struct S97 T97;
typedef struct S292 T292;
typedef struct S555 T555;
typedef struct S507 T507;
typedef struct S776 T776;
typedef struct S285 T285;
typedef struct S715 T715;
typedef struct S626 T626;
typedef struct S431 T431;
typedef struct S554 T554;
typedef void*T149;
typedef struct S446 T446;
typedef struct S435 T435;
typedef struct S615 T615;
typedef struct S788 T788;
typedef struct S782 T782;
typedef void*T638;
typedef struct S550 T550;
typedef void*T217;
typedef struct S428 T428;
typedef struct S690 T690;
typedef struct S126 T126;
typedef struct S419 T419;
typedef struct S192 T192;
typedef struct S79 T79;
typedef struct S220 T220;
typedef void*T376;
typedef struct S580 T580;
typedef struct S372 T372;
typedef struct S402 T402;
typedef struct S741 T741;
typedef struct S533 T533;
typedef struct S488 T488;
typedef struct S98 T98;
typedef struct S618 T618;
typedef void*T415;
typedef struct S226 T226;
typedef struct S679 T679;
typedef struct S609 T609;
typedef void*T332;
typedef struct S240 T240;
typedef void*T407;
typedef struct S37 T37;
typedef struct S17 T17;
typedef struct S603 T603;
typedef struct S437 T437;
typedef struct S30 T30;
typedef void*T39;
typedef void*T315;
typedef struct S422 T422;
typedef struct S482 T482;
typedef struct S429 T429;
typedef struct S475 T475;
typedef struct S400 T400;

/*C Header Pass 2 :*/
typedef T8*T707;
#define M707 NULL
typedef T0**T300;
#define M300 NULL
typedef T0**T414;
#define M414 NULL
typedef T0**T606;
#define M606 NULL
typedef T0**T125;
#define M125 NULL
typedef T0**T371;
#define M371 NULL
typedef T0**T595;
#define M595 NULL
typedef T0**T578;
#define M578 NULL
typedef T6*T105;
#define M105 NULL
typedef T0**T367;
#define M367 NULL
typedef T0**T770;
#define M770 NULL
typedef T0**T144;
#define M144 NULL
typedef T0**T571;
#define M571 NULL
typedef T0**T785;
#define M785 NULL
typedef T0**T589;
#define M589 NULL
typedef T0**T562;
#define M562 NULL
typedef T10*T228;
#define M228 NULL
typedef T0**T128;
#define M128 NULL
typedef T0**T611;
#define M611 NULL
typedef T0**T330;
#define M330 NULL
typedef T0**T282;
#define M282 NULL
typedef T0**T224;
#define M224 NULL
typedef T3*T9;
#define M9 NULL
typedef T1*T234;
#define M234 NULL
typedef T0**T583;
#define M583 NULL
typedef T2*T94;
#define M94 NULL
typedef T0**T287;
#define M287 NULL
typedef T0**T421;
#define M421 NULL

/*C Header Pass 3 :*/
struct S33{T8 _directory_stream;T8 _current_entry;};
int se_cmpT33(T33 o1,T33 o2);

/*C Header Pass 4 :*/
struct S323{T0* _comparator;};
extern T323 M323;
extern T633 M633;
struct S418{T421 _storage;T2 _capacity;T2 _upper;};
extern T418 M418;
struct S40{Tid id;T0* _doc;T0* _params;T0* _ast;T0* _parts;T0* _authors;T0* _comments;T0* _summary;T0* _nbpages;T0* _date;T0* _type;T0* _file;T0* _title;T0* _language;T0* _url;T0* _documents;T0* _author_name;T0* _content;T0* _node_content;T0* _xml_filename;};
extern T40 M40;
extern T49 M49;
struct S291{Tid id;T2 _count;T0* _storage;T0* _symbols;};
extern T291 M291;
struct S738{T0* _item;T0* _right;};
extern T738 M738;
struct S652{T2 _position;T0* _container;};
extern T652 M652;
struct S403{Tid id;T2 _count;T2 _capacity;T0* _storage;T0* _fixed_array_;T0* _internal_cursor;};
extern T403 M403;
struct S406{T367 _storage;T2 _capacity;T2 _upper;};
extern T406 M406;
struct S289{T2 _count;T0* _storage;};
extern T289 M289;
struct S687{Tid id;T0* _item;T0* _right;};
extern T687 M687;
extern T632 M632;
struct S260{T6 _yyline_used;T0* _states;T0* _yy_accept;T0* _yy_ec;T6 _yyposition_used;T0* _input_filename;T0* _eiffel_header;T6 _bol_needed;T6 _pre_action_used;T6 _post_action_used;T6 _post_eof_action_used;T0* _yy_nxt;T6 _yybacking_up;T2 _start_states_count;T2 _maximum_symbol;T0* _yy_start_conditions;T2 _backing_up_count;T0* _partitions;T0* _yy_rules;T0* _yy_eof_rules;T2 _yynb_rules;T2 _yynull_equiv_class;T0* _eiffel_code;T6 _pre_eof_action_used;T2 _characters_count;T2 _array_size;T6 _actions_separated;T2 _yynb_rows;T2 _minimum_symbol;T2 _yyend_of_buffer;T6 _inspect_used;};
extern T260 M260;
struct S590{T0* _system_id;};
extern T590 M590;
struct S45{Tid id;T0* _name;T0* _string_name;T0* _last_string;T8 _input_stream;T6 _end_of_file;T0* _path;T6 _push_back_flag;T3 _last_character;T3 _old_last_character;T6 _end_reached;T0* _character_buffer;T6 _old_end_of_file;T9 _buffer;T2 _buffer_position;T2 _buffer_size;T2 _capacity;};
extern T45 M45;
struct S298{T2 _item;T0* _right;T0* _left;};
extern T298 M298;
struct S736{T0* _first;T0* _second;};
extern T736 M736;
struct S145{Tid id;};
extern T145 M145;
struct S301{Tid id;T0* _transition;T0* _epsilon_transition;T0* _accepted_rule;T2 _id;T6 _in_trail_context;};
extern T301 M301;
struct S416{T94 _storage;T2 _capacity;T2 _upper;};
extern T416 M416;
struct S103{T105 _storage;T2 _capacity;T2 _upper;};
extern T103 M103;
struct S634{Tid id;T2 _last_token;T0* _input_buffer;T2 _line;T2 _column;T2 _position;T2 _yy_start_state;T0* _yy_content;T0* _yy_content_area;T2 _yy_end;T2 _yy_start;T2 _yy_column;T2 _yy_line;T2 _yy_position;T6 _yy_more_flag;T2 _yy_more_len;T2 _yy_last_accepting_state;T2 _yy_last_accepting_cpos;T0* _yy_nxt;T0* _yy_chk;T0* _yy_base;T0* _yy_def;T0* _yy_ec;T0* _yy_meta;T0* _yy_accept;T0* _yy_acclist;T6 _yy_rejected;T0* _yy_state_stack;T2 _yy_state_count;T2 _yy_full_match;T2 _yy_lp;T2 _yy_looking_for_trail_begin;T2 _yy_full_lp;T2 _yy_full_state;T0* _input_stream;T0* _input_filter;T0* _last_error;T0* _filename;T0* _source;T0* _last_value;T0* _character_entity;T0* _start_conditions;T6 _decl_start_sent;T6 _decl_end_sent;};
extern T634 M634;
struct S411{T414 _storage;T2 _capacity;T2 _upper;};
extern T411 M411;
struct S361{T2 _count;T2 _capacity;T0* _storage;T0* _fixed_array_;T0* _internal_cursor;};
extern T361 M361;
struct S791{T0* _item;T0* _right;T0* _left;};
extern T791 M791;
struct S77{T0* _ast;T0* _str;T0* _path;T6 _allow_private;T0* _tcomment;T0* _tdocument;T0* _tglobal;T0* _httpd_path;T6 _is_writable;T2 _value;T0* _cerr;T0* _regexp;};
extern T77 M77;
struct S765{T2 _position;T0* _container;};
extern T765 M765;
struct S131{Tid id;T0* _next;T6 _has_error;T0* _last_error;};
extern T131 M131;
struct S239{T2 _count;T0* _first_cell;};
extern T239 M239;
struct S297{T300 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T297 M297;
struct S12{T0* _params;T2 _nb_docs;T2 _bibtex_index;T0* _tex_str;T6 _is_prog;T0* _res;};
extern T12 M12;
struct S267{T2 _error_count;T0* _yytranslate;T0* _yyr1;T0* _yydefact;T0* _yydefgoto;T0* _yypact;T0* _yypgoto;T0* _yytable;T0* _yycheck;T0* _yytypes1;T0* _yytypes2;T0* _yyss;T2 _yyssp;T6 _yy_lookahead_needed;T2 _yyerrstatus;T2 _yy_parsing_status;T2 _column;T2 _position;T2 _yy_start_state;T0* _yy_content;T0* _yy_content_area;T2 _yy_start;T2 _yy_column;T2 _yy_more_len;T2 _yy_last_accepting_state;T2 _yy_last_accepting_cpos;T0* _yy_nxt;T0* _yy_chk;T0* _yy_def;T0* _yy_ec;T0* _yy_accept;T0* _yy_acclist;T2 _yy_state_count;T2 _yy_looking_for_trail_begin;T0* _error_handler;T2 _line_nb;T0* _pending_rules;T0* _action_factory;T0* _rule;T6 _has_trail_context;T2 _singleton_line;T2 _singleton_column;T2 _singleton_count;T2 _series_line;T2 _series_count;T2 _head_column;T2 _trail_count;T0* _last_string_value;T0* _yy_base;T6 _yy_rejected;T2 _yy_full_state;T6 _successful;T0* _description;T0* _last_string;T2 _regexp_line;T0* _last_any_value;T2 _last_token;T0* _input_buffer;T2 _line;T2 _yy_end;T2 _yy_line;T2 _yy_position;T6 _yy_more_flag;T0* _yy_meta;T2 _yy_lp;T2 _yy_full_lp;T0* _character_classes;T0* _start_condition_stack;T6 _in_trail_context;T2 _series_column;T2 _regexp_column;T2 _regexp_count;T2 _head_line;T2 _head_count;T0* _last_lx_symbol_class_value;T0* _yy_state_stack;T2 _yy_full_match;T2 _rule_line_nb;T0* _name_definitions;T0* _yyvs1;T2 _yyvsc1;T2 _yyvsp1;T0* _yyspecial_routines1;T0* _yyvs2;T2 _yyvsc2;T2 _yyvsp2;T0* _yyspecial_routines2;T0* _yyvs3;T2 _yyvsc3;T2 _yyvsp3;T0* _yyspecial_routines3;T0* _yyvs4;T2 _yyvsc4;T2 _yyvsp4;T0* _yyspecial_routines4;T0* _yyvs5;T2 _yyvsc5;T2 _yyvsp5;T0* _yyspecial_routines5;T2 _last_integer_value;};
extern T267 M267;
struct S773{T0* _container;T6 _after;T6 _before;T0* _current_cell;T0* _next_cursor;};
extern T773 M773;
struct S529{Tid id;T0* _container;T2 _position;T0* _next_cursor;};
extern T529 M529;
struct S174{Tid id;T2 _last_token;T0* _input_buffer;T2 _line;T2 _column;T2 _position;T2 _yy_start_state;T0* _yy_content;T0* _yy_content_area;T2 _yy_end;T2 _yy_start;T2 _yy_column;T2 _yy_line;T2 _yy_position;T6 _yy_more_flag;T2 _yy_more_len;T2 _yy_last_accepting_state;T2 _yy_last_accepting_cpos;T0* _yy_nxt;T0* _yy_chk;T0* _yy_base;T0* _yy_def;T0* _yy_ec;T0* _yy_meta;T0* _yy_accept;T0* _yy_acclist;T6 _yy_rejected;T0* _yy_state_stack;T2 _yy_state_count;T2 _yy_full_match;T2 _yy_lp;T2 _yy_looking_for_trail_begin;T2 _yy_full_lp;T2 _yy_full_state;T0* _input_stream;T0* _input_filter;T0* _last_error;T0* _filename;T0* _source;T0* _last_value;T0* _character_entity;T0* _start_conditions;};
extern T174 M174;
struct S253{T0* _ast;T0* _regexp;T6 _res;T0* _document;T6 _allow_private;};
extern T253 M253;
extern T434 M434;
struct S464{Tid id;T0* _target;T0* _label;};
extern T464 M464;
struct S231{Tid id;T94 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T231 M231;
struct S194{Tid id;};
extern T194 M194;
struct S448{Tid id;T0* _parameters;};
extern T448 M448;
struct S628{Tid id;T6 _after;T6 _before;T0* _container;T0* _current_cell;T0* _next_cursor;};
extern T628 M628;
extern T74 M74;
extern T711 M711;
struct S462{Tid id;T0* _parameters;};
extern T462 M462;
struct S443{Tid id;T0* _parameters;};
extern T443 M443;
struct S365{T367 _storage;T2 _capacity;T2 _upper;};
extern T365 M365;
struct S479{Tid id;T0* _target;T2 _label;};
extern T479 M479;
struct S129{T0* _start;T0* _error;T0* _tree;T0* _last;};
extern T129 M129;
struct S254{T0* _subject;T2 _subject_start;T2 _subject_end;T2 _match_count;T2 _matched_start;T2 _matched_end;T0* _yy_nxt;T0* _yy_accept;T2 _yynb_rows;T6 _has_caret;T6 _has_dollar;};
extern T254 M254;
struct S521{Tid id;T2 _position;T0* _container;T0* _next_cursor;};
extern T521 M521;
struct S264{T0* _error_file;T0* _warning_file;T0* _info_file;};
extern T264 M264;
struct S250{T2 _count;T9 _area;T0* _area_string;};
extern T250 M250;
struct S115{T0* _item;T0* _next;};
extern T115 M115;
struct S445{Tid id;T0* _parameters;};
extern T445 M445;
struct S450{Tid id;T0* _parameters;};
extern T450 M450;
struct S724{T2 _count;T0* _last_cell;T0* _internal_cursor;T0* _first_cell;};
extern T724 M724;
struct S316{T0* _comparator;};
extern T316 M316;
struct S279{T2 _count;T2 _capacity;T0* _storage;T0* _fixed_array_;T0* _internal_cursor;};
extern T279 M279;
struct S694{T0* _first;T0* _second;};
extern T694 M694;
struct S347{T0* _container;T2 _position;T0* _next_cursor;};
extern T347 M347;
struct S116{T0* _item;T0* _next;};
extern T116 M116;
extern T620 M620;
struct S141{Tid id;T0* _next;T0* _document;T0* _last_position_table;T0* _current_element;T0* _namespace_cache;T0* _source_parser;};
extern T141 M141;
struct S778{T0* _item;T0* _right;T0* _left;};
extern T778 M778;
struct S241{Tid id;T0* _filename;};
extern T241 M241;
struct S290{T287 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T290 M290;
struct S705{T6 _after;T6 _before;T0* _container;T0* _current_cell;T0* _next_cursor;};
extern T705 M705;
struct S584{T0* _name;T0* _items;T3 _type;T3 _repetition;T6 _is_character_data_allowed;};
extern T584 M584;
struct S491{Tid id;T0* _parameters;};
extern T491 M491;
struct S283{T2 _count;T2 _capacity;T0* _storage;T0* _fixed_array_;T0* _internal_cursor;};
extern T283 M283;
struct S43{T0* _documents;};
extern T43 M43;
struct S16{T0* _file;T0* _buff;T0* _model;T0* _path;};
extern T16 M16;
struct S586{T589 _storage;T2 _capacity;T2 _upper;};
extern T586 M586;
extern T73 M73;
struct S409{T0* _equality_tester;T2 _count;T2 _capacity;T0* _storage;T0* _fixed_array_;T0* _internal_cursor;T6 _negated;T6 _sort_needed;};
extern T409 M409;
struct S102{T0* _set;};
extern T102 M102;
struct S614{Tid id;T6 _end_of_input;T3 _last_character;T0* _last_string;T0* _string;T2 _location;};
extern T614 M614;
struct S111{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T111 M111;
struct S444{Tid id;T0* _parameters;};
extern T444 M444;
struct S112{T0* _author_name;T0* _content;};
extern T112 M112;
extern T76 M76;
struct S363{Tid id;T2 _count;T2 _capacity;T0* _storage;T0* _fixed_array_;T0* _internal_cursor;};
extern T363 M363;
struct S142{T144 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T142 M142;
struct S151{Tid id;T0* _dtd_resolver;T0* _entity_resolver;T0* _callbacks;T0* _source;T6 _is_correct;T2 _last_error;T2 _last_internal_error;T8 _item;};
extern T151 M151;
struct S780{Tid id;T0* _parent;T0* _data;};
extern T780 M780;
struct S360{Tid id;T0* _states;T6 _in_trail_context;};
extern T360 M360;
struct S359{T0* _text;};
extern T359 M359;
struct S568{T571 _storage;T2 _capacity;T2 _upper;};
extern T568 M568;
struct S608{T611 _storage;T2 _capacity;T2 _upper;};
extern T608 M608;
struct S767{T770 _storage;T2 _capacity;T2 _upper;};
extern T767 M767;
struct S559{T562 _storage;T2 _capacity;T2 _upper;};
extern T559 M559;
struct S266{T2 _array_size;T6 _case_insensitive;T2 _characters_count;T6 _equiv_classes_used;T6 _meta_equiv_classes_used;T6 _full_table;T6 _actions_separated;T6 _inspect_used;T6 _reject_used;T6 _line_used;T6 _position_used;T6 _pre_action_used;T6 _post_action_used;T6 _pre_eof_action_used;T6 _post_eof_action_used;T0* _input_filename;T0* _start_conditions;T0* _rules;T0* _eof_rules;T0* _equiv_classes;T6 _bol_needed;T6 _variable_trail_context;T0* _eiffel_code;T0* _eiffel_header;};
extern T266 M266;
struct S412{T414 _storage;T2 _capacity;T2 _upper;};
extern T412 M412;
struct S596{T6 _use_namespaces;T0* _first;T2 _count;T0* _second;T0* _tail;};
extern T596 M596;
struct S124{T125 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T124 M124;
struct S451{T2 _position;T0* _container;T0* _next_cursor;};
extern T451 M451;
struct S525{Tid id;T0* _container;};
extern T525 M525;
struct S575{T578 _storage;T2 _capacity;T2 _upper;};
extern T575 M575;
struct S328{T330 _storage;T2 _capacity;T2 _upper;};
extern T328 M328;
struct S732{Tid id;T0* _parent;T0* _content;};
extern T732 M732;
struct S162{Tid id;};
extern T162 M162;
struct S480{Tid id;T0* _parameters;};
extern T480 M480;
struct S531{T0* _name;};
extern T531 M531;
struct S714{T0* _item;};
extern T714 M714;
struct S658{T2 _count;T0* _last_cell;T0* _internal_cursor;T0* _first_cell;};
extern T658 M658;
struct S252{T0* _ast;T0* _path;T0* _str;T0* _tdocument;T0* _tcomment;T6 _grep;};
extern T252 M252;
struct S630{T3 _item;T0* _right;};
extern T630 M630;
struct S545{T0* _last_value;T0* _eif_buffer;T0* _yydefact;T0* _yydefgoto;T0* _yypgoto;T0* _yytable;T0* _yycheck;T0* _yytypes1;T0* _yytypes2;T0* _yyss;T2 _yyssp;T2 _yyerrstatus;T2 _yy_parsing_status;T2 _line;T2 _column;T2 _position;T2 _yy_start_state;T0* _yy_content_area;T2 _yy_start;T2 _yy_line;T2 _yy_column;T2 _yy_position;T2 _yy_more_len;T2 _yy_last_accepting_cpos;T0* _yyvs;T2 _yyvsc;T0* _yyval;T0* _fixed_array_;T0* _yy_nxt;T0* _yy_chk;T0* _yy_base;T0* _yy_def;T0* _yy_ec;T0* _yy_accept;T0* _yy_acclist;T6 _yy_rejected;T0* _yy_state_stack;T2 _yy_state_count;T2 _yy_lp;T2 _yy_looking_for_trail_begin;T2 _yy_full_lp;T2 _yy_full_state;T2 _eif_lineno;T2 _error_count;T0* _yytranslate;T0* _yyr1;T0* _yypact;T6 _yy_lookahead_needed;T0* _input_buffer;T6 _yy_more_flag;T2 _yy_last_accepting_state;T2 _yyvsp;T2 _last_token;T0* _yy_content;T2 _yy_end;T0* _yy_meta;T2 _yy_full_match;T0* _data;};
extern T545 M545;
struct S146{Tid id;T0* _next;T0* _context;T0* _element_prefix;T0* _element_local_part;T0* _attributes_prefix;T0* _attributes_local_part;T0* _attributes_value;};
extern T146 M146;
struct S293{T105 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T293 M293;
struct S251{T2 _code;};
extern T251 M251;
struct S717{T0* _context;};
extern T717 M717;
struct S195{Tid id;};
extern T195 M195;
struct S449{Tid id;T0* _parameters;};
extern T449 M449;
struct S783{T785 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T783 M783;
struct S38{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T38 M38;
struct S629{Tid id;T2 _count;T0* _first_cell;T0* _last_cell;T0* _internal_cursor;};
extern T629 M629;
struct S219{T128 _storage;T2 _capacity;T2 _upper;};
extern T219 M219;
struct S280{T282 _storage;T2 _capacity;T2 _upper;};
extern T280 M280;
struct S362{T2 _id;T0* _name;T0* _patterns;T0* _bol_patterns;T6 _is_exclusive;};
extern T362 M362;
struct S232{Tid id;T234 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T232 M232;
struct S553{Tid id;T2 _item;};
extern T553 M553;
struct S31{T0* _path;T6 _end_of_input;T6 _push_back_flag;T8 _input_stream;T9 _buffer;T6 _end_reached;T2 _buffer_position;T2 _buffer_size;T2 _capacity;};
extern T31 M31;
struct S729{T6 _after;T6 _before;T0* _container;T0* _current_cell;T0* _next_cursor;};
extern T729 M729;
struct S532{T0* _ast;T6 _enable_private;T2 _pos;T0* _path;T0* _str;T0* _tdocument;};
extern T532 M532;
struct S748{T0* _equality_tester;T2 _count;T2 _capacity;T2 _last_position;T2 _modulus;T2 _free_slot;T2 _position;T2 _slots_position;T2 _clashes_previous_position;T2 _found_position;T0* _internal_cursor;T0* _items;T0* _clashes;T0* _slots;T0* _fixed_item_array_;};
extern T748 M748;
struct S369{T371 _storage;T2 _capacity;T2 _upper;};
extern T369 M369;
struct S619{T2 _item;T0* _right;};
extern T619 M619;
struct S274{T2 _id;T0* _action;T0* _pattern;T2 _line_nb;T2 _trail_count;T2 _head_count;T2 _line_count;T2 _column_count;T6 _is_useful;T6 _has_trail_context;};
extern T274 M274;
struct S669{T6 _before;T0* _container;};
extern T669 M669;
struct S118{T2 _item;T0* _next;};
extern T118 M118;
struct S685{T6 _after;T6 _before;T0* _container;T0* _current_cell;T0* _next_cursor;};
extern T685 M685;
struct S210{T2 _position;T0* _container;T0* _next_cursor;};
extern T210 M210;
struct S113{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T113 M113;
struct S21{T6 _verbose;T6 _html_mode;T6 _display_mode;T6 _bibtex_mode;T6 _latex_mode;T0* _xml_file;T0* _input_path;T6 _recursive;T0* _output_file;T0* _output_path;T0* _httpd_path;T6 _enable_private;T0* _regexp;T6 _insensitive;T0* _conffile;T0* _template_path;};
extern T21 M21;
struct S110{T0* _parts;T0* _authors;T0* _comments;T0* _summary;T0* _nbpages;T0* _date;T0* _type;T0* _file;T0* _url;T0* _title;T0* _language;T6 _mark;};
extern T110 M110;
struct S354{T0* _container;T2 _position;T0* _next_cursor;};
extern T354 M354;
struct S390{Tid id;T2 _position;T0* _container;};
extern T390 M390;
struct S7{Tid id;T9 _storage;T2 _count;T2 _capacity;};
extern T7 M7;
struct S592{T595 _storage;T2 _capacity;T2 _upper;};
extern T592 M592;
struct S574{T2 _count;T0* _last_cell;T0* _internal_cursor;T0* _first_cell;};
extern T574 M574;
struct S695{T2 _count;T0* _last_cell;T0* _internal_cursor;T0* _first_cell;};
extern T695 M695;
struct S693{T0* _first;T0* _second;};
extern T693 M693;
struct S709{T0* _item;T0* _right;T0* _left;};
extern T709 M709;
struct S243{Tid id;T0* _content;T2 _count;T2 _capacity;T2 _position;T2 _column;T2 _line;T2 _index;T6 _beginning_of_line;T6 _filled;};
extern T243 M243;
struct S117{T0* _item;T0* _next;};
extern T117 M117;
struct S501{T0* _container;T2 _position;T0* _next_cursor;};
extern T501 M501;
struct S481{Tid id;T0* _parameters;};
extern T481 M481;
struct S688{Tid id;T0* _item;T0* _right;T0* _left;};
extern T688 M688;
struct S109{T0* _lower_table;T0* _flip_table;};
extern T109 M109;
struct S612{T0* _item;T0* _right;};
extern T612 M612;
struct S303{Tid id;T0* _equality_tester;T2 _count;T2 _capacity;T0* _storage;T0* _fixed_array_;T0* _internal_cursor;};
extern T303 M303;
struct S442{Tid id;T0* _parameters;};
extern T442 M442;
extern T492 M492;
struct S572{T0* _name;T3 _type;T3 _value;T0* _default_value;T6 _is_list_type;T0* _enumeration_list;};
extern T572 M572;
struct S163{Tid id;T0* _yydefact;T0* _yydefgoto;T0* _yytable;T0* _yycheck;T0* _yytypes1;T0* _yytypes2;T0* _yyss;T2 _yyssp;T6 _yy_lookahead_needed;T2 _yyerrstatus;T0* _callbacks;T2 _string_mode;T0* _dtd_resolver;T0* _entity_resolver;T2 _error_count;T0* _yytranslate;T0* _yyr1;T0* _yypact;T0* _yypgoto;T2 _yy_parsing_status;T0* _dtd_callbacks;T0* _last_any_value;T0* _last_string_value;T6 _use_namespaces;T0* _last_error_description;T0* _entities;T0* _pe_entities;T6 _in_external_dtd;T0* _scanner;T0* _scanners;T2 _last_token;T0* _yyvs1;T2 _yyvsc1;T2 _yyvsp1;T0* _yyspecial_routines1;T0* _yyvs2;T2 _yyvsc2;T2 _yyvsp2;T0* _yyspecial_routines2;T0* _yyvs3;T2 _yyvsc3;T2 _yyvsp3;T0* _yyspecial_routines3;T0* _yyvs4;T2 _yyvsc4;T2 _yyvsp4;T0* _yyspecial_routines4;T0* _yyvs5;T2 _yyvsc5;T2 _yyvsp5;T0* _yyspecial_routines5;T0* _yyvs6;T2 _yyvsc6;T2 _yyvsp6;T0* _yyspecial_routines6;T0* _yyvs7;T2 _yyvsc7;T2 _yyvsp7;T0* _yyspecial_routines7;T0* _yyvs8;T2 _yyvsc8;T2 _yyvsp8;T0* _yyspecial_routines8;T0* _yyvs9;T2 _yyvsc9;T2 _yyvsp9;T0* _yyspecial_routines9;T0* _yyvs10;T2 _yyvsc10;T2 _yyvsp10;T0* _yyspecial_routines10;T0* _yyvs11;T2 _yyvsc11;T2 _yyvsp11;T0* _yyspecial_routines11;};
extern T163 M163;
struct S781{Tid id;T0* _element;T0* _character_data;T0* _processing_instruction;T0* _document;T0* _comment;T0* _xml_attribute;T0* _composite;};
extern T781 M781;
struct S44{T0* _path;T0* _event_parser;T0* _tree_pipe;};
extern T44 M44;
struct S746{T2 _count;T0* _first_cell;T0* _last_cell;};
extern T746 M746;
struct S534{Tid id;T0* _parent;T2 _count;T0* _first_cell;T0* _last_cell;T0* _internal_cursor;T0* _root_element;};
extern T534 M534;
extern T33 M33;
struct S447{Tid id;T0* _parameters;};
extern T447 M447;
extern T62 M62;
struct S744{T0* _item;T0* _right;};
extern T744 M744;
struct S408{T128 _storage;T2 _capacity;T2 _upper;};
extern T408 M408;
extern T160 M160;
struct S306{Tid id;T0* _target;};
extern T306 M306;
struct S272{Tid id;T2 _id;T0* _states;T0* _accepted_rules;T0* _accepted_head_rules;T0* _transitions;T2 _code;};
extern T272 M272;
struct S564{T105 _storage;T2 _capacity;T2 _upper;};
extern T564 M564;
struct S65{Tid id;T9 _storage;T2 _count;T2 _capacity;T2 _byte_count;T2 _last_byte_index_input;T2 _last_byte_index_result;};
extern T65 M65;
struct S97{Tid id;T94 _storage;T2 _capacity;T2 _upper;};
extern T97 M97;
struct S292{Tid id;T2 _count;T0* _storage;};
extern T292 M292;
struct S555{Tid id;T6 _item;};
extern T555 M555;
struct S507{Tid id;T0* _equality_tester;T2 _count;T2 _capacity;T2 _last_position;T2 _modulus;T2 _free_slot;T2 _position;T2 _slots_position;T2 _clashes_previous_position;T2 _found_position;T0* _internal_cursor;T0* _key_equality_tester;T0* _items;T0* _keys;T0* _clashes;T0* _slots;T0* _fixed_item_array_;T0* _fixed_key_array_;};
extern T507 M507;
struct S776{Tid id;T0* _parent;T0* _target;T0* _data;};
extern T776 M776;
struct S557{T0* _version;T0* _encoding;T6 _stand_alone;};
extern T557 M557;
struct S285{T287 _storage;T2 _capacity;T2 _upper;};
extern T285 M285;
struct S715{Tid id;T0* _uri;};
extern T715 M715;
struct S626{Tid id;T0* _container;T6 _after;T6 _before;T0* _current_cell;T0* _next_cursor;};
extern T626 M626;
struct S431{Tid id;T0* _content;T2 _count;T2 _capacity;T2 _position;T2 _column;T2 _line;T2 _index;T6 _beginning_of_line;T6 _filled;T6 _interactive;T0* _file;T6 _end_of_file;};
extern T431 M431;
struct S554{T2 _buffer_position;T9 _buffer;T2 _capacity;T0* _name;};
extern T554 M554;
extern T149 M149;
struct S173{Tid id;T2 _last_token;T0* _input_buffer;T2 _line;T2 _column;T2 _position;T2 _yy_start_state;T0* _yy_content;T0* _yy_content_area;T2 _yy_end;T2 _yy_start;T2 _yy_column;T2 _yy_line;T2 _yy_position;T6 _yy_more_flag;T2 _yy_more_len;T2 _yy_last_accepting_state;T2 _yy_last_accepting_cpos;T0* _yy_nxt;T0* _yy_chk;T0* _yy_base;T0* _yy_def;T0* _yy_ec;T0* _yy_meta;T0* _yy_accept;T0* _yy_acclist;T6 _yy_rejected;T0* _yy_state_stack;T2 _yy_state_count;T2 _yy_full_match;T2 _yy_lp;T2 _yy_looking_for_trail_begin;T2 _yy_full_lp;T2 _yy_full_state;T0* _input_stream;T0* _input_filter;T0* _last_error;T0* _filename;T0* _source;T0* _last_value;T0* _character_entity;T0* _start_conditions;T0* _resolver;T6 _is_external;T0* _value;T6 _in_use;};
extern T173 M173;
struct S446{Tid id;T0* _parameters;};
extern T446 M446;
struct S435{T0* _name;};
extern T435 M435;
struct S615{Tid id;T0* _last_string;T2 _encoding;T0* _utf_queue;T0* _impl;};
extern T615 M615;
struct S788{T0* _source;T2 _byte_index;T2 _column;T2 _row;};
extern T788 M788;
struct S782{Tid id;T0* _parent;T0* _name;T0* _namespace;T0* _value;};
extern T782 M782;
struct S550{T0* _html_file;T0* _bibtex_file;T0* _latex_file;T0* _xml_file;T0* _input_path;T0* _output_path;T0* _mode;T6 _recursive;T6 _enable_private;T0* _template_path;T0* _httpd_path;};
extern T550 M550;
struct S428{Tid id;T9 _storage;T2 _count;T2 _capacity;T2 _byte_count;T2 _last_byte_index_input;T2 _last_byte_index_result;};
extern T428 M428;
struct S690{Tid id;T2 _last_token;T0* _input_buffer;T2 _line;T2 _column;T2 _position;T2 _yy_start_state;T0* _yy_content;T0* _yy_content_area;T2 _yy_end;T2 _yy_start;T2 _yy_column;T2 _yy_line;T2 _yy_position;T6 _yy_more_flag;T2 _yy_more_len;T2 _yy_last_accepting_state;T2 _yy_last_accepting_cpos;T0* _yy_nxt;T0* _yy_chk;T0* _yy_base;T0* _yy_def;T0* _yy_ec;T0* _yy_meta;T0* _yy_accept;T0* _yy_acclist;T6 _yy_rejected;T0* _yy_state_stack;T2 _yy_state_count;T2 _yy_full_match;T2 _yy_lp;T2 _yy_looking_for_trail_begin;T2 _yy_full_lp;T2 _yy_full_state;T0* _input_stream;T0* _input_filter;T0* _last_error;T0* _filename;T0* _source;T0* _last_value;T0* _character_entity;T0* _start_conditions;T0* _resolver;T6 _is_external;T0* _value;T6 _in_use;T6 _pre_sent;T6 _post_sent;};
extern T690 M690;
struct S126{T128 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T126 M126;
struct S419{T421 _storage;T2 _capacity;T2 _upper;};
extern T419 M419;
struct S192{T0* _equality_tester;T2 _count;T2 _capacity;T2 _last_position;T2 _modulus;T2 _free_slot;T2 _position;T2 _slots_position;T2 _clashes_previous_position;T2 _found_position;T0* _internal_cursor;T0* _key_equality_tester;T0* _items;T0* _keys;T0* _clashes;T0* _slots;T0* _fixed_item_array_;T0* _fixed_key_array_;};
extern T192 M192;
struct S79{T6 _is_caseless;T6 _is_extended;T6 _is_greedy;T6 _is_multiline;T6 _is_dotall;T6 _is_empty_allowed;T6 _is_dollar_endonly;T6 _is_bol;T6 _is_eol;T6 _is_anchored;T6 _is_strict;T0* _byte_code;T0* _character_case_mapping;T0* _word_set;T0* _error_message;T2 _error_code;T2 _error_position;T6 _is_startline;T6 _is_ichanged;T2 _optchanged;T2 _code_index;T0* _pattern;T2 _pattern_position;T2 _pattern_count;T2 _subexpression_count;T2 _maxbackrefs;T0* _start_bits;T2 _first_character;T2 _required_character;T2 _regexp_countlits;T0* _subject;T2 _subject_start;T2 _subject_end;T2 _match_count;T6 _is_matching_caseless;T6 _is_matching_multiline;T6 _is_matching_dotall;T2 _subject_next_start;T2 _first_matched_index;T2 _eptr;T0* _offset_vector;T2 _offset_vector_count;T2 _offset_top;T94 _brastart_vector;T2 _brastart_lower;T2 _brastart_count;T2 _brastart_capacity;T94 _eptr_vector;T2 _eptr_lower;T2 _eptr_upper;T2 _eptr_capacity;};
extern T79 M79;
struct S220{T224 _storage;T2 _capacity;T2 _upper;};
extern T220 M220;
struct S580{T583 _storage;T2 _capacity;T2 _upper;};
extern T580 M580;
struct S372{Tid id;T0* _equality_tester;T2 _count;T2 _capacity;T2 _last_position;T2 _modulus;T2 _free_slot;T2 _position;T2 _slots_position;T2 _clashes_previous_position;T2 _found_position;T0* _internal_cursor;T0* _key_equality_tester;T0* _items;T0* _keys;T0* _clashes;T0* _slots;T0* _fixed_item_array_;T0* _fixed_key_array_;};
extern T372 M372;
struct S402{T282 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T402 M402;
struct S741{Tid id;T0* _parent;T0* _name;T0* _namespace;T2 _count;T0* _first_cell;T0* _last_cell;T0* _internal_cursor;};
extern T741 M741;
struct S533{T0* _ast;T6 _enable_private;T0* _path;T0* _str;T0* _tdocument;T0* _tcomment;};
extern T533 M533;
struct S488{T0* _comparator;};
extern T488 M488;
struct S98{T2 _count;T2 _capacity;T94 _byte_code;T105 _character_sets;T2 _character_sets_count;T2 _character_sets_capacity;};
extern T98 M98;
struct S618{T2 _count;T0* _first_cell;T0* _last_cell;};
extern T618 M618;
struct S226{Tid id;T228 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T226 M226;
struct S679{T0* _item;T0* _right;T0* _left;};
extern T679 M679;
struct S609{T611 _storage;T2 _capacity;T2 _upper;};
extern T609 M609;
struct S240{T2 _count;T0* _first_cell;};
extern T240 M240;
struct S602{T0* _equality_tester;T2 _count;T2 _capacity;T2 _last_position;T2 _modulus;T2 _free_slot;T2 _position;T2 _slots_position;T2 _clashes_previous_position;T2 _found_position;T0* _internal_cursor;T0* _items;T0* _clashes;T0* _slots;T0* _fixed_item_array_;};
extern T602 M602;
struct S37{T2 _upper;T0* _first_link;T0* _last_link;T2 _mem_idx;T0* _mem_lnk;};
extern T37 M37;
struct S17{T0* _path;T9 _buffer;T2 _buffer_position;T2 _capacity;T8 _output_stream;};
extern T17 M17;
struct S747{T0* _ns_prefix;T0* _uri;};
extern T747 M747;
struct S603{T606 _storage;T2 _capacity;T2 _upper;};
extern T603 M603;
struct S437{T0* _equality_tester;T2 _count;T2 _capacity;T2 _last_position;T2 _modulus;T2 _free_slot;T2 _position;T2 _slots_position;T2 _clashes_previous_position;T2 _found_position;T0* _internal_cursor;T0* _key_equality_tester;T0* _items;T0* _keys;T0* _clashes;T0* _slots;T0* _fixed_item_array_;T0* _fixed_key_array_;};
extern T437 M437;
struct S567{Tid id;T0* _equality_tester;T2 _count;T0* _last_cell;T0* _internal_cursor;T0* _first_cell;};
extern T567 M567;
struct S30{T2 _buffer_position;T9 _buffer;T2 _capacity;};
extern T30 M30;
extern T39 M39;
struct S422{Tid id;T0* _parameters;};
extern T422 M422;
struct S482{Tid id;T0* _parameters;};
extern T482 M482;
struct S429{T0* _program_name;};
extern T429 M429;
struct S475{T0* _container;};
extern T475 M475;
struct S400{T0* _container;};
extern T400 M400;
extern char*s16_0;
extern char*s12_10;
extern char*s77_46;
extern char*s12_47;
extern char*s174_62;
extern char*s33_63;
extern char*s533_95;
extern char*s87_1607748595;
extern char*s252_252;
extern char*s33_276;
extern char*s77_277;
extern char*s21_324;
extern char*s40_7207;
extern char*s12_1956468118;
extern char*s169_1338477769;
extern char*s87_269618764;
extern char*s21_576769141;
extern char*s40_1090070780;
extern char*s268_1173251759;
extern char*s615_90456;
extern char*s176_195717202;
extern char*s12_94835277;
/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/

/*
  This file (SmartEiffel/sys/runtime/boost.h) is automatically included when
  `run_control.boost' is true (ie. only for mode -boost).
*/
#define SE_BOOST 1
void se_print_run_time_stack (void);
void se_signal_handler(int sig);
/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/
/*
  This file (SmartEiffel/sys/runtime/exception.h) is automatically included
  when exception handling is used somewhere in the live code.
*/

#define SE_EXCEPTIONS 1

/*
  Constants from Eiffel class EXCEPTIONS :
*/
#define Check_instruction 	  1
#define Class_invariant 	  2
#define Developer_exception 	  3
#define Incorrect_inspect_value   4
#define Loop_invariant 		  5
#define Loop_variant 		  6
#define No_more_memory  	  7
#define Postcondition 		  8
#define Precondition  		  9
#define Routine_failure  	  10
#define	Os_signal		  11
#define Void_attached_to_expanded 12
#define Void_call_target 	  13
#define System_level_type_error	  14

/*
   This will be the structure of rescue contexts.  A rescue context
   will be declared for every routine that has a rescue clause.

   The `next' pointer is the address of the next rescue context if there
   is one higher up the call chain, or NULL if there is no other
   context.
*/
struct rescue_context {
  JMP_BUF jb;
#ifndef SE_BOOST
    /* To keep track of dump stack to unwind it safely
       before the LONGJMP :
    */
    struct _se_dump_stack * top_of_ds ;
#endif
  struct rescue_context *next;
};

extern struct rescue_context *rescue_context_top;
extern int internal_exception_number;
extern int original_internal_exception_number;
extern int signal_exception_number;
extern char *additional_error_message;

void setup_signal_handler(void);
void signal_exception_handler(int);
void internal_exception_handler(int);
void print_exception(void);

#ifndef SE_BOOST
void free_exception_frames(void);
#endif
/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/
/*
  This file (SmartEiffel/sys/runtime/basic_directory.h) is automatically
  included when some external "SmartEiffel" feature of class BASIC_DIRECTORY
  is live.
*/

#ifndef WIN32
#  include <dirent.h>
#endif
#ifndef WIN32
#  include <unistd.h>
#endif

EIF_POINTER basic_directory_open(EIF_POINTER path);
EIF_POINTER basic_directory_read_entry(EIF_POINTER dirstream);
EIF_POINTER basic_directory_get_entry_name(EIF_POINTER entry);
EIF_BOOLEAN basic_directory_close(EIF_POINTER dirstream);
#define basic_directory_current_working_directory (basic_directory_cwd())
EIF_POINTER basic_directory_cwd(void);
EIF_BOOLEAN basic_directory_chdir(EIF_POINTER destination);
EIF_BOOLEAN basic_directory_mkdir(EIF_POINTER directory_path);
EIF_BOOLEAN basic_directory_rmdir(EIF_POINTER directory_path);
/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/
/*
  This file (SmartEiffel/sys/runtime/basic_io.h) is automatically
  included when some external "SmartEiffel" basic_io_* feature is used.
*/

#define basic_io_stdin (stdin)
#define basic_io_stdout (stdout)
#define basic_io_stderr (stderr)
#define basic_io_eof (EOF)
#define basic_io_text_file_read_open(p) (fopen(((char*)(p)),"r"))
#define basic_io_text_file_write_open(p) (fopen(((char*)(p)),"w"))
#define basic_io_text_file_write_append(p) (fopen(((char*)(p)),"a"))
#define basic_io_text_file_read_write_open(p) (fopen(((char*)(p)),"r+"))
#define basic_io_text_file_read_write_append(p) (fopen(((char*)(p)),"a+"))
#define basic_io_binary_file_read_open(p) (fopen(((char*)(p)),"rb"))
#define basic_io_binary_file_write_open(p) (fopen(((char*)(p)),"wb"))
#define basic_io_binary_file_write_append(p) (fopen(((char*)(p)),"ab"))
#define basic_io_fclose(p) (fclose((FILE*)(p)))
#define basic_io_flush(p) (fflush((FILE*)(p)))
#define basic_io_getc(f) (getc(((FILE*)(f))))
#define basic_io_putc(b, f) (putc((b),((FILE*)(f))))
#define basic_io_fread(b, n, f) (fread((void *)(b),(size_t)(1), (size_t)(n),(FILE*)(f)))
#define basic_io_fwrite(b, n, f) (fwrite((void *)(b),(size_t)(1), (size_t)(n),(FILE*)(f)))
#define basic_io_feof(f) (feof(((FILE*)(f))))
#define basic_io_rename(o, n) (rename(((char*)(o)),((char*)(n))))
#define basic_io_remove(f) (remove(((char*)(f))))

#if defined __USE_POSIX || defined __unix__ || defined _POSIX_C_SOURCE
#  define basic_io_read_stdin(b, s) (read(STDIN_FILENO, b, s))
#else
  extern int basic_io_read_stdin(char *buffer, int size);
#endif

/*
-- This file is  free  software, which  comes  along  with  SmartEiffel. This
-- software  is  distributed  in the hope that it will be useful, but WITHOUT
-- ANY  WARRANTY;  without  even  the  implied warranty of MERCHANTABILITY or
-- FITNESS  FOR A PARTICULAR PURPOSE. You can modify it as you want, provided
-- this header is kept unaltered, and a notification of the changes is added.
-- You  are  allowed  to  redistribute  it and sell it, alone or as a part of
-- another product.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
--
*/
/*
  This file (SmartEiffel/sys/runtime/basic_sprintf.h) is automatically
  included when the external "SmartEiffel" basic_sprintf feature is used.
*/

#define basic_sprintf_pointer(buffer, pointer) sprintf((char*)(buffer),"%p",pointer)

void basic_sprintf_double(EIF_CHARACTER* b, int f, double d);
/*POINTER*/
T6 r8is_null(T8 C);
extern T0*oBC8string_buffer;
/*POINTER*/
void r8append_in(T8 C,T0* a1);
/*BOOLEAN*/
T6 r6_ix_and(T6 C,T6 a1);
/*BOOLEAN*/
T6 r6_px_not(T6 C);
/*BOOLEAN*/
T6 r6_ix_or(T6 C,T6 a1);
/*CHARACTER*/
T6 r3is_digit(T3 C);
/*CHARACTER*/
T6 r3is_separator(T3 C);
/*CHARACTER*/
T6 r3_ix_6061(T3 C,T3 a1);
/*CHARACTER*/
T1 r3value(T3 C);
/*CHARACTER*/
T6 r3same_as(T3 C,T3 a1);
/*CHARACTER*/
T1 r3decimal_value(T3 C);
/*CHARACTER*/
T6 r3_ix_6261(T3 C,T3 a1);
/*CHARACTER*/
T3 r3to_lower(T3 C);
/*CHARACTER*/
T6 r3_ix_60(T3 C,T3 a1);
/*CHARACTER*/
T6 r3_ix_62(T3 C,T3 a1);
/*INTEGER*/
T0* r2out(T2 C);
/*INTEGER*/
T6 r2is_equal(T2 C,T2 a1);
extern T0*oBC26string_buffer;
/*INTEGER*/
T2 r2max(T2 C,T2 a1);
/*INTEGER*/
T0* r2to_string(T2 C);
/*INTEGER*/
T2 r2min(T2 C,T2 a1);
/*INTEGER*/
T3 r2digit(T2 C);
/*INTEGER*/
T2 r2hash_code(T2 C);
/*INTEGER*/
void r2append_in(T2 C,T0* a1);
/*INTEGER*/
T11 r2to_integer_64(T2 C);
extern T0*oBC15tagged_out_memory;
/*INTEGER_16*/
T0* r10out(T10 C);
/*INTEGER_16*/
T3 r10digit(T10 C);
/*INTEGER_16*/
void r10append_in(T10 C,T0* a1);
/*NATIVE_ARRAY[DS_BILINKABLE[INTEGER]]*/
void r300set_all_with(T300 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[LX_SYMBOL_CLASS]*/
void r414clear_all(T414 C,T2 a1);
/*NATIVE_ARRAY[LX_SYMBOL_CLASS]*/
T414 r414realloc(T414 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LX_SYMBOL_CLASS]*/
void r414set_all_with(T414 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[LX_SYMBOL_CLASS]*/
void r414clear(T414 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LX_SYMBOL_CLASS]*/
void r414copy_from(T414 C,T414 a1,T2 a2);
/*NATIVE_ARRAY[DS_HASH_SET[XM_EIFFEL_PARSER_NAME]]*/
void r606clear_all(T606 C,T2 a1);
/*NATIVE_ARRAY[DS_HASH_SET[XM_EIFFEL_PARSER_NAME]]*/
T606 r606realloc(T606 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[DS_HASH_SET[XM_EIFFEL_PARSER_NAME]]*/
void r606set_all_with(T606 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[DS_HASH_SET[XM_EIFFEL_PARSER_NAME]]*/
void r606clear(T606 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[DS_HASH_SET[XM_EIFFEL_PARSER_NAME]]*/
void r606copy_from(T606 C,T606 a1,T2 a2);
/*NATIVE_ARRAY[LX_START_CONDITION]*/
void r371clear_all(T371 C,T2 a1);
/*NATIVE_ARRAY[XM_DTD_EXTERNAL_ID]*/
void r595clear_all(T595 C,T2 a1);
/*NATIVE_ARRAY[XM_DTD_EXTERNAL_ID]*/
T595 r595realloc(T595 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_DTD_EXTERNAL_ID]*/
void r595set_all_with(T595 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[XM_DTD_EXTERNAL_ID]*/
void r595clear(T595 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_DTD_EXTERNAL_ID]*/
void r595copy_from(T595 C,T595 a1,T2 a2);
/*NATIVE_ARRAY[DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]]*/
void r578clear_all(T578 C,T2 a1);
/*NATIVE_ARRAY[DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]]*/
T578 r578realloc(T578 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]]*/
void r578set_all_with(T578 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]]*/
void r578clear(T578 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]]*/
void r578copy_from(T578 C,T578 a1,T2 a2);
/*NATIVE_ARRAY[BOOLEAN]*/
void r105clear_all(T105 C,T2 a1);
/*NATIVE_ARRAY[BOOLEAN]*/
T105 r105realloc(T105 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[BOOLEAN]*/
void r105set_all_with(T105 C,T6 a1,T2 a2);
/*NATIVE_ARRAY[BOOLEAN]*/
void r105clear(T105 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[BOOLEAN]*/
void r105copy_from(T105 C,T105 a1,T2 a2);
/*NATIVE_ARRAY[LX_NFA]*/
void r367clear_all(T367 C,T2 a1);
/*NATIVE_ARRAY[LX_NFA]*/
T367 r367realloc(T367 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LX_NFA]*/
void r367set_all_with(T367 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[LX_NFA]*/
void r367clear(T367 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LX_NFA]*/
void r367copy_from(T367 C,T367 a1,T2 a2);
/*NATIVE_ARRAY[XM_NAMESPACE]*/
void r770clear_all(T770 C,T2 a1);
/*NATIVE_ARRAY[XM_NAMESPACE]*/
T770 r770realloc(T770 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_NAMESPACE]*/
void r770clear(T770 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_NAMESPACE]*/
void r770copy_from(T770 C,T770 a1,T2 a2);
/*NATIVE_ARRAY[DS_BILINKED_LIST[STRING]]*/
void r571clear_all(T571 C,T2 a1);
/*NATIVE_ARRAY[DS_BILINKED_LIST[STRING]]*/
T571 r571realloc(T571 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[DS_BILINKED_LIST[STRING]]*/
void r571set_all_with(T571 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[DS_BILINKED_LIST[STRING]]*/
void r571clear(T571 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[DS_BILINKED_LIST[STRING]]*/
void r571copy_from(T571 C,T571 a1,T2 a2);
/*NATIVE_ARRAY[XM_DTD_ELEMENT_CONTENT]*/
void r589clear_all(T589 C,T2 a1);
/*NATIVE_ARRAY[XM_DTD_ELEMENT_CONTENT]*/
T589 r589realloc(T589 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_DTD_ELEMENT_CONTENT]*/
void r589set_all_with(T589 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[XM_DTD_ELEMENT_CONTENT]*/
void r589clear(T589 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_DTD_ELEMENT_CONTENT]*/
void r589copy_from(T589 C,T589 a1,T2 a2);
/*NATIVE_ARRAY[XM_EIFFEL_DECLARATION]*/
void r562clear_all(T562 C,T2 a1);
/*NATIVE_ARRAY[XM_EIFFEL_DECLARATION]*/
T562 r562realloc(T562 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_EIFFEL_DECLARATION]*/
void r562set_all_with(T562 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[XM_EIFFEL_DECLARATION]*/
void r562clear(T562 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_EIFFEL_DECLARATION]*/
void r562copy_from(T562 C,T562 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER_16]*/
void r228set_all_with(T228 C,T10 a1,T2 a2);
/*NATIVE_ARRAY[STRING]*/
void r128clear_all(T128 C,T2 a1);
/*NATIVE_ARRAY[STRING]*/
T128 r128realloc(T128 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[STRING]*/
void r128set_all_with(T128 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[STRING]*/
void r128clear(T128 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[STRING]*/
void r128copy_from(T128 C,T128 a1,T2 a2);
/*NATIVE_ARRAY[XM_EIFFEL_PARSER_NAME]*/
void r611clear_all(T611 C,T2 a1);
/*NATIVE_ARRAY[XM_EIFFEL_PARSER_NAME]*/
T611 r611realloc(T611 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_EIFFEL_PARSER_NAME]*/
void r611set_all_with(T611 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[XM_EIFFEL_PARSER_NAME]*/
void r611clear(T611 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_EIFFEL_PARSER_NAME]*/
void r611copy_from(T611 C,T611 a1,T2 a2);
/*NATIVE_ARRAY[LX_NFA_STATE]*/
void r330clear_all(T330 C,T2 a1);
/*NATIVE_ARRAY[LX_NFA_STATE]*/
T330 r330realloc(T330 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LX_NFA_STATE]*/
void r330clear(T330 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LX_NFA_STATE]*/
void r330copy_from(T330 C,T330 a1,T2 a2);
/*NATIVE_ARRAY[LX_RULE]*/
void r282clear_all(T282 C,T2 a1);
/*NATIVE_ARRAY[LX_RULE]*/
T282 r282realloc(T282 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LX_RULE]*/
void r282set_all_with(T282 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[LX_RULE]*/
void r282clear(T282 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LX_RULE]*/
void r282copy_from(T282 C,T282 a1,T2 a2);
/*NATIVE_ARRAY[XM_EIFFEL_ENTITY_DEF]*/
void r224clear_all(T224 C,T2 a1);
/*NATIVE_ARRAY[XM_EIFFEL_ENTITY_DEF]*/
T224 r224realloc(T224 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_EIFFEL_ENTITY_DEF]*/
void r224clear(T224 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_EIFFEL_ENTITY_DEF]*/
void r224copy_from(T224 C,T224 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/
void r9copy_slice(T9 C,T2 a1,T9 a2,T2 a3,T2 a4);
/*NATIVE_ARRAY[CHARACTER]*/
T9 r9realloc(T9 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/
void r9move(T9 C,T2 a1,T2 a2,T2 a3);
/*NATIVE_ARRAY[CHARACTER]*/
void r9set_all_with(T9 C,T3 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/
T6 r9fast_memcmp(T9 C,T9 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/
T6 r9fast_has(T9 C,T3 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/
void r9copy_at(T9 C,T2 a1,T9 a2,T2 a3);
/*NATIVE_ARRAY[CHARACTER]*/
void r9clear(T9 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[CHARACTER]*/
void r9copy_from(T9 C,T9 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER_8]*/
void r234set_all_with(T234 C,T1 a1,T2 a2);
/*NATIVE_ARRAY[XM_DTD_ATTRIBUTE_CONTENT]*/
void r583clear_all(T583 C,T2 a1);
/*NATIVE_ARRAY[XM_DTD_ATTRIBUTE_CONTENT]*/
T583 r583realloc(T583 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_DTD_ATTRIBUTE_CONTENT]*/
void r583set_all_with(T583 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[XM_DTD_ATTRIBUTE_CONTENT]*/
void r583clear(T583 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[XM_DTD_ATTRIBUTE_CONTENT]*/
void r583copy_from(T583 C,T583 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER]*/
void r94clear_all(T94 C,T2 a1);
/*NATIVE_ARRAY[INTEGER]*/
T94 r94realloc(T94 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER]*/
void r94set_all_with(T94 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER]*/
void r94clear(T94 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[INTEGER]*/
void r94copy_from(T94 C,T94 a1,T2 a2);
/*NATIVE_ARRAY[LX_DFA_STATE]*/
void r287clear_all(T287 C,T2 a1);
/*NATIVE_ARRAY[LX_DFA_STATE]*/
T287 r287realloc(T287 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LX_DFA_STATE]*/
void r287set_all_with(T287 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[LX_DFA_STATE]*/
void r287clear(T287 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[LX_DFA_STATE]*/
void r287copy_from(T287 C,T287 a1,T2 a2);
/*NATIVE_ARRAY[ANY]*/
void r421clear_all(T421 C,T2 a1);
/*NATIVE_ARRAY[ANY]*/
T421 r421realloc(T421 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ANY]*/
void r421set_all_with(T421 C,T0* a1,T2 a2);
/*NATIVE_ARRAY[ANY]*/
void r421clear(T421 C,T2 a1,T2 a2);
/*NATIVE_ARRAY[ANY]*/
void r421copy_from(T421 C,T421 a1,T2 a2);
/*STRING*/
T0* r7out(T7* C);
/*STRING*/
void r7copy(T7* C,T0* a1);
/*STRING*/
T0* r7substring(T7* C,T2 a1,T2 a2);
/*STRING*/
T3 r7last(T7* C);
/*STRING*/
T2 r7first_substring_index(T7* C,T0* a1);
/*STRING*/
T2 r7item_code(T7* C,T2 a1);
/*STRING*/
void r7remove_between(T7* C,T2 a1,T2 a2);
/*STRING*/
T6 r7is_equal(T7* C,T0* a1);
/*STRING*/
T3 r7item(T7* C,T2 a1);
/*STRING*/
void r7append(T7* C,T0* a1);
/*STRING*/
T6 r7se_assigned_from(T0* a1);
/*STRING*/
void r7print_on(T7* C,T0* a1);
/*STRING*/
void r7make_from_string(T7* C,T0* a1);
/*STRING*/
T2 r7index_of(T7* C,T3 a1,T2 a2);
/*STRING*/
void r7out_in_tagged_out_memory(T7* C);
/*STRING*/
T6 r7same_type(T7* C,T0* a1);
/*STRING*/
void r7remove_tail(T7* C,T2 a1);
/*STRING*/
void r7make(T7* C,T2 a1);
/*STRING*/
void r7fill_tagged_out_memory(T7* C);
/*STRING*/
void r7append_string(T7* C,T0* a1);
/*STRING*/
void r7make_filled(T7* C,T3 a1,T2 a2);
/*STRING*/
void r7remove(T7* C,T2 a1);
/*STRING*/
T0* r7string(T7* C);
/*STRING*/
void r7extend(T7* C,T3 a1);
/*STRING*/
T2 r7hash_code(T7* C);
/*STRING*/
void r7remove_last(T7* C,T2 a1);
/*STRING*/
T6 r7conforms_to(T7* C,T0* a1);
/*STRING*/
T6 r7has(T7* C,T3 a1);
/*STRING*/
T2 r7to_integer(T7* C);
/*STRING*/
void r7append_character(T7* C,T3 a1);
/*STRING*/
void r7extend_unless(T7* C,T3 a1);
/*STRING*/
T6 r7same_as(T7* C,T0* a1);
/*STRING*/
void r7add_last(T7* C,T3 a1);
/*STRING*/
T3 r7first(T7* C);
/*STRING*/
void r7resize(T7* C,T2 a1);
/*STRING*/
T2 r7substring_index(T7* C,T0* a1,T2 a2);
/*STRING*/
void r7from_external_copy(T7* C,T8 a1);
/*STRING*/
void r7replace_substring(T7* C,T0* a1,T2 a2,T2 a3);
/*STRING*/
T8 r7to_external(T7* C);
/*STRING*/
void r7to_lower(T7* C);
/*STRING*/
T0* r7twin(T7* C);
/*STRING*/
T0* r7_ix_43(T7* C,T0* a1);
/*STRING*/
void r7swap(T7* C,T2 a1,T2 a2);
/*FIXED_ARRAY[BOOLEAN]*/
void r103make(T103* C,T2 a1);
/*ARRAY[DS_BILINKABLE[INTEGER]]*/
T2 r297count(T297* C);
/*ARRAY[DS_BILINKABLE[INTEGER]]*/
T0* r297item(T297* C,T2 a1);
/*ARRAY[DS_BILINKABLE[INTEGER]]*/
void r297make(T297* C,T2 a1,T2 a2);
/*ARRAY[INTEGER]*/
void r231clear_all(T231* C);
/*ARRAY[INTEGER]*/
T2 r231count(T231* C);
/*ARRAY[INTEGER]*/
T2 r231item(T231* C,T2 a1);
/*ARRAY[INTEGER]*/
void r231make(T231* C,T2 a1,T2 a2);
/*FIXED_ARRAY[LX_NFA]*/
void r365make(T365* C,T2 a1);
/*FIXED_ARRAY[LX_NFA]*/
void r365resize(T365* C,T2 a1);
/*ARRAY[LX_DFA_STATE]*/
T0* r290item(T290* C,T2 a1);
/*ARRAY[LX_DFA_STATE]*/
void r290make(T290* C,T2 a1,T2 a2);
/*ARRAY[XM_CALLBACKS_FILTER]*/
T0* r142item(T142* C,T2 a1);
/*FIXED_ARRAY[XM_NAMESPACE]*/
void r767make(T767* C,T2 a1);
/*FIXED_ARRAY[XM_NAMESPACE]*/
void r767resize(T767* C,T2 a1);
/*FIXED_ARRAY[LX_SYMBOL_CLASS]*/
void r412make(T412* C,T2 a1);
/*FIXED_ARRAY[LX_SYMBOL_CLASS]*/
void r412resize(T412* C,T2 a1);
/*ARRAY[RX_CHARACTER_SET]*/
T0* r124item(T124* C,T2 a1);
/*FIXED_ARRAY[LX_NFA_STATE]*/
void r328make(T328* C,T2 a1);
/*FIXED_ARRAY[LX_NFA_STATE]*/
void r328resize(T328* C,T2 a1);
/*ARRAY[BOOLEAN]*/
T6 r293item(T293* C,T2 a1);
/*ARRAY[BOOLEAN]*/
void r293make(T293* C,T2 a1,T2 a2);
/*ARRAY[ARRAY[INTEGER]]*/
T0* r783item(T783* C,T2 a1);
/*FIXED_ARRAY[STRING]*/
void r219make(T219* C,T2 a1);
/*FIXED_ARRAY[STRING]*/
void r219resize(T219* C,T2 a1);
/*FIXED_ARRAY[LX_RULE]*/
void r280make(T280* C,T2 a1);
/*FIXED_ARRAY[LX_RULE]*/
void r280resize(T280* C,T2 a1);
/*ARRAY[INTEGER_8]*/
T2 r232count(T232* C);
/*ARRAY[INTEGER_8]*/
T1 r232item(T232* C,T2 a1);
/*ARRAY[INTEGER_8]*/
void r232make(T232* C,T2 a1,T2 a2);
/*FIXED_ARRAY[LX_START_CONDITION]*/
void r369make(T369* C,T2 a1);
/*FIXED_ARRAY[INTEGER]*/
void r97copy(T97* C,T0* a1);
/*FIXED_ARRAY[INTEGER]*/
void r97make(T97* C,T2 a1);
/*FIXED_ARRAY[INTEGER]*/
void r97resize(T97* C,T2 a1);
/*FIXED_ARRAY[INTEGER]*/
T0* r97twin(T97* C);
/*FIXED_ARRAY[INTEGER]*/
void r97with_capacity(T97* C,T2 a1);
/*FIXED_ARRAY[INTEGER]*/
void r97from_collection(T97* C,T0* a1);
/*FIXED_ARRAY[LX_DFA_STATE]*/
void r285make(T285* C,T2 a1);
/*FIXED_ARRAY[LX_DFA_STATE]*/
void r285resize(T285* C,T2 a1);
/*ARRAY[STRING]*/
T2 r126count(T126* C);
/*ARRAY[STRING]*/
T0* r126item(T126* C,T2 a1);
/*ARRAY[STRING]*/
T6 r126valid_index(T126* C,T2 a1);
/*ARRAY[STRING]*/
void r126make(T126* C,T2 a1,T2 a2);
/*FIXED_ARRAY[ANY]*/
void r419make(T419* C,T2 a1);
/*FIXED_ARRAY[ANY]*/
void r419resize(T419* C,T2 a1);
/*FIXED_ARRAY[XM_EIFFEL_ENTITY_DEF]*/
void r220make(T220* C,T2 a1);
/*FIXED_ARRAY[XM_EIFFEL_ENTITY_DEF]*/
void r220resize(T220* C,T2 a1);
/*ARRAY[LX_RULE]*/
void r402make(T402* C,T2 a1,T2 a2);
/*ARRAY[INTEGER_16]*/
T2 r226count(T226* C);
/*ARRAY[INTEGER_16]*/
T10 r226item(T226* C,T2 a1);
/*ARRAY[INTEGER_16]*/
void r226make(T226* C,T2 a1,T2 a2);
/*FIXED_ARRAY[XM_EIFFEL_PARSER_NAME]*/
void r609make(T609* C,T2 a1);
/*FIXED_ARRAY[XM_EIFFEL_PARSER_NAME]*/
void r609resize(T609* C,T2 a1);
/*DS_BUBBLE_SORTER[LX_NFA_STATE]*/
void r323subsort_with_comparator(T0* a1,T0* a2,T2 a3,T2 a4);
/*DS_BUBBLE_SORTER[LX_NFA_STATE]*/
void r323sort_with_comparator(T0* a1,T0* a2);
/*SPECIAL[ANY]*/
void r418make(T418* C,T2 a1);
/*SPECIAL[ANY]*/
T0* r418resize(T418* C,T2 a1);
/*SPECIAL[ANY]*/
void r418array_resize(T418* C,T2 a1);
/*KL_SPECIAL_ROUTINES[ANY]*/
T0* r417make(T2 a1);
/*KL_SPECIAL_ROUTINES[ANY]*/
T0* r417resize(T0* a1,T2 a2);
/*DS_HASH_SET_CURSOR[XM_EIFFEL_PARSER_NAME]*/
void r652make(T652* C,T0* a1);
/*DS_ARRAYED_LIST[STRING]*/
T2 r403new_capacity(T2 a1);
/*DS_ARRAYED_LIST[STRING]*/
T6 r403extendible(T403* C,T2 a1);
/*DS_ARRAYED_LIST[STRING]*/
T0* r403last(T403* C);
/*DS_ARRAYED_LIST[STRING]*/
T0* r403cursor_item(T403* C,T0* a1);
/*DS_ARRAYED_LIST[STRING]*/
void r403remove_traversing_cursor(T403* C,T0* a1);
/*DS_ARRAYED_LIST[STRING]*/
void r403add_traversing_cursor(T403* C,T0* a1);
/*DS_ARRAYED_LIST[STRING]*/
T6 r403cursor_before(T0* a1);
/*DS_ARRAYED_LIST[STRING]*/
void r403make(T403* C,T2 a1);
/*DS_ARRAYED_LIST[STRING]*/
T6 r403cursor_after(T0* a1);
/*DS_ARRAYED_LIST[STRING]*/
void r403cursor_forth(T403* C,T0* a1);
/*DS_ARRAYED_LIST[STRING]*/
void r403resize(T403* C,T2 a1);
/*DS_ARRAYED_LIST[STRING]*/
void r403cursor_start(T403* C,T0* a1);
/*DS_ARRAYED_LIST[STRING]*/
void r403force_last(T403* C,T0* a1);
/*DS_ARRAYED_LIST[STRING]*/
T0* r403new_cursor(T403* C);
/*DS_ARRAYED_LIST[STRING]*/
T6 r403cursor_off(T0* a1);
/*SPECIAL[LX_NFA]*/
void r406make(T406* C,T2 a1);
/*SPECIAL[LX_NFA]*/
T0* r406resize(T406* C,T2 a1);
/*SPECIAL[LX_NFA]*/
void r406array_resize(T406* C,T2 a1);
/*LX_TRANSITION_TABLE[LX_DFA_STATE]*/
void r289set_target(T289* C,T0* a1,T2 a2);
/*LX_TRANSITION_TABLE[LX_DFA_STATE]*/
void r289make(T289* C,T2 a1,T2 a2);
/*DS_BILINKABLE[INTEGER]*/
void r298put_left(T298* C,T0* a1);
/*DS_BILINKABLE[INTEGER]*/
void r298put_right(T298* C,T0* a1);
/*DS_PAIR[XM_POSITION,XM_NODE]*/
void r736make(T736* C,T0* a1,T0* a2);
/*KL_SPECIAL_ROUTINES[DS_HASH_SET[XM_EIFFEL_PARSER_NAME]]*/
T0* r601make(T2 a1);
/*KL_SPECIAL_ROUTINES[DS_HASH_SET[XM_EIFFEL_PARSER_NAME]]*/
T0* r601resize(T0* a1,T2 a2);
/*SPECIAL[INTEGER]*/
void r416make(T416* C,T2 a1);
/*SPECIAL[INTEGER]*/
T0* r416resize(T416* C,T2 a1);
/*SPECIAL[INTEGER]*/
void r416array_resize(T416* C,T2 a1);
/*KL_SPECIAL_ROUTINES[DS_BILINKED_LIST[STRING]]*/
T0* r566make(T2 a1);
/*KL_SPECIAL_ROUTINES[DS_BILINKED_LIST[STRING]]*/
T0* r566resize(T0* a1,T2 a2);
/*SPECIAL[LX_SYMBOL_CLASS]*/
void r411make(T411* C,T2 a1);
/*SPECIAL[LX_SYMBOL_CLASS]*/
T0* r411resize(T411* C,T2 a1);
/*SPECIAL[LX_SYMBOL_CLASS]*/
void r411array_resize(T411* C,T2 a1);
/*DS_BILINKABLE[XM_DTD_ELEMENT_CONTENT]*/
void r791put_right(T791* C,T0* a1);
/*DS_HASH_SET_CURSOR[XM_NAMESPACE]*/
void r765make(T765* C,T0* a1);
/*DS_LINKED_STACK[XM_EIFFEL_SCANNER]*/
void r239force(T239* C,T0* a1);
/*DS_LINKED_STACK[XM_EIFFEL_SCANNER]*/
void r239remove(T239* C);
/*KL_FIXED_ARRAY_ROUTINES[LX_SYMBOL_CLASS]*/
T0* r465make(T2 a1);
/*KL_FIXED_ARRAY_ROUTINES[LX_SYMBOL_CLASS]*/
T0* r465resize(T0* a1,T2 a2);
/*DS_LINKED_LIST_CURSOR[XM_NODE]*/
void r773set(T773* C,T0* a1,T6 a2,T6 a3);
/*DS_LINKED_LIST_CURSOR[XM_NODE]*/
T6 r773is_first(T773* C);
/*DS_LINKED_LIST_CURSOR[XM_NODE]*/
T6 r773is_last(T773* C);
/*DS_LINKED_LIST_CURSOR[XM_NODE]*/
void r773make(T773* C,T0* a1);
/*DS_LINKED_LIST_CURSOR[XM_NODE]*/
void r773remove(T773* C);
/*DS_LINKED_LIST_CURSOR[XM_NODE]*/
void r773forth(T773* C);
/*DS_LINKED_LIST_CURSOR[XM_NODE]*/
void r773start(T773* C);
/*DS_LINKED_LIST_CURSOR[XM_NODE]*/
void r773go_after(T773* C);
/*DS_LINKED_LIST_CURSOR[XM_NODE]*/
void r773set_after(T773* C);
/*DS_ARRAYED_LIST_CURSOR[STRING]*/
T0* r529item(T529* C);
/*DS_ARRAYED_LIST_CURSOR[STRING]*/
T6 r529after(T529* C);
/*DS_ARRAYED_LIST_CURSOR[STRING]*/
T6 r529off(T529* C);
/*KL_SPECIAL_ROUTINES[XM_DTD_EXTERNAL_ID]*/
T0* r591make(T2 a1);
/*KL_SPECIAL_ROUTINES[XM_DTD_EXTERNAL_ID]*/
T0* r591resize(T0* a1,T2 a2);
/*LX_SYMBOL_CLASS_TRANSITION[LX_NFA_STATE]*/
T6 r464labeled(T464* C,T2 a1);
/*LX_SYMBOL_CLASS_TRANSITION[LX_NFA_STATE]*/
void r464make(T464* C,T0* a1,T0* a2);
/*LX_SYMBOL_CLASS_TRANSITION[LX_NFA_STATE]*/
T0* r464twin(T464* C);
/*LX_SYMBOL_CLASS_TRANSITION[LX_NFA_STATE]*/
void r464record(T464* C,T0* a1);
/*KL_FIXED_ARRAY_ROUTINES[LX_NFA]*/
T0* r378make(T2 a1);
/*KL_FIXED_ARRAY_ROUTINES[LX_NFA]*/
T0* r378resize(T0* a1,T2 a2);
/*KL_SPECIAL_ROUTINES[XM_DTD_ATTRIBUTE_CONTENT]*/
T0* r579make(T2 a1);
/*KL_SPECIAL_ROUTINES[XM_DTD_ATTRIBUTE_CONTENT]*/
T0* r579resize(T0* a1,T2 a2);
/*KL_EQUALITY_TESTER[STRING]*/
T6 r194test(T0* a1,T0* a2);
/*DS_BILINKED_LIST_CURSOR[STRING]*/
void r628set(T628* C,T0* a1,T6 a2,T6 a3);
/*DS_BILINKED_LIST_CURSOR[STRING]*/
void r628make(T628* C,T0* a1);
/*KL_FIXED_ARRAY_ROUTINES[XM_EIFFEL_ENTITY_DEF]*/
T0* r221make(T2 a1);
/*KL_FIXED_ARRAY_ROUTINES[XM_EIFFEL_ENTITY_DEF]*/
T0* r221resize(T0* a1,T2 a2);
/*KL_FIXED_ARRAY_ROUTINES[ANY]*/
T0* r551make(T2 a1);
/*KL_FIXED_ARRAY_ROUTINES[ANY]*/
T0* r551resize(T0* a1,T2 a2);
/*LX_SYMBOL_TRANSITION[LX_NFA_STATE]*/
void r479make(T479* C,T2 a1,T0* a2);
/*LX_SYMBOL_TRANSITION[LX_NFA_STATE]*/
T0* r479twin(T479* C);
/*LX_SYMBOL_TRANSITION[LX_NFA_STATE]*/
void r479record(T479* C,T0* a1);
/*KL_FIXED_ARRAY_ROUTINES[INTEGER]*/
T0* r119to_fixed_array(T0* a1);
/*KL_FIXED_ARRAY_ROUTINES[INTEGER]*/
T0* r119make(T2 a1);
/*KL_FIXED_ARRAY_ROUTINES[INTEGER]*/
T0* r119make_from_array(T0* a1);
/*KL_FIXED_ARRAY_ROUTINES[INTEGER]*/
T0* r119resize(T0* a1,T2 a2);
/*KL_COMPARABLE_COMPARATOR[LX_NFA_STATE]*/
T6 r322less_than(T0* a1,T0* a2);
/*DS_HASH_TABLE_CURSOR[STRING,STRING]*/
T0* r521item(T521* C);
/*DS_HASH_TABLE_CURSOR[STRING,STRING]*/
T6 r521after(T521* C);
/*DS_HASH_TABLE_CURSOR[STRING,STRING]*/
void r521make(T521* C,T0* a1);
/*KL_SPECIAL_ROUTINES[BOOLEAN]*/
T0* r563make(T2 a1);
/*KL_SPECIAL_ROUTINES[BOOLEAN]*/
T0* r563resize(T0* a1,T2 a2);
/*LINK[COMMENT]*/
void r115make(T115* C,T0* a1,T0* a2);
/*KL_NATIVE_ARRAY_ROUTINES[BOOLEAN]*/
T105 r121make(T2 a1);
/*KL_NATIVE_ARRAY_ROUTINES[BOOLEAN]*/
T105 r121resize(T105 a1,T2 a2,T2 a3);
/*KL_COMPARABLE_COMPARATOR[INTEGER]*/
T6 r487less_than(T2 a1,T2 a2);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r724set_last_cell(T724* C,T0* a1);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r724wipe_out(T724* C);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r724cursor_back(T724* C,T0* a1);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
T0* r724cursor_item(T0* a1);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r724remove_traversing_cursor(T724* C,T0* a1);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r724move_all_cursors_after(T724* C);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r724add_traversing_cursor(T724* C,T0* a1);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
T6 r724cursor_before(T0* a1);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r724make(T724* C);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r724remove_last(T724* C);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r724cursor_finish(T724* C,T0* a1);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r724move_last_cursors_after(T724* C);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r724cursor_go_before(T724* C,T0* a1);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
void r724force_last(T724* C,T0* a1);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
T0* r724new_cursor(T724* C);
/*DS_BILINKED_LIST[DS_HASH_TABLE[STRING,STRING]]*/
T6 r724cursor_off(T0* a1);
/*KL_FIXED_ARRAY_ROUTINES[LX_START_CONDITION]*/
T0* r504make(T2 a1);
/*KL_SPECIAL_ROUTINES[LX_NFA]*/
T0* r405make(T2 a1);
/*KL_SPECIAL_ROUTINES[LX_NFA]*/
T0* r405resize(T0* a1,T2 a2);
/*DS_BUBBLE_SORTER[LX_RULE]*/
void r316subsort_with_comparator(T0* a1,T0* a2,T2 a3,T2 a4);
/*DS_BUBBLE_SORTER[LX_RULE]*/
void r316sort_with_comparator(T0* a1,T0* a2);
/*DS_ARRAYED_LIST[LX_RULE]*/
T2 r279new_capacity(T2 a1);
/*DS_ARRAYED_LIST[LX_RULE]*/
T6 r279extendible(T279* C,T2 a1);
/*DS_ARRAYED_LIST[LX_RULE]*/
void r279move_cursors_right(T279* C,T2 a1,T2 a2);
/*DS_ARRAYED_LIST[LX_RULE]*/
void r279put(T279* C,T0* a1,T2 a2);
/*DS_ARRAYED_LIST[LX_RULE]*/
void r279force_first(T279* C,T0* a1);
/*DS_ARRAYED_LIST[LX_RULE]*/
void r279make(T279* C,T2 a1);
/*DS_ARRAYED_LIST[LX_RULE]*/
void r279move_right(T279* C,T2 a1,T2 a2);
/*DS_ARRAYED_LIST[LX_RULE]*/
void r279resize(T279* C,T2 a1);
/*DS_ARRAYED_LIST[LX_RULE]*/
void r279force_last(T279* C,T0* a1);
/*DS_ARRAYED_LIST[LX_RULE]*/
T0* r279new_cursor(T279* C);
/*DS_ARRAYED_LIST[LX_RULE]*/
void r279put_last(T279* C,T0* a1);
/*DS_PAIR[STRING,STRING]*/
void r694make(T694* C,T0* a1,T0* a2);
/*LINK[STRING]*/
void r116make(T116* C,T0* a1,T0* a2);
/*DS_BILINKABLE[DS_HASH_TABLE[STRING,STRING]]*/
void r778put_right(T778* C,T0* a1);
/*DS_BILINKED_LIST_CURSOR[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
void r705set(T705* C,T0* a1,T6 a2,T6 a3);
/*DS_BILINKED_LIST_CURSOR[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
void r705make(T705* C,T0* a1);
/*DS_ARRAYED_LIST[LX_DFA_STATE]*/
void r283make(T283* C,T2 a1);
/*DS_ARRAYED_LIST[LX_DFA_STATE]*/
void r283resize(T283* C,T2 a1);
/*DS_ARRAYED_LIST[LX_DFA_STATE]*/
T0* r283new_cursor(T283* C);
/*DS_ARRAYED_LIST[LX_DFA_STATE]*/
void r283put_last(T283* C,T0* a1);
/*SPECIAL[XM_DTD_ELEMENT_CONTENT]*/
void r586make(T586* C,T2 a1);
/*SPECIAL[XM_DTD_ELEMENT_CONTENT]*/
T0* r586resize(T586* C,T2 a1);
/*SPECIAL[XM_DTD_ELEMENT_CONTENT]*/
void r586array_resize(T586* C,T2 a1);
/*KL_SPECIAL_ROUTINES[XM_EIFFEL_DECLARATION]*/
T0* r558make(T2 a1);
/*KL_SPECIAL_ROUTINES[XM_EIFFEL_DECLARATION]*/
T0* r558resize(T0* a1,T2 a2);
/*LINKED_LIST[DOCUMENT]*/
T0* r111item(T111* C,T2 a1);
/*LINKED_LIST[DOCUMENT]*/
void r111make(T111* C);
/*LINKED_LIST[DOCUMENT]*/
void r111add_last(T111* C,T0* a1);
/*LINKED_LIST[DOCUMENT]*/
void r111go_item(T111* C,T2 a1);
/*KL_SPECIAL_ROUTINES[DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]]*/
T0* r573make(T2 a1);
/*KL_SPECIAL_ROUTINES[DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]]*/
T0* r573resize(T0* a1,T2 a2);
/*DS_ARRAYED_LIST[LX_NFA]*/
T2 r363new_capacity(T2 a1);
/*DS_ARRAYED_LIST[LX_NFA]*/
T6 r363extendible(T363* C,T2 a1);
/*DS_ARRAYED_LIST[LX_NFA]*/
void r363make(T363* C,T2 a1);
/*DS_ARRAYED_LIST[LX_NFA]*/
void r363resize(T363* C,T2 a1);
/*DS_ARRAYED_LIST[LX_NFA]*/
void r363force_last(T363* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA]*/
T0* r363new_cursor(T363* C);
/*KL_FIXED_ARRAY_ROUTINES[XM_EIFFEL_PARSER_NAME]*/
T0* r635make(T2 a1);
/*KL_FIXED_ARRAY_ROUTINES[XM_EIFFEL_PARSER_NAME]*/
T0* r635resize(T0* a1,T2 a2);
/*SPECIAL[DS_BILINKED_LIST[STRING]]*/
void r568make(T568* C,T2 a1);
/*SPECIAL[DS_BILINKED_LIST[STRING]]*/
T0* r568resize(T568* C,T2 a1);
/*SPECIAL[DS_BILINKED_LIST[STRING]]*/
void r568array_resize(T568* C,T2 a1);
/*SPECIAL[XM_EIFFEL_PARSER_NAME]*/
void r608make(T608* C,T2 a1);
/*SPECIAL[XM_EIFFEL_PARSER_NAME]*/
T0* r608resize(T608* C,T2 a1);
/*SPECIAL[XM_EIFFEL_PARSER_NAME]*/
void r608array_resize(T608* C,T2 a1);
/*KL_SPECIAL_ROUTINES[LX_SYMBOL_CLASS]*/
T0* r410make(T2 a1);
/*KL_SPECIAL_ROUTINES[LX_SYMBOL_CLASS]*/
T0* r410resize(T0* a1,T2 a2);
/*KL_FIXED_ARRAY_ROUTINES[LX_NFA_STATE]*/
T0* r331make(T2 a1);
/*KL_FIXED_ARRAY_ROUTINES[LX_NFA_STATE]*/
T0* r331resize(T0* a1,T2 a2);
/*SPECIAL[XM_EIFFEL_DECLARATION]*/
void r559make(T559* C,T2 a1);
/*SPECIAL[XM_EIFFEL_DECLARATION]*/
T0* r559resize(T559* C,T2 a1);
/*SPECIAL[XM_EIFFEL_DECLARATION]*/
void r559array_resize(T559* C,T2 a1);
/*DS_HASH_TABLE_CURSOR[LX_SYMBOL_CLASS,STRING]*/
T0* r451item(T451* C);
/*DS_HASH_TABLE_CURSOR[LX_SYMBOL_CLASS,STRING]*/
T6 r451after(T451* C);
/*DS_HASH_TABLE_CURSOR[LX_SYMBOL_CLASS,STRING]*/
void r451make(T451* C,T0* a1);
/*KL_FIXED_ARRAY_ROUTINES[XM_NAMESPACE]*/
T0* r768make(T2 a1);
/*KL_FIXED_ARRAY_ROUTINES[XM_NAMESPACE]*/
T0* r768resize(T0* a1,T2 a2);
/*SPECIAL[DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]]*/
void r575make(T575* C,T2 a1);
/*SPECIAL[DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]]*/
T0* r575resize(T575* C,T2 a1);
/*SPECIAL[DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]]*/
void r575array_resize(T575* C,T2 a1);
/*DS_BILINKED_LIST[XM_DTD_ELEMENT_CONTENT]*/
void r658force_first(T658* C,T0* a1);
/*DS_BILINKED_LIST[XM_DTD_ELEMENT_CONTENT]*/
void r658make(T658* C);
/*DS_BILINKED_LIST[XM_DTD_ELEMENT_CONTENT]*/
void r658force_last(T658* C,T0* a1);
/*DS_BILINKED_LIST[XM_DTD_ELEMENT_CONTENT]*/
T0* r658new_cursor(T658* C);
/*KL_SPECIAL_ROUTINES[XM_DTD_ELEMENT_CONTENT]*/
T0* r585make(T2 a1);
/*KL_SPECIAL_ROUTINES[XM_DTD_ELEMENT_CONTENT]*/
T0* r585resize(T0* a1,T2 a2);
/*LINKED_LIST[STRING]*/
T0* r38item(T38* C,T2 a1);
/*LINKED_LIST[STRING]*/
void r38make(T38* C);
/*LINKED_LIST[STRING]*/
void r38add_last(T38* C,T0* a1);
/*LINKED_LIST[STRING]*/
void r38go_item(T38* C,T2 a1);
/*DS_LINKED_LIST[STRING]*/
T0* r629last(T629* C);
/*DS_LINKED_LIST[STRING]*/
T0* r629cursor_item(T0* a1);
/*DS_LINKED_LIST[STRING]*/
void r629remove_traversing_cursor(T629* C,T0* a1);
/*DS_LINKED_LIST[STRING]*/
T0* r629item(T629* C,T2 a1);
/*DS_LINKED_LIST[STRING]*/
void r629add_traversing_cursor(T629* C,T0* a1);
/*DS_LINKED_LIST[STRING]*/
void r629make(T629* C);
/*DS_LINKED_LIST[STRING]*/
T6 r629cursor_after(T0* a1);
/*DS_LINKED_LIST[STRING]*/
void r629cursor_forth(T629* C,T0* a1);
/*DS_LINKED_LIST[STRING]*/
void r629cursor_start(T629* C,T0* a1);
/*DS_LINKED_LIST[STRING]*/
void r629force_last(T629* C,T0* a1);
/*DS_LINKED_LIST[STRING]*/
T0* r629new_cursor(T629* C);
/*DS_LINKED_LIST[STRING]*/
T6 r629cursor_off(T0* a1);
/*DS_BILINKED_LIST_CURSOR[DS_HASH_TABLE[STRING,STRING]]*/
void r729set(T729* C,T0* a1,T6 a2,T6 a3);
/*DS_BILINKED_LIST_CURSOR[DS_HASH_TABLE[STRING,STRING]]*/
void r729set_before(T729* C);
/*DS_BILINKED_LIST_CURSOR[DS_HASH_TABLE[STRING,STRING]]*/
void r729make(T729* C,T0* a1);
/*DS_BILINKED_LIST_CURSOR[DS_HASH_TABLE[STRING,STRING]]*/
void r729set_after(T729* C);
/*KL_FIXED_ARRAY_ROUTINES[BOOLEAN]*/
T0* r108make(T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
T2 r748new_capacity(T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
void r748make_equal(T748* C,T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
T0* r748keys_item(T748* C,T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
void r748make_clashes(T748* C,T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
void r748search_position(T748* C,T0* a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
T0* r748item(T748* C,T0* a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
void r748make_items(T748* C,T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
void r748make(T748* C,T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
T6 r748has(T748* C,T0* a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
T2 r748hash_position(T748* C,T0* a1);
extern T0*oBC81fixed_integer_array_;
/*DS_HASH_SET[XM_NAMESPACE]*/
void r748items_resize(T748* C,T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
void r748resize(T748* C,T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
void r748clashes_resize(T748* C,T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
void r748slots_resize(T748* C,T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
void r748force_last(T748* C,T0* a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
T0* r748new_cursor(T748* C);
/*DS_HASH_SET[XM_NAMESPACE]*/
void r748make_slots(T748* C,T2 a1);
/*DS_HASH_SET[XM_NAMESPACE]*/
T2 r748new_modulus(T2 a1);
/*KL_ARRAY_ROUTINES[INTEGER]*/
void r249subcopy(T0* a1,T0* a2,T2 a3,T2 a4,T2 a5);
/*KL_NATIVE_ARRAY_ROUTINES[INTEGER]*/
T94 r101make(T2 a1);
/*KL_NATIVE_ARRAY_ROUTINES[INTEGER]*/
T94 r101resize(T94 a1,T2 a2,T2 a3);
/*DS_BILINKED_LIST_CURSOR[XM_DTD_ELEMENT_CONTENT]*/
void r669make(T669* C,T0* a1);
/*LINK[INTEGER]*/
void r118make(T118* C,T2 a1,T0* a2);
/*DS_BILINKED_LIST_CURSOR[XM_DTD_ATTRIBUTE_CONTENT]*/
void r685set(T685* C,T0* a1,T6 a2,T6 a3);
/*DS_BILINKED_LIST_CURSOR[XM_DTD_ATTRIBUTE_CONTENT]*/
void r685make(T685* C,T0* a1);
/*DS_HASH_TABLE_CURSOR[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r210make(T210* C,T0* a1);
/*LINKED_LIST[COMMENT]*/
T0* r113item(T113* C,T2 a1);
/*LINKED_LIST[COMMENT]*/
void r113make(T113* C);
/*LINKED_LIST[COMMENT]*/
void r113add_last(T113* C,T0* a1);
/*LINKED_LIST[COMMENT]*/
void r113go_item(T113* C,T2 a1);
/*KL_EQUALITY_TESTER[XM_NAMESPACE]*/
T6 r754test(T0* a1,T0* a2);
/*DS_ARRAYED_LIST_CURSOR[LX_NFA_STATE]*/
T0* r354item(T354* C);
/*DS_ARRAYED_LIST_CURSOR[LX_NFA_STATE]*/
T6 r354after(T354* C);
/*DS_ARRAYED_LIST_CURSOR[LX_NFA_STATE]*/
T6 r354off(T354* C);
/*DS_HASH_TABLE_CURSOR[LX_NFA,INTEGER]*/
void r390make(T390* C,T0* a1);
/*SPECIAL[XM_DTD_EXTERNAL_ID]*/
void r592make(T592* C,T2 a1);
/*SPECIAL[XM_DTD_EXTERNAL_ID]*/
T0* r592resize(T592* C,T2 a1);
/*SPECIAL[XM_DTD_EXTERNAL_ID]*/
void r592array_resize(T592* C,T2 a1);
/*DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]*/
T0* r574cursor_item(T0* a1);
/*DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]*/
void r574remove_traversing_cursor(T574* C,T0* a1);
/*DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]*/
void r574add_traversing_cursor(T574* C,T0* a1);
/*DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]*/
void r574make(T574* C);
/*DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]*/
T6 r574cursor_after(T0* a1);
/*DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]*/
void r574cursor_forth(T574* C,T0* a1);
/*DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]*/
void r574cursor_start(T574* C,T0* a1);
/*DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]*/
void r574force_last(T574* C,T0* a1);
/*DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]*/
T0* r574new_cursor(T574* C);
/*DS_BILINKED_LIST[XM_DTD_ATTRIBUTE_CONTENT]*/
T6 r574cursor_off(T0* a1);
/*DS_BILINKED_LIST[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
T0* r695cursor_item(T0* a1);
/*DS_BILINKED_LIST[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
void r695remove_traversing_cursor(T695* C,T0* a1);
/*DS_BILINKED_LIST[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
void r695add_traversing_cursor(T695* C,T0* a1);
/*DS_BILINKED_LIST[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
void r695make(T695* C);
/*DS_BILINKED_LIST[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
T6 r695cursor_after(T0* a1);
/*DS_BILINKED_LIST[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
void r695cursor_forth(T695* C,T0* a1);
/*DS_BILINKED_LIST[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
void r695cursor_start(T695* C,T0* a1);
/*DS_BILINKED_LIST[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
void r695force_last(T695* C,T0* a1);
/*DS_BILINKED_LIST[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
T0* r695new_cursor(T695* C);
/*DS_BILINKED_LIST[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
T6 r695cursor_off(T0* a1);
/*DS_PAIR[DS_PAIR[STRING,STRING],STRING]*/
void r693make(T693* C,T0* a1,T0* a2);
/*DS_BILINKABLE[DS_PAIR[DS_PAIR[STRING,STRING],STRING]]*/
void r709put_right(T709* C,T0* a1);
/*LINK[DOCUMENT]*/
void r117make(T117* C,T0* a1,T0* a2);
/*DS_BILINKABLE[STRING]*/
void r688put_right(T688* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T2 r303new_capacity(T2 a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T6 r303extendible(T303* C,T2 a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r303append_last(T303* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r303move_cursors_right(T303* C,T2 a1,T2 a2);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T0* r303last(T303* C);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r303put(T303* C,T0* a1,T2 a2);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T0* r303cursor_item(T303* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T6 r303is_equal(T303* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r303remove_traversing_cursor(T303* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r303add_traversing_cursor(T303* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T6 r303se_assigned_from(T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r303print_on(T303* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r303out_in_tagged_out_memory(T303* C);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T6 r303cursor_before(T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T6 r303same_type(T303* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r303make(T303* C,T2 a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T6 r303cursor_after(T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T6 r303conforms_to(T303* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T6 r303has(T303* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r303move_right(T303* C,T2 a1,T2 a2);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r303cursor_forth(T303* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r303resize(T303* C,T2 a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r303cursor_start(T303* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r303force_last(T303* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T0* r303new_cursor(T303* C);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r303extend_last(T303* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
void r303put_last(T303* C,T0* a1);
/*DS_ARRAYED_LIST[LX_NFA_STATE]*/
T6 r303cursor_off(T0* a1);
/*KL_SPECIAL_ROUTINES[XM_EIFFEL_PARSER_NAME]*/
T0* r607make(T2 a1);
/*KL_SPECIAL_ROUTINES[XM_EIFFEL_PARSER_NAME]*/
T0* r607resize(T0* a1,T2 a2);
/*DS_LINKED_QUEUE[STRING]*/
void r746force(T746* C,T0* a1);
/*DS_LINKED_QUEUE[STRING]*/
void r746wipe_out(T746* C);
/*DS_LINKED_QUEUE[STRING]*/
T0* r746item(T746* C);
/*DS_LINKED_QUEUE[STRING]*/
void r746remove(T746* C);
/*SPECIAL[STRING]*/
void r408make(T408* C,T2 a1);
/*SPECIAL[STRING]*/
T0* r408resize(T408* C,T2 a1);
/*SPECIAL[STRING]*/
void r408array_resize(T408* C,T2 a1);
/*LX_EPSILON_TRANSITION[LX_NFA_STATE]*/
T6 r306labeled(T2 a1);
/*LX_EPSILON_TRANSITION[LX_NFA_STATE]*/
T0* r306twin(T306* C);
/*KL_FIXED_ARRAY_ROUTINES[LX_DFA_STATE]*/
T0* r357make(T2 a1);
/*KL_FIXED_ARRAY_ROUTINES[LX_DFA_STATE]*/
T0* r357resize(T0* a1,T2 a2);
/*SPECIAL[BOOLEAN]*/
void r564make(T564* C,T2 a1);
/*SPECIAL[BOOLEAN]*/
T0* r564resize(T564* C,T2 a1);
/*SPECIAL[BOOLEAN]*/
void r564array_resize(T564* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
T2 r507new_capacity(T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r507make_clashes(T507* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
T0* r507cursor_item(T507* C,T0* a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r507search_position(T507* C,T0* a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r507remove_traversing_cursor(T507* C,T0* a1);
extern T2 oBC185default_capacity;
/*DS_HASH_TABLE[STRING,STRING]*/
void r507keys_resize(T507* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
T0* r507item(T507* C,T0* a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r507make_items(T507* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r507add_traversing_cursor(T507* C,T0* a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r507make(T507* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
T6 r507cursor_after(T0* a1);
/*DS_HASH_TABLE[STRING,STRING]*/
T6 r507has(T507* C,T0* a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r507make_keys(T507* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r507force_new(T507* C,T0* a1,T0* a2);
/*DS_HASH_TABLE[STRING,STRING]*/
T2 r507hash_position(T507* C,T0* a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r507cursor_forth(T507* C,T0* a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r507items_resize(T507* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r507resize(T507* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r507make_with_equality_testers(T507* C,T2 a1,T0* a2,T0* a3);
/*DS_HASH_TABLE[STRING,STRING]*/
void r507make_sparse_container(T507* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r507cursor_start(T507* C,T0* a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r507clashes_resize(T507* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
void r507slots_resize(T507* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
T0* r507new_cursor(T507* C);
/*DS_HASH_TABLE[STRING,STRING]*/
void r507make_slots(T507* C,T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
T2 r507new_modulus(T2 a1);
/*DS_HASH_TABLE[STRING,STRING]*/
T6 r507cursor_off(T0* a1);
/*DS_LINKED_LIST_CURSOR[STRING]*/
void r626set(T626* C,T0* a1,T6 a2,T6 a3);
/*DS_LINKED_LIST_CURSOR[STRING]*/
T0* r626item(T626* C);
/*DS_LINKED_LIST_CURSOR[STRING]*/
void r626make(T626* C,T0* a1);
/*DS_LINKED_LIST_CURSOR[STRING]*/
void r626forth(T626* C);
/*DS_LINKED_LIST_CURSOR[STRING]*/
void r626start(T626* C);
/*KL_EQUALITY_TESTER[XM_EIFFEL_PARSER_NAME]*/
T6 r638test(T0* a1,T0* a2);
/*KL_FIXED_ARRAY_ROUTINES[STRING]*/
T0* r217make(T2 a1);
/*KL_FIXED_ARRAY_ROUTINES[STRING]*/
T0* r217resize(T0* a1,T2 a2);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
T2 r192new_capacity(T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r192force(T192* C,T0* a1,T0* a2);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r192wipe_out(T192* C);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r192make_clashes(T192* C,T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r192search_position(T192* C,T0* a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r192keys_resize(T192* C,T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
T0* r192item(T192* C,T0* a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r192move_all_cursors_after(T192* C);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r192make_items(T192* C,T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r192slots_wipe_out(T192* C);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r192make(T192* C,T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r192clashes_wipe_out(T192* C);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
T6 r192has(T192* C,T0* a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r192make_keys(T192* C,T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
T2 r192hash_position(T192* C,T0* a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r192items_wipe_out(T192* C);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r192items_resize(T192* C,T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r192resize(T192* C,T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r192make_with_equality_testers(T192* C,T2 a1,T0* a2,T0* a3);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r192make_sparse_container(T192* C,T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r192clashes_resize(T192* C,T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r192slots_resize(T192* C,T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r192keys_wipe_out(T192* C);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
T0* r192new_cursor(T192* C);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
void r192make_slots(T192* C,T2 a1);
/*DS_HASH_TABLE[XM_EIFFEL_ENTITY_DEF,STRING]*/
T2 r192new_modulus(T2 a1);
/*KL_EQUALITY_TESTER[INTEGER]*/
T6 r376test(T2 a1,T2 a2);
/*SPECIAL[XM_DTD_ATTRIBUTE_CONTENT]*/
void r580make(T580* C,T2 a1);
/*SPECIAL[XM_DTD_ATTRIBUTE_CONTENT]*/
T0* r580resize(T580* C,T2 a1);
/*SPECIAL[XM_DTD_ATTRIBUTE_CONTENT]*/
void r580array_resize(T580* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
T2 r372new_capacity(T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r372force(T372* C,T0* a1,T2 a2);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r372make_clashes(T372* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r372search_position(T372* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r372keys_resize(T372* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
T0* r372item(T372* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r372make_items(T372* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r372make(T372* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
T6 r372has(T372* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r372make_keys(T372* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
T2 r372hash_position(T372* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r372items_resize(T372* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r372make_with_equality_testers(T372* C,T2 a1,T0* a2,T0* a3);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r372resize(T372* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r372make_sparse_container(T372* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r372clashes_resize(T372* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r372slots_resize(T372* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
T0* r372new_cursor(T372* C);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
void r372make_slots(T372* C,T2 a1);
/*DS_HASH_TABLE[LX_NFA,INTEGER]*/
T2 r372new_modulus(T2 a1);
/*DS_SHELL_SORTER[INTEGER]*/
void r488subsort_with_comparator(T0* a1,T0* a2,T2 a3,T2 a4);
/*DS_SHELL_SORTER[INTEGER]*/
void r488sort_with_comparator(T0* a1,T0* a2);
/*DS_LINKED_QUEUE[CHARACTER]*/
void r618force(T618* C,T3 a1);
/*DS_LINKED_QUEUE[CHARACTER]*/
void r618wipe_out(T618* C);
/*DS_LINKED_QUEUE[CHARACTER]*/
void r618remove(T618* C);
/*KL_SPECIAL_ROUTINES[INTEGER]*/
T0* r415make(T2 a1);
/*KL_SPECIAL_ROUTINES[INTEGER]*/
T0* r415resize(T0* a1,T2 a2);
/*DS_BILINKABLE[XM_DTD_ATTRIBUTE_CONTENT]*/
void r679put_right(T679* C,T0* a1);
/*KL_FIXED_ARRAY_ROUTINES[LX_RULE]*/
T0* r332make(T2 a1);
/*KL_FIXED_ARRAY_ROUTINES[LX_RULE]*/
T0* r332resize(T0* a1,T2 a2);
/*DS_LINKED_STACK[INTEGER]*/
void r240force(T240* C,T2 a1);
/*DS_LINKED_STACK[INTEGER]*/
void r240remove(T240* C);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
T2 r602new_capacity(T2 a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
void r602make_equal(T602* C,T2 a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
T0* r602keys_item(T602* C,T2 a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
void r602make_clashes(T602* C,T2 a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
void r602search_position(T602* C,T0* a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
void r602make_items(T602* C,T2 a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
void r602make(T602* C,T2 a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
T6 r602has(T602* C,T0* a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
void r602force_new(T602* C,T0* a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
T2 r602hash_position(T602* C,T0* a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
void r602items_resize(T602* C,T2 a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
void r602resize(T602* C,T2 a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
void r602clashes_resize(T602* C,T2 a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
void r602slots_resize(T602* C,T2 a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
T0* r602new_cursor(T602* C);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
void r602make_slots(T602* C,T2 a1);
/*DS_HASH_SET[XM_EIFFEL_PARSER_NAME]*/
T2 r602new_modulus(T2 a1);
/*KL_SPECIAL_ROUTINES[STRING]*/
T0* r407make(T2 a1);
/*KL_SPECIAL_ROUTINES[STRING]*/
T0* r407resize(T0* a1,T2 a2);
/*LINKED_LIST[INTEGER]*/
T2 r37item(T37* C,T2 a1);
/*LINKED_LIST[INTEGER]*/
void r37make(T37* C);
/*LINKED_LIST[INTEGER]*/
void r37add_last(T37* C,T2 a1);
/*LINKED_LIST[INTEGER]*/
void r37go_item(T37* C,T2 a1);
/*SPECIAL[DS_HASH_SET[XM_EIFFEL_PARSER_NAME]]*/
void r603make(T603* C,T2 a1);
/*SPECIAL[DS_HASH_SET[XM_EIFFEL_PARSER_NAME]]*/
T0* r603resize(T603* C,T2 a1);
/*SPECIAL[DS_HASH_SET[XM_EIFFEL_PARSER_NAME]]*/
void r603array_resize(T603* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
T2 r437new_capacity(T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r437force(T437* C,T0* a1,T0* a2);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r437make_clashes(T437* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
T0* r437cursor_item(T437* C,T0* a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r437search_position(T437* C,T0* a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r437remove_traversing_cursor(T437* C,T0* a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r437keys_resize(T437* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
T0* r437item(T437* C,T0* a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r437make_items(T437* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r437add_traversing_cursor(T437* C,T0* a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r437make(T437* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
T6 r437cursor_after(T0* a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
T6 r437has(T437* C,T0* a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r437make_keys(T437* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
T2 r437hash_position(T437* C,T0* a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r437cursor_forth(T437* C,T0* a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r437items_resize(T437* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r437make_with_equality_testers(T437* C,T2 a1,T0* a2,T0* a3);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r437resize(T437* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r437make_sparse_container(T437* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r437cursor_start(T437* C,T0* a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r437clashes_resize(T437* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r437slots_resize(T437* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
T0* r437new_cursor(T437* C);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
void r437make_slots(T437* C,T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
T2 r437new_modulus(T2 a1);
/*DS_HASH_TABLE[LX_SYMBOL_CLASS,STRING]*/
T6 r437cursor_off(T0* a1);
/*DS_BILINKED_LIST[STRING]*/
T0* r567cursor_item(T0* a1);
/*DS_BILINKED_LIST[STRING]*/
void r567remove_traversing_cursor(T567* C,T0* a1);
/*DS_BILINKED_LIST[STRING]*/
T0* r567item(T567* C,T2 a1);
/*DS_BILINKED_LIST[STRING]*/
void r567add_traversing_cursor(T567* C,T0* a1);
/*DS_BILINKED_LIST[STRING]*/
void r567make(T567* C);
/*DS_BILINKED_LIST[STRING]*/
T6 r567cursor_after(T0* a1);
/*DS_BILINKED_LIST[STRING]*/
void r567cursor_forth(T567* C,T0* a1);
/*DS_BILINKED_LIST[STRING]*/
void r567cursor_start(T567* C,T0* a1);
/*DS_BILINKED_LIST[STRING]*/
void r567force_last(T567* C,T0* a1);
/*DS_BILINKED_LIST[STRING]*/
T0* r567new_cursor(T567* C);
/*DS_BILINKED_LIST[STRING]*/
T6 r567cursor_off(T0* a1);
/*KL_COMPARABLE_COMPARATOR[LX_RULE]*/
T6 r315less_than(T0* a1,T0* a2);
extern T0*oBC42string_;
/*TREE_TO_AST*/
void r40process_end_element(T40* C,T0* a1);
/*TREE_TO_AST*/
void r40process_start_element(T40* C,T0* a1);
/*TREE_TO_AST*/
void r40process_composite(T40* C,T0* a1);
/*TREE_TO_AST*/
void r40make(T40* C,T0* a1,T0* a2,T0* a3);
/*TREE_TO_AST*/
T0* r40convert(T40* C);
/*TREE_TO_AST*/
void r40process_element(T40* C,T0* a1);
/*TREE_TO_AST*/
void r40process_character_data(T40* C,T0* a1);
/*LX_SYMBOL_PARTITIONS*/
void r291build(T291* C);
/*LX_SYMBOL_PARTITIONS*/
T2 r291previous_symbol(T291* C,T2 a1);
/*LX_SYMBOL_PARTITIONS*/
void r291put(T291* C,T2 a1);
/*LX_SYMBOL_PARTITIONS*/
T0* r291to_array(T291* C,T2 a1,T2 a2);
/*LX_SYMBOL_PARTITIONS*/
void r291make(T291* C,T2 a1,T2 a2);
/*LX_SYMBOL_PARTITIONS*/
void r291equiv_add(T291* C,T0* a1);
/*LX_SYMBOL_PARTITIONS*/
void r291equiv_initialize(T291* C);
/*LX_SYMBOL_PARTITIONS*/
T2 r291equivalence_class(T291* C,T2 a1);
/*LX_SYMBOL_PARTITIONS*/
void r291add(T291* C,T0* a1);
/*LX_SYMBOL_PARTITIONS*/
T6 r291is_representative(T291* C,T2 a1);
/*LX_SYMBOL_PARTITIONS*/
void r291initialize(T291* C);
/*LX_SYMBOL_PARTITIONS*/
void r291equiv_put(T291* C,T2 a1);
/*LX_FULL_DFA*/
void r260build(T260* C);
/*LX_FULL_DFA*/
void r260build_accept_table(T260* C);
/*LX_FULL_DFA*/
void r260initialize_dfa(T260* C,T0* a1,T2 a2,T2 a3);
/*LX_FULL_DFA*/
void r260put_start_condition(T260* C,T0* a1);
/*LX_FULL_DFA*/
void r260set_nfa_state_ids(T0* a1);
/*LX_FULL_DFA*/
void r260make(T260* C,T0* a1);
/*LX_FULL_DFA*/
void r260build_eof_rules(T260* C,T0* a1,T2 a2,T2 a3);
/*LX_FULL_DFA*/
void r260build_transitions(T260* C,T0* a1);
/*LX_FULL_DFA*/
void r260initialize(T260* C,T0* a1);
/*LX_FULL_DFA*/
void r260put_eob_state(T260* C);
/*LX_FULL_DFA*/
void r260build_rules(T260* C,T0* a1);
/*LX_FULL_DFA*/
void r260build_nxt_table(T260* C);
/*LX_FULL_DFA*/
T0* r260new_state(T260* C,T0* a1);
/*KL_TEXT_INPUT_FILE*/
T6 r45is_closed(T45* C);
/*KL_TEXT_INPUT_FILE*/
void r45old_close(T45* C);
/*KL_TEXT_INPUT_FILE*/
T2 r45read_to_string(T45* C,T0* a1,T2 a2,T2 a3);
/*KL_TEXT_INPUT_FILE*/
void r45open_read(T45* C);
/*KL_TEXT_INPUT_FILE*/
void r45old_read_character(T45* C);
/*KL_TEXT_INPUT_FILE*/
void r45read_character(T45* C);
/*KL_TEXT_INPUT_FILE*/
void r45fill_buffer(T45* C);
/*KL_TEXT_INPUT_FILE*/
void r45close(T45* C);
/*KL_TEXT_INPUT_FILE*/
void r45make(T45* C,T0* a1);
/*KL_TEXT_INPUT_FILE*/
T2 r45read_to_buffer(T45* C,T0* a1,T2 a2,T2 a3);
/*KL_TEXT_INPUT_FILE*/
void r45connect_to(T45* C,T0* a1);
/*KL_TEXT_INPUT_FILE*/
void r45read_string(T45* C,T2 a1);
/*KL_TEXT_INPUT_FILE*/
T2 r45_57Pread_to_buffer(T45* C,T0* a1,T2 a2,T2 a3);
/*KL_TEXT_INPUT_FILE*/
void r45old_open_read(T45* C);
/*LX_NFA_STATE*/
T6 r301is_equal(T301* C,T0* a1);
/*LX_NFA_STATE*/
T6 r301has_transition(T301* C);
/*LX_NFA_STATE*/
T6 r301is_accepting_head(T301* C);
/*LX_NFA_STATE*/
T0* r301twin(T301* C);
/*LX_NFA_STATE*/
void r301set_beginning_as_normal(T301* C);
/*LX_NFA_STATE*/
T6 r301_ix_60(T301* C,T0* a1);
extern T0*oBC175normalized_newline;
extern T0*oBC178integer_array_;
/*XM_EIFFEL_SCANNER_DTD*/
T2 r634start_condition(T634* C);
/*XM_EIFFEL_SCANNER_DTD*/
void r634_176Preset(T634* C);
/*XM_EIFFEL_SCANNER_DTD*/
void r634_177Pset_input_buffer(T634* C,T0* a1);
/*XM_EIFFEL_SCANNER_DTD*/
void r634set_input_buffer(T634* C,T0* a1);
/*XM_EIFFEL_SCANNER_DTD*/
T0* r634text_substring(T634* C,T2 a1,T2 a2);
extern T0*oBC174yy_ec_template;
extern int fBC174yy_ec_template;
/*XM_EIFFEL_SCANNER_DTD*/
T0* r634yy_ec_template(void);
/*XM_EIFFEL_SCANNER_DTD*/
void r634yy_execute_action(T634* C,T2 a1);
extern T0*oBC174yy_def_template;
extern int fBC174yy_def_template;
/*XM_EIFFEL_SCANNER_DTD*/
T0* r634yy_def_template(void);
/*XM_EIFFEL_SCANNER_DTD*/
void r634_174Pread_token(T634* C);
/*XM_EIFFEL_SCANNER_DTD*/
T3 r634text_item(T634* C,T2 a1);
/*XM_EIFFEL_SCANNER_DTD*/
T0* r634system_literal_text(T634* C);
/*XM_EIFFEL_SCANNER_DTD*/
void r634yy_load_input_buffer(T634* C);
/*XM_EIFFEL_SCANNER_DTD*/
void r634make_with_buffer(T634* C,T0* a1);
/*XM_EIFFEL_SCANNER_DTD*/
T2 r634yy_null_trans_state(T634* C,T2 a1);
/*XM_EIFFEL_SCANNER_DTD*/
void r634pop_start_condition(T634* C);
extern T0*oBC174yy_accept_template;
extern int fBC174yy_accept_template;
/*XM_EIFFEL_SCANNER_DTD*/
T0* r634yy_accept_template(void);
/*XM_EIFFEL_SCANNER_DTD*/
void r634read_token(T634* C);
/*XM_EIFFEL_SCANNER_DTD*/
T2 r634yy_previous_state(T634* C);
/*XM_EIFFEL_SCANNER_DTD*/
void r634yy_refill_input_buffer(T634* C);
/*XM_EIFFEL_SCANNER_DTD*/
T0* r634yy_fixed_array(T0* a1);
extern T0*oBC174yy_meta_template;
extern int fBC174yy_meta_template;
/*XM_EIFFEL_SCANNER_DTD*/
T0* r634yy_meta_template(void);
extern T0*oBC174yy_base_template;
extern int fBC174yy_base_template;
/*XM_EIFFEL_SCANNER_DTD*/
T0* r634yy_base_template(void);
/*XM_EIFFEL_SCANNER_DTD*/
void r634set_input_stream(T634* C,T0* a1);
/*XM_EIFFEL_SCANNER_DTD*/
T2 r634text_count(T634* C);
/*XM_EIFFEL_SCANNER_DTD*/
T0* r634new_file_buffer(T0* a1);
/*XM_EIFFEL_SCANNER_DTD*/
void r634make_scanner(T634* C);
/*XM_EIFFEL_SCANNER_DTD*/
void r634_175Pmake_scanner(T634* C);
/*XM_EIFFEL_SCANNER_DTD*/
void r634yy_initialize(T634* C);
/*XM_EIFFEL_SCANNER_DTD*/
void r634reset(T634* C);
/*XM_EIFFEL_SCANNER_DTD*/
void r634push_start_condition(T634* C,T2 a1);
/*XM_EIFFEL_SCANNER_DTD*/
T0* r634text(T634* C);
/*XM_EIFFEL_SCANNER_DTD*/
void r634close_input(T634* C);
extern T0*oBC174yy_nxt_template;
extern int fBC174yy_nxt_template;
/*XM_EIFFEL_SCANNER_DTD*/
T0* r634yy_nxt_template(void);
/*XM_EIFFEL_SCANNER_DTD*/
void r634yy_set_line_column(T634* C);
extern T0*oBC179empty_buffer;
extern int fBC179empty_buffer;
/*XM_EIFFEL_SCANNER_DTD*/
T0* r634empty_buffer(void);
extern T0*oBC174yy_chk_template;
extern int fBC174yy_chk_template;
/*XM_EIFFEL_SCANNER_DTD*/
T0* r634yy_chk_template(void);
/*XM_EIFFEL_SCANNER_DTD*/
void r634yy_set_content(T634* C,T0* a1);
/*XM_EIFFEL_SCANNER_DTD*/
void r634set_start_condition(T634* C,T2 a1);
/*XM_EIFFEL_SCANNER_DTD*/
void r634yy_build_tables(T634* C);
/*LX_START_CONDITIONS*/
void r361move_cursors_right(T361* C,T2 a1,T2 a2);
/*LX_START_CONDITIONS*/
void r361put(T361* C,T0* a1,T2 a2);
/*LX_START_CONDITIONS*/
void r361make_with_initial(T361* C,T2 a1);
/*LX_START_CONDITIONS*/
void r361add_bol_nfa_to_all(T361* C,T0* a1);
/*LX_START_CONDITIONS*/
T0* r361names(T361* C);
/*LX_START_CONDITIONS*/
void r361add_nfa_to_non_exclusive(T361* C,T0* a1);
/*LX_START_CONDITIONS*/
void r361add_bol_nfa_to_non_exclusive(T361* C,T0* a1);
/*LX_START_CONDITIONS*/
void r361make(T361* C,T2 a1);
/*LX_START_CONDITIONS*/
void r361move_right(T361* C,T2 a1,T2 a2);
/*LX_START_CONDITIONS*/
void r361add_nfa_to_all(T361* C,T0* a1);
/*LX_START_CONDITIONS*/
T0* r361new_cursor(T361* C);
/*LX_START_CONDITIONS*/
void r361put_last(T361* C,T0* a1);
/*HTML_VISITOR*/
void r77sub_visit(T77* C,T0* a1);
/*HTML_VISITOR*/
T0* r77visit_cmts(T77* C,T0* a1);
/*HTML_VISITOR*/
void r77visit(T77* C);
/*HTML_VISITOR*/
void r77make(T77* C,T0* a1,T0* a2,T0* a3,T0* a4,T0* a5,T0* a6,T0* a7,T0* a8,T0* a9);
/*HTML_VISITOR*/
T0* r77visit_strs(T0* a1);
/*HTML_VISITOR*/
T0* r77concat(T0* a1,T0* a2,T0* a3);
/*HTML_VISITOR*/
T0* r77get_result(T77* C);
/*HTML_VISITOR*/
T0* r77read_file(T0* a1);
/*HTML_VISITOR*/
T0* r77visit_cmt(T77* C,T0* a1);
/*HTML_VISITOR*/
T0* r77visit_str(T0* a1);
/*XM_STOP_ON_ERROR_FILTER*/
void r131on_start_tag_finish(T131* C);
/*XM_STOP_ON_ERROR_FILTER*/
void r131_133Pon_processing_instruction(T131* C,T0* a1,T0* a2);
/*XM_STOP_ON_ERROR_FILTER*/
void r131_133Pon_end_tag(T131* C,T0* a1,T0* a2,T0* a3);
/*XM_STOP_ON_ERROR_FILTER*/
void r131_133Pon_comment(T131* C,T0* a1);
/*XM_STOP_ON_ERROR_FILTER*/
void r131_133Pon_attribute(T131* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*XM_STOP_ON_ERROR_FILTER*/
void r131on_finish(T131* C);
/*XM_STOP_ON_ERROR_FILTER*/
void r131on_content(T131* C,T0* a1);
/*XM_STOP_ON_ERROR_FILTER*/
void r131make_null(T131* C);
/*XM_STOP_ON_ERROR_FILTER*/
void r131on_start(T131* C);
/*XM_STOP_ON_ERROR_FILTER*/
void r131on_processing_instruction(T131* C,T0* a1,T0* a2);
/*XM_STOP_ON_ERROR_FILTER*/
void r131_133Pon_finish(T131* C);
/*XM_STOP_ON_ERROR_FILTER*/
void r131_133Pon_start_tag(T131* C,T0* a1,T0* a2,T0* a3);
/*XM_STOP_ON_ERROR_FILTER*/
void r131_133Pon_error(T131* C,T0* a1);
/*XM_STOP_ON_ERROR_FILTER*/
void r131_133Pon_content(T131* C,T0* a1);
/*XM_STOP_ON_ERROR_FILTER*/
void r131on_start_tag(T131* C,T0* a1,T0* a2,T0* a3);
/*XM_STOP_ON_ERROR_FILTER*/
void r131on_comment(T131* C,T0* a1);
/*XM_STOP_ON_ERROR_FILTER*/
void r131on_end_tag(T131* C,T0* a1,T0* a2,T0* a3);
/*XM_STOP_ON_ERROR_FILTER*/
void r131on_attribute(T131* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*XM_STOP_ON_ERROR_FILTER*/
void r131_133Pon_start_tag_finish(T131* C);
/*XM_STOP_ON_ERROR_FILTER*/
void r131on_error(T131* C,T0* a1);
/*XM_STOP_ON_ERROR_FILTER*/
void r131_133Pon_start(T131* C);
/*XM_STOP_ON_ERROR_FILTER*/
void r131on_xml_declaration(T131* C,T0* a1,T0* a2,T6 a3);
/*LX_REGEXP_PARSER*/
void r267report_iteration_not_positive_error(T267* C);
/*LX_REGEXP_PARSER*/
void r267yy_do_action(T267* C,T2 a1);
/*LX_REGEXP_PARSER*/
void r267process_escaped_character(T267* C);
/*LX_REGEXP_PARSER*/
void r267report_bad_character_error(T267* C,T0* a1);
extern T0*oBC267yytable_template;
extern int fBC267yytable_template;
/*LX_REGEXP_PARSER*/
T0* r267yytable_template(void);
/*LX_REGEXP_PARSER*/
void r267make_parser_skeleton(T267* C);
/*LX_REGEXP_PARSER*/
T0* r267append_character_set_to_character_class(T267* C,T2 a1,T2 a2,T0* a3);
/*LX_REGEXP_PARSER*/
void r267process_regexp_or_series(T267* C);
/*LX_REGEXP_PARSER*/
T0* r267append_trail_context_to_regexp(T267* C,T0* a1,T0* a2);
/*LX_REGEXP_PARSER*/
void r267report_bad_character_in_brackets_error(T267* C);
/*LX_REGEXP_PARSER*/
void r267process_singleton_dot(T267* C);
/*LX_REGEXP_PARSER*/
T0* r267new_iteration_nfa(T267* C,T0* a1,T2 a2);
/*LX_REGEXP_PARSER*/
void r267report_unrecognized_rule_error(T267* C);
/*LX_REGEXP_PARSER*/
void r267report_bad_iteration_values_error(T267* C);
/*LX_REGEXP_PARSER*/
void r267fatal_error(T0* a1);
extern T0*oBC84std;
/*LX_REGEXP_PARSER*/
void r267process_singleton_empty_string(T267* C);
/*LX_REGEXP_PARSER*/
T2 r267start_condition(T267* C);
/*LX_REGEXP_PARSER*/
void r267yy_do_error_action(T267* C,T2 a1);
/*LX_REGEXP_PARSER*/
T0* r267new_nfa_from_character(T267* C,T2 a1);
/*LX_REGEXP_PARSER*/
void r267parse(T267* C);
/*LX_REGEXP_PARSER*/
void r267check_options(T267* C);
/*LX_REGEXP_PARSER*/
void r267report_missing_quote_error(T267* C);
/*LX_REGEXP_PARSER*/
void r267set_input_buffer(T267* C,T0* a1);
extern T0*oBC268yy_ec_template;
extern int fBC268yy_ec_template;
/*LX_REGEXP_PARSER*/
T0* r267yy_ec_template(void);
/*LX_REGEXP_PARSER*/
void r267yy_execute_action(T267* C,T2 a1);
extern T0*oBC267yytranslate_template;
extern int fBC267yytranslate_template;
/*LX_REGEXP_PARSER*/
T0* r267yytranslate_template(void);
extern T0*oBC268yy_def_template;
extern int fBC268yy_def_template;
/*LX_REGEXP_PARSER*/
T0* r267yy_def_template(void);
/*LX_REGEXP_PARSER*/
void r267report_full_and_meta_equiv_classes_error(T267* C);
/*LX_REGEXP_PARSER*/
T3 r267text_item(T267* C,T2 a1);
/*LX_REGEXP_PARSER*/
void r267yy_push_last_value(T267* C,T2 a1);
/*LX_REGEXP_PARSER*/
T0* r267new_string_buffer(T0* a1);
/*LX_REGEXP_PARSER*/
void r267yy_load_input_buffer(T267* C);
/*LX_REGEXP_PARSER*/
void r267yy_push_error_value(T267* C);
extern T0*oBC267yyr1_template;
extern int fBC267yyr1_template;
/*LX_REGEXP_PARSER*/
T0* r267yyr1_template(void);
/*LX_REGEXP_PARSER*/
void r267make_with_buffer(T267* C,T0* a1);
/*LX_REGEXP_PARSER*/
void r267process_singleton_unbounded_iteration(T267* C,T2 a1);
/*LX_REGEXP_PARSER*/
void r267process_rule(T267* C,T0* a1);
extern T0*oBC267yytypes1_template;
extern int fBC267yytypes1_template;
/*LX_REGEXP_PARSER*/
T0* r267yytypes1_template(void);
/*LX_REGEXP_PARSER*/
void r267process_character(T267* C,T2 a1);
/*LX_REGEXP_PARSER*/
T2 r267yy_null_trans_state(T267* C,T2 a1);
/*LX_REGEXP_PARSER*/
void r267process_singleton_bounded_iteration(T267* C,T2 a1,T2 a2);
/*LX_REGEXP_PARSER*/
T0* r267dot_character_class(T267* C);
/*LX_REGEXP_PARSER*/
void r267report_negative_range_in_character_class_error(T267* C);
/*LX_REGEXP_PARSER*/
void r267report_full_and_variable_trailing_context_error(T267* C);
extern T0*oBC268yy_accept_template;
extern int fBC268yy_accept_template;
/*LX_REGEXP_PARSER*/
T0* r267yy_accept_template(void);
/*LX_REGEXP_PARSER*/
void r267read_token(T267* C);
/*LX_REGEXP_PARSER*/
void r267yy_init_value_stacks(T267* C);
/*LX_REGEXP_PARSER*/
T2 r267yy_previous_state(T267* C);
extern T0*oBC267yypgoto_template;
extern int fBC267yypgoto_template;
/*LX_REGEXP_PARSER*/
T0* r267yypgoto_template(void);
/*LX_REGEXP_PARSER*/
void r267yy_refill_input_buffer(T267* C);
extern T0*oBC267yytypes2_template;
extern int fBC267yytypes2_template;
/*LX_REGEXP_PARSER*/
T0* r267yytypes2_template(void);
/*LX_REGEXP_PARSER*/
T0* r267yy_fixed_array(T0* a1);
extern T0*oBC268yy_meta_template;
extern int fBC268yy_meta_template;
/*LX_REGEXP_PARSER*/
T0* r267yy_meta_template(void);
/*LX_REGEXP_PARSER*/
void r267report_character_out_of_range_error(T267* C,T0* a1);
/*LX_REGEXP_PARSER*/
void r267process_bol_rule(T267* C,T0* a1);
/*LX_REGEXP_PARSER*/
T0* r267new_epsilon_nfa(T267* C);
extern T0*oBC268yy_base_template;
extern int fBC268yy_base_template;
/*LX_REGEXP_PARSER*/
T0* r267yy_base_template(void);
/*LX_REGEXP_PARSER*/
T0* r267append_eol_to_regexp(T267* C,T0* a1);
/*LX_REGEXP_PARSER*/
void r267report_full_and_reject_error(T267* C);
/*LX_REGEXP_PARSER*/
T0* r267append_character_to_character_class(T267* C,T2 a1,T0* a2);
/*LX_REGEXP_PARSER*/
T2 r267text_count(T267* C);
/*LX_REGEXP_PARSER*/
void r267process_singleton_plus(T267* C);
/*LX_REGEXP_PARSER*/
void r267parse_string(T267* C,T0* a1);
/*LX_REGEXP_PARSER*/
void r267yy_initialize(T267* C);
/*LX_REGEXP_PARSER*/
T0* r267text(T267* C);
/*LX_REGEXP_PARSER*/
void r267report_missing_bracket_error(T267* C);
/*LX_REGEXP_PARSER*/
T0* r267new_symbol_nfa(T267* C,T2 a1);
/*LX_REGEXP_PARSER*/
void r267process_singleton_symbol_class(T267* C,T0* a1);
/*LX_REGEXP_PARSER*/
void r267yy_clear_value_stacks(T267* C);
extern T0*oBC268yy_nxt_template;
extern int fBC268yy_nxt_template;
/*LX_REGEXP_PARSER*/
T0* r267yy_nxt_template(void);
/*LX_REGEXP_PARSER*/
void r267yy_set_line_column(T267* C);
/*LX_REGEXP_PARSER*/
void r267yy_build_parser_tables(T267* C);
/*LX_REGEXP_PARSER*/
void r267process_singleton_string(T267* C,T2 a1);
/*LX_REGEXP_PARSER*/
void r267build_equiv_classes(T267* C);
/*LX_REGEXP_PARSER*/
T0* r267new_symbol_class_nfa(T267* C,T0* a1);
/*LX_REGEXP_PARSER*/
void r267process_series_singleton(T267* C);
/*LX_REGEXP_PARSER*/
T0* r267new_unbounded_iteration_nfa(T267* C,T0* a1,T2 a2);
/*LX_REGEXP_PARSER*/
T0* r267new_bounded_iteration_nfa(T267* C,T0* a1,T2 a2,T2 a3);
/*LX_REGEXP_PARSER*/
void r267process_singleton_optional(T267* C);
/*LX_REGEXP_PARSER*/
void r267report_trailing_context_used_twice_error(T267* C);
/*LX_REGEXP_PARSER*/
T0* r267empty_buffer(void);
/*LX_REGEXP_PARSER*/
void r267report_error(T267* C,T0* a1);
/*LX_REGEXP_PARSER*/
T0* r267append_character_to_string(T267* C,T2 a1,T0* a2);
/*LX_REGEXP_PARSER*/
void r267process_singleton_star(T267* C);
/*LX_REGEXP_PARSER*/
void r267process_singleton_fixed_iteration(T267* C,T2 a1);
extern T0*oBC267yydefact_template;
extern int fBC267yydefact_template;
/*LX_REGEXP_PARSER*/
T0* r267yydefact_template(void);
extern T0*oBC268yy_chk_template;
extern int fBC268yy_chk_template;
/*LX_REGEXP_PARSER*/
T0* r267yy_chk_template(void);
/*LX_REGEXP_PARSER*/
T0* r267new_nfa_from_character_class(T267* C,T0* a1);
extern T0*oBC267yycheck_template;
extern int fBC267yycheck_template;
/*LX_REGEXP_PARSER*/
T0* r267yycheck_template(void);
/*LX_REGEXP_PARSER*/
T0* r267new_character_class(T267* C);
/*LX_REGEXP_PARSER*/
T0* r267filename(T267* C);
/*LX_REGEXP_PARSER*/
T0* r267yyfixed_array(T0* a1);
/*LX_REGEXP_PARSER*/
void r267process_singleton_char(T267* C,T2 a1);
extern T0*oBC267yydefgoto_template;
extern int fBC267yydefgoto_template;
/*LX_REGEXP_PARSER*/
T0* r267yydefgoto_template(void);
/*LX_REGEXP_PARSER*/
void r267yy_pop_last_value(T267* C,T2 a1);
/*LX_REGEXP_PARSER*/
void r267yy_set_content(T267* C,T0* a1);
extern T0*oBC267yypact_template;
extern int fBC267yypact_template;
/*LX_REGEXP_PARSER*/
T0* r267yypact_template(void);
/*LX_REGEXP_PARSER*/
void r267set_start_condition(T267* C,T2 a1);
/*LX_REGEXP_PARSER*/
void r267yy_build_tables(T267* C);
/*LX_REGEXP_PARSER*/
void r267make_lex_scanner_from_description(T267* C,T0* a1,T0* a2);
/*LX_REGEXP_PARSER*/
void r267less(T267* C,T2 a1);
/*LX_REGEXP_PARSER*/
void r267report_bad_character_class_error(T267* C);
/*LX_REGEXP_PARSER*/
void r267make_from_description(T267* C,T0* a1,T0* a2);
/*XM_EIFFEL_SCANNER*/
T2 r174start_condition(T174* C);
/*XM_EIFFEL_SCANNER*/
void r174_176Preset(T174* C);
/*XM_EIFFEL_SCANNER*/
void r174_177Pset_input_buffer(T174* C,T0* a1);
/*XM_EIFFEL_SCANNER*/
void r174yy_chk_template_1(T0* a1);
/*XM_EIFFEL_SCANNER*/
void r174yy_chk_template_2(T0* a1);
/*XM_EIFFEL_SCANNER*/
void r174set_input_buffer(T174* C,T0* a1);
/*XM_EIFFEL_SCANNER*/
T0* r174text_substring(T174* C,T2 a1,T2 a2);
/*XM_EIFFEL_SCANNER*/
T0* r174yy_ec_template(void);
/*XM_EIFFEL_SCANNER*/
void r174yy_execute_action(T174* C,T2 a1);
/*XM_EIFFEL_SCANNER*/
T0* r174yy_def_template(void);
/*XM_EIFFEL_SCANNER*/
T3 r174text_item(T174* C,T2 a1);
/*XM_EIFFEL_SCANNER*/
T0* r174system_literal_text(T174* C);
/*XM_EIFFEL_SCANNER*/
void r174yy_load_input_buffer(T174* C);
/*XM_EIFFEL_SCANNER*/
void r174make_with_buffer(T174* C,T0* a1);
/*XM_EIFFEL_SCANNER*/
T2 r174yy_null_trans_state(T174* C,T2 a1);
/*XM_EIFFEL_SCANNER*/
void r174pop_start_condition(T174* C);
/*XM_EIFFEL_SCANNER*/
T6 r174is_valid_encoding(T174* C,T0* a1);
/*XM_EIFFEL_SCANNER*/
T0* r174yy_accept_template(void);
/*XM_EIFFEL_SCANNER*/
void r174read_token(T174* C);
/*XM_EIFFEL_SCANNER*/
T2 r174yy_previous_state(T174* C);
/*XM_EIFFEL_SCANNER*/
void r174yy_refill_input_buffer(T174* C);
/*XM_EIFFEL_SCANNER*/
void r174push_start_condition_dtd_ignore(T174* C);
/*XM_EIFFEL_SCANNER*/
T0* r174yy_fixed_array(T0* a1);
/*XM_EIFFEL_SCANNER*/
T0* r174yy_meta_template(void);
/*XM_EIFFEL_SCANNER*/
T0* r174yy_base_template(void);
/*XM_EIFFEL_SCANNER*/
void r174set_input_stream(T174* C,T0* a1);
/*XM_EIFFEL_SCANNER*/
T2 r174text_count(T174* C);
/*XM_EIFFEL_SCANNER*/
T0* r174new_file_buffer(T0* a1);
/*XM_EIFFEL_SCANNER*/
void r174make_scanner(T174* C);
/*XM_EIFFEL_SCANNER*/
void r174yy_initialize(T174* C);
/*XM_EIFFEL_SCANNER*/
void r174reset(T174* C);
/*XM_EIFFEL_SCANNER*/
void r174push_start_condition(T174* C,T2 a1);
/*XM_EIFFEL_SCANNER*/
T0* r174text(T174* C);
/*XM_EIFFEL_SCANNER*/
void r174close_input(T174* C);
/*XM_EIFFEL_SCANNER*/
T0* r174yy_nxt_template(void);
/*XM_EIFFEL_SCANNER*/
void r174yy_set_line_column(T174* C);
/*XM_EIFFEL_SCANNER*/
T0* r174empty_buffer(void);
/*XM_EIFFEL_SCANNER*/
void r174yy_nxt_template_1(T0* a1);
/*XM_EIFFEL_SCANNER*/
void r174yy_nxt_template_2(T0* a1);
/*XM_EIFFEL_SCANNER*/
T0* r174yy_chk_template(void);
/*XM_EIFFEL_SCANNER*/
void r174yy_set_content(T174* C,T0* a1);
/*XM_EIFFEL_SCANNER*/
void r174set_start_condition(T174* C,T2 a1);
/*XM_EIFFEL_SCANNER*/
void r174yy_execute_eof_action(T174* C,T2 a1);
/*XM_EIFFEL_SCANNER*/
void r174yy_build_tables(T174* C);
/*GREP_VISITOR*/
void r253sub_visit(T253* C,T0* a1);
/*GREP_VISITOR*/
void r253visit(T253* C);
/*GREP_VISITOR*/
void r253visit_string(T253* C,T0* a1);
/*GREP_VISITOR*/
void r253make(T253* C,T0* a1,T6 a2,T0* a3,T6 a4);
/*GREP_VISITOR*/
void r253visit_comments(T253* C,T0* a1);
/*GREP_VISITOR*/
void r253visit_strings(T253* C,T0* a1);
/*GREP_VISITOR*/
void r253visit_comment(T253* C,T0* a1);
extern T0*oBC424arguments;
extern int fBC424arguments;
/*LX_FULL_AND_REJECT_ERROR*/
T0* r448arguments(void);
/*LX_FULL_AND_REJECT_ERROR*/
void r448make(T448* C);
/*LX_FULL_AND_REJECT_ERROR*/
T0* r448message(T448* C,T0* a1);
/*LX_UNRECOGNIZED_RULE_ERROR*/
T0* r462arguments(void);
/*LX_UNRECOGNIZED_RULE_ERROR*/
void r462make(T462* C,T0* a1,T2 a2);
/*LX_UNRECOGNIZED_RULE_ERROR*/
T0* r462message(T462* C,T0* a1);
/*LX_BAD_CHARACTER_IN_BRACKETS_ERROR*/
T0* r443arguments(void);
/*LX_BAD_CHARACTER_IN_BRACKETS_ERROR*/
void r443make(T443* C,T0* a1,T2 a2);
/*LX_BAD_CHARACTER_IN_BRACKETS_ERROR*/
T0* r443message(T443* C,T0* a1);
/*XM_TREE_CALLBACKS_PIPE*/
T0* r129callbacks_pipe(T0* a1);
/*XM_TREE_CALLBACKS_PIPE*/
T0* r129new_tree_builder(void);
/*XM_TREE_CALLBACKS_PIPE*/
void r129make(T129* C);
/*XM_TREE_CALLBACKS_PIPE*/
T0* r129new_namespace_resolver(void);
/*XM_TREE_CALLBACKS_PIPE*/
T0* r129new_stop_on_error(void);
/*LX_DFA_REGULAR_EXPRESSION*/
void r254wipe_out(T254* C);
/*LX_DFA_REGULAR_EXPRESSION*/
T6 r254matches(T254* C,T0* a1);
/*LX_DFA_REGULAR_EXPRESSION*/
void r254compile(T254* C,T0* a1,T6 a2);
/*LX_DFA_REGULAR_EXPRESSION*/
T2 r254smallest_end_position(T254* C,T0* a1,T2 a2);
/*LX_DFA_REGULAR_EXPRESSION*/
T2 r254longest_end_position(T254* C,T0* a1,T2 a2);
/*UT_ERROR_HANDLER*/
void r264make_null(T264* C);
extern T0*oBC265null_output_stream;
extern int fBC265null_output_stream;
/*UT_ERROR_HANDLER*/
T0* r264null_output_stream(void);
/*UT_ERROR_HANDLER*/
T0* r264message(T0* a1);
/*YY_FILE_BUFFER*/
void r431fill(T431* C);
/*YY_FILE_BUFFER*/
void r431compact_left(T431* C);
/*YY_FILE_BUFFER*/
void r431set_position(T431* C,T2 a1,T2 a2,T2 a3);
/*YY_FILE_BUFFER*/
T0* r431name(T431* C);
extern T2 oBC243default_capacity;
/*YY_FILE_BUFFER*/
void r431make_from_string(T431* C,T0* a1);
/*YY_FILE_BUFFER*/
void r431make_from_buffer(T431* C,T0* a1);
/*YY_FILE_BUFFER*/
void r431resize(T431* C);
/*YY_FILE_BUFFER*/
T0* r431new_default_buffer(T2 a1);
/*YY_FILE_BUFFER*/
void r431make_with_size(T431* C,T0* a1,T2 a2);
/*YY_FILE_BUFFER*/
void r431set_file(T431* C,T0* a1);
/*YY_FILE_BUFFER*/
void r431flush(T431* C);
/*LX_MISSING_QUOTE_ERROR*/
T0* r445arguments(void);
/*LX_MISSING_QUOTE_ERROR*/
void r445make(T445* C,T0* a1,T2 a2);
/*LX_MISSING_QUOTE_ERROR*/
T0* r445message(T445* C,T0* a1);
/*LX_FULL_AND_META_ERROR*/
T0* r450arguments(void);
/*LX_FULL_AND_META_ERROR*/
void r450make(T450* C);
/*LX_FULL_AND_META_ERROR*/
T0* r450message(T450* C,T0* a1);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r141on_start_tag_finish(T141* C);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r141on_finish(T141* C);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r141on_content(T141* C,T0* a1);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r141make_null(T141* C);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r141on_start(T141* C);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r141on_processing_instruction(T141* C,T0* a1,T0* a2);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r141on_start_tag(T141* C,T0* a1,T0* a2,T0* a3);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r141handle_position(T141* C,T0* a1);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r141on_comment(T141* C,T0* a1);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r141on_end_tag(T141* C,T0* a1,T0* a2,T0* a3);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r141on_attribute(T141* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*XM_CALLBACKS_TO_TREE_FILTER*/
T0* r141new_namespace(T141* C,T0* a1,T0* a2);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r141on_error(T141* C,T0* a1);
/*XM_CALLBACKS_TO_TREE_FILTER*/
void r141on_xml_declaration(T141* C,T0* a1,T0* a2,T6 a3);
/*XM_DTD_ELEMENT_CONTENT*/
void r584make_choice(T584* C);
/*XM_DTD_ELEMENT_CONTENT*/
void r584make_mixed(T584* C);
/*XM_DTD_ELEMENT_CONTENT*/
void r584set_content_mixed(T584* C);
/*XM_DTD_ELEMENT_CONTENT*/
void r584make_empty(T584* C);
/*XM_DTD_ELEMENT_CONTENT*/
void r584set_default(T584* C);
/*XM_DTD_ELEMENT_CONTENT*/
void r584make_any(T584* C);
/*XM_DTD_ELEMENT_CONTENT*/
void r584make_sequence(T584* C);
/*XM_DTD_ELEMENT_CONTENT*/
void r584make_list(T584* C);
/*XM_DTD_ELEMENT_CONTENT*/
void r584make_name(T584* C,T0* a1);
/*XM_DTD_ELEMENT_CONTENT*/
void r584set_content_any(T584* C);
/*LX_NEGATIVE_RANGE_IN_CHARACTER_CLASS_ERROR*/
T0* r491arguments(void);
/*LX_NEGATIVE_RANGE_IN_CHARACTER_CLASS_ERROR*/
void r491make(T491* C,T0* a1,T2 a2);
/*LX_NEGATIVE_RANGE_IN_CHARACTER_CLASS_ERROR*/
T0* r491message(T491* C,T0* a1);
/*TEMPLATE*/
void r16make(T16* C,T0* a1);
/*TEMPLATE*/
void r16print(T0* a1);
/*TEMPLATE*/
T6 r16start(T16* C);
extern T0*oBC15std_output;
/*TEMPLATE*/
void r16replace(T16* C,T0* a1,T0* a2);
/*LX_SYMBOL_CLASS*/
T2 r409new_capacity(T2 a1);
/*LX_SYMBOL_CLASS*/
T6 r409extendible(T409* C,T2 a1);
/*LX_SYMBOL_CLASS*/
T2 r409last(T409* C);
/*LX_SYMBOL_CLASS*/
void r409put(T409* C,T2 a1);
/*LX_SYMBOL_CLASS*/
void r409sort(T409* C);
/*LX_SYMBOL_CLASS*/
T6 r409arrayed_has(T409* C,T2 a1);
/*LX_SYMBOL_CLASS*/
void r409make(T409* C,T2 a1);
/*LX_SYMBOL_CLASS*/
void r409convert_to_equivalence(T409* C,T0* a1);
extern T0*oBC409sorter;
extern int fBC409sorter;
/*LX_SYMBOL_CLASS*/
T0* r409sorter(void);
/*LX_SYMBOL_CLASS*/
T6 r409has(T409* C,T2 a1);
/*LX_SYMBOL_CLASS*/
void r409resize(T409* C,T2 a1);
/*LX_SYMBOL_CLASS*/
void r409force_last(T409* C,T2 a1);
/*LX_SYMBOL_CLASS*/
T0* r409new_cursor(T409* C);
/*RX_CHARACTER_SET*/
void r102wipe_out(T102* C);
extern T0*oBC81fixed_boolean_array_;
/*RX_CHARACTER_SET*/
void r102make(T102* C,T0* a1);
/*RX_CHARACTER_SET*/
T6 r102has(T102* C,T2 a1);
/*RX_CHARACTER_SET*/
void r102add_set(T102* C,T0* a1);
/*RX_CHARACTER_SET*/
void r102add_string(T102* C,T0* a1);
/*RX_CHARACTER_SET*/
void r102add_negated_set(T102* C,T0* a1);
/*RX_CHARACTER_SET*/
void r102add_character(T102* C,T2 a1);
extern T0*oBC614name;
/*KL_STRING_INPUT_STREAM*/
T2 r614read_to_string(T614* C,T0* a1,T2 a2,T2 a3);
/*KL_STRING_INPUT_STREAM*/
void r614read_character(T614* C);
/*KL_STRING_INPUT_STREAM*/
void r614make(T614* C,T0* a1);
/*KL_STRING_INPUT_STREAM*/
T2 r614read_to_buffer(T614* C,T0* a1,T2 a2,T2 a3);
/*KL_STRING_INPUT_STREAM*/
void r614read_string(T614* C,T2 a1);
/*LX_MISSING_BRACKET_ERROR*/
T0* r444arguments(void);
/*LX_MISSING_BRACKET_ERROR*/
void r444make(T444* C,T0* a1,T2 a2);
/*LX_MISSING_BRACKET_ERROR*/
T0* r444message(T444* C,T0* a1);
/*XM_EXPAT_PARSER*/
void r151on_end_tag_procedure(T151* C,T8 a1);
/*l735c4/xm_expat_api.e*/#ifdef __cplusplus
}
#endif
#include <expat.h>
#ifdef __cplusplus
extern "C" {
#endif
/*l735c4/xm_expat_api.e*//*XM_EXPAT_PARSER*/
void r151on_start_tag_finish(T151* C);
/*XM_EXPAT_PARSER*/
void r151create_default_parser(T151* C);
/*XM_EXPAT_PARSER*/
void r151register_default_callbacks(T151* C);
/*XM_EXPAT_PARSER*/
void r151on_finish(T151* C);
/*XM_EXPAT_PARSER*/
T0* r151new_uc_string_from_c_utf8_runlength_string(T8 a1,T2 a2);
/*XM_EXPAT_PARSER*/
T0* r151new_string_from_c_zero_terminated_string(T8 a1);
/*XM_EXPAT_PARSER*/
void r151on_content(T151* C,T0* a1);
/*XM_EXPAT_PARSER*/
T0* r151new_uc_string_from_c_utf8_zero_terminated_string_safe(T8 a1);
/*XM_EXPAT_PARSER*/
T0* r151clone(T0* a1);
/*XM_EXPAT_PARSER*/
void r151on_start(T151* C);
/*XM_EXPAT_PARSER*/
T0* r151new_unicode_string_from_utf8(T0* a1);
/*XM_EXPAT_PARSER*/
void r151on_processing_instruction(T151* C,T0* a1,T0* a2);
/*XM_EXPAT_PARSER*/
void r151finish_incremental(T151* C);
/*XM_EXPAT_PARSER*/
void r151parse_incremental_from_stream(T151* C,T0* a1);
/*XM_EXPAT_PARSER*/
void r151on_start_tag_procedure(T151* C,T8 a1,T8 a2);
/*XM_EXPAT_PARSER*/
void r151on_processing_instruction_procedure(T151* C,T8 a1,T8 a2);
/*XM_EXPAT_PARSER*/
T0* r151position(T151* C);
/*XM_EXPAT_PARSER*/
T2 r151last_line_number(T151* C);
/*XM_EXPAT_PARSER*/
void r151on_start_tag(T151* C,T0* a1,T0* a2,T0* a3);
/*XM_EXPAT_PARSER*/
T0* r151new_string_from_c_runlength_string(T8 a1,T2 a2);
/*XM_EXPAT_PARSER*/
void r151make(T151* C);
/*XM_EXPAT_PARSER*/
void r151on_comment(T151* C,T0* a1);
/*XM_EXPAT_PARSER*/
T8 r151default_pointer(void);
/*XM_EXPAT_PARSER*/
void r151parse_from_stream(T151* C,T0* a1);
/*XM_EXPAT_PARSER*/
void r151parse_string_and_set_error(T151* C,T0* a1,T6 a2);
/*XM_EXPAT_PARSER*/
void r151on_end_tag(T151* C,T0* a1,T0* a2,T0* a3);
/*XM_EXPAT_PARSER*/
T2 r151last_column_number(T151* C);
extern T0*oBC152exceptions;
/*XM_EXPAT_PARSER*/
void r151set_error_from_parse_result(T151* C,T2 a1);
/*XM_EXPAT_PARSER*/
void r151on_attribute(T151* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*XM_EXPAT_PARSER*/
T6 r151is_parser_created(T151* C);
/*XM_EXPAT_PARSER*/
T2 r151exml_xml_parse_string(T8 a1,T0* a2,T6 a3);
/*XM_EXPAT_PARSER*/
T2 r151last_byte_index(T151* C);
/*XM_EXPAT_PARSER*/
T0* r151new_unicode_string_empty(void);
/*XM_EXPAT_PARSER*/
void r151free_parser(T151* C);
/*XM_EXPAT_PARSER*/
T0* r151new_attribute_list_from_c(T8 a1);
/*XM_EXPAT_PARSER*/
void r151set_callback_object(T8 a1,T0* a2);
/*XM_EXPAT_PARSER*/
T0* r151new_uc_string_from_c_utf8_zero_terminated_string(T8 a1);
/*XM_EXPAT_PARSER*/
void r151create_new_parser(T151* C);
/*XM_EXPAT_PARSER*/
void r151on_xml_declaration(T151* C,T0* a1,T0* a2,T6 a3);
extern int fBC155init_api;
/*XM_EXPAT_PARSER*/
void r151init_api(void);
/*XM_COMMENT*/
void r780make_last_in_document(T780* C,T0* a1,T0* a2);
/*XM_COMMENT*/
void r780process(T780* C,T0* a1);
/*XM_COMMENT*/
void r780make_last(T780* C,T0* a1,T0* a2);
/*LX_NFA*/
void r360copy(T360* C,T0* a1);
/*LX_NFA*/
void r360build_closure(T360* C);
/*LX_NFA*/
void r360build_unbounded_iteration(T360* C,T2 a1);
/*LX_NFA*/
T0* r360clone(T0* a1);
/*LX_NFA*/
void r360build_bounded_iteration(T360* C,T2 a1,T2 a2);
/*LX_NFA*/
void r360make_symbol(T360* C,T2 a1,T6 a2);
/*LX_NFA*/
void r360build_optional(T360* C);
/*LX_NFA*/
void r360build_positive_closure(T360* C);
/*LX_NFA*/
T0* r360twin(T360* C);
/*LX_NFA*/
void r360build_concatenation(T360* C,T0* a1);
/*LX_NFA*/
void r360make_epsilon(T360* C,T6 a1);
/*LX_NFA*/
void r360build_iteration(T360* C,T2 a1);
/*LX_NFA*/
void r360make_symbol_class(T360* C,T0* a1,T6 a2);
/*LX_NFA*/
void r360build_union(T360* C,T0* a1);
/*LX_DESCRIPTION*/
void r266make(T266* C);
/*LX_DESCRIPTION*/
void r266create_equiv_classes(T266* C);
/*XM_EIFFEL_PARSER_NAME*/
void r596make_no_namespaces(T596* C);
/*XM_EIFFEL_PARSER_NAME*/
void r596make_namespaces(T596* C);
/*XM_EIFFEL_PARSER_NAME*/
T0* r596last(T596* C);
/*XM_EIFFEL_PARSER_NAME*/
T6 r596is_equal(T596* C,T0* a1);
/*XM_EIFFEL_PARSER_NAME*/
T0* r596item(T596* C,T2 a1);
extern T0*oBC147string_equality_tester;
/*XM_EIFFEL_PARSER_NAME*/
T0* r596clone(T0* a1);
/*XM_EIFFEL_PARSER_NAME*/
T2 r596hash_code(T596* C);
/*XM_EIFFEL_PARSER_NAME*/
T6 r596can_force_last(T596* C,T0* a1);
/*XM_EIFFEL_PARSER_NAME*/
T6 r596same_string(T0* a1,T0* a2);
/*XM_EIFFEL_PARSER_NAME*/
void r596force_last(T596* C,T0* a1);
/*XM_EIFFEL_PARSER_NAME*/
T0* r596ns_prefix(T596* C);
/*XM_EIFFEL_PARSER_NAME*/
T0* r596local_part(T596* C);
/*XM_EIFFEL_PARSER_NAME*/
T6 r596is_namespace_name(T596* C);
/*XM_EIFFEL_PARSER_NAME*/
T0* r596new_string_bilinked_list(void);
/*XM_CHARACTER_DATA*/
void r732process(T732* C,T0* a1);
/*XM_CHARACTER_DATA*/
void r732make_last(T732* C,T0* a1,T0* a2);
/*LX_TRAILING_CONTEXT_USED_TWICE_ERROR*/
T0* r480arguments(void);
/*LX_TRAILING_CONTEXT_USED_TWICE_ERROR*/
void r480make(T480* C,T0* a1,T2 a2);
/*LX_TRAILING_CONTEXT_USED_TWICE_ERROR*/
T0* r480message(T480* C,T0* a1);
/*PRINT_VISITOR*/
void r252sub_visit(T252* C,T0* a1);
/*PRINT_VISITOR*/
T0* r252visit_cmts(T252* C,T0* a1);
/*PRINT_VISITOR*/
void r252visit(T252* C);
/*PRINT_VISITOR*/
void r252make_all(T252* C,T0* a1,T0* a2,T0* a3);
/*PRINT_VISITOR*/
void r252make(T252* C,T0* a1,T0* a2,T0* a3);
/*PRINT_VISITOR*/
T0* r252visit_strs(T0* a1);
/*PRINT_VISITOR*/
T0* r252get_result(T252* C);
/*PRINT_VISITOR*/
T0* r252visit_cmt(T252* C,T0* a1);
/*PRINT_VISITOR*/
T0* r252visit_str(T0* a1);
/*PARSER*/
void r545yy_refill_input_buffer(T545* C);
/*PARSER*/
void r545yy_push_last_value(T545* C,T2 a1);
/*PARSER*/
void r545yy_build_tables(T545* C);
extern T0*oBC546yy_meta_template;
extern int fBC546yy_meta_template;
/*PARSER*/
T0* r545yy_meta_template(void);
/*PARSER*/
void r545yy_create_value_stacks(T545* C);
extern T0*oBC545yycheck_template;
extern int fBC545yycheck_template;
/*PARSER*/
T0* r545yycheck_template(void);
/*PARSER*/
void r545yy_pop_last_value(T545* C,T2 a1);
extern T0*oBC545yytypes1_template;
extern int fBC545yytypes1_template;
/*PARSER*/
T0* r545yytypes1_template(void);
extern T0*oBC546yy_accept_template;
extern int fBC546yy_accept_template;
/*PARSER*/
T0* r545yy_accept_template(void);
/*PARSER*/
void r545read_token(T545* C);
/*PARSER*/
void r545yy_execute_eof_action(T545* C,T2 a1);
extern T0*oBC546yy_base_template;
extern int fBC546yy_base_template;
/*PARSER*/
T0* r545yy_base_template(void);
/*PARSER*/
void r545yy_build_parser_tables(T545* C);
extern T0*oBC545yytable_template;
extern int fBC545yytable_template;
/*PARSER*/
T0* r545yytable_template(void);
/*PARSER*/
void r545set_input_buffer(T545* C,T0* a1);
/*PARSER*/
T0* r545empty_buffer(void);
extern T0*oBC545yytypes2_template;
extern int fBC545yytypes2_template;
/*PARSER*/
T0* r545yytypes2_template(void);
/*PARSER*/
T0* r545yyfixed_array(T0* a1);
/*PARSER*/
T2 r545yy_null_trans_state(T545* C,T2 a1);
extern T0*oBC545yypgoto_template;
extern int fBC545yypgoto_template;
/*PARSER*/
T0* r545yypgoto_template(void);
/*PARSER*/
void r545yy_set_content(T545* C,T0* a1);
extern T0*oBC546yy_nxt_template;
extern int fBC546yy_nxt_template;
/*PARSER*/
T0* r545yy_nxt_template(void);
/*PARSER*/
void r545make(T545* C);
extern T0*oBC546yy_chk_template;
extern int fBC546yy_chk_template;
/*PARSER*/
T0* r545yy_chk_template(void);
/*PARSER*/
void r545yy_push_error_value(T545* C);
/*PARSER*/
void r545fatal_error(T0* a1);
extern T0*oBC545yypact_template;
extern int fBC545yypact_template;
/*PARSER*/
T0* r545yypact_template(void);
/*PARSER*/
void r545make_parser_skeleton(T545* C);
extern T0*oBC545yydefact_template;
extern int fBC545yydefact_template;
/*PARSER*/
T0* r545yydefact_template(void);
extern T0*oBC546yy_def_template;
extern int fBC546yy_def_template;
/*PARSER*/
T0* r545yy_def_template(void);
/*PARSER*/
void r545yy_clear_all(T545* C);
/*PARSER*/
T0* r545yytype2(T0* a1);
extern T0*oBC546yy_ec_template;
extern int fBC546yy_ec_template;
/*PARSER*/
T0* r545yy_ec_template(void);
/*PARSER*/
T6 r545yytype4(T0* a1);
/*PARSER*/
void r545make_with_buffer(T545* C,T0* a1);
/*PARSER*/
void r545yy_execute_action(T545* C,T2 a1);
/*PARSER*/
void r545execute(T545* C,T0* a1);
/*PARSER*/
void r545reset(T545* C);
/*PARSER*/
void r545yy_do_error_action(T545* C,T2 a1);
/*PARSER*/
void r545yy_initialize(T545* C);
extern T0*oBC545yyr1_template;
extern int fBC545yyr1_template;
/*PARSER*/
T0* r545yyr1_template(void);
/*PARSER*/
void r545parse(T545* C);
/*PARSER*/
void r545yy_do_action(T545* C,T2 a1);
/*PARSER*/
void r545yy_load_input_buffer(T545* C);
extern T0*oBC545yytranslate_template;
extern int fBC545yytranslate_template;
/*PARSER*/
T0* r545yytranslate_template(void);
/*PARSER*/
T0* r545yy_fixed_array(T0* a1);
/*PARSER*/
T0* r545text(T545* C);
/*PARSER*/
T2 r545text_count(T545* C);
/*PARSER*/
T2 r545yy_previous_state(T545* C);
/*PARSER*/
void r545report_error(T545* C,T0* a1);
/*PARSER*/
void r545make_scanner(T545* C);
extern T0*oBC545yydefgoto_template;
extern int fBC545yydefgoto_template;
/*PARSER*/
T0* r545yydefgoto_template(void);
/*PARSER*/
T0* r545new_file_buffer(T0* a1);
/*PARSER*/
void r545reset_compressed_scanner_skeleton(T545* C);
/*XM_NAMESPACE_RESOLVER*/
void r146on_start_tag_finish(T146* C);
/*XM_NAMESPACE_RESOLVER*/
void r146on_delayed_attributes(T146* C);
/*XM_NAMESPACE_RESOLVER*/
void r146_133Pon_end_tag(T146* C,T0* a1,T0* a2,T0* a3);
/*XM_NAMESPACE_RESOLVER*/
void r146on_finish(T146* C);
/*XM_NAMESPACE_RESOLVER*/
void r146on_content(T146* C,T0* a1);
/*XM_NAMESPACE_RESOLVER*/
void r146make_null(T146* C);
/*XM_NAMESPACE_RESOLVER*/
void r146on_start(T146* C);
/*XM_NAMESPACE_RESOLVER*/
T6 r146is_xmlns(T0* a1);
/*XM_NAMESPACE_RESOLVER*/
void r146on_processing_instruction(T146* C,T0* a1,T0* a2);
/*XM_NAMESPACE_RESOLVER*/
T0* r146new_string_queue(void);
/*XM_NAMESPACE_RESOLVER*/
void r146on_start_tag(T146* C,T0* a1,T0* a2,T0* a3);
/*XM_NAMESPACE_RESOLVER*/
T6 r146has_prefix(T0* a1);
/*XM_NAMESPACE_RESOLVER*/
void r146on_comment(T146* C,T0* a1);
/*XM_NAMESPACE_RESOLVER*/
void r146on_end_tag(T146* C,T0* a1,T0* a2,T0* a3);
extern T0*oBC148xmlns;
/*XM_NAMESPACE_RESOLVER*/
void r146attributes_make(T146* C);
/*XM_NAMESPACE_RESOLVER*/
void r146on_attribute(T146* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*XM_NAMESPACE_RESOLVER*/
void r146_133Pon_start_tag_finish(T146* C);
/*XM_NAMESPACE_RESOLVER*/
void r146on_error(T146* C,T0* a1);
/*XM_NAMESPACE_RESOLVER*/
T6 r146same_string(T0* a1,T0* a2);
/*XM_NAMESPACE_RESOLVER*/
void r146attributes_remove(T146* C);
/*XM_NAMESPACE_RESOLVER*/
void r146attributes_force(T146* C,T0* a1,T0* a2,T0* a3);
/*XM_NAMESPACE_RESOLVER*/
void r146on_xml_declaration(T146* C,T0* a1,T0* a2,T6 a3);
/*XM_EIFFEL_CHARACTER_ENTITY*/
void r251from_hexadecimal(T251* C,T0* a1);
extern T0*oBC68utf8;
/*XM_EIFFEL_CHARACTER_ENTITY*/
T0* r251to_utf8(T251* C);
/*XM_EIFFEL_CHARACTER_ENTITY*/
T6 r251is_valid(T251* C);
/*XM_EIFFEL_CHARACTER_ENTITY*/
void r251from_decimal(T251* C,T0* a1);
extern T0*oBC63unicode;
/*XM_NAMESPACE_RESOLVER_CONTEXT*/
T0* r717new_string_string_table(void);
/*XM_NAMESPACE_RESOLVER_CONTEXT*/
T6 r717shallow_has(T717* C,T0* a1);
/*XM_NAMESPACE_RESOLVER_CONTEXT*/
void r717make(T717* C);
/*XM_NAMESPACE_RESOLVER_CONTEXT*/
T0* r717resolve(T717* C,T0* a1);
extern T0*oBC717default_pseudo_prefix;
extern int fBC717default_pseudo_prefix;
/*XM_NAMESPACE_RESOLVER_CONTEXT*/
T0* r717default_pseudo_prefix(void);
/*XM_NAMESPACE_RESOLVER_CONTEXT*/
T6 r717has(T717* C,T0* a1);
/*XM_NAMESPACE_RESOLVER_CONTEXT*/
T0* r717resolve_default(T717* C);
extern T0*oBC717default_namespace;
extern int fBC717default_namespace;
/*XM_NAMESPACE_RESOLVER_CONTEXT*/
T0* r717default_namespace(void);
/*XM_NAMESPACE_RESOLVER_CONTEXT*/
void r717pop(T717* C);
/*LX_FULL_AND_VARIABLE_TRAILING_CONTEXT_ERROR*/
T0* r449arguments(void);
/*LX_FULL_AND_VARIABLE_TRAILING_CONTEXT_ERROR*/
void r449make(T449* C);
/*LX_FULL_AND_VARIABLE_TRAILING_CONTEXT_ERROR*/
T0* r449message(T449* C,T0* a1);
/*LX_START_CONDITION*/
void r362make(T362* C,T0* a1,T2 a2,T6 a3);
/*TEXT_FILE_READ*/
void r31disconnect(T31* C);
/*TEXT_FILE_READ*/
void r31fill_buffer(T31* C);
/*TEXT_FILE_READ*/
void r31read_line_in(T31* C,T0* a1);
/*TEXT_FILE_READ*/
void r31connect_to(T31* C,T0* a1);
/*TEXT_FILE_READ*/
void r31read_line(T31* C);
extern T0*oBC32last_string;
/*BIBTEX_VISITOR*/
void r532sub_visit(T532* C,T0* a1);
/*BIBTEX_VISITOR*/
void r532visit(T532* C);
/*BIBTEX_VISITOR*/
void r532make(T532* C,T0* a1,T6 a2,T0* a3,T2 a4,T0* a5);
/*BIBTEX_VISITOR*/
T0* r532visit_strs(T0* a1);
/*BIBTEX_VISITOR*/
T0* r532visit_str(T0* a1);
/*LX_RULE*/
void r274make_default(T274* C,T2 a1);
extern T0*oBC274dummy_pattern;
extern int fBC274dummy_pattern;
/*LX_RULE*/
T0* r274dummy_pattern(void);
extern T0*oBC274dummy_action;
extern int fBC274dummy_action;
/*LX_RULE*/
T0* r274dummy_action(void);
/*LX_RULE*/
T6 r274_ix_60(T274* C,T0* a1);
/*PARAMS*/
void r21process_arguments(T21* C);
/*PARAMS*/
void r21display_help(T21* C);
extern T0*oBC15command_arguments;
extern int fBC15command_arguments;
/*PARAMS*/
T0* r21command_arguments(void);
/*PARAMS*/
void r21display_version(T21* C);
/*PARAMS*/
void r21use_conffile(T21* C,T0* a1);
/*PARAMS*/
void r21pre_process_arguments(T21* C);
/*PARAMS*/
void r21make(T21* C);
/*PARAMS*/
void r21reinit(T21* C);
/*DOCUMENT*/
void r110make(T110* C);
/*YY_BUFFER*/
void r243set_position(T243* C,T2 a1,T2 a2,T2 a3);
/*YY_BUFFER*/
void r243make(T243* C,T0* a1);
/*YY_BUFFER*/
void r243make_from_buffer(T243* C,T0* a1);
/*YY_BUFFER*/
T0* r243new_default_buffer(T2 a1);
/*LX_BAD_ITERATION_VALUES_ERROR*/
T0* r481arguments(void);
/*LX_BAD_ITERATION_VALUES_ERROR*/
void r481make(T481* C,T0* a1,T2 a2);
/*LX_BAD_ITERATION_VALUES_ERROR*/
T0* r481message(T481* C,T0* a1);
/*RX_CASE_MAPPING*/
void r109make_default(T109* C);
/*RX_CASE_MAPPING*/
void r109make(T109* C,T0* a1,T0* a2);
/*RX_CASE_MAPPING*/
void r109add(T109* C,T0* a1,T0* a2);
/*RX_CASE_MAPPING*/
void r109clear(T109* C);
/*RX_CASE_MAPPING*/
T2 r109to_lower(T109* C,T2 a1);
/*RX_CASE_MAPPING*/
T2 r109flip_case(T109* C,T2 a1);
/*LX_CHARACTER_OUT_OF_RANGE_ERROR*/
T0* r442arguments(void);
/*LX_CHARACTER_OUT_OF_RANGE_ERROR*/
void r442make(T442* C,T0* a1,T2 a2,T0* a3);
/*LX_CHARACTER_OUT_OF_RANGE_ERROR*/
T0* r442message(T442* C,T0* a1);
/*XM_DTD_ATTRIBUTE_CONTENT*/
void r572set_enumeration_list(T572* C,T0* a1);
/*XM_DTD_ATTRIBUTE_CONTENT*/
T6 r572is_value_required(T572* C);
/*XM_DTD_ATTRIBUTE_CONTENT*/
void r572set_enumeration(T572* C);
/*XM_DTD_ATTRIBUTE_CONTENT*/
void r572set_default_value(T572* C,T0* a1);
extern T0*oBC572default_enumeration_list;
extern int fBC572default_enumeration_list;
/*XM_DTD_ATTRIBUTE_CONTENT*/
T0* r572default_enumeration_list(void);
/*XM_DTD_ATTRIBUTE_CONTENT*/
void r572make(T572* C);
/*XM_DTD_ATTRIBUTE_CONTENT*/
void r572copy_default(T572* C,T0* a1);
/*XM_DTD_ATTRIBUTE_CONTENT*/
void r572set_value_fixed(T572* C,T0* a1);
/*XM_EIFFEL_PARSER*/
void r163yy_do_action(T163* C,T2 a1);
extern T0*oBC163yytable_template;
extern int fBC163yytable_template;
/*XM_EIFFEL_PARSER*/
T0* r163yytable_template(void);
/*XM_EIFFEL_PARSER*/
void r163on_end_tag(T163* C,T0* a1,T0* a2,T0* a3);
/*XM_EIFFEL_PARSER*/
void r163check_void(T163* C);
/*XM_EIFFEL_PARSER*/
T0* r163defined_entity_referenced(T163* C,T0* a1);
/*XM_EIFFEL_PARSER*/
T2 r163line(T163* C);
/*XM_EIFFEL_PARSER*/
T0* r163new_entities_table(void);
/*XM_EIFFEL_PARSER*/
void r163on_attribute(T163* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*XM_EIFFEL_PARSER*/
void r163on_start_tag_finish(T163* C);
/*XM_EIFFEL_PARSER*/
void r163when_external_dtd(T163* C,T0* a1);
/*XM_EIFFEL_PARSER*/
void r163yy_do_error_action(T163* C,T2 a1);
/*XM_EIFFEL_PARSER*/
void r163parse(T163* C);
/*XM_EIFFEL_PARSER*/
T0* r163new_dtd_external_id(void);
/*XM_EIFFEL_PARSER*/
T2 r163byte_position(T163* C);
/*XM_EIFFEL_PARSER*/
void r163when_entity_declared(T163* C,T0* a1,T0* a2);
/*XM_EIFFEL_PARSER*/
void r163on_error(T163* C,T0* a1);
/*XM_EIFFEL_PARSER*/
T0* r163new_literal_entity(T0* a1);
extern T0*oBC163yytranslate_template;
extern int fBC163yytranslate_template;
/*XM_EIFFEL_PARSER*/
T0* r163yytranslate_template(void);
/*XM_EIFFEL_PARSER*/
void r163process_pe_entity(T163* C,T0* a1);
/*XM_EIFFEL_PARSER*/
T0* r163new_unicode_string_from_utf8(T0* a1);
/*XM_EIFFEL_PARSER*/
void r163yy_push_last_value(T163* C,T2 a1);
/*XM_EIFFEL_PARSER*/
T0* r163new_name_set(void);
/*XM_EIFFEL_PARSER*/
void r163yy_push_error_value(T163* C);
/*XM_EIFFEL_PARSER*/
void r163on_start(T163* C);
extern T0*oBC163yyr1_template;
extern int fBC163yyr1_template;
/*XM_EIFFEL_PARSER*/
T0* r163yyr1_template(void);
/*XM_EIFFEL_PARSER*/
T0* r163new_external_entity(T163* C,T0* a1);
extern T0*oBC163yytypes1_template;
extern int fBC163yytypes1_template;
/*XM_EIFFEL_PARSER*/
T0* r163yytypes1_template(void);
/*XM_EIFFEL_PARSER*/
T0* r163onstring_ascii(T163* C,T0* a1);
/*XM_EIFFEL_PARSER*/
T0* r163position(T163* C);
/*XM_EIFFEL_PARSER*/
void r163on_finish(T163* C);
/*XM_EIFFEL_PARSER*/
T0* r163new_dtd_attribute_content(void);
/*XM_EIFFEL_PARSER*/
void r163read_token(T163* C);
/*XM_EIFFEL_PARSER*/
void r163on_attribute_declarations(T163* C,T0* a1,T0* a2);
/*XM_EIFFEL_PARSER*/
void r163yy_init_value_stacks(T163* C);
extern T0*oBC163yypgoto_template;
extern int fBC163yypgoto_template;
/*XM_EIFFEL_PARSER*/
T0* r163yypgoto_template(void);
/*XM_EIFFEL_PARSER*/
void r163process_entity_scanner(T163* C,T0* a1);
extern T0*oBC163yytypes2_template;
extern int fBC163yytypes2_template;
/*XM_EIFFEL_PARSER*/
T0* r163yytypes2_template(void);
/*XM_EIFFEL_PARSER*/
void r163namespace_force_last(T163* C,T0* a1,T0* a2);
/*XM_EIFFEL_PARSER*/
void r163when_pe_entity_declared(T163* C,T0* a1,T0* a2);
extern T0*oBC66integer_;
/*XM_EIFFEL_PARSER*/
T0* r163shared_empty_string(T163* C);
/*XM_EIFFEL_PARSER*/
T2 r163column(T163* C);
/*XM_EIFFEL_PARSER*/
void r163set_element_repetition(T0* a1,T0* a2);
/*XM_EIFFEL_PARSER*/
void r163make_scanner(T163* C);
/*XM_EIFFEL_PARSER*/
T0* r163new_namespace_name(T163* C);
/*XM_EIFFEL_PARSER*/
void r163reset(T163* C);
/*XM_EIFFEL_PARSER*/
T0* r163new_string_bilinked_list(void);
/*XM_EIFFEL_PARSER*/
T0* r163source(T163* C);
extern T0*oBC164null_resolver;
/*XM_EIFFEL_PARSER*/
void r163yy_clear_value_stacks(T163* C);
/*XM_EIFFEL_PARSER*/
void r163parse_from_stream(T163* C,T0* a1);
/*XM_EIFFEL_PARSER*/
void r163yy_build_parser_tables(T163* C);
/*XM_EIFFEL_PARSER*/
void r163force_error(T163* C,T0* a1);
/*XM_EIFFEL_PARSER*/
void r163on_start_tag(T163* C,T0* a1,T0* a2,T0* a3);
/*XM_EIFFEL_PARSER*/
T0* r163element_name(T0* a1);
/*XM_EIFFEL_PARSER*/
void r163on_processing_instruction(T163* C,T0* a1,T0* a2);
/*XM_EIFFEL_PARSER*/
void r163apply_encoding(T163* C,T0* a1);
/*XM_EIFFEL_PARSER*/
T0* r163external_entity_to_string(T163* C,T0* a1);
/*XM_EIFFEL_PARSER*/
T0* r163entity_referenced_in_entity_value(T163* C,T0* a1);
/*XM_EIFFEL_PARSER*/
void r163on_content(T163* C,T0* a1);
/*XM_EIFFEL_PARSER*/
void r163make_parser(T163* C);
extern T0*oBC163yydefact_template;
extern int fBC163yydefact_template;
/*XM_EIFFEL_PARSER*/
T0* r163yydefact_template(void);
extern T0*oBC164shared_empty_string_uc;
extern int fBC164shared_empty_string_uc;
/*XM_EIFFEL_PARSER*/
T0* r163shared_empty_string_uc(void);
/*XM_EIFFEL_PARSER*/
void r163_133Pon_error(T163* C,T0* a1);
extern T0*oBC163yycheck_template;
extern int fBC163yycheck_template;
/*XM_EIFFEL_PARSER*/
T0* r163yycheck_template(void);
/*XM_EIFFEL_PARSER*/
T0* r163new_dtd_attribute_content_list(void);
/*XM_EIFFEL_PARSER*/
void r163make(T163* C);
/*XM_EIFFEL_PARSER*/
void r163on_xml_declaration(T163* C,T0* a1,T0* a2,T6 a3);
/*XM_EIFFEL_PARSER*/
T0* r163yyfixed_array(T0* a1);
extern T0*oBC163yydefgoto_template;
extern int fBC163yydefgoto_template;
/*XM_EIFFEL_PARSER*/
T0* r163yydefgoto_template(void);
/*XM_EIFFEL_PARSER*/
void r163yy_pop_last_value(T163* C,T2 a1);
/*XM_EIFFEL_PARSER*/
void r163process_entity(T163* C,T0* a1);
extern T0*oBC163yypact_template;
extern int fBC163yypact_template;
/*XM_EIFFEL_PARSER*/
T0* r163yypact_template(void);
/*XM_EIFFEL_PARSER*/
void r163on_comment(T163* C,T0* a1);
/*XM_EIFFEL_PARSER*/
void r163process_attribute_entity(T163* C,T0* a1);
extern T0*oBC164shared_empty_string_string;
extern int fBC164shared_empty_string_string;
/*XM_EIFFEL_PARSER*/
T0* r163shared_empty_string_string(void);
/*XM_EIFFEL_PARSER*/
T0* r163onstring_utf8(T163* C,T0* a1);
/*READ_XML*/
T6 r44file_exist(T44* C);
/*READ_XML*/
void r44print(T0* a1);
/*READ_XML*/
T6 r44parse(T44* C);
extern T0*oBC44fact;
/*XM_DOCUMENT*/
void r534set_last_cell(T534* C,T0* a1);
/*XM_DOCUMENT*/
void r534wipe_out(T534* C);
/*XM_DOCUMENT*/
void r534remove_first(T534* C);
extern T0*oBC538default_ns;
extern int fBC538default_ns;
/*XM_DOCUMENT*/
T0* r534default_ns(void);
/*XM_DOCUMENT*/
T0* r534cursor_item(T0* a1);
/*XM_DOCUMENT*/
T6 r534cursor_is_last(T534* C,T0* a1);
/*XM_DOCUMENT*/
void r534remove_traversing_cursor(T534* C,T0* a1);
/*XM_DOCUMENT*/
void r534cursor_go_after(T534* C,T0* a1);
/*XM_DOCUMENT*/
void r534move_all_cursors_after(T534* C);
/*XM_DOCUMENT*/
void r534add_traversing_cursor(T534* C,T0* a1);
/*XM_DOCUMENT*/
void r534_536Pforce_last(T534* C,T0* a1);
/*XM_DOCUMENT*/
void r534remove_previous_root_element(T534* C);
/*XM_DOCUMENT*/
void r534process(T534* C,T0* a1);
/*XM_DOCUMENT*/
void r534before_addition(T534* C,T0* a1);
/*XM_DOCUMENT*/
void r534remove_last(T534* C);
/*XM_DOCUMENT*/
T6 r534cursor_after(T0* a1);
/*XM_DOCUMENT*/
void r534make_with_root_named(T534* C,T0* a1,T0* a2);
/*XM_DOCUMENT*/
void r534make_list(T534* C);
/*XM_DOCUMENT*/
void r534equality_delete(T534* C,T0* a1);
/*XM_DOCUMENT*/
void r534cursor_forth(T534* C,T0* a1);
/*XM_DOCUMENT*/
void r534move_last_cursors_after(T534* C);
/*XM_DOCUMENT*/
void r534cursor_start(T534* C,T0* a1);
/*XM_DOCUMENT*/
void r534force_last(T534* C,T0* a1);
/*XM_DOCUMENT*/
T0* r534new_cursor(T534* C);
/*XM_DOCUMENT*/
T6 r534cursor_is_first(T534* C,T0* a1);
/*XM_DOCUMENT*/
void r534remove_at_cursor(T534* C,T0* a1);
/*XM_DOCUMENT*/
void r534move_all_cursors(T534* C,T0* a1,T0* a2);
/*XM_DOCUMENT*/
T6 r534cursor_off(T0* a1);
/*XM_DOCUMENT*/
void r534set_root_element(T534* C,T0* a1);
/*LX_BAD_CHARACTER_ERROR*/
T0* r447arguments(void);
/*LX_BAD_CHARACTER_ERROR*/
void r447make(T447* C,T0* a1,T2 a2,T0* a3);
/*LX_BAD_CHARACTER_ERROR*/
T0* r447message(T447* C,T0* a1);
/*LX_DFA_STATE*/
T6 r272is_equal(T272* C,T0* a1);
extern T0*oBC272rule_sorter;
extern int fBC272rule_sorter;
/*LX_DFA_STATE*/
T0* r272rule_sorter(void);
/*LX_DFA_STATE*/
T6 r272se_assigned_from(T0* a1);
/*LX_DFA_STATE*/
void r272print_on(T272* C,T0* a1);
extern T0*oBC272bubble_sorter;
extern int fBC272bubble_sorter;
/*LX_DFA_STATE*/
T0* r272bubble_sorter(void);
/*LX_DFA_STATE*/
void r272out_in_tagged_out_memory(T272* C);
/*LX_DFA_STATE*/
T6 r272same_type(T272* C,T0* a1);
/*LX_DFA_STATE*/
void r272make(T272* C,T0* a1,T2 a2,T2 a3);
/*LX_DFA_STATE*/
void r272partition(T272* C,T0* a1);
/*LX_DFA_STATE*/
T6 r272conforms_to(T272* C,T0* a1);
/*LX_DFA_STATE*/
T6 r272is_accepting(T272* C);
/*LX_DFA_STATE*/
T0* r272new_state(T272* C,T2 a1);
/*UC_STRING*/
T0* r65out(T65* C);
/*UC_STRING*/
void r65copy(T65* C,T0* a1);
/*UC_STRING*/
T0* r65substring(T65* C,T2 a1,T2 a2);
/*UC_STRING*/
void r65reset_byte_index_cache(T65* C);
/*UC_STRING*/
T2 r65shifted_byte_index(T65* C,T2 a1,T2 a2);
/*UC_STRING*/
void r65wipe_out(T65* C);
/*UC_STRING*/
T3 r65last(T65* C);
/*UC_STRING*/
T2 r65first_substring_index(T65* C,T0* a1);
/*UC_STRING*/
T6 r65same_unicode_string(T65* C,T0* a1);
/*UC_STRING*/
T2 r65item_code(T65* C,T2 a1);
/*UC_STRING*/
T3 r65character_item_at_byte_index(T65* C,T2 a1);
/*UC_STRING*/
void r65put(T65* C,T3 a1,T2 a2);
/*UC_STRING*/
void r65remove_between(T65* C,T2 a1,T2 a2);
/*UC_STRING*/
T6 r65is_equal(T65* C,T0* a1);
/*UC_STRING*/
T2 r65index_of_code(T65* C,T2 a1,T2 a2);
/*UC_STRING*/
T3 r65item(T65* C,T2 a1);
/*UC_STRING*/
void r65resize_byte_storage(T65* C,T2 a1);
/*UC_STRING*/
void r65append(T65* C,T0* a1);
/*UC_STRING*/
T6 r65se_assigned_from(T0* a1);
/*UC_STRING*/
T2 r65byte_index(T65* C,T2 a1);
/*UC_STRING*/
void r65print_on(T65* C,T0* a1);
/*UC_STRING*/
T0* r65clone(T0* a1);
/*UC_STRING*/
T2 r65index_of(T65* C,T3 a1,T2 a2);
/*UC_STRING*/
void r65out_in_tagged_out_memory(T65* C);
/*UC_STRING*/
void r65remove_substring(T65* C,T2 a1,T2 a2);
/*UC_STRING*/
void r65move_bytes_right(T65* C,T2 a1,T2 a2);
/*UC_STRING*/
void r65set_count(T65* C,T2 a1);
/*UC_STRING*/
T2 r65next_byte_index(T65* C,T2 a1);
/*UC_STRING*/
T6 r65same_type(T65* C,T0* a1);
/*UC_STRING*/
void r65remove_tail(T65* C,T2 a1);
extern T0*oBC65dummy_uc_string;
extern int fBC65dummy_uc_string;
/*UC_STRING*/
T0* r65dummy_uc_string(void);
/*UC_STRING*/
void r65make(T65* C,T2 a1);
/*UC_STRING*/
void r65old_make_filled(T65* C,T3 a1,T2 a2);
/*UC_STRING*/
void r65fill_tagged_out_memory(T65* C);
/*UC_STRING*/
void r65append_string(T65* C,T0* a1);
/*UC_STRING*/
void r65remove(T65* C,T2 a1);
/*UC_STRING*/
void r65append_substring(T65* C,T0* a1,T2 a2,T2 a3);
/*UC_STRING*/
T2 r65item_code_at_byte_index(T65* C,T2 a1);
extern T0*oBC55platform;
/*UC_STRING*/
T0* r65string(T65* C);
/*UC_STRING*/
void r65extend(T65* C,T3 a1);
/*UC_STRING*/
T2 r65hash_code(T65* C);
/*UC_STRING*/
void r65remove_last(T65* C,T2 a1);
/*UC_STRING*/
T0* r65prefixed_string(T65* C,T0* a1);
/*UC_STRING*/
T6 r65conforms_to(T65* C,T0* a1);
/*UC_STRING*/
T6 r65has(T65* C,T3 a1);
/*UC_STRING*/
void r65keep_head(T65* C,T2 a1);
/*UC_STRING*/
T2 r65to_integer(T65* C);
/*UC_STRING*/
T0* r65new_empty_string(T2 a1);
/*UC_STRING*/
void r65append_character(T65* C,T3 a1);
/*UC_STRING*/
void r65make_from_substring(T65* C,T0* a1,T2 a2,T2 a3);
/*UC_STRING*/
void r65put_code_at_byte_index(T65* C,T2 a1,T2 a2,T2 a3);
/*UC_STRING*/
void r65fill_with(T65* C,T3 a1);
/*UC_STRING*/
T6 r65same_as(T65* C,T0* a1);
/*UC_STRING*/
void r65extend_unless(T65* C,T3 a1);
/*UC_STRING*/
void r65put_character_at_byte_index(T65* C,T3 a1,T2 a2,T2 a3);
/*UC_STRING*/
void r65_7Pappend_string(T65* C,T0* a1);
/*UC_STRING*/
void r65add_last(T65* C,T3 a1);
/*UC_STRING*/
T3 r65first(T65* C);
/*UC_STRING*/
void r65resize(T65* C,T2 a1);
/*UC_STRING*/
void r65put_substring_at_byte_index(T65* C,T0* a1,T2 a2,T2 a3,T2 a4,T2 a5);
/*UC_STRING*/
T2 r65substring_index(T65* C,T0* a1,T2 a2);
/*UC_STRING*/
void r65replace_substring(T65* C,T0* a1,T2 a2,T2 a3);
/*UC_STRING*/
void r65from_external_copy(T65* C,T8 a1);
/*UC_STRING*/
T3 r65byte_item(T65* C,T2 a1);
/*UC_STRING*/
void r65move_bytes_left(T65* C,T2 a1,T2 a2);
/*UC_STRING*/
void r65old_make(T65* C,T2 a1);
/*UC_STRING*/
T8 r65to_external(T65* C);
/*UC_STRING*/
void r65old_make_from_string(T65* C,T0* a1);
/*UC_STRING*/
void r65to_lower(T65* C);
/*UC_STRING*/
T0* r65twin(T65* C);
/*UC_STRING*/
T0* r65to_utf8(T65* C);
/*UC_STRING*/
T0* r65_ix_43(T65* C,T0* a1);
/*UC_STRING*/
T2 r65_7Phash_code(T65* C);
/*UC_STRING*/
T2 r65unicode_substring_index(T65* C,T0* a1,T2 a2);
/*UC_STRING*/
void r65swap(T65* C,T2 a1,T2 a2);
/*LX_EQUIVALENCE_CLASSES*/
void r292build(T292* C);
/*LX_EQUIVALENCE_CLASSES*/
void r292put(T292* C,T2 a1);
/*LX_EQUIVALENCE_CLASSES*/
T2 r292upper(T292* C);
/*LX_EQUIVALENCE_CLASSES*/
T2 r292lower(T292* C);
/*LX_EQUIVALENCE_CLASSES*/
T0* r292to_array(T292* C,T2 a1,T2 a2);
/*LX_EQUIVALENCE_CLASSES*/
void r292make(T292* C,T2 a1,T2 a2);
/*LX_EQUIVALENCE_CLASSES*/
T2 r292equivalence_class(T292* C,T2 a1);
/*LX_EQUIVALENCE_CLASSES*/
void r292add(T292* C,T0* a1);
/*LX_EQUIVALENCE_CLASSES*/
T6 r292is_representative(T292* C,T2 a1);
/*LX_EQUIVALENCE_CLASSES*/
void r292initialize(T292* C);
/*XM_PROCESSING_INSTRUCTION*/
void r776make_last_in_document(T776* C,T0* a1,T0* a2,T0* a3);
/*XM_PROCESSING_INSTRUCTION*/
void r776process(T776* C,T0* a1);
/*XM_PROCESSING_INSTRUCTION*/
void r776make_last(T776* C,T0* a1,T0* a2,T0* a3);
/*XM_EIFFEL_DECLARATION*/
void r557process(T557* C,T0* a1);
/*XM_EIFFEL_DECLARATION*/
void r557make(T557* C);
/*KL_STDOUT_FILE*/
void r554make(T554* C);
/*KL_STDOUT_FILE*/
void r554old_put_string(T554* C,T0* a1);
/*KL_STDOUT_FILE*/
void r554old_put_character(T554* C,T3 a1);
/*KL_STDOUT_FILE*/
void r554old_make(T554* C);
/*KL_STDOUT_FILE*/
void r554write_buffer(T554* C);
/*KL_STDOUT_FILE*/
void r554put_string(T554* C,T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
void r173_175Preset(T173* C);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r173normalized_newline(T173* C);
/*XM_EIFFEL_ENTITY_DEF*/
T6 r173is_literal(T173* C);
/*XM_EIFFEL_ENTITY_DEF*/
T2 r173start_condition(T173* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r173_177Pset_input_buffer(T173* C,T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
void r173yy_chk_template_1(T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
void r173yy_chk_template_2(T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
void r173set_input_buffer(T173* C,T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r173text_substring(T173* C,T2 a1,T2 a2);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r173yy_ec_template(void);
/*XM_EIFFEL_ENTITY_DEF*/
void r173yy_execute_action(T173* C,T2 a1);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r173yy_def_template(void);
/*XM_EIFFEL_ENTITY_DEF*/
void r173_174Pread_token(T173* C);
/*XM_EIFFEL_ENTITY_DEF*/
T3 r173text_item(T173* C,T2 a1);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r173system_literal_text(T173* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r173yy_load_input_buffer(T173* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r173apply_input_buffer(T173* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r173make_with_buffer(T173* C,T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
void r173_176P_175Preset(T173* C);
/*XM_EIFFEL_ENTITY_DEF*/
T2 r173yy_null_trans_state(T173* C,T2 a1);
/*XM_EIFFEL_ENTITY_DEF*/
void r173pop_start_condition(T173* C);
/*XM_EIFFEL_ENTITY_DEF*/
T6 r173is_valid_encoding(T173* C,T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r173yy_accept_template(void);
/*XM_EIFFEL_ENTITY_DEF*/
void r173read_token(T173* C);
/*XM_EIFFEL_ENTITY_DEF*/
T2 r173yy_previous_state(T173* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r173yy_refill_input_buffer(T173* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r173push_start_condition_dtd_ignore(T173* C);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r173yy_fixed_array(T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r173yy_meta_template(void);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r173yy_base_template(void);
/*XM_EIFFEL_ENTITY_DEF*/
void r173set_input_stream(T173* C,T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
T2 r173text_count(T173* C);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r173new_file_buffer(T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
void r173make_scanner(T173* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r173yy_initialize(T173* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r173reset(T173* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r173push_start_condition(T173* C,T2 a1);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r173text(T173* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r173close_input(T173* C);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r173yy_nxt_template(void);
/*XM_EIFFEL_ENTITY_DEF*/
void r173yy_set_line_column(T173* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r173make_literal(T173* C,T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r173empty_buffer(void);
/*XM_EIFFEL_ENTITY_DEF*/
void r173yy_nxt_template_1(T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
void r173yy_nxt_template_2(T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
T0* r173yy_chk_template(void);
/*XM_EIFFEL_ENTITY_DEF*/
void r173yy_set_content(T173* C,T0* a1);
/*XM_EIFFEL_ENTITY_DEF*/
void r173set_start_condition(T173* C,T2 a1);
/*XM_EIFFEL_ENTITY_DEF*/
void r173yy_execute_eof_action(T173* C,T2 a1);
/*XM_EIFFEL_ENTITY_DEF*/
void r173yy_build_tables(T173* C);
/*XM_EIFFEL_ENTITY_DEF*/
void r173make_external(T173* C,T0* a1,T0* a2);
/*LX_BAD_CHARACTER_CLASS_ERROR*/
T0* r446arguments(void);
/*LX_BAD_CHARACTER_CLASS_ERROR*/
void r446make(T446* C,T0* a1,T2 a2);
/*LX_BAD_CHARACTER_CLASS_ERROR*/
T0* r446message(T446* C,T0* a1);
/*KL_STDERR_FILE*/
void r435old_put_string(T0* a1);
/*KL_STDERR_FILE*/
void r435put_integer(T2 a1);
/*KL_STDERR_FILE*/
void r435put_string(T0* a1);
/*XM_EIFFEL_INPUT_STREAM*/
void r615make_from_stream(T615* C,T0* a1);
/*XM_EIFFEL_INPUT_STREAM*/
T0* r615name(T615* C);
/*XM_EIFFEL_INPUT_STREAM*/
T2 r615read_to_string(T615* C,T0* a1,T2 a2,T2 a3);
/*XM_EIFFEL_INPUT_STREAM*/
T2 r615most_significant(T615* C,T3 a1,T3 a2);
/*XM_EIFFEL_INPUT_STREAM*/
T6 r615is_valid_encoding(T0* a1);
/*XM_EIFFEL_INPUT_STREAM*/
void r615noqueue_read_character(T615* C);
/*XM_EIFFEL_INPUT_STREAM*/
T0* r615clone(T0* a1);
/*XM_EIFFEL_INPUT_STREAM*/
void r615read_character(T615* C);
/*XM_EIFFEL_INPUT_STREAM*/
void r615utf16_detect_read_character(T615* C);
/*XM_EIFFEL_INPUT_STREAM*/
T2 r615least_significant(T615* C,T3 a1,T3 a2);
/*XM_EIFFEL_INPUT_STREAM*/
T2 r615read_to_buffer(T615* C,T0* a1,T2 a2,T2 a3);
/*XM_EIFFEL_INPUT_STREAM*/
T2 r615_56Pread_to_string(T615* C,T0* a1,T2 a2,T2 a3);
/*XM_EIFFEL_INPUT_STREAM*/
T6 r615end_of_input(T615* C);
/*XM_EIFFEL_INPUT_STREAM*/
void r615append_character(T615* C,T2 a1);
/*XM_EIFFEL_INPUT_STREAM*/
void r615latin1_read_character(T615* C);
/*XM_EIFFEL_INPUT_STREAM*/
void r615utf16_read_character(T615* C);
/*XM_EIFFEL_INPUT_STREAM*/
T3 r615last_character(T615* C);
/*XM_EIFFEL_INPUT_STREAM*/
void r615read_string(T615* C,T2 a1);
extern T0*oBC67utf16;
extern T0*oBC615utf8_buffer;
extern int fBC615utf8_buffer;
/*XM_EIFFEL_INPUT_STREAM*/
T0* r615utf8_buffer(void);
/*XM_EIFFEL_INPUT_STREAM*/
void r615set_encoding(T615* C,T0* a1);
/*XM_DEFAULT_POSITION*/
void r788make(T788* C,T0* a1,T2 a2,T2 a3,T2 a4);
/*XM_ATTRIBUTE*/
void r782process(T782* C,T0* a1);
/*XM_ATTRIBUTE*/
void r782make_last(T782* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*UC_UTF8_STRING*/
T0* r428out(T428* C);
/*UC_UTF8_STRING*/
void r428copy(T428* C,T0* a1);
/*UC_UTF8_STRING*/
T0* r428substring(T428* C,T2 a1,T2 a2);
/*UC_UTF8_STRING*/
void r428reset_byte_index_cache(T428* C);
/*UC_UTF8_STRING*/
T2 r428shifted_byte_index(T428* C,T2 a1,T2 a2);
/*UC_UTF8_STRING*/
void r428wipe_out(T428* C);
/*UC_UTF8_STRING*/
T3 r428last(T428* C);
/*UC_UTF8_STRING*/
T2 r428first_substring_index(T428* C,T0* a1);
/*UC_UTF8_STRING*/
T6 r428same_unicode_string(T428* C,T0* a1);
/*UC_UTF8_STRING*/
T2 r428item_code(T428* C,T2 a1);
/*UC_UTF8_STRING*/
T3 r428character_item_at_byte_index(T428* C,T2 a1);
/*UC_UTF8_STRING*/
void r428put(T428* C,T3 a1,T2 a2);
/*UC_UTF8_STRING*/
void r428remove_between(T428* C,T2 a1,T2 a2);
/*UC_UTF8_STRING*/
T6 r428is_equal(T428* C,T0* a1);
/*UC_UTF8_STRING*/
T2 r428index_of_code(T428* C,T2 a1,T2 a2);
/*UC_UTF8_STRING*/
T3 r428item(T428* C,T2 a1);
/*UC_UTF8_STRING*/
void r428resize_byte_storage(T428* C,T2 a1);
/*UC_UTF8_STRING*/
void r428append(T428* C,T0* a1);
/*UC_UTF8_STRING*/
T6 r428se_assigned_from(T0* a1);
/*UC_UTF8_STRING*/
T2 r428byte_index(T428* C,T2 a1);
/*UC_UTF8_STRING*/
void r428print_on(T428* C,T0* a1);
/*UC_UTF8_STRING*/
T0* r428clone(T0* a1);
/*UC_UTF8_STRING*/
T2 r428index_of(T428* C,T3 a1,T2 a2);
/*UC_UTF8_STRING*/
void r428out_in_tagged_out_memory(T428* C);
/*UC_UTF8_STRING*/
void r428remove_substring(T428* C,T2 a1,T2 a2);
/*UC_UTF8_STRING*/
void r428move_bytes_right(T428* C,T2 a1,T2 a2);
/*UC_UTF8_STRING*/
void r428set_count(T428* C,T2 a1);
/*UC_UTF8_STRING*/
T2 r428next_byte_index(T428* C,T2 a1);
/*UC_UTF8_STRING*/
T6 r428same_type(T428* C,T0* a1);
/*UC_UTF8_STRING*/
T0* r428dummy_uc_string(void);
/*UC_UTF8_STRING*/
void r428remove_tail(T428* C,T2 a1);
/*UC_UTF8_STRING*/
void r428make(T428* C,T2 a1);
/*UC_UTF8_STRING*/
void r428old_make_filled(T428* C,T3 a1,T2 a2);
/*UC_UTF8_STRING*/
void r428fill_tagged_out_memory(T428* C);
/*UC_UTF8_STRING*/
void r428append_string(T428* C,T0* a1);
/*UC_UTF8_STRING*/
void r428remove(T428* C,T2 a1);
/*UC_UTF8_STRING*/
void r428append_substring(T428* C,T0* a1,T2 a2,T2 a3);
/*UC_UTF8_STRING*/
T2 r428item_code_at_byte_index(T428* C,T2 a1);
/*UC_UTF8_STRING*/
T0* r428string(T428* C);
/*UC_UTF8_STRING*/
void r428extend(T428* C,T3 a1);
/*UC_UTF8_STRING*/
T2 r428hash_code(T428* C);
/*UC_UTF8_STRING*/
T0* r428prefixed_string(T428* C,T0* a1);
/*UC_UTF8_STRING*/
void r428remove_last(T428* C,T2 a1);
/*UC_UTF8_STRING*/
T6 r428conforms_to(T428* C,T0* a1);
/*UC_UTF8_STRING*/
T6 r428has(T428* C,T3 a1);
/*UC_UTF8_STRING*/
void r428keep_head(T428* C,T2 a1);
/*UC_UTF8_STRING*/
T2 r428to_integer(T428* C);
/*UC_UTF8_STRING*/
T0* r428new_empty_string(T2 a1);
/*UC_UTF8_STRING*/
void r428append_character(T428* C,T3 a1);
/*UC_UTF8_STRING*/
void r428put_code_at_byte_index(T428* C,T2 a1,T2 a2,T2 a3);
/*UC_UTF8_STRING*/
void r428make_from_substring(T428* C,T0* a1,T2 a2,T2 a3);
/*UC_UTF8_STRING*/
void r428fill_with(T428* C,T3 a1);
/*UC_UTF8_STRING*/
T6 r428same_as(T428* C,T0* a1);
/*UC_UTF8_STRING*/
void r428extend_unless(T428* C,T3 a1);
/*UC_UTF8_STRING*/
void r428put_character_at_byte_index(T428* C,T3 a1,T2 a2,T2 a3);
/*UC_UTF8_STRING*/
void r428_7Pappend_string(T428* C,T0* a1);
/*UC_UTF8_STRING*/
void r428add_last(T428* C,T3 a1);
/*UC_UTF8_STRING*/
void r428resize(T428* C,T2 a1);
/*UC_UTF8_STRING*/
void r428put_substring_at_byte_index(T428* C,T0* a1,T2 a2,T2 a3,T2 a4,T2 a5);
/*UC_UTF8_STRING*/
T2 r428substring_index(T428* C,T0* a1,T2 a2);
/*UC_UTF8_STRING*/
void r428append_utf8(T428* C,T0* a1);
/*UC_UTF8_STRING*/
void r428replace_substring(T428* C,T0* a1,T2 a2,T2 a3);
/*UC_UTF8_STRING*/
void r428from_external_copy(T428* C,T8 a1);
/*UC_UTF8_STRING*/
void r428move_bytes_left(T428* C,T2 a1,T2 a2);
/*UC_UTF8_STRING*/
void r428old_make(T428* C,T2 a1);
/*UC_UTF8_STRING*/
T8 r428to_external(T428* C);
/*UC_UTF8_STRING*/
void r428old_make_from_string(T428* C,T0* a1);
/*UC_UTF8_STRING*/
void r428to_lower(T428* C);
/*UC_UTF8_STRING*/
T0* r428twin(T428* C);
/*UC_UTF8_STRING*/
T0* r428to_utf8(T428* C);
/*UC_UTF8_STRING*/
T0* r428_ix_43(T428* C,T0* a1);
/*UC_UTF8_STRING*/
T2 r428unicode_substring_index(T428* C,T0* a1,T2 a2);
/*UC_UTF8_STRING*/
T2 r428_7Phash_code(T428* C);
/*UC_UTF8_STRING*/
void r428make_from_utf8(T428* C,T0* a1);
/*UC_UTF8_STRING*/
void r428swap(T428* C,T2 a1,T2 a2);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r690normalized_newline(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T2 r690start_condition(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690_177Pset_input_buffer(T690* C,T0* a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690set_input_buffer(T690* C,T0* a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r690text_substring(T690* C,T2 a1,T2 a2);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r690yy_ec_template(void);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690yy_execute_action(T690* C,T2 a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r690yy_def_template(void);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T3 r690text_item(T690* C,T2 a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r690system_literal_text(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690yy_load_input_buffer(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690apply_input_buffer(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690make_with_buffer(T690* C,T0* a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T2 r690yy_null_trans_state(T690* C,T2 a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690pop_start_condition(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r690yy_accept_template(void);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690read_token(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690_173Pread_token(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T2 r690yy_previous_state(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690yy_refill_input_buffer(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690_176P_175P_173Preset(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r690yy_fixed_array(T0* a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r690yy_meta_template(void);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r690yy_base_template(void);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690set_input_stream(T690* C,T0* a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T2 r690text_count(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r690new_file_buffer(T0* a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690make_scanner(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690yy_initialize(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690reset(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690push_start_condition(T690* C,T2 a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r690text(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690make_def(T690* C,T0* a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690reset_sent(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690close_input(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r690yy_nxt_template(void);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690yy_set_line_column(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690_173Preset(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690make_literal(T690* C,T0* a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r690empty_buffer(void);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690_174P_173Pread_token(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
T0* r690yy_chk_template(void);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690_175P_173Preset(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690yy_set_content(T690* C,T0* a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690set_start_condition(T690* C,T2 a1);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690yy_build_tables(T690* C);
/*XM_EIFFEL_PE_ENTITY_DEF*/
void r690make_external(T690* C,T0* a1,T0* a2);
extern T0*oBC87default_word_set;
extern int fBC87default_word_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r79default_word_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r79compile_repeats(T79* C,T2 a1,T2 a2,T2 a3,T2 a4,T2 a5);
extern T0*oBC87digit_set;
extern int fBC87digit_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r79digit_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r79_92Pwipe_out(T79* C);
extern T0*oBC87graph_set;
extern int fBC87graph_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r79graph_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79match_additional_bracket(T79* C,T2 a1,T2 a2);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79unset_option_dotall(T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T6 r79has_startline(T79* C);
extern T0*oBC87upper_set;
extern int fBC87upper_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r79upper_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79first_significant_code(T79* C,T2 a1,T2 a2,T6 a3);
extern T2 oBC83infinity;
extern int fBC83infinity;
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79infinity(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79match_recursive(T79* C,T2 a1,T6 a2,T6 a3);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79escape_character(T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r79compile_regexp(T79* C,T2 a1,T6 a2,T6 a3,T2 a4);
/*RX_PCRE_REGULAR_EXPRESSION*/
T6 r79is_option_dotall(T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79match_internal(T79* C,T2 a1,T6 a2,T6 a3);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79match_repeated_classes(T79* C,T2 a1);
extern T0*oBC87meta_set;
extern int fBC87meta_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r79meta_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79find_firstchar(T79* C,T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T6 r79is_option_caseless(T2 a1);
extern T0*oBC87punct_set;
extern int fBC87punct_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r79punct_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79to_option_ims(T2 a1);
extern T0*oBC87print_set;
extern int fBC87print_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r79print_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r79match_substring(T79* C,T0* a1,T2 a2,T2 a3);
/*RX_PCRE_REGULAR_EXPRESSION*/
T6 r79match_start(T79* C,T2 a1);
extern T0*oBC87space_set;
extern int fBC87space_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r79space_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79match_repeated_characters(T79* C,T2 a1,T2 a2,T2 a3,T6 a4);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r79set_error(T79* C,T0* a1,T2 a2,T2 a3);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79ims_options(T79* C);
extern T0*oBC83actual_set;
extern int fBC83actual_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r79actual_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79unset_option_multiline(T2 a1);
extern T0*oBC82native_integer_array_;
extern T0*oBC87alnum_set;
extern int fBC87alnum_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r79alnum_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79check_posix_syntax(T79* C,T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79match_not_repeated_characters(T79* C,T2 a1,T2 a2,T2 a3,T6 a4);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r79match_it(T79* C,T0* a1,T2 a2,T2 a3);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79scan_octal_number(T79* C,T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r79_83Preset(T79* C);
extern T0*oBC87default_character_case_mapping;
extern int fBC87default_character_case_mapping;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r79default_character_case_mapping(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79match_repeated_refs(T79* C,T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79unset_option_caseless(T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r79wipe_out(T79* C);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79match_repeated_type(T79* C,T2 a1,T2 a2,T2 a3,T6 a4);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r79compile_single_repeat(T79* C,T2 a1,T2 a2,T2 a3,T2 a4,T2 a5,T2 a6);
extern T0*oBC87xdigit_set;
extern int fBC87xdigit_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r79xdigit_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T6 r79is_captured_substring_defined(T79* C,T2 a1);
extern T0*oBC87ascii_set;
extern int fBC87ascii_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r79ascii_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79captured_start_position(T79* C,T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r79clone(T0* a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79match_ref(T79* C,T2 a1,T2 a2,T2 a3);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79captured_end_position(T79* C,T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r79_83Pcompile(T79* C,T0* a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r79reset(T79* C);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79scan_escape(T79* C,T2 a1,T6 a2);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79find_fixed_code_length(T79* C,T2 a1);
extern T2 oBC83maxlit;
extern int fBC83maxlit;
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79maxlit(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79set_option_multiline(T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r79set_ims_options(T79* C,T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79next_matching_alternate(T79* C,T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r79set_default_options(T79* C);
extern T0*oBC87cntrl_set;
extern int fBC87cntrl_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r79cntrl_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T6 r79compile_counted_repeats(T79* C,T2 a1,T2 a2,T2 a3);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r79scan_comment(T79* C);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r79compile_character_class(T79* C);
extern T0*oBC83empty_pattern;
/*RX_PCRE_REGULAR_EXPRESSION*/
void r79set_default_internal_options(T79* C);
/*RX_PCRE_REGULAR_EXPRESSION*/
T6 r79is_option_multiline(T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r79compile(T79* C,T0* a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T6 r79is_option_undef(T2 a1);
extern T0*oBC87lower_set;
extern int fBC87lower_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r79lower_set(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79scan_hex_number(T79* C,T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r79compile_branch(T79* C,T6 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r79_83Pmake(T79* C);
/*RX_PCRE_REGULAR_EXPRESSION*/
void r79make(T79* C);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79scan_decimal_number(T79* C,T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79set_option_caseless(T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T6 r79matches(T79* C,T0* a1);
extern T0*oBC87class_sets;
extern int fBC87class_sets;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r79class_sets(void);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79set_option_dotall(T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T6 r79can_anchored(T79* C,T2 a1);
/*RX_PCRE_REGULAR_EXPRESSION*/
T2 r79check_posix_name(T79* C,T2 a1,T2 a2);
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r79captured_substring(T79* C,T2 a1);
extern T0*oBC87class_names;
extern T0*oBC87alpha_set;
extern int fBC87alpha_set;
/*RX_PCRE_REGULAR_EXPRESSION*/
T0* r79alpha_set(void);
/*XM_ELEMENT*/
void r741set_last_cell(T741* C,T0* a1);
/*XM_ELEMENT*/
void r741wipe_out(T741* C);
/*XM_ELEMENT*/
void r741remove_first(T741* C);
/*XM_ELEMENT*/
T0* r741cursor_item(T0* a1);
/*XM_ELEMENT*/
T6 r741cursor_is_last(T741* C,T0* a1);
/*XM_ELEMENT*/
void r741remove_traversing_cursor(T741* C,T0* a1);
/*XM_ELEMENT*/
void r741make_root(T741* C,T0* a1,T0* a2,T0* a3);
/*XM_ELEMENT*/
void r741cursor_go_after(T741* C,T0* a1);
/*XM_ELEMENT*/
void r741move_all_cursors_after(T741* C);
/*XM_ELEMENT*/
void r741add_traversing_cursor(T741* C,T0* a1);
/*XM_ELEMENT*/
void r741process(T741* C,T0* a1);
/*XM_ELEMENT*/
void r741make(T741* C,T0* a1,T0* a2,T0* a3);
/*XM_ELEMENT*/
T0* r741parent_element(T741* C);
/*XM_ELEMENT*/
void r741before_addition(T741* C,T0* a1);
/*XM_ELEMENT*/
void r741remove_last(T741* C);
/*XM_ELEMENT*/
T6 r741cursor_after(T0* a1);
/*XM_ELEMENT*/
void r741make_last(T741* C,T0* a1,T0* a2,T0* a3);
/*XM_ELEMENT*/
void r741make_list(T741* C);
/*XM_ELEMENT*/
void r741equality_delete(T741* C,T0* a1);
/*XM_ELEMENT*/
void r741cursor_forth(T741* C,T0* a1);
/*XM_ELEMENT*/
void r741move_last_cursors_after(T741* C);
/*XM_ELEMENT*/
void r741_535Pforce_last(T741* C,T0* a1);
/*XM_ELEMENT*/
void r741cursor_start(T741* C,T0* a1);
/*XM_ELEMENT*/
void r741force_last(T741* C,T0* a1);
/*XM_ELEMENT*/
T0* r741new_cursor(T741* C);
/*XM_ELEMENT*/
T6 r741cursor_is_first(T741* C,T0* a1);
/*XM_ELEMENT*/
void r741remove_at_cursor(T741* C,T0* a1);
/*XM_ELEMENT*/
void r741move_all_cursors(T741* C,T0* a1,T0* a2);
/*XM_ELEMENT*/
T6 r741cursor_off(T0* a1);
/*XM_ELEMENT*/
void r741_536P_535Pforce_last(T741* C,T0* a1);
/*LATEX_VISITOR*/
void r533sub_visit(T533* C,T0* a1);
/*LATEX_VISITOR*/
T0* r533visit_cmts(T533* C,T0* a1);
/*LATEX_VISITOR*/
void r533visit(T533* C);
/*LATEX_VISITOR*/
T0* r533correct(T0* a1);
/*LATEX_VISITOR*/
void r533make(T533* C,T0* a1,T6 a2,T0* a3,T0* a4);
/*LATEX_VISITOR*/
T0* r533visit_strs(T0* a1);
/*LATEX_VISITOR*/
T0* r533visit_cmt(T533* C,T0* a1);
/*LATEX_VISITOR*/
T0* r533visit_str(T0* a1);
/*RX_BYTE_CODE*/
void r98wipe_out(T98* C);
/*RX_BYTE_CODE*/
void r98append_integer(T98* C,T2 a1);
/*RX_BYTE_CODE*/
void r98resize_character_sets(T98* C,T2 a1);
extern T0*oBC82native_boolean_array_;
/*RX_BYTE_CODE*/
void r98make(T98* C,T2 a1);
/*RX_BYTE_CODE*/
void r98append_opcode(T98* C,T2 a1);
/*RX_BYTE_CODE*/
void r98move_right(T98* C,T2 a1,T2 a2);
/*RX_BYTE_CODE*/
void r98append_character(T98* C,T2 a1);
/*RX_BYTE_CODE*/
void r98resize_byte_code(T98* C,T2 a1);
/*RX_BYTE_CODE*/
void r98append_subcopy(T98* C,T2 a1,T2 a2);
/*RX_BYTE_CODE*/
T6 r98character_set_has(T98* C,T2 a1,T2 a2);
/*RX_BYTE_CODE*/
void r98append_character_set(T98* C,T0* a1,T6 a2);
/*RX_BYTE_CODE*/
void r98put_character(T98* C,T2 a1,T2 a2);
/*TEXT_FILE_WRITE*/
void r17disconnect(T17* C);
/*TEXT_FILE_WRITE*/
void r17connect_to(T17* C,T0* a1);
/*TEXT_FILE_WRITE*/
void r17write_buffer(T17* C);
/*TEXT_FILE_WRITE*/
void r17put_character(T17* C,T3 a1);
/*TEXT_FILE_WRITE*/
void r17put_string(T17* C,T0* a1);
/*XM_NAMESPACE*/
T6 r747is_equal(T747* C,T0* a1);
/*XM_NAMESPACE*/
void r747make(T747* C,T0* a1,T0* a2);
/*XM_NAMESPACE*/
T2 r747hash_code(T747* C);
/*XM_NAMESPACE*/
T6 r747same_prefix(T747* C,T0* a1);
/*STD_OUTPUT*/
void r30make(T30* C);
/*STD_OUTPUT*/
void r30flush(T30* C);
/*STD_OUTPUT*/
void r30write_buffer(T30* C);
/*STD_OUTPUT*/
void r30put_character(T30* C,T3 a1);
/*STD_OUTPUT*/
void r30put_string(T30* C,T0* a1);
/*STD_ERROR*/
void r39put_string(T0* a1);
/*UT_SYNTAX_ERROR*/
T0* r422arguments(void);
/*UT_SYNTAX_ERROR*/
void r422make(T422* C,T0* a1,T2 a2);
/*UT_SYNTAX_ERROR*/
T0* r422message(T422* C,T0* a1);
/*LX_ITERATION_NOT_POSITIVE_ERROR*/
T0* r482arguments(void);
/*LX_ITERATION_NOT_POSITIVE_ERROR*/
void r482make(T482* C,T0* a1,T2 a2);
/*LX_ITERATION_NOT_POSITIVE_ERROR*/
T0* r482message(T482* C,T0* a1);
/*KL_ARGUMENTS*/
T0* r429command_arguments(void);
/*KL_ARGUMENTS*/
T0* r429argument(T2 a1);
/*KL_CHARACTER_BUFFER*/
T0* r250substring(T250* C,T2 a1,T2 a2);
/*KL_CHARACTER_BUFFER*/
void r250fill_from_string(T250* C,T0* a1,T2 a2);
/*KL_CHARACTER_BUFFER*/
T2 r250fill_from_stream(T250* C,T0* a1,T2 a2,T2 a3);
/*KL_CHARACTER_BUFFER*/
void r250move_left(T250* C,T2 a1,T2 a2,T2 a3);
/*KL_CHARACTER_BUFFER*/
void r250make(T250* C,T2 a1);
/*KL_CHARACTER_BUFFER*/
void r250resize(T250* C,T2 a1);
/*UC_UTF16_ROUTINES*/
T6 r632is_endian_detection_character_least_first(T2 a1,T2 a2);
/*UC_UTF16_ROUTINES*/
T6 r632is_high_surrogate(T2 a1);
/*UC_UTF16_ROUTINES*/
T6 r632is_low_surrogate(T2 a1);
/*UC_UTF16_ROUTINES*/
T6 r632is_endian_detection_character_most_first(T2 a1,T2 a2);
/*UC_UTF16_ROUTINES*/
T6 r632is_surrogate(T2 a1);
/*UC_UTF16_ROUTINES*/
T2 r632least_10_bits(T2 a1,T2 a2);
/*UC_UTF16_ROUTINES*/
T2 r632surrogate(T2 a1,T2 a2);
/*ORGADOC*/
void r12convert_html_file(T12* C,T0* a1,T0* a2,T0* a3,T0* a4);
/*ORGADOC*/
void r12convert_latex_file(T12* C,T0* a1,T0* a2);
/*ORGADOC*/
T0* r12correct(T0* a1);
/*ORGADOC*/
void r12make(T12* C);
/*ORGADOC*/
void r12convert_bibtex_file(T12* C,T0* a1,T0* a2);
/*ORGADOC*/
void r12print(T0* a1);
/*ORGADOC*/
void r12convert_display_file(T12* C,T0* a1,T0* a2);
/*ORGADOC*/
void r12convert_regexp_file(T12* C,T0* a1,T0* a2);
/*ORGADOC*/
void r12convert_file_nosubpaths(T12* C,T0* a1,T0* a2);
/*ORGADOC*/
T6 r12recursive_convert(T12* C,T0* a1);
/*ORGADOC*/
void r12create_dirs(T0* a1);
/*ORGADOC*/
void r12convert_file(T12* C,T0* a1,T0* a2,T0* a3,T0* a4);
extern T0*oBC434error;
extern int fBC434error;
/*KL_STANDARD_FILES*/
T0* r434error(void);
extern T0*oBC434output;
extern int fBC434output;
/*KL_STANDARD_FILES*/
T0* r434output(void);
extern T2 oBC74maximum_character_code;
extern int fBC74maximum_character_code;
/*KL_PLATFORM*/
T2 r74maximum_character_code(T74* C);
extern T2 oBC74maximum_integer;
/*KL_EXCEPTIONS*/
void r711raise(T711* C,T0* a1);
extern T0*oBC712developer_exception_name_memory;
extern T0*oBC621lowercase_24;
extern int fBC621lowercase_24;
/*UC_UNICODE_ROUTINES*/
T0* r620lowercase_24(void);
extern T0*oBC621lowercase_21;
extern int fBC621lowercase_21;
/*UC_UNICODE_ROUTINES*/
T0* r620lowercase_21(void);
extern T0*oBC621lowercase_06;
extern int fBC621lowercase_06;
/*UC_UNICODE_ROUTINES*/
T0* r620lowercase_06(void);
extern T0*oBC621lowercase_05;
extern int fBC621lowercase_05;
/*UC_UNICODE_ROUTINES*/
T0* r620lowercase_05(void);
extern T0*oBC621lowercase_04;
extern int fBC621lowercase_04;
/*UC_UNICODE_ROUTINES*/
T0* r620lowercase_04(void);
extern T0*oBC621lowercase_03;
extern int fBC621lowercase_03;
/*UC_UNICODE_ROUTINES*/
T0* r620lowercase_03(void);
extern T0*oBC621lowercase_02;
extern int fBC621lowercase_02;
/*UC_UNICODE_ROUTINES*/
T0* r620lowercase_02(void);
extern T0*oBC621lowercase_01;
extern int fBC621lowercase_01;
/*UC_UNICODE_ROUTINES*/
T0* r620lowercase_01(void);
extern T0*oBC621lowercase_00;
extern int fBC621lowercase_00;
/*UC_UNICODE_ROUTINES*/
T0* r620lowercase_00(void);
extern T0*oBC621lowercase_ff;
extern int fBC621lowercase_ff;
/*UC_UNICODE_ROUTINES*/
T0* r620lowercase_ff(void);
/*UC_UNICODE_ROUTINES*/
T2 r620lower_code(T2 a1);
/*UC_UNICODE_ROUTINES*/
T6 r620valid_code(T2 a1);
extern T0*oBC621lowercase_1f;
extern int fBC621lowercase_1f;
/*UC_UNICODE_ROUTINES*/
T0* r620lowercase_1f(void);
extern T0*oBC621lowercase_1e;
extern int fBC621lowercase_1e;
/*UC_UNICODE_ROUTINES*/
T0* r620lowercase_1e(void);
extern T0*oBC621lowercase;
extern int fBC621lowercase;
/*UC_UNICODE_ROUTINES*/
T0* r620lowercase(void);
/*UC_UTF8_ROUTINES*/
T2 r73encoded_next_value(T3 a1);
/*UC_UTF8_ROUTINES*/
T2 r73character_byte_count(T3 a1);
/*UC_UTF8_ROUTINES*/
T2 r73encoded_first_value(T3 a1);
/*UC_UTF8_ROUTINES*/
T2 r73code_byte_count(T2 a1);
/*UC_UTF8_ROUTINES*/
T2 r73encoded_byte_count(T3 a1);
/*UC_UTF8_ROUTINES*/
void r73append_code_to_utf8(T0* a1,T2 a2);
/*UC_UTF8_ROUTINES*/
T0* r73to_utf8(T0* a1);
/*UC_UTF8_ROUTINES*/
T2 r73substring_byte_count(T0* a1,T2 a2,T2 a3);
/*KL_INTEGER_ROUTINES*/
T3 r76to_character(T2 a1);
/*UC_EQUALITY_TESTER*/
T6 r195test(T0* a1,T0* a2);
/*reference INTEGER*/
T0* r553twin(T553* C);
/*XM_NODE_TYPER*/
void r781process_comment(T781* C,T0* a1);
/*XM_NODE_TYPER*/
void r781process_processing_instruction(T781* C,T0* a1);
/*XM_NODE_TYPER*/
void r781process_document(T781* C,T0* a1);
/*XM_NODE_TYPER*/
void r781process_element(T781* C,T0* a1);
/*XM_NODE_TYPER*/
void r781process_attribute(T781* C,T0* a1);
/*XM_NODE_TYPER*/
void r781process_character_data(T781* C,T0* a1);
/*XM_NODE_TYPER*/
void r781reset(T781* C);
/*BASIC_DIRECTORY*/
void r33set_notation_using(T0* a1);
/*BASIC_DIRECTORY*/
T6 r33amiga_notation(void);
/*BASIC_DIRECTORY*/
void r33disconnect(T33* C);
/*BASIC_DIRECTORY*/
void r33compute_subdirectory_with(T0* a1,T0* a2);
/*BASIC_DIRECTORY*/
T6 r33system_notation_detected(void);
/*BASIC_DIRECTORY*/
T6 r33windows_notation(void);
/*BASIC_DIRECTORY*/
T6 r33unix_notation(void);
extern T0*oBC33last_entry;
/*BASIC_DIRECTORY*/
T6 r33macintosh_notation(void);
/*BASIC_DIRECTORY*/
void r33read_entry(T33* C);
/*BASIC_DIRECTORY*/
void r33connect_to(T33* C,T0* a1);
/*BASIC_DIRECTORY*/
T6 r33create_new_directory(T0* a1);
/*BASIC_DIRECTORY*/
T6 r33openvms_notation(void);
/*BASIC_DIRECTORY*/
T6 r33cygwin_notation(void);
/*KL_STRING_ROUTINES*/
T0* r62substring(T0* a1,T2 a2,T2 a3);
/*KL_STRING_ROUTINES*/
void r62wipe_out(T0* a1);
/*KL_STRING_ROUTINES*/
T0* r62as_string(T0* a1);
/*KL_STRING_ROUTINES*/
T0* r62clone(T0* a1);
/*KL_STRING_ROUTINES*/
T0* r62appended_string(T0* a1,T0* a2);
/*KL_STRING_ROUTINES*/
T6 r62is_integer(T0* a1);
/*KL_STRING_ROUTINES*/
T0* r62make(T2 a1);
/*KL_STRING_ROUTINES*/
T0* r62string(T0* a1);
/*KL_STRING_ROUTINES*/
T2 r62hexadecimal_to_integer(T0* a1);
/*KL_STRING_ROUTINES*/
T0* r62as_lower(T0* a1);
/*KL_STRING_ROUTINES*/
T0* r62appended_substring(T0* a1,T0* a2,T2 a3,T2 a4);
/*KL_STRING_ROUTINES*/
T0* r62new_empty_string(T0* a1,T2 a2);
/*KL_STRING_ROUTINES*/
T0* r62concat(T0* a1,T0* a2);
/*KL_STRING_ROUTINES*/
T2 r62substring_index(T0* a1,T0* a2,T2 a3);
/*KL_STRING_ROUTINES*/
T6 r62same_string(T0* a1,T0* a2);
/*KL_STRING_ROUTINES*/
T6 r62elks_same_string(T0* a1,T0* a2);
/*KL_STRING_ROUTINES*/
void r62append_substring_to_string(T0* a1,T0* a2,T2 a3,T2 a4);
/*XM_NULL_EXTERNAL_RESOLVER*/
T0* r160last_error(void);
/*reference BOOLEAN*/
T0* r555twin(T555* C);
/*XM_EXPAT_PARSER_FACTORY*/
T0* r149new_expat_parser(void);
extern T12*eiffel_root_object;
extern int se_argc;
extern char**se_argv;
#define SE_MAXID 793
extern T7*g[];
extern T7*t[];
void se_atexit(void);
void initialize_eiffel_runtime(int argc,char*argv[]);
extern T0*ms47_250860571;
extern T0*ms78_469863407;
extern T0*ms78_438699;
extern T0*ms532_840780094;
extern T0*ms446_1086870388;
extern T0*ms166_1639807481;
extern T0*ms78_93494782;
extern T0*ms7_241908472;
extern T0*ms166_1105337616;
extern T0*ms16_0aaaa;
extern T0*ms90_529870453;
extern T0*ms442_645257649;
extern T0*ms40_10378916;
extern T0*ms90_106524939;
extern T0*ms166_758578972;
extern T0*ms21_750997226;
extern T0*ms166_224621212;
extern T0*ms12_94835277;
extern T0*ms252_763354227;
extern T0*ms90_1584292294;
extern T0*ms78_94830657;
extern T0*ms166_313350252;
extern T0*ms16_0aa;
extern T0*ms21_1356433198;
extern T0*ms480_596994766;
extern T0*ms166_1785408556;
extern T0*ms21_1356433650;
extern T0*ms482_465236511;
extern T0*ms166_414094759;
extern T0*ms615_90456;
extern T0*ms90_1432094708;
extern T0*ms33_276a;
extern T0*ms448_1686894687;
extern T0*ms40_3603;
extern T0*ms252_511118884;
extern T0*ms166_620986269;
extern T0*ms90_1005188058;
extern T0*ms90_1012776380;
extern T0*ms90_1884818624;
extern T0*ms166_1232318322;
extern T0*ms447_215272365;
extern T0*ms16_0aaaaa;
extern T0*ms445_1203377682;
extern T0*ms90_247606932;
extern T0*ms77_277;
extern T0*ms166_225532234;
extern T0*ms77_46a;
extern T0*ms90_1194160835;
extern T0*ms7_280756769;
extern T0*ms90_261495747;
extern T0*ms615_90456a;
extern T0*ms90_1835565352;
extern T0*ms90_535188632;
extern T0*ms615_11156230;
extern T0*ms21_167969882;
extern T0*ms146_2055053662;
extern T0*ms166_880035048;
extern T0*ms481_1753741984;
extern T0*ms533_670536417;
extern T0*ms16_0;
extern T0*ms166_1718816811;
extern T0*ms166_729820516;
extern T0*ms615_259593324;
extern T0*ms422_1449702436;
extern T0*ms615_452299;
extern T0*ms90_2048967656;
extern T0*ms77_2032339083;
extern T0*ms12_1062900903;
extern T0*ms90_1189338692;
extern T0*ms164_42;
extern T0*ms164_43;
extern T0*ms77_46;
extern T0*ms7_1983847;
extern T0*ms15_14150;
extern T0*ms243_6934577;
extern T0*ms21_257857803;
extern T0*ms40_1978691;
extern T0*ms90_577467693;
extern T0*ms166_1040340337;
extern T0*ms78_94145427;
extern T0*ms166_1383485945;
extern T0*ms40_9946191;
extern T0*ms78_29952;
extern T0*ms90_53019651;
extern T0*ms261_1338085634;
extern T0*ms78_93444877;
extern T0*ms21_883075729;
extern T0*ms90_532624755;
extern T0*ms78_151842;
extern T0*ms175_32;
extern T0*ms40_1980191;
extern T0*ms557_1503;
extern T0*ms166_1787513656;
extern T0*ms78_746857;
extern T0*ms21_271663153;
extern T0*ms21_1487;
extern T0*ms533_986516197;
extern T0*ms166_513387338;
extern T0*ms78_752737;
extern T0*ms12_94835277a;
extern T0*ms90_42590039;
extern T0*ms166_438332871;
extern T0*ms12_1956468118;
extern T0*ms146_473224273;
extern T0*ms77_1538838099;
extern T0*ms78_3789657;
extern T0*ms78_467436677;
extern T0*ms90_763469248;
extern T0*ms40_89166;
extern T0*ms77_462330772;
extern T0*ms90_619510042;
extern T0*ms166_2065551545;
extern T0*ms166_1864547461;
extern T0*ms90_727439395;
extern T0*ms12_8970;
extern T0*ms12_8991;
extern T0*ms12_10;
extern T0*ms166_498324258;
extern T0*ms443_19730319;
extern T0*ms78_759757;
extern T0*ms450_1531431095;
extern T0*ms175_192;
extern T0*ms40_1231385571;
extern T0*ms166_993001251;
extern T0*ms444_111876583;
extern T0*ms40_2110320;
extern T0*ms40_434646;
extern T0*ms166_930325994;
extern T0*ms16_0aaa;
extern T0*ms77_1101570667;
extern T0*ms77_1318123306;
extern T0*ms16_0a;
extern T0*ms40_2247366;
extern T0*ms78_18948517;
extern T0*ms33_276;
extern T0*ms90_1317500565;
extern T0*ms33_63a;
extern T0*ms90_1200988023;
extern T0*ms166_1806352573;
extern T0*ms491_823229232;
extern T0*ms166_2083254325;
extern T0*ms90_139329733;
extern T0*ms40_394019;
extern T0*ms534_17696;
extern T0*ms166_1806545392;
extern T0*ms40_16016;
extern T0*ms40_15606;
extern T0*ms166_429369815;
extern T0*ms78_3772177;
extern T0*ms40_17111;
extern T0*ms166_766510371;
extern T0*ms90_1675130891;
extern T0*ms90_1141105903;
extern T0*ms78_18688922;
extern T0*ms462_280487577;
extern T0*ms166_1680506019;
extern T0*ms449_1520688928;
extern T0*ms40_18186;
extern T0*ms166_1389019675;
extern T0*ms78_10968511;
extern T0*ms12_1956468118a;
extern T0*ms78_18886672;
extern T0*ms33_63;
extern T0*ms78_3763952;
T0*se_ms(int c,char*e);
T0*se_string(char*e);
void se_msi1(void);
void se_msi2(void);
void se_msi3(void);
void se_msi4(void);
void W151on_xml_declaration_procedure(void* C,T8 a1,T8 a2,T2 a3);
void W151on_content_procedure(void* C,T8 a1,T2 a2);
void W151on_comment_procedure(void* C,T8 a1);
void*se_ma783(int argc,...);
void*se_ma226(int argc,...);
void*se_ma231(int argc,...);
void*se_ma232(int argc,...);
void*se_ma124(int argc,...);
void*se_ma126(int argc,...);
void*se_ma142(int argc,...);
void X292put(T0*C,T2 a1);
T0* X292to_array(T0*C,T2 a1,T2 a2);
void X292add(T0*C,T0* a1);
void X231put(T0*C,T2 a1,T2 a2);
T2 X231item(T0*C,T2 a1);
T6 X194test(T0*C,T0* a1,T0* a2);
T6 X65same_unicode_string(T0*C,T0* a1);
T0* X65as_string(T0*C);
T2 X65byte_index(T0*C,T2 a1);
T2 X65next_byte_index(T0*C,T2 a1);
T6 X65same_type(T0*C,T0* a1);
void X65append_string(T0*C,T0* a1);
void X65append_substring(T0*C,T0* a1,T2 a2,T2 a3);
T2 X65item_code_at_byte_index(T0*C,T2 a1);
T0* X65string(T0*C);
T0* X65prefixed_string(T0*C,T0* a1);
T0* X65new_empty_string(T0*C,T2 a1);
T2 X65substring_index(T0*C,T0* a1,T2 a2);
T3 X65byte_item(T0*C,T2 a1);
T0* X65to_utf8(T0*C);
T0* X65_ix_43(T0*C,T0* a1);
T0* X516item(T0*C);
T6 X516after(T0*C);
void X516forth(T0*C);
void X516start(T0*C);
T0* X512cursor_item(T0*C,T0* a1);
T6 X512cursor_after(T0*C,T0* a1);
void X512cursor_forth(T0*C,T0* a1);
void X512cursor_start(T0*C,T0* a1);
T0* X7out(T0*C);
void X7copy(T0*C,T0* a1);
T0* X7substring(T0*C,T2 a1,T2 a2);
void X7wipe_out(T0*C);
T3 X7last(T0*C);
T2 X7first_substring_index(T0*C,T0* a1);
T2 X7item_code(T0*C,T2 a1);
void X7put(T0*C,T3 a1,T2 a2);
T6 X7is_equal(T0*C,T0* a1);
T3 X7item(T0*C,T2 a1);
void X7append(T0*C,T0* a1);
T2 X7index_of(T0*C,T3 a1,T2 a2);
void X7set_count(T0*C,T2 a1);
T6 X7same_type(T0*C,T0* a1);
void X7remove_tail(T0*C,T2 a1);
void X7append_string(T0*C,T0* a1);
void X7remove(T0*C,T2 a1);
T0* X7string(T0*C);
void X7extend(T0*C,T3 a1);
T2 X7hash_code(T0*C);
T6 X7has(T0*C,T3 a1);
T2 X7to_integer(T0*C);
void X7append_character(T0*C,T3 a1);
void X7extend_unless(T0*C,T3 a1);
T6 X7same_as(T0*C,T0* a1);
void X7add_last(T0*C,T3 a1);
T3 X7first(T0*C);
void X7resize(T0*C,T2 a1);
T2 X7substring_index(T0*C,T0* a1,T2 a2);
void X7from_external_copy(T0*C,T8 a1);
void X7replace_substring(T0*C,T0* a1,T2 a2,T2 a3);
T8 X7to_external(T0*C);
void X7to_lower(T0*C);
T0* X7twin(T0*C);
T0* X7_ix_43(T0*C,T0* a1);
void X7swap(T0*C,T2 a1,T2 a2);
T0* X544cursor_item(T0*C,T0* a1);
T6 X544cursor_after(T0*C,T0* a1);
void X544cursor_forth(T0*C,T0* a1);
void X544cursor_start(T0*C,T0* a1);
void X687put_right(T0*C,T0* a1);
void X136set_callbacks(T0*C,T0* a1);
T0* X136position(T0*C);
void X136parse_from_stream(T0*C,T0* a1);
T0* X527last(T0*C);
T0* X527cursor_item(T0*C,T0* a1);
T0* X527item(T0*C,T2 a1);
T6 X527cursor_after(T0*C,T0* a1);
void X527cursor_forth(T0*C,T0* a1);
void X527cursor_start(T0*C,T0* a1);
void X527force_last(T0*C,T0* a1);
T0* X527new_cursor(T0*C);
T0* X13twin(T0*C);
void X538process(T0*C,T0* a1);
void X173apply_input_buffer(T0*C);
T6 X15se_assigned_from(T0*C,T0* a1);
void X15print_on(T0*C,T0* a1);
T6 X15conforms_to(T0*C,T0* a1);
T6 X56is_closable(T0*C);
T0* X56name(T0*C);
T2 X56read_to_string(T0*C,T0* a1,T2 a2,T2 a3);
void X56read_character(T0*C);
void X56close(T0*C);
T2 X56read_to_buffer(T0*C,T0* a1,T2 a2,T2 a3);
T6 X56end_of_input(T0*C);
T3 X56last_character(T0*C);
void X56read_string(T0*C,T2 a1);
T0* X56last_string(T0*C);
void X537process(T0*C,T0* a1);
void X537equality_delete(T0*C,T0* a1);
T0* X537new_cursor(T0*C);
void X243fill(T0*C);
T0* X243name(T0*C);
void X41process_comment(T0*C,T0* a1);
void X41process_processing_instruction(T0*C,T0* a1);
void X41process_document(T0*C,T0* a1);
void X41process_element(T0*C,T0* a1);
void X41process_attribute(T0*C,T0* a1);
void X41process_character_data(T0*C,T0* a1);
void X626set(T0*C,T0* a1,T6 a2,T6 a3);
void X626set_next_cursor(T0*C,T0* a1);
T6 X626after(T0*C);
T6 X626before(T0*C);
void X134on_start_tag_finish(T0*C);
void X134on_finish(T0*C);
void X134on_content(T0*C,T0* a1);
void X134on_start(T0*C);
void X134on_processing_instruction(T0*C,T0* a1,T0* a2);
void X134on_start_tag(T0*C,T0* a1,T0* a2,T0* a3);
void X134on_comment(T0*C,T0* a1);
void X134on_end_tag(T0*C,T0* a1,T0* a2,T0* a3);
void X134on_attribute(T0*C,T0* a1,T0* a2,T0* a3,T0* a4);
void X134on_error(T0*C,T0* a1);
void X134on_xml_declaration(T0*C,T0* a1,T0* a2,T6 a3);
T2 X229count(T0*C);
T2 X229item(T0*C,T2 a1);
T6 X304labeled(T0*C,T2 a1);
void X304record(T0*C,T0* a1);
T0* X528item(T0*C);
T6 X528after(T0*C);
void X528forth(T0*C);
void X528start(T0*C);
T6 X775cursor_is_last(T0*C,T0* a1);
void X775cursor_go_after(T0*C,T0* a1);
void X775cursor_forth(T0*C,T0* a1);
void X775cursor_start(T0*C,T0* a1);
T6 X775cursor_is_first(T0*C,T0* a1);
void X775remove_at_cursor(T0*C,T0* a1);
void X629cursor_forth(T0*C,T0* a1);
void X629cursor_start(T0*C,T0* a1);
T0* X423default_message(T0*C);
void X174read_token(T0*C);
void X174close_input(T0*C);
void X174reset(T0*C);
void X174set_input_stream(T0*C,T0* a1);
T0* T2toT553(T2 source);
T0* T6toT555(T6 source);

#ifdef __cplusplus
}
#endif
