<!-- contributed by Erik Vold [erikvvold@gmail.com]  -->

The `l10n` module allows one to localize their Jetpack.

## Example ##

    var _ = require("l10n").l10n({
      filename: "text.properties",
      baseURL: require("self").data.url("locale")
    });
    console.log(_("hello.world"));

<api name="l10n">
@function
  Creates and returns a function which can be used to access translations by
  key.

  Translations should be grouped together in a folder which contains a folder
  for each locale being supported whose name is the locale being supported
  (examples: "en", "en-US", "ja", "ja-JP"). Inside each locale's folder should
  be a `.properties` file with a name that is the same for every locale. Here
  is a example of how you might organize things:

  - data/
      - locale/
          - en/
              - text.properties
          - ja/
              - text.properties

@param options {object}
  

@prop filename {string}
  The name of the file storing the translations.
@prop baseURL {string}
  The url to the folder containing the locale folders.
@prop [defaultLocale] {string}
  Defines the locale to use when you don't have translations for the user's
  locale. The default is `"en"`.
</api>
