/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2018, 2024 (c)
 * 
 *    file: module_cpp.c
 *    This file is part of mino.
 *
 *    mino is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    mino is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with mino.  If not, see <http://www.gnu.org/licenses/>.
 */    
#include "modules.h"

char *ext_cpp[] = { "C", "CPP", "cpp", "cc", "c++", "cxx", "hpp", "cp" };
wchar_t *keyword_cpp[] = {
      //basic C++ language keywords
      L"alignas",
      L"alignof",
      L"and",
      L"and_eq",
      L"asm",
      L"auto",
      L"bitand",
      L"bitor",
      L"bool",
      L"break",
      L"case",
      L"catch",
      L"char",
      L"char16_t",
      L"char32_t",
      L"class",
      L"compl",
      L"const",
      L"constexpr",
      L"const_cast",
      L"continue",
      L"decltype",
      L"default",
      L"delete",
      L"do",
      L"double",
      L"dynamic_cast",
      L"else",
      L"enum",
      L"explicit",
      L"extern",
      L"export",
      L"false",
      L"float",
      L"for",
      L"friend",
      L"goto",
      L"if",
      L"inline",
      L"int",
      L"long",
      L"mutable",
      L"namespace",
      L"new",
      L"noexcept",
      L"not",
      L"not_eq",
      L"nullptr",
      L"operator",
      L"or",
      L"or_eq",
      L"private",
      L"protected",
      L"public",
      L"register",
      L"reinterpret_cast",
      L"return",
      L"short",
      L"signed",
      L"sizeof",
      L"static",
      L"static_assert",
      L"static_cast",
      L"struct",
      L"switch",
      L"template",
      L"this",
      L"thread_local",
      L"throw",
      L"true",
      L"try",
      L"typedef",
      L"typeid",
      L"typename",
      L"union",
      L"unsigned",
      L"using",
      L"virtual",
      L"void",
      L"volatile",
      L"wchar_t",
      L"while",
      L"xor",
      L"xor_eq",
      L"overried",
      L"final",
      //strings library
      L"string",
      L"wstring",
      L"u16string",
      L"u32string",
      //containers library
      L"array",
      L"vector",
      L"deque",
      L"forward_list",
      L"list",
      L"set",
      L"map",
      L"qsort",
      L"bsearch",
      //I/O functions
      L"srand",
      L"rand",
      L"std",
      L"fopen",
      L"freopen",
      L"fclose",
      L"fflush",
      L"fwide",
      L"setbuf",
      L"setvbuf",
      L"fread",
      L"fwrite",
      L"fgetc",
      L"getc",
      L"fgets",
      L"fputc",
      L"putc",
      L"fputs",
      L"getchar",
      L"gets",
      L"putchar",
      L"puts",
      L"ungetc",
      L"fgetwc",
      L"getwc",
      L"fgetws",
      L"fputwc",
      L"putwc",
      L"fputws",
      L"getwchar",
      L"putwchar",
      L"ungetwc",
      L"scanf",
      L"fscanf",
      L"sscanf",
      L"vscanf",
      L"vfscanf",
      L"vsscanf",
      L"printf",
      L"fprintf",
      L"sprintf",
      L"snprintf",
      L"vprintf",
      L"vfprintf",
      L"vsprintf",
      L"vsnprintf",
      L"wscanf",
      L"fwscanf",
      L"swscanf",
      L"vwscanf",
      L"vfwscanf",
      L"vswscanf",
      L"wprintf",
      L"fwprintf",
      L"swprintf",
      L"vwprintf",
      L"vfwprintf",
      L"vswprintf",
      L"ftell",
      L"fgetpos",
      L"fseek",
      L"fsetpos",
      L"rewind",
      L"clearerr",
      L"feof",
      L"ferror",
      L"perror",
      L"remove",
      L"rename",
      L"tmpfile",
      L"tmpnam",
      L"stdin",
      L"stdout",
      L"stderr",
};

struct modulestruct module_cpp =
{
    .extsCount      = 8,
    .exts           = ext_cpp,
    .keywordCount   = 173,
    .keywords       = keyword_cpp,
    .mlCommentStart = L"/*",
    .mlCommentEnd   = L"*/",
    .slCommentStart = L"//",
    .caseSensitive  = 1,
};

