#!/bin/sh
# Program to process GNATS queries via email.
# Copyright (C) 1993 Free Software Foundation, Inc.
# Contributed by Jason Merrill (jason@cygnus.com).
#
# This file is part of GNU GNATS.
#
# GNU GNATS is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# GNU GNATS is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU GNATS; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

GNATS_ROOT=xGNATS_ROOTx
GNATS_ADMIN=xGNATS_ADMINx
MAIL_AGENT="xMAIL_AGENTx"
[ -r $GNATS_ROOT/gnats-adm/config ] && . $GNATS_ROOT/gnats-adm/config

PATH=xBINDIRx:${PATH}
export PATH

oldIFS="$IFS"
while true; do
  IFS=:
  read header contents
  IFS="$oldIFS"
  [ -z "$header" ] && break;

  contents="`echo $contents | sed 's/^  *//'`"
  
  [ "$header" = "From" -a -z "$to" ] && to="$contents"
  [ "$header" = "Reply-To" ] && to="$contents"
  [ "$header" = "Subject" ] && args="$contents"
done

mail=/tmp/query$$

exec 3>&1 4>&2 > $mail 2>&1

if [ -n "$to" ]; then
  echo "To: $to"
  echo "Subject: query-pr output [$args]"
  echo
  case $args in
    *query-pr*)
      query-pr --restricted --state 'o|a|f|s' \
	`echo $args | sed 's/^.*query-pr//'`;;
    *)
      query-pr --restricted --state 'o|a|f|s' $args;;
  esac
else
  echo "To: $GNATS_ADMIN"
  echo "Subject: query-pr request failed"
  echo
  echo "Subject line:$args"
  echo "Body of message:"
  cat
fi

exec >&- 1>&3 2>&4

$MAIL_AGENT < $mail

[ $? -eq 0 ] && rm -f $mail
