/* LocaleInformation_sr.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_sr extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "GBP|CHF|FRF|HRK|IEP|JPY|HRD|ITL|EUR|PTE|NOK|AUD|DEM|LUF|BEF|YUN|NLG|DKK|RUR|KWD|ESP|CAD|GRD|ATS|SEK|USD|RUB|FIN|FIM|SIT|BAM";

  private static final String currenciesDisplayNameValues = "\u0424\u0443\u043d\u0442\u0430 \u0441\u0442\u0435\u0440\u043b\u0438\u043d\u0433\u0430|\u0428\u0432\u0430\u0458\u0446\u0430\u0440\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u0430\u043a|\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u0430\u043a|\u041a\u0443\u043d\u0430|\u0418\u0440\u0441\u043a\u0430 \u0444\u0443\u043d\u0442\u0430|\u0408\u0435\u043d|\u0425\u0440\u0432\u0430\u0442\u0441\u043a\u0438 \u0434\u0438\u043d\u0430\u0440|\u0418\u0442\u0430\u043b\u0438\u0458\u0430\u043d\u0441\u043a\u0430 \u043b\u0438\u0440\u0430|\u0415\u0412\u0420\u041e|\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0441\u043a\u0438 \u0435\u0441\u043a\u0443\u0434\u043e|\u041d\u043e\u0440\u0432\u0435\u0448\u043a\u0430 \u043a\u0440\u0443\u043d\u0430|\u0410\u0443\u0441\u0442\u0440\u0430\u043b\u0438\u0458\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440|\u041d\u0435\u043c\u0430\u0447\u043a\u0430 \u043c\u0430\u0440\u043a\u0430|\u041b\u0443\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0448\u043a\u0438 \u0444\u0440\u0430\u043d\u0430\u043a|\u0411\u0435\u043b\u0433\u0438\u0458\u0441\u043a\u0438 \u0444\u0440\u0430\u043d\u0430\u043a|YUN|\u0425\u043e\u043b\u0430\u043d\u0434\u0441\u043a\u0438 \u0433\u0443\u043b\u0434\u0435\u043d|\u0414\u0430\u043d\u0441\u043a\u0430 \u043a\u0440\u0443\u043d\u0430|\u0420\u0443\u0441\u043a\u0430 \u0440\u0443\u0431\u0459\u0430 (1991-1998)|\u041a\u0443\u0432\u0430\u0458\u0442\u0441\u043a\u0438 \u0434\u0438\u043d\u0430\u0440|\u0428\u043f\u0430\u043d\u0441\u043a\u0430 \u043f\u0435\u0437\u0435\u0442\u0430|\u041a\u0430\u043d\u0430\u0434\u0441\u043a\u0438 \u0434\u043e\u043b\u0430\u0440|\u0414\u0440\u0430\u0445\u043c\u0430|\u0410\u0443\u0441\u0442\u0440\u0438\u0458\u0441\u043a\u0438 \u0448\u0438\u043b\u0438\u043d\u0433|\u0428\u0432\u0435\u0434\u0441\u043a\u0430 \u043a\u0440\u0443\u043d\u0430|\u0410\u043c\u0435\u0440\u0438\u0447\u043a\u0438 \u0434\u043e\u043b\u0430\u0440|\u0420\u0443\u0441\u043a\u0430 \u0440\u0443\u0431\u0459\u0430|\u0424\u0438\u043d\u0441\u043a\u0430 \u043c\u0430\u0440\u043a\u0430 (1860-1962)|\u0424\u0438\u043d\u0441\u043a\u0430 \u043c\u0430\u0440\u043a\u0430|\u0422\u043e\u043b\u0430\u0440|\u041a\u043e\u043d\u0432\u0435\u0440\u0442\u0438\u0431\u0438\u043b\u043d\u0430 \u043c\u0430\u0440\u043a\u0430";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "CHF|FRF|HRK|IEP|HRD|PTE|NOK|AUD|DEM|LUF|BEF|YUN|NLG|DKK|RUR|KWD|ESP|CAD|GRD|ATS|SEK|USD|RUB|FIN|FIM|SIT|BAM";

  private static final String currenciesSymbolValues = "SwF|FRF|HRK|IR\u00a3|HRD|PTE|NKr|$A|DEM|LUF|BF|\u0414\u0438\u043d|NLG|DKr|RUR|KD|ESP|Can$|GRD|ATS|SKr|US$|RUB|FIN|FIM|SIT|KM";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "\u0458\u0430\u043d",
    "\u0444\u0435\u0431",
    "\u043c\u0430\u0440",
    "\u0430\u043f\u0440",
    "\u043c\u0430\u0458",
    "\u0458\u0443\u043d",
    "\u0458\u0443\u043b",
    "\u0430\u0432\u0433",
    "\u0441\u0435\u043f",
    "\u043e\u043a\u0442",
    "\u043d\u043e\u0432",
    "\u0434\u0435\u0446",
    null,
  };

  private static final String[] months = {
    "\u0458\u0430\u043d\u0443\u0430\u0440",
    "\u0444\u0435\u0431\u0440\u0443\u0430\u0440",
    "\u043c\u0430\u0440\u0442",
    "\u0430\u043f\u0440\u0438\u043b",
    "\u043c\u0430\u0458",
    "\u0458\u0443\u043d",
    "\u0458\u0443\u043b",
    "\u0430\u0432\u0433\u0443\u0441\u0442",
    "\u0441\u0435\u043f\u0442\u0435\u043c\u0431\u0430\u0440",
    "\u043e\u043a\u0442\u043e\u0431\u0430\u0440",
    "\u043d\u043e\u0432\u0435\u043c\u0431\u0430\u0440",
    "\u0434\u0435\u0446\u0435\u043c\u0431\u0430\u0440",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "\u043d\u0435\u0434",
    "\u043f\u043e\u043d",
    "\u0443\u0442\u043e",
    "\u0441\u0440\u0435",
    "\u0447\u0435\u0442",
    "\u043f\u0435\u0442",
    "\u0441\u0443\u0431",
  };

  private static final String[] weekdays = {
    null,
    "\u043d\u0435\u0434\u0435\u0459\u0430",
    "\u043f\u043e\u043d\u0435\u0434\u0435\u0459\u0430\u043a",
    "\u0443\u0442\u043e\u0440\u0430\u043a",
    "\u0441\u0440\u0435\u0434\u0430",
    "\u0447\u0435\u0442\u0432\u0440\u0442\u0430\u043a",
    "\u043f\u0435\u0442\u0430\u043a",
    "\u0441\u0443\u0431\u043e\u0442\u0430",
  };

  private static final String[] eras = {
    "\u043f. \u043d. \u0435.",
    "\u043d. \u0435",
  };

  private static final String[][] zoneStrings =
  {
    { "CET", "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u0415\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u0412\u0440\u0435\u043c\u0435", "CET", "\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u0415\u0432\u0440\u043e\u043f\u0441\u043a\u043e \u0412\u0440\u0435\u043c\u0435",  "Europe/Belgrade" },
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AR|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|MS|MR|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "\u0422\u0438\u043c\u043e\u0440-\u041b\u0435\u0441\u0442\u0435|\u0422\u043e\u043a\u0435\u043b\u0430\u0443|\u0422\u0430\u045f\u0438\u043a\u0438\u0441\u0442\u0430\u043d|\u0422\u0430\u0458\u043b\u0430\u043d\u0434|\u0422\u043e\u0433\u043e|\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0435 \u0408\u0443\u0436\u043d\u0435 \u0422\u0435\u0440\u0438\u0442\u043e\u0440\u0438\u0458\u0435|\u0413\u0432\u0430\u0458\u0430\u043d\u0430|\u0427\u0430\u0434|\u0422\u0443\u0440\u043a\u0441 \u0438 \u041a\u0430\u0458\u043a\u043e\u0441 \u041e\u0441\u0442\u0440\u0432\u0430|\u0413\u0432\u0438\u043d\u0435\u0458\u0430-\u0411\u0438\u0441\u0430\u043e|\u0413\u0443\u0430\u043c|\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u0430|\u0408\u0443\u0436\u043d\u0430 \u040f\u043e\u0440\u045f\u0438\u0458\u0430 \u0438 \u0408\u0443\u0436\u043d\u0430 \u0421\u0435\u043d\u0434\u0432\u0438\u0447 \u041e\u0441\u0442\u0440\u0432\u0430|\u0413\u0440\u0447\u043a\u0430|\u0415\u043a\u0432\u0430\u0442\u043e\u0440\u0438\u0458\u0430\u043b\u043d\u0430 \u0413\u0432\u0438\u043d\u0435\u0458\u0430|\u0413\u0432\u0430\u0434\u0435\u043b\u0443\u043f\u0435|\u0421\u0432\u0430\u0437\u0438\u043b\u0435\u043d\u0434|\u0421\u0438\u0440\u0438\u0458\u0430|\u0413\u0432\u0438\u043d\u0435\u0458\u0430|\u0413\u0430\u043c\u0431\u0438\u0458\u0430|\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434|\u0421\u0430\u043b\u0432\u0430\u0434\u043e\u0440|\u0421\u0430\u043e \u0422\u043e\u043c\u0435 \u0438 \u041f\u0440\u0438\u043d\u0446\u0438\u043f\u0438|\u0413\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440|\u0413\u0430\u043d\u0430|\u0421\u0443\u0440\u0438\u043d\u0430\u043c|\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0430 \u0413\u0432\u0430\u0458\u0430\u043d\u0430|\u0413\u0440\u0443\u0437\u0438\u0458\u0430|\u0421\u043e\u043c\u0430\u043b\u0438\u0458\u0430|\u0413\u0440\u0435\u043d\u0430\u0434\u0430|\u0421\u0435\u043d\u0435\u0433\u0430\u043b|\u0421\u0430\u043d \u041c\u0430\u0440\u0438\u043d\u043e|\u0412\u0435\u043b\u0438\u043a\u0430 \u0411\u0440\u0438\u0442\u0430\u043d\u0438\u0458\u0430|\u0421\u0438\u0458\u0435\u0440\u0430 \u041b\u0435\u043e\u043d\u0435|\u0413\u0430\u0431\u043e\u043d|\u0421\u043b\u043e\u0432\u0430\u0447\u043a\u0430|\u0421\u0432\u0430\u043b\u0431\u0430\u0440\u0434 \u0438 \u0408\u0430\u043d\u043c\u0430\u0458\u0435\u043d \u041e\u0441\u0442\u0440\u0432\u0430|\u0421\u043b\u043e\u0432\u0435\u043d\u0438\u0458\u0430|\u0421\u0432\u0435\u0442\u0430 \u0408\u0435\u043b\u0435\u043d\u0430|\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440|\u0428\u0432\u0435\u0434\u0441\u043a\u0430|\u0421\u0443\u0434\u0430\u043d|\u0421\u0435\u0458\u0448\u0435\u043b\u0438|\u0421\u043e\u043b\u043e\u043c\u043e\u043d\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430|\u0421\u0430\u0443\u0434\u0438\u0458\u0441\u043a\u0430 \u0410\u0440\u0430\u0431\u0438\u0458\u0430|\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0430|\u0424\u0430\u0440\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430|\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u0458\u0430|\u0420\u0443\u0430\u043d\u0434\u0430|\u0424\u043e\u043b\u043a\u043b\u0430\u043d\u0434\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430|\u0420\u0443\u0441\u0438\u0458\u0430|\u0424\u0438\u045f\u0438|\u0424\u0438\u043d\u0441\u043a\u0430|\u0420\u0443\u043c\u0443\u043d\u0438\u0458\u0430|\u0420\u0435\u0438\u043d\u0438\u043e\u043d|\u0415\u0442\u0438\u043e\u043f\u0438\u0458\u0430|\u0428\u043f\u0430\u043d\u0438\u0458\u0430|\u0415\u0440\u0438\u0442\u0440\u0435\u0458\u0430|\u0417\u0430\u043f\u0430\u0434\u043d\u0430 \u0421\u0430\u0445\u0430\u0440\u0430|\u0415\u0433\u0438\u043f\u0430\u0442|\u0415\u0441\u0442\u043e\u043d\u0438\u0458\u0430|\u0415\u043a\u0432\u0430\u0434\u043e\u0440|\u0410\u043b\u0436\u0438\u0440|\u041a\u0430\u0442\u0430\u0440|\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d\u0441\u043a\u0430 \u0420\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0430|\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0458|\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430|\u041f\u0430\u043b\u0430\u0443|\u0414\u0430\u043d\u0441\u043a\u0430|\u040f\u0438\u0431\u0443\u0442\u0438|\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b|\u041f\u0430\u043b\u0435\u0441\u0442\u0438\u043d\u0441\u043a\u0430 \u0442\u0435\u0440\u0438\u0442\u043e\u0440\u0438\u0458\u0430|\u041f\u043e\u0440\u0442\u043e \u0420\u0438\u043a\u043e|\u041d\u0435\u043c\u0430\u0447\u043a\u0430|\u041f\u0438\u0442\u043a\u0435\u0440\u043d|\u0421\u0435\u043d \u041f\u0458\u0435\u0440 \u0438 \u041c\u0438\u043a\u0435\u043b\u043e\u043d|\u041f\u043e\u0459\u0441\u043a\u0430|\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d|\u0424\u0438\u043b\u0438\u043f\u0438\u043d\u0438|\u041f\u0430\u043f\u0443\u0430 \u041d\u043e\u0432\u0430 \u0413\u0432\u0438\u043d\u0435\u0458\u0430|\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0430 \u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438\u0458\u0430|\u0427\u0435\u0448\u043a\u0430|\u041f\u0435\u0440\u0443|\u041a\u0438\u043f\u0430\u0440|\u0411\u043e\u0436\u0438\u045b\u043d\u043e \u041e\u0441\u0442\u0440\u0432\u043e|\u041a\u0430\u043f\u0435 \u0412\u0435\u0440\u0434\u0435|\u041f\u0430\u043d\u0430\u043c\u0430|\u041a\u0443\u0431\u0430|\u041a\u043e\u0441\u0442\u0430\u0440\u0438\u043a\u0430|\u041a\u043e\u043b\u0443\u043c\u0431\u0438\u0458\u0430|\u041a\u0438\u043d\u0430|\u041a\u0430\u043c\u0435\u0440\u0443\u043d|\u0427\u0438\u043b\u0435|\u041e\u0431\u0430\u043b\u0430 \u0421\u043b\u043e\u043d\u043e\u0432\u0430\u0447\u0435|\u0428\u0432\u0430\u0458\u0446\u0430\u0440\u0441\u043a\u0430|\u041a\u043e\u043d\u0433\u043e|\u0426\u0435\u043d\u0442\u0440\u0430\u043b\u043d\u043e \u0410\u0444\u0440\u0438\u0447\u043a\u0430 \u0420\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0430|\u0414\u0435\u043c\u043e\u043a\u0440\u0430\u0442\u0441\u043a\u0430 \u0440\u0435\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041a\u043e\u043d\u0433\u043e|\u041a\u043e\u043a\u043e\u0441\u043e\u0432\u0430 \u041e\u0441\u0442\u0440\u0432\u0430|\u041e\u043c\u0430\u043d|\u041a\u0430\u043d\u0430\u0434\u0430|\u0411\u0435\u043b\u0438\u0441\u0435|\u0411\u0435\u043b\u043e\u0440\u0443\u0441\u0438\u0458\u0430|\u0411\u043e\u0446\u0432\u0430\u043d\u0430|\u0411\u0443\u0432\u0435|\u0411\u0443\u0442\u0430\u043d|\u0411\u0430\u0445\u0430\u043c\u0438|\u0411\u0440\u0430\u0455\u0438\u043b|\u041d\u043e\u0432\u0438 \u0417\u0435\u043b\u0430\u043d\u0434|\u0411\u043e\u043b\u0438\u0432\u0438\u0458\u0430|\u0411\u0440\u0443\u043d\u0435\u0458|\u0411\u0435\u0440\u043c\u0443\u0434\u0430|\u041d\u0438\u0443\u0435|\u0411\u0435\u043d\u0438\u043d|\u0411\u0443\u0440\u0443\u043d\u0434\u0438|\u0411\u0430\u0445\u0440\u0435\u0438\u043d|\u041d\u0430\u0443\u0440\u0443|\u0411\u0443\u0433\u0430\u0440\u0441\u043a\u0430|\u0411\u0443\u0440\u043a\u0438\u043d\u0430 \u0424\u0430\u0441\u043e|\u041d\u0435\u043f\u0430\u043b|\u0411\u0435\u043b\u0433\u0438\u0458\u0430|\u041d\u043e\u0440\u0432\u0435\u0448\u043a\u0430|\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448|\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441|\u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435|\u0425\u043e\u043b\u0430\u043d\u0434\u0438\u0458\u0430|\u0411\u043e\u0441\u043d\u0430 \u0438 \u0425\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430|\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0432\u0430|\u041d\u0438\u0433\u0435\u0440\u0438\u0458\u0430|\u041d\u043e\u0440\u0444\u043e\u043b\u043a \u041e\u0441\u0442\u0440\u0432\u043e|\u0410\u0437\u0435\u0440\u0431\u0435\u0458\u045f\u0430\u043d|\u041d\u0438\u0433\u0435\u0440|\u041d\u043e\u0432\u0430 \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438\u0458\u0430|\u0410\u0440\u0443\u0431\u0430|\u0417\u0430\u043c\u0431\u0438\u0458\u0430|\u041d\u0430\u043c\u0438\u0431\u0438\u0458\u0430|\u0410\u0443\u0441\u0442\u0440\u0430\u043b\u0438\u0458\u0430|\u0410\u0443\u0441\u0442\u0440\u0438\u0458\u0430|\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430|\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a|\u0410\u043d\u0433\u043e\u043b\u0430|\u041c\u0430\u043b\u0435\u0437\u0438\u0458\u0430|\u0425\u043e\u043b\u0430\u043d\u0434\u0441\u043a\u0438 \u0410\u043d\u0442\u0438\u043b\u0438|\u041c\u0435\u043a\u0441\u0438\u043a\u043e|\u0410\u0440\u043c\u0435\u043d\u0438\u0458\u0430|\u041c\u0430\u043b\u0430\u0432\u0438|\u0410\u043b\u0431\u0430\u043d\u0438\u0458\u0430|\u041c\u0430\u043b\u0434\u0438\u0432\u0438|\u0408\u0443\u0436\u043d\u0430 \u0410\u0444\u0440\u0438\u043a\u0430|\u041c\u0430\u0443\u0440\u0438\u0446\u0438\u0458\u0443\u0441|\u041c\u0430\u043b\u0442\u0430|\u041c\u043e\u043d\u0441\u0435\u0440\u0430\u0442|\u041c\u0430\u0443\u0440\u0438\u0442\u0430\u043d\u0438\u0458\u0430|\u041c\u0430\u0440\u0442\u0438\u043d\u0438\u043a|\u0410\u0432\u0433\u0430\u043d\u0438\u0441\u0442\u0430\u043d|\u0421\u0435\u0432\u0435\u0440\u043d\u0430 \u041c\u0430\u0440\u0438\u0458\u0430\u043d\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430|\u0423\u0458\u0435\u0434\u0438\u045a\u0435\u043d\u0438 \u0410\u0440\u0430\u043f\u0441\u043a\u0438 \u0415\u043c\u0438\u0440\u0430\u0442\u0438|\u041c\u0430\u043a\u0430\u043e (\u0421. \u0410. \u0420. \u041a\u0438\u043d\u0430)|\u0410\u043d\u0434\u043e\u0440\u0430|\u041c\u043e\u043d\u0433\u043e\u043b\u0438\u0458\u0430|\u041c\u0438\u0458\u0430\u043d\u043c\u0430\u0440|\u041c\u0430\u043b\u0438|\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0438\u0458\u0430|\u0408\u0443\u0433\u043e\u0441\u043b\u0430\u0432\u0438\u0458\u0430|\u041c\u0430\u0458\u043e\u0442\u0435|\u041c\u0430\u0440\u0448\u0430\u043b\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430|\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440|\u041c\u043e\u043b\u0434\u0430\u0432\u0438\u0458\u0430|\u041c\u043e\u043d\u0430\u043a\u043e|\u041c\u0430\u0440\u043e\u043a\u043e|\u0408\u0435\u043c\u0435\u043d|\u041b\u0438\u0431\u0438\u0458\u0430|\u041b\u0435\u0442\u043e\u043d\u0438\u0458\u0430|\u041b\u0443\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433|\u041b\u0438\u0442\u0432\u0430\u043d\u0438\u0458\u0430|\u041b\u0435\u0441\u043e\u0442\u043e|\u041b\u0438\u0431\u0435\u0440\u0438\u0458\u0430|\u0428\u0440\u0438 \u041b\u0430\u043d\u043a\u0430|\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0430\u0458\u043d|\u0421\u0435\u043d\u0442 \u041b\u0443\u0446\u0438\u0458\u0430|\u041b\u0438\u0431\u0430\u043d|\u041b\u0430\u043e\u0441|\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d|\u041a\u0430\u0458\u043c\u0430\u043d\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430|\u041a\u0443\u0432\u0430\u0458\u0442|\u0408\u0443\u0436\u043d\u0430 \u041a\u043e\u0440\u0435\u0458\u0430|\u0421\u0435\u0432\u0435\u0440\u043d\u0430 \u041a\u043e\u0440\u0435\u0458\u0430|\u0421\u0435\u043d\u0442 \u041a\u0438\u0442\u0441 \u0438 \u041d\u0435\u0432\u0438\u0441|\u041a\u043e\u043c\u043e\u0440\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430|\u041a\u0438\u0440\u0438\u0431\u0430\u0442\u0438|\u0421\u0430\u043c\u043e\u0430|\u041a\u0430\u043c\u0431\u043e\u045f\u0430|\u041a\u0438\u0440\u0433\u0438\u0437\u0441\u0442\u0430\u043d|\u041a\u0435\u043d\u0438\u0458\u0430|\u0412\u0430\u043b\u0438\u0441 \u0438 \u0424\u0443\u0442\u0443\u043d\u0430 \u041e\u0441\u0442\u0440\u0432\u0430|\u0408\u0430\u043f\u0430\u043d|\u0408\u043e\u0440\u0434\u0430\u043d|\u0408\u0430\u043c\u0430\u0458\u043a\u0430|\u0412\u0430\u043d\u0443\u0430\u0442\u0443|\u0412\u0438\u0458\u0435\u0442\u043d\u0430\u043c|\u0421.\u0410.\u0414. \u0414\u0435\u0432\u0438\u0447\u0430\u043d\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430|\u0411\u0440\u0438\u0442\u0430\u043d\u0441\u043a\u0430 \u0414\u0435\u0432\u0438\u0447\u0430\u043d\u0441\u043a\u0430 \u041e\u0441\u0442\u0440\u0432\u0430|\u0412\u0435\u043d\u0435\u0446\u0443\u0435\u043b\u0430|\u0421\u0435\u043d\u0442 \u0412\u0438\u043d\u0441\u0435\u043d\u0442 \u0438 \u0413\u0440\u0435\u043d\u0430\u0434\u0438\u043d\u0438|\u0412\u0430\u0442\u0438\u043a\u0430\u043d|\u0418\u0442\u0430\u043b\u0438\u0458\u0430|\u0418\u0441\u043b\u0430\u043d\u0434|\u0418\u0440\u0430\u043d|\u0418\u0440\u0430\u043a|\u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u0430\u043d|\u0423\u0440\u0443\u0433\u0432\u0430\u0458|\u0418\u043d\u0434\u0438\u0458\u0430|\u0418\u0437\u0440\u0430\u0435\u043b|\u0421\u0458\u0435\u0434\u0438\u045a\u0435\u043d\u0435 \u0410\u043c\u0435\u0440\u0438\u0447\u043a\u0435 \u0414\u0440\u0436\u0430\u0432\u0435|\u0418\u0440\u0441\u043a\u0430|\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u0458\u0430|\u041c\u0430\u045a\u0430 \u0443\u0434\u0430\u0459\u0435\u043d\u0430 \u043e\u0441\u0442\u0440\u0432\u0430 \u0421\u0410\u0414|\u0423\u0433\u0430\u043d\u0434\u0430|\u0423\u043a\u0440\u0430\u0458\u0438\u043d\u0430|\u041c\u0430\u0452\u0430\u0440\u0441\u043a\u0430|\u0425\u0430\u0438\u0442\u0438|\u0425\u0440\u0432\u0430\u0442\u0441\u043a\u0430|\u0422\u0430\u043d\u0437\u0430\u043d\u0438\u0458\u0430|\u0425\u043e\u043d\u0434\u0443\u0440\u0430\u0441|\u0425\u0435\u0440\u0434 \u0438 \u041c\u0435\u043a\u0434\u043e\u043d\u0430\u043b\u0434 \u041e\u0441\u0442\u0440\u0432\u0430|\u0422\u0430\u0458\u0432\u0430\u043d|\u0422\u0443\u0432\u0430\u043b\u0443|\u0425\u043e\u043d\u0433 \u041a\u043e\u043d\u0433 (\u0421. \u0410. \u0420. \u041a\u0438\u043d\u0430)|\u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u0438 \u0422\u043e\u0431\u0430\u0433\u043e|\u0422\u0443\u0440\u0441\u043a\u0430|\u0422\u043e\u043d\u0433\u0430|\u0422\u0443\u043d\u0438\u0441|\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0438\u0441\u0442\u0430\u043d";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "ka|zh|ar|my|sw|sv|pt|mo|sr|mn|af|sq|mk|de|pl|sl|sk|da|ga|sh|vi|ja|yi|sa|cs|lv|it|fr|is|co|lt|ru|fi|ro|rm|ca|id|uk|fa|la|hy|ky|eu|et|br|hu|es|ku|hr|eo|en|el|ko|no|km|bg|tr|be|nl|he";

  private static final String languagesValues = "\u0413\u0440\u0443\u0437\u0438\u0458\u0441\u043a\u0438|\u041a\u0438\u043d\u0435\u0441\u043a\u0438|\u0410\u0440\u0430\u043f\u0441\u043a\u0438|\u0411\u0443\u0440\u043c\u0430\u043d\u0441\u043a\u0438|\u0421\u0432\u0430\u0445\u0438\u043b\u0438|\u0428\u0432\u0435\u0434\u0441\u043a\u0438|\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0441\u043a\u0438|\u041c\u043e\u043b\u0434\u0430\u0432\u0441\u043a\u0438|\u0421\u0440\u043f\u0441\u043a\u0438|\u041c\u043e\u043d\u0433\u043e\u043b\u0441\u043a\u0438|\u0410\u0444\u0440\u0438\u043a\u0430\u043d\u0435\u0440\u0441\u043a\u0438|\u0410\u043b\u0431\u0430\u043d\u0441\u043a\u0438|\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438|\u041d\u0435\u043c\u0430\u0447\u043a\u0438|\u041f\u043e\u0459\u0441\u043a\u0438|\u0421\u043b\u043e\u0432\u0435\u043d\u0430\u0447\u043a\u0438|\u0421\u043b\u043e\u0432\u0430\u0447\u043a\u0438|\u0414\u0430\u043d\u0441\u043a\u0438|\u0418\u0440\u0441\u043a\u0438|\u0421\u0440\u043f\u0441\u043a\u043e-\u0425\u0440\u0432\u0430\u0442\u0441\u043a\u0438|\u0412\u0438\u0458\u0435\u0442\u043d\u0430\u043c\u0441\u043a\u0438|\u0408\u0430\u043f\u0430\u043d\u0441\u043a\u0438|\u0408\u0438\u0434\u0438\u0448|\u0421\u0430\u043d\u0441\u043a\u0440\u0438\u0442|\u0427\u0435\u0448\u043a\u0438|\u041b\u0435\u0442\u043e\u043d\u0441\u043a\u0438|\u0418\u0442\u0430\u043b\u0438\u0458\u0430\u043d\u0441\u043a\u0438|\u0424\u0440\u0430\u043d\u0446\u0443\u0441\u043a\u0438|\u0418\u0441\u043b\u0430\u043d\u0434\u0441\u043a\u0438|\u041a\u043e\u0440\u0437\u0438\u043a\u0430\u043d\u0441\u043a\u0438|\u041b\u0438\u0442\u0432\u0430\u043d\u0441\u043a\u0438|\u0420\u0443\u0441\u043a\u0438|\u0424\u0438\u043d\u0441\u043a\u0438|\u0420\u0443\u043c\u0443\u043d\u0441\u043a\u0438|\u0420\u0435\u0442\u043e-\u0420\u043e\u043c\u0430\u043d\u0441\u043a\u0438|\u041a\u0430\u0442\u0430\u043b\u043e\u043d\u0441\u043a\u0438|\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u0458\u0441\u043a\u0438|\u0423\u043a\u0440\u0430\u0458\u0438\u043d\u0441\u043a\u0438|\u041f\u0435\u0440\u0441\u0438\u0458\u0441\u043a\u0438|\u041b\u0430\u0442\u0438\u043d\u0441\u043a\u0438|\u0410\u0440\u043c\u0435\u043d\u0441\u043a\u0438|\u041a\u0438\u0440\u0433\u0438\u0441\u043a\u0438|\u0411\u0430\u0441\u043a\u0438\u0458\u0441\u043a\u0438|\u0415\u0441\u0442\u043e\u043d\u0441\u043a\u0438|\u0411\u0440\u0435\u0442\u043e\u043d\u0441\u043a\u0438|\u041c\u0430\u0452\u0430\u0440\u0441\u043a\u0438|\u0428\u043f\u0430\u043d\u0441\u043a\u0438|\u041a\u0443\u0440\u0434\u0441\u043a\u0438|\u0425\u0440\u0432\u0430\u0442\u0441\u043a\u0438|\u0415\u0441\u043f\u0435\u0440\u0430\u043d\u0442\u043e|\u0415\u043d\u0433\u043b\u0435\u0441\u043a\u0438|\u0413\u0440\u0447\u043a\u0438|\u041a\u043e\u0440\u0435\u0458\u0441\u043a\u0438|\u041d\u043e\u0440\u0432\u0435\u0448\u043a\u0438|\u041a\u043c\u0435\u0440\u0441\u043a\u0438|\u0411\u0443\u0433\u0430\u0440\u0441\u043a\u0438|\u0422\u0443\u0440\u0441\u043a\u0438|\u0411\u0435\u043b\u043e\u0440\u0443\u0441\u043a\u0438|\u0425\u043e\u043b\u0430\u043d\u0434\u0441\u043a\u0438|\u0425\u0435\u0431\u0440\u0435\u0458\u0441\u043a\u0438";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "localPatternChars", "GanjkHmsSEDFwWxhKzAeugXZ" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "shortDateFormat", "d.M.yy." },
    { "mediumDateFormat", "dd.MM.yyyy." },
    { "longDateFormat", "dd.MM.yyyy." },
    { "fullDateFormat", "EEEE, dd.MMMM.yyyy." },
    { "shortTimeFormat", "HH.mm" },
    { "mediumTimeFormat", "HH.mm.ss" },
    { "longTimeFormat", "HH.mm.ss z" },
    { "fullTimeFormat", "HH.mm.ss z" },
    { "zoneStrings", zoneStrings },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
