/* IDEA cryptosystem DLL, (c) 1994 Andy Brown */


#include <windows.h>
#include "idea.h"

#define mulMod        0x10001 									/* 2**16 + 1 */
#define addMod        0x10000 									/* 2**16 */
#define ones          0xFFFF 										/* 2**16 - 1 */

#define nofKeyPerRound      6 									/* number of used keys per round */
#define nofRound            8 									/* number of rounds */

#define dataSize       8 	/* bytes = 64 bits */
#define dataLen        4
#define keySize      104 	/* bytes = 832 bits */
#define keyLen        52
#define userKeySize   16 	/* bytes = 128 bits */
#define userKeyLen     8

#define data_t(v)    WORD v[dataLen]
#define key_t(v)     WORD v[keyLen]
#define userkey_t(v) WORD v[userKeyLen]

static DWORD Mul(DWORD a,DWORD b);
static WORD MulInv(WORD x);
int FAR PASCAL LibMain(HANDLE hInstance,WORD wDataSeg,WORD wHeapSize,LPSTR lpszCmdLine);


/******************************/
/* LibMain DLL initialisation */
/******************************/

int FAR PASCAL LibMain(HANDLE hInstance,WORD wDataSeg,WORD wHeapSize,LPSTR lpszCmdLine)
{
	if(wHeapSize>0) UnlockData(0);
	return 1;
}


/******************/
/* multiplication */
/******************/

static DWORD Mul(DWORD a,DWORD b)
{
LONG p;
DWORD q;
  
	if(a==0) p=mulMod-b; 
  else if(b==0) p=mulMod-a;
	else
	{
		q=a*b;
    p=(q & ones)-(q>>16);
    if(p<=0) p+=mulMod;
  }
	return (DWORD)(p & ones);
}


/*****************************************************/
/* compute inverse of 'x' by Euclidean gcd algorithm */
/*****************************************************/

static WORD MulInv(WORD x)
{
LONG n1,n2,q,r,b1,b2,t;

	if(x==0) return 0;
  n1=mulMod;
  n2=(LONG)x;
	b2=1;
	b1=0;
	do
	{
  	r=(n1 % n2);
    q=(n1-r)/n2;
		if(r==0)
		{
    	if(b2<0)
      b2=mulMod+b2;
    }
		else
		{
    	n1=n2;
      n2=r;
      t=b2;
      b2=b1-q*b2;
      b1=t;
    }
  } while(r!=0);
	return (WORD)b2;
}


/********************************************/
/* encryption and decryption algorithm IDEA */
/********************************************/

VOID FAR PASCAL _export Idea(LPWORD dataIn,LPWORD dataOut,LPWORD key)
{
DWORD round,x0,x1,x2,x3,t0,t1;

	x0=(DWORD)*(dataIn++);
	x1=(DWORD)*(dataIn++);
	x2=(DWORD)*(dataIn++);
	x3=(DWORD)*(dataIn);
	for(round=nofRound;round>0;round--)
	{
		x0=Mul(x0,(DWORD)*(key++));
		x1=(x1+(DWORD)*(key++)) & ones;
		x2=(x2+(DWORD)*(key++)) & ones;
		x3=Mul(x3,(DWORD)*(key++));
		t0=Mul((DWORD)*(key++),x0^x2);
		t1=Mul((DWORD)*(key++),(t0+(x1^x3)) & ones);
    t0=(t0+t1) & ones;
    x0^=t1;
    x3^=t0;
    t0^=x1;
    x1=x2^t1;
    x2=t0;
  }
	*(dataOut++)=(WORD)(Mul(x0,(DWORD)*(key++)));
	*(dataOut++)=(WORD)((x2+(DWORD)*(key++)) & ones);
	*(dataOut++)=(WORD)((x1+(DWORD)*(key++)) & ones);
	*(dataOut)=(WORD)(Mul(x3,(DWORD)*key));
}

 
/**********************************************/
/* invert decryption / encrytion key for IDEA */
/**********************************************/

VOID FAR PASCAL _export InvertIdeaKey(LPWORD key,LPWORD invKey)
{
register int  i;
key_t(dk);

  dk[nofKeyPerRound*nofRound+0]=MulInv(*(key++));
  dk[nofKeyPerRound*nofRound+1]=(addMod-*(key++)) & ones;
	dk[nofKeyPerRound*nofRound+2]=(addMod-*(key++)) & ones;
  dk[nofKeyPerRound*nofRound+3]=MulInv(*(key++));
	for(i=nofKeyPerRound*(nofRound-1);i>=0;i-=nofKeyPerRound)
	{
  	dk[i+4]=*(key++);
    dk[i+5]=*(key++);
    dk[i+0]=MulInv(*(key++));
		if(i>0)
		{
    	dk[i+2]=(addMod-*(key++)) & ones;
      dk[i+1]=(addMod-*(key++)) & ones;
    }
		else
		{
      dk[i+1]=(addMod-*(key++)) & ones;
      dk[i+2]=(addMod-*(key++)) & ones;
    }
    dk[i+3]=MulInv(*(key++));
  }
	for(i=0;i<keyLen;i++) invKey[i]=dk[i];
}


/*******************************************************/
/* expand user key of 128 bits to full key of 832 bits */
/*******************************************************/

VOID FAR PASCAL _export ExpandUserKey(LPWORD userKey,LPWORD key)
{
register int i;

	for(i=0;i<userKeyLen;i++) key[i]=userKey[i];
	for(i=userKeyLen;i<keyLen;i++)								/* shifts */
	{
  	if((i+2) % 8==0)                    				/* for key[14],key[22],..  */
      key[i]=((key[i-7] & 127)<<9)^(key[i-14]>>7); 
    else if((i+1) % 8==0)               				/* for key[15],key[23],..  */
      key[i]=((key[i-15] & 127)<<9)^(key[i-14]>>7); 
    else
      key[i]=((key[i-7] & 127)<<9)^(key[i-6]>>7);
	 }
}
