#include <stdio.h>
#include <pwd.h>
#include <sys/file.h>
#include <sys/syslog.h>

#define HOSTNAME_SIZE 32
#define NAME_SIZE      8
#define TIMEOUT       90
#define LOG_STAT  LOG_LOCAL0

#define MIN_UID  99
#define MIN_GID  99

/* good_cmd holds the list of authorized   */
/* commands this program may be linked to. */
 
char *good_cmd[] = {
   "telout",            /* telnet account on gateway system */
   "ftpout",            /* ftp    account on gateway system */
};

int num_cmds = (sizeof (good_cmd)/ sizeof(char *));

/* Specify the system name of the firewall system here */
#define GATEWAY "firewall"

/* Specify the domain name of the internal network here */
#define DOMAIN  "DDP.Sterling.COM"

int main(argc,argv)
int argc;
char **argv;
{
    char *strchr();
    char *strcat();
    char *getenv();

    char *term;
    char envstr[128];
    char thishost[HOSTNAME_SIZE];
    char domain[HOSTNAME_SIZE];
    char *cmd;
    int  cmd_uid;
    int  cmd_gid;
    int  found;
    register int i;
    struct passwd *pw;

    /* Get the command name of the application */

    if ((cmd = strchr(argv[0], '/')) != NULL)
        ++cmd;
    else
        cmd = argv[0];

    /* Open the logger */

    openlog(cmd,LOG_PID,LOG_STAT);

    /* What is my host name ? */

    if (gethostname(thishost,sizeof (thishost)) != 0) {
        syslog(LOG_ERR,"%s: Cannot get hostname.. ??\n",cmd);
        (void) printf("%s: Sorry...\n",cmd);
        return(1);
    }

    /*
    ** Is this a valid command name ?
    */
    found = 0;
    for (i = 0; i < num_cmds; i++) {
        if (strcmp(cmd,good_cmd[i]) == 0) {
            found = 1;
            break;
        }
    }

    if (!found) {
        syslog(LOG_ERR,"%s: invalid link encountered\n",cmd);
        (void) printf("%s is an invalid link name. Call your admin!\n",cmd);
        return(1);
    }
       
    /* Get the uid to use later */

    if ((pw = getpwnam(cmd)) == NULL) {
        syslog(LOG_ERR,"%s: unknown user encountered\n",cmd);
        (void) printf("%s: Who are you ?\n",cmd);
        return(1);
    }
    else {
        cmd_uid = pw->pw_uid;
        cmd_gid = pw->pw_gid;
    }
      
    /* Get the login name */

    if ((pw = getpwuid(getuid())) == NULL) {
        syslog(LOG_ERR,"%s: unknown user encountered\n",cmd);
        (void) printf("%s: Who are you ?\n",cmd);
        return(1);
    }

    /* Assure that the user account number is greater than */ 
    /* the site specified account limits.                  */ 
    
    if ((getuid() <= MIN_UID) || (getgid() <= MIN_GID)) {
        syslog(LOG_INFO,"%s@%s tried to use %s\n",pw->pw_name,thishost,cmd);
        (void) printf("Sorry but system accounts can not use %s\n",cmd);
        return(1);
    }

    /* Assure this is not running on the gateway system */

    if (strcasecmp(GATEWAY, thishost) == 0) {
        syslog(LOG_ERR,"%s: %s attempted to use on %s\n",
                          cmd,pw->pw_name,thishost);
        (void) printf("%s not available from %s\n",cmd, GATEWAY);
        return(1);
    }

    /*
    ** Set the usr and group ids here to that of the telout account
    ** so that the rlogin command will work for the user.  
    */

    if ((setuid(cmd_uid) != 0) || (setgid(cmd_gid) != 0)) {
        syslog(LOG_ERR,"%s: Cannot set priviledges\n",cmd);
        (void) printf("%s: Sorry, call the admin and complain.\n",cmd);
        return(1);
    }

    /*
    ** assure that the host name passed is a fully qualified domain name.
    */

    if (strchr(thishost,'.') == NULL) {
        if (getdomainname(domain,sizeof (domain)) != 0) {
            syslog(LOG_ERR,"%s: Cannot get domainname.. ??\n",cmd);
            (void) printf("%s: Tell your admin to set the domainname...\n",cmd);
            return(1);
        }
        (void) strcat(thishost,".");
        (void) strcat(thishost,domain);
    }

    /*
    ** We need to pass the user@hostname to the process on the receiving
    ** end.  The only way to do this with the standard rlogin as supplied
    ** by the vendors is to play games with the terminal type.
    */

    if ((term = getenv("TERM")) == NULL) {
        syslog(LOG_ERR,"%s: Cannot determine terminal type\n",cmd);
        (void) printf("%s: Can't determine terminal type.. ??\n",cmd);
        return(1);
    }
    
    (void) sprintf(envstr,"TERM=%s::%s@%s", term,pw->pw_name,thishost);
    if (putenv(envstr) != 0) {
        syslog(LOG_ERR,"%s: setting TERM failed\n",cmd);
        (void) printf("%s: Sorry, environment setting failed.\n",cmd);
        return(1);
    }
   
    syslog(LOG_INFO,"%s requesting outbound %s connection\n", pw->pw_name,cmd);
    (void) execl("/usr/ucb/rlogin", "rlogin", "-l", cmd, GATEWAY, 0);
    syslog(LOG_INFO,"%s request for %s failed\n", cmd, pw->pw_name);
    return(127);
}
