/******************************************************************
 *
 *     I R I S P L O T
 *              --------------  graphic.a source
 *      Copyright 1989 Zou Maorong
 *
 ******************************************************************/

#define YZX                      1
#define XZY                      2
#define XYZ                      3
#define ORTHOGONAL               1
#define PERSPECTIVE              2
#define SLICEPLANEMAT            3123
#define R2D                      572.9577951471
#define D2R                      0.001745329252

#define MAX(X,Y)                 ( (X) > (Y) ? (X) : (Y))


/**********************************
 *
 *  struct used by the front end
 */

typedef  struct 
{
  float xmax,xmin,ymax,ymin,zmax,zmin;
  float vx,vy,vz,px,py,pz; 
  int   window_position[4];
  short twist,proj_type;
  union 
    {
      struct  ortho
	{
	  float   left,right,top,bottom,near,far;
	}  o;
      struct pers
	{
	  float   pnear,pfar,aspect; short fovy;
	} p;
    } projections;
} oview;

/***********************************************************/

typedef struct
{
  char   *obj_list_content;
  int    menu,scale_menu,trans_menu,rot_menu,obj_menu,obj_list_menu;
  int    material_menu,rgb_menu,local_menu,l_and_m_menu,warning_menu;
  int    on_light_menu,lmodel_menu,light_menu,slice_menu,dir_menu,scale_only;
  int    depthcue_menu,extra_menu;
  int    spotlight_menu,nonlocal_menu,nonspot_menu;
} Menu;

typedef struct 
{
  float   vx,vy,vz,dist,scale,p_factor,left,right,top,bottom,near,far;
}Slice;

typedef struct
{
  int    mode_flag,light,box_flag,sp_flag,slice,slice_draw, zbuffer_flag;
  int    redraw,coor_flag,cmap_flag,depthcue,buffer_flag;
  int    big_box_flag,bulb_flag,r_coor_flag,local_light;
  int    need_redefine_lm, need_redefine_mp,save_image_flag;
  int    show_message_flag;
  int    random_color;
} Flag;

typedef  struct
{
  float   mater[21];
  int     mat_change;
  long    mat_index;
} Mat;

typedef  struct 
{
  float   vx,vy,vz,px,py,pz; short twist;
  float   left,right,top,bottom,near,far;
  float   pnear,pfar,aspect; short fovy;
  float   x_trans, y_trans, z_trans, x_scale, y_scale, z_scale;
  short   x_rot,y_rot,z_rot,theta,phi;
  int     view_menu,proj_type_menu,ortho_menu,pers_menu;
  int     proj_view_mod_menu;
  int     proj_flag,rot_new_flag,rot_old_flag,proj_change,view_change;
} View;

typedef struct
{
  float    x_scale,y_scale,z_scale;
  float    x_trans,y_trans,z_trans;
  short    x_rot,y_rot,z_rot;
  int      material_menu,tr_flag,ro_flag,sc_flag;
  int      rot_old,rot_new;
  char     *menu_content;
  Mat      *mat;
  int      draw;
} Obj;

typedef struct
{
  float    x_scale,y_scale,z_scale,x_trans,y_trans,z_trans;
  short    x_rot,y_rot,z_rot,brx,bry,brz;
} Box;

typedef struct
{
  float   token[14];
  int     lmodel_change;
}  Lmodel;

typedef struct
{
  float    token[22];
  int      light_change,on,spot;
} Light;


/************************************************************************/




