/*
 * Decompiled with CFR 0.152.
 */
package Serpent;

import Serpent.Serpent_Standard;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

public final class gen_plains {
    static final String VERSION = "$Revision: 1.0$";
    static final String SUBMITTER = "<as stated on the submission cover sheet>";
    String dirName;
    String keylengths;
    String cipherName;
    File destination;
    int[] keys = new int[]{128, 192, 256};
    final String FileName = "ecb_tbl.txt";
    long encBlocks;
    long decBlocks;
    long keyCount;
    Method makeKey;
    Method encrypt;
    Method decrypt;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void main(String[] stringArray) {
        System.out.println("NIST tables (SB) Tests data generator/exerciser\n$Revision: 1.0$\nCopyright (c) 1998 Systemics Ltd. on behalf of\nthe Cryptix Development Team.  All rights reserved.\n\n");
        gen_plains gen_plains2 = new gen_plains();
        gen_plains2.processOptions(stringArray);
        gen_plains2.run();
    }

    private void processOptions(String[] stringArray) {
        Object object;
        Object[] objectArray;
        int n = stringArray.length;
        if (n == 0) {
            this.printUsage();
        }
        System.out.println("(type \"java NIST.gen_plains\" with no arguments for help)\n\n");
        int n2 = -1;
        String string = "";
        boolean bl = true;
        while (true) {
            if (bl) {
                if (++n2 >= n) break;
                string = stringArray[n2];
            } else {
                string = "-" + string.substring(2);
            }
            if (string.startsWith("-l")) {
                this.keylengths = stringArray[n2 + 1];
                ++n2;
                bl = true;
                continue;
            }
            if (string.startsWith("-d")) {
                this.dirName = stringArray[n2 + 1];
                ++n2;
                bl = true;
                continue;
            }
            this.cipherName = string;
        }
        if (this.cipherName == null) {
            gen_plains.halt("Missing cipher algorithm name");
        }
        if (this.cipherName.length() > 1 && (this.cipherName.startsWith("\"") || this.cipherName.startsWith("'"))) {
            this.cipherName = this.cipherName.substring(2, this.cipherName.length() - 2);
        }
        if (this.keylengths != null) {
            int n3 = 0;
            objectArray = new int[3];
            object = new StringTokenizer(this.keylengths, ", \t\"");
            while (((StringTokenizer)object).hasMoreTokens()) {
                int n4 = Integer.parseInt(((StringTokenizer)object).nextToken());
                if (n4 <= 0) {
                    gen_plains.halt("Negative key length not allowed: " + n4);
                }
                if (n3 == 3) {
                    gen_plains.halt("Only three key-length values are allowed.");
                }
                objectArray[n3++] = n4;
            }
            if (n3 != 0) {
                this.keys = new int[n3];
                System.arraycopy(objectArray, 0, this.keys, 0, n3);
            }
        }
        if (this.dirName == null) {
            this.dirName = System.getProperty("user.dir");
        }
        this.destination = new File(this.dirName);
        if (!this.destination.isDirectory()) {
            gen_plains.halt("Destination <" + this.destination.getName() + "> is not a directory");
        }
        String string2 = String.valueOf(this.cipherName) + "." + this.cipherName + "_Algorithm";
        try {
            Class<?> clazz = Class.forName(string2);
            objectArray = clazz.getDeclaredMethods();
            n2 = 0;
            while (n2 < objectArray.length) {
                object = objectArray[n2].getName();
                int n5 = objectArray[n2].getParameterTypes().length;
                if (((String)object).equals("makeKey") && n5 == 1) {
                    this.makeKey = (Method)objectArray[n2];
                } else if (((String)object).equals("blockEncrypt") && n5 == 3) {
                    this.encrypt = (Method)objectArray[n2];
                } else if (((String)object).equals("blockDecrypt") && n5 == 3) {
                    this.decrypt = (Method)objectArray[n2];
                }
                ++n2;
            }
            if (this.makeKey == null) {
                throw new NoSuchMethodException("makeKey()");
            }
            if (this.encrypt == null) {
                throw new NoSuchMethodException("blockEncrypt()");
            }
            if (this.decrypt == null) {
                throw new NoSuchMethodException("blockDecrypt()");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            gen_plains.halt("Unable to find " + string2 + " class");
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            gen_plains.halt("Unable to find " + string2 + "." + noSuchMethodException.getMessage() + " method");
        }
    }

    static void halt(String string) {
        System.err.println("\n*** " + string + "...");
        System.exit(-1);
    }

    static void notify(String string) {
        System.out.println("gen_plains: " + string + "...");
    }

    void printUsage() {
        System.out.println("NAME\n  gen_plains: tables (SB) Tests data generator/exerciser for Serpent.\n\nSYNTAX\n  java NIST.gen_plains\n    [ -l <comma-separated-key-lengths>]\n    [ -d <output-directory>]\n    <cipher>\n\nDESCRIPTION\n Generates plain texts for testing s boxes\nOPTIONS\n  -l <comma-separated-key-lengths>\n       Comma separated list (maximum of three) of key lengths to use\n       for the tests.  If omitted, the following three values are\n       assumed: 128, 192 and 256.\n\n  -d <output-directory>\n       Pathname of the directory where output files: \"ecb_tbl.txt\"\n       and \"ecb_tbl.txt\" will be generated.  If this destination\n       directory is not specified, those files will be placed in\n       the current user directory.\n\n  <cipher>\n       Cipher algorithm name.\n\nCOPYRIGHT\n  Copyright (c) 1998 Systemics Ltd. on behalf of\n  the Cryptix Development Team.  All rights reserved.\n");
        System.exit(0);
    }

    void run() {
        long l = System.currentTimeMillis();
        this.gen_plains("ecb_tbl.txt");
        gen_plains.notify("Java interpreter used: Version " + System.getProperty("java.version"));
        gen_plains.notify("Java Just-In-Time (JIT) compiler: " + System.getProperty("java.compiler"));
        gen_plains.notify("Total execution time (ms): " + (System.currentTimeMillis() - l));
        gen_plains.notify("During this time, " + this.cipherName + ":");
        gen_plains.notify("  Encrypted " + this.encBlocks + " blocks");
        gen_plains.notify("  Decrypted " + this.decBlocks + " blocks");
        gen_plains.notify("  Created " + this.keyCount + " session keys");
    }

    void gen_plains(String string) {
        File file = new File(this.destination, string);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(file), true);
        }
        catch (IOException iOException) {
            gen_plains.halt("Unable to initialize <" + string + "> as a Writer:\n" + iOException.getMessage());
        }
        printWriter.println();
        printWriter.println("=========================");
        printWriter.println();
        printWriter.println("FILENAME:  \"" + string + "\"");
        printWriter.println();
        printWriter.println("Electronic Codebook (ECB) Mode");
        printWriter.println("ECB tables (SB) Tests");
        printWriter.println();
        printWriter.println("Algorithm Name: " + this.cipherName);
        printWriter.println("Principal Submitter: <as stated on the submission cover sheet>");
        printWriter.println();
        try {
            int n = 0;
            while (n < this.keys.length) {
                this.forKey(this.keys[n], printWriter);
                ++n;
            }
        }
        catch (Exception exception) {
            gen_plains.halt("Exception encountered in a " + this.cipherName + "_Algorithm method:\n" + exception.getMessage());
        }
        printWriter.println("==========");
        printWriter.close();
    }

    void forKey(int n, PrintWriter printWriter) throws IllegalAccessException, InvocationTargetException {
        Object object;
        gen_plains.notify("Generating and testing Variable Text gen_plains (short); key size: " + n);
        Object[] objectArray = new Object[]{};
        byte[] byArray = new byte[n / 8];
        byte[] byArray2 = new byte[16];
        int n2 = 0;
        objectArray = new Object[]{byArray};
        Object object2 = object = this.makeKey.invoke(null, objectArray);
        try {
            object2 = Serpent_Standard.makeKey(byArray);
        }
        catch (Exception exception) {
            gen_plains.halt("Exception encountered in a " + this.cipherName + "_Algorithm method:\n" + exception.getMessage());
        }
        ++this.keyCount;
        printWriter.println("==========");
        printWriter.println();
        printWriter.println("KEYSIZE=" + n);
        printWriter.println();
        printWriter.println("KEY=" + gen_plains.toString(byArray));
        printWriter.println();
        objectArray = new Object[3];
        objectArray[1] = new Integer(0);
        objectArray[2] = object;
        int n3 = 0;
        while (n3 < 32) {
            int n4 = 0;
            while (n4 < 16) {
                printWriter.println("I=" + ++n2 + " Round=" + n3 + " Input value=" + n4);
                int n5 = 0;
                while (n5 < 16) {
                    byArray2[n5] = 0;
                    ++n5;
                }
                byArray2 = Serpent_Standard.blockDecryptGetP(n3, n4, 0, object2);
                printWriter.println("PT=" + gen_plains.toString(byArray2));
                objectArray[0] = byArray2;
                byte[] byArray3 = (byte[])this.encrypt.invoke(null, objectArray);
                ++this.encBlocks;
                printWriter.print("CT=" + gen_plains.toString(byArray3));
                objectArray[0] = byArray3;
                byte[] byArray4 = (byte[])this.decrypt.invoke(null, objectArray);
                ++this.decBlocks;
                if (!gen_plains.areEqual(byArray2, byArray4)) {
                    printWriter.print(" *** ERROR ***");
                }
                printWriter.println();
                printWriter.println();
                ++n4;
            }
            ++n3;
        }
    }

    private static boolean areEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static String toString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = n;
        int n3 = 0;
        while (n2 > 0) {
            byte by = byArray[--n2];
            cArray[n3++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }
}

