/*
 * Decompiled with CFR 0.152.
 */
package Serpent;

import Serpent.Serpent_Properties;
import java.io.PrintWriter;
import java.security.InvalidKeyException;

public final class Serpent_BitSlice {
    static final String NAME = "Serpent_BitSlice";
    static final boolean IN = true;
    static final boolean OUT = false;
    static final boolean DEBUG = false;
    static final int debuglevel = 0;
    static final PrintWriter err = null;
    static final boolean TRACE = Serpent_Properties.isTraceable("Serpent_Algorithm");
    static final int BLOCK_SIZE = 16;
    static final int ROUNDS = 32;
    static final int PHI = -1640531527;
    static final byte[][] Sbox = new byte[][]{{3, 8, 15, 1, 10, 6, 5, 11, 14, 13, 4, 2, 7, 0, 9, 12}, {15, 12, 2, 7, 9, 0, 5, 10, 1, 11, 14, 8, 6, 13, 3, 4}, {8, 6, 7, 9, 3, 12, 10, 15, 13, 1, 14, 4, 0, 11, 5, 2}, {0, 15, 11, 8, 12, 9, 6, 3, 13, 1, 2, 4, 10, 7, 5, 14}, {1, 15, 8, 3, 12, 0, 11, 6, 2, 5, 4, 10, 9, 14, 7, 13}, {15, 5, 2, 11, 4, 10, 9, 12, 0, 3, 14, 8, 13, 6, 7, 1}, {7, 2, 12, 5, 8, 4, 6, 11, 14, 9, 1, 15, 13, 3, 10, 0}, {1, 13, 15, 0, 14, 8, 2, 11, 7, 4, 12, 10, 9, 3, 5, 6}, {3, 8, 15, 1, 10, 6, 5, 11, 14, 13, 4, 2, 7, 0, 9, 12}, {15, 12, 2, 7, 9, 0, 5, 10, 1, 11, 14, 8, 6, 13, 3, 4}, {8, 6, 7, 9, 3, 12, 10, 15, 13, 1, 14, 4, 0, 11, 5, 2}, {0, 15, 11, 8, 12, 9, 6, 3, 13, 1, 2, 4, 10, 7, 5, 14}, {1, 15, 8, 3, 12, 0, 11, 6, 2, 5, 4, 10, 9, 14, 7, 13}, {15, 5, 2, 11, 4, 10, 9, 12, 0, 3, 14, 8, 13, 6, 7, 1}, {7, 2, 12, 5, 8, 4, 6, 11, 14, 9, 1, 15, 13, 3, 10, 0}, {1, 13, 15, 0, 14, 8, 2, 11, 7, 4, 12, 10, 9, 3, 5, 6}, {3, 8, 15, 1, 10, 6, 5, 11, 14, 13, 4, 2, 7, 0, 9, 12}, {15, 12, 2, 7, 9, 0, 5, 10, 1, 11, 14, 8, 6, 13, 3, 4}, {8, 6, 7, 9, 3, 12, 10, 15, 13, 1, 14, 4, 0, 11, 5, 2}, {0, 15, 11, 8, 12, 9, 6, 3, 13, 1, 2, 4, 10, 7, 5, 14}, {1, 15, 8, 3, 12, 0, 11, 6, 2, 5, 4, 10, 9, 14, 7, 13}, {15, 5, 2, 11, 4, 10, 9, 12, 0, 3, 14, 8, 13, 6, 7, 1}, {7, 2, 12, 5, 8, 4, 6, 11, 14, 9, 1, 15, 13, 3, 10, 0}, {1, 13, 15, 0, 14, 8, 2, 11, 7, 4, 12, 10, 9, 3, 5, 6}, {3, 8, 15, 1, 10, 6, 5, 11, 14, 13, 4, 2, 7, 0, 9, 12}, {15, 12, 2, 7, 9, 0, 5, 10, 1, 11, 14, 8, 6, 13, 3, 4}, {8, 6, 7, 9, 3, 12, 10, 15, 13, 1, 14, 4, 0, 11, 5, 2}, {0, 15, 11, 8, 12, 9, 6, 3, 13, 1, 2, 4, 10, 7, 5, 14}, {1, 15, 8, 3, 12, 0, 11, 6, 2, 5, 4, 10, 9, 14, 7, 13}, {15, 5, 2, 11, 4, 10, 9, 12, 0, 3, 14, 8, 13, 6, 7, 1}, {7, 2, 12, 5, 8, 4, 6, 11, 14, 9, 1, 15, 13, 3, 10, 0}, {1, 13, 15, 0, 14, 8, 2, 11, 7, 4, 12, 10, 9, 3, 5, 6}};
    static final byte[][] SboxInverse = new byte[][]{{13, 3, 11, 0, 10, 6, 5, 12, 1, 14, 4, 7, 15, 9, 8, 2}, {5, 8, 2, 14, 15, 6, 12, 3, 11, 4, 7, 9, 1, 13, 10, 0}, {12, 9, 15, 4, 11, 14, 1, 2, 0, 3, 6, 13, 5, 8, 10, 7}, {0, 9, 10, 7, 11, 14, 6, 13, 3, 5, 12, 2, 4, 8, 15, 1}, {5, 0, 8, 3, 10, 9, 7, 14, 2, 12, 11, 6, 4, 15, 13, 1}, {8, 15, 2, 9, 4, 1, 13, 14, 11, 6, 5, 3, 7, 12, 10, 0}, {15, 10, 1, 13, 5, 3, 6, 0, 4, 9, 14, 7, 2, 12, 8, 11}, {3, 0, 6, 13, 9, 14, 15, 8, 5, 12, 11, 7, 10, 1, 4, 2}, {13, 3, 11, 0, 10, 6, 5, 12, 1, 14, 4, 7, 15, 9, 8, 2}, {5, 8, 2, 14, 15, 6, 12, 3, 11, 4, 7, 9, 1, 13, 10, 0}, {12, 9, 15, 4, 11, 14, 1, 2, 0, 3, 6, 13, 5, 8, 10, 7}, {0, 9, 10, 7, 11, 14, 6, 13, 3, 5, 12, 2, 4, 8, 15, 1}, {5, 0, 8, 3, 10, 9, 7, 14, 2, 12, 11, 6, 4, 15, 13, 1}, {8, 15, 2, 9, 4, 1, 13, 14, 11, 6, 5, 3, 7, 12, 10, 0}, {15, 10, 1, 13, 5, 3, 6, 0, 4, 9, 14, 7, 2, 12, 8, 11}, {3, 0, 6, 13, 9, 14, 15, 8, 5, 12, 11, 7, 10, 1, 4, 2}, {13, 3, 11, 0, 10, 6, 5, 12, 1, 14, 4, 7, 15, 9, 8, 2}, {5, 8, 2, 14, 15, 6, 12, 3, 11, 4, 7, 9, 1, 13, 10, 0}, {12, 9, 15, 4, 11, 14, 1, 2, 0, 3, 6, 13, 5, 8, 10, 7}, {0, 9, 10, 7, 11, 14, 6, 13, 3, 5, 12, 2, 4, 8, 15, 1}, {5, 0, 8, 3, 10, 9, 7, 14, 2, 12, 11, 6, 4, 15, 13, 1}, {8, 15, 2, 9, 4, 1, 13, 14, 11, 6, 5, 3, 7, 12, 10, 0}, {15, 10, 1, 13, 5, 3, 6, 0, 4, 9, 14, 7, 2, 12, 8, 11}, {3, 0, 6, 13, 9, 14, 15, 8, 5, 12, 11, 7, 10, 1, 4, 2}, {13, 3, 11, 0, 10, 6, 5, 12, 1, 14, 4, 7, 15, 9, 8, 2}, {5, 8, 2, 14, 15, 6, 12, 3, 11, 4, 7, 9, 1, 13, 10, 0}, {12, 9, 15, 4, 11, 14, 1, 2, 0, 3, 6, 13, 5, 8, 10, 7}, {0, 9, 10, 7, 11, 14, 6, 13, 3, 5, 12, 2, 4, 8, 15, 1}, {5, 0, 8, 3, 10, 9, 7, 14, 2, 12, 11, 6, 4, 15, 13, 1}, {8, 15, 2, 9, 4, 1, 13, 14, 11, 6, 5, 3, 7, 12, 10, 0}, {15, 10, 1, 13, 5, 3, 6, 0, 4, 9, 14, 7, 2, 12, 8, 11}, {3, 0, 6, 13, 9, 14, 15, 8, 5, 12, 11, 7, 10, 1, 4, 2}};
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    static void debug(String string) {
        ((PrintWriter)null).println(">>> Serpent_BitSlice: " + string);
    }

    static void trace(boolean bl, String string) {
        if (TRACE) {
            ((PrintWriter)null).println(String.valueOf(bl ? "==> " : "<== ") + NAME + "." + string);
        }
    }

    static void trace(String string) {
        if (TRACE) {
            ((PrintWriter)null).println("<=> Serpent_BitSlice." + string);
        }
    }

    public static synchronized Object makeKey(byte[] byArray) throws InvalidKeyException {
        int n;
        int[] nArray = new int[132];
        int n2 = byArray.length / 4;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            nArray[n4] = byArray[n3++] & 0xFF | (byArray[n3++] & 0xFF) << 8 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 24;
            ++n4;
        }
        if (n4 < 8) {
            nArray[n4++] = 1;
        }
        n4 = 8;
        int n5 = 0;
        while (n4 < 16) {
            n = nArray[n5] ^ nArray[n4 - 5] ^ nArray[n4 - 3] ^ nArray[n4 - 1] ^ 0x9E3779B9 ^ n5++;
            nArray[n4] = n << 11 | n >>> 21;
            ++n4;
        }
        n4 = 0;
        n5 = 8;
        while (n4 < 8) {
            nArray[n4++] = nArray[n5++];
        }
        n2 = 132;
        while (n4 < n2) {
            n = nArray[n4 - 8] ^ nArray[n4 - 5] ^ nArray[n4 - 3] ^ nArray[n4 - 1] ^ 0x9E3779B9 ^ n4;
            nArray[n4] = n << 11 | n >>> 21;
            ++n4;
        }
        n4 = 0;
        while (n4 < 33) {
            int n6 = nArray[4 * n4];
            int n7 = nArray[4 * n4 + 1];
            int n8 = nArray[4 * n4 + 2];
            int n9 = nArray[4 * n4 + 3];
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            byte[] byArray2 = Sbox[(35 - n4) % 32];
            n5 = 0;
            while (n5 < 32) {
                byte by = byArray2[n6 >>> n5 & 1 | (n7 >>> n5 & 1) << 1 | (n8 >>> n5 & 1) << 2 | (n9 >>> n5 & 1) << 3];
                n13 |= (by & 1) << n5;
                n12 |= (by >>> 1 & 1) << n5;
                n11 |= (by >>> 2 & 1) << n5;
                n10 |= (by >>> 3 & 1) << n5;
                ++n5;
            }
            nArray[4 * n4] = n13;
            nArray[4 * n4 + 1] = n12;
            nArray[4 * n4 + 2] = n11;
            nArray[4 * n4 + 3] = n10;
            ++n4;
        }
        return nArray;
    }

    public static byte[] blockEncrypt(byte[] byArray, int n, Object object) {
        int[] nArray = (int[])object;
        int n2 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n3 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n4 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n5 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n6 = (n3 ^= nArray[1]) ^ (n4 ^= nArray[2]);
        int n7 = (n2 ^= nArray[0]) | (n5 ^= nArray[3]);
        int n8 = n2 ^ n3;
        int n9 = n7 ^ n6;
        int n10 = n4 | n9;
        int n11 = n2 ^ n5;
        int n12 = n3 | n4;
        int n13 = n5 & n10;
        int n14 = n8 & n12;
        int n15 = n14 ^ n13;
        int n16 = n14 & n15;
        int n17 = n4 ^ n5;
        int n18 = n12 ^ n16;
        int n19 = n3 & n11;
        int n20 = n11 ^ n18;
        int n21 = ~n20;
        int n22 = n21 ^ n19;
        int n23 = n17 ^ n22;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[4]) | (n5 ^= nArray[7]);
        n7 = (n4 ^= nArray[6]) ^ n5;
        n8 = ~(n3 ^= nArray[5]);
        int n24 = n2 ^ n4;
        n10 = n2 | n8;
        n11 = n5 & n24;
        n12 = n6 & n7;
        n13 = n3 | n11;
        n15 = n7 ^ n10;
        int n25 = n12 ^ n13;
        n16 = n6 ^ n25;
        n17 = n15 ^ n16;
        n18 = n3 & n5;
        n9 = ~n25;
        n23 = n18 ^ n17;
        int n26 = n25 | n23;
        n22 = n10 & n26;
        n21 = n4 ^ n22;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[8]) | (n4 ^= nArray[10]);
        n7 = n2 ^ (n3 ^= nArray[9]);
        n8 = (n5 ^= nArray[11]) ^ n6;
        n21 = n7 ^ n8;
        n10 = n4 ^ n21;
        n11 = n3 ^ n10;
        n12 = n3 | n10;
        n13 = n6 & n11;
        n14 = n8 ^ n12;
        n25 = n7 | n14;
        n23 = n25 ^ n13;
        n17 = n2 | n5;
        n18 = n14 ^ n23;
        n19 = n3 ^ n18;
        n9 = ~n14;
        n15 = n17 ^ n19;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[12]) ^ (n4 ^= nArray[14]);
        n7 = n2 | (n5 ^= nArray[15]);
        n8 = n2 & n5;
        n24 = n6 & n7;
        n10 = (n3 ^= nArray[13]) | n8;
        n11 = n2 & n3;
        n12 = n5 ^ n24;
        n13 = n4 | n11;
        n14 = n3 ^ n12;
        n25 = n5 & n10;
        n16 = n7 ^ n25;
        n9 = n13 ^ n14;
        n18 = n5 | n9;
        n19 = n2 | n12;
        n20 = n3 & n18;
        n15 = n13 ^ n16;
        n21 = n19 ^ n20;
        n23 = n10 ^ n24;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[16]) | (n3 ^= nArray[17]);
        n7 = n3 | (n4 ^= nArray[18]);
        n8 = n2 ^ n7;
        n24 = n3 ^ (n5 ^= nArray[19]);
        n10 = n5 | n8;
        n11 = n5 & n6;
        n9 = n8 ^ n11;
        n13 = n9 & n24;
        n14 = n24 & n10;
        n25 = n4 ^ n11;
        n16 = n3 & n4;
        n17 = n24 ^ n13;
        n18 = n16 | n8;
        n19 = n25 ^ n14;
        n20 = n2 & n10;
        n26 = n16 | n17;
        n15 = n18 ^ n13;
        n23 = n20 ^ n26;
        n21 = ~n19;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n3 ^= nArray[21]) ^ (n5 ^= nArray[23]);
        n7 = n3 | n5;
        n8 = (n2 ^= nArray[20]) & n6;
        n24 = (n4 ^= nArray[22]) ^ n7;
        n10 = n8 ^ n24;
        n21 = ~n10;
        n12 = n2 ^ n6;
        n13 = n5 | n21;
        n14 = n3 | n10;
        n25 = n5 ^ n13;
        n16 = n3 | n12;
        n17 = n8 | n21;
        n18 = n12 | n25;
        n19 = n6 ^ n16;
        n15 = n14 ^ n18;
        n23 = n12 ^ n13;
        n9 = n17 ^ n19;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[24]) & (n5 ^= nArray[27]);
        n7 = (n3 ^= nArray[25]) ^ (n4 ^= nArray[26]);
        n8 = n2 ^ n5;
        n24 = n6 ^ n7;
        n10 = n3 | n4;
        n23 = ~n24;
        n12 = n8 & n10;
        n13 = n3 & n23;
        n14 = n2 | n4;
        n25 = n12 ^ n13;
        n16 = n3 | n5;
        n17 = n4 ^ n16;
        n18 = n14 ^ n25;
        n15 = ~n18;
        n20 = n23 & n8;
        n9 = n17 ^ n12;
        n22 = n2 ^ n3;
        int n27 = n15 ^ n20;
        n21 = n22 ^ n27;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[28]) & (n4 ^= nArray[30]);
        n7 = ~(n5 ^= nArray[31]);
        n8 = n2 & n7;
        n24 = (n3 ^= nArray[29]) | n6;
        n10 = n2 & n3;
        n11 = n4 ^ n24;
        n9 = n8 ^ n11;
        n13 = n4 | n9;
        n14 = n5 | n10;
        n25 = n2 ^ n13;
        n16 = n24 & n9;
        n23 = n14 ^ n25;
        n18 = n3 ^ n23;
        n19 = n6 ^ n23;
        n20 = n4 ^ n10;
        n26 = n16 | n18;
        n22 = n7 | n19;
        n21 = n20 ^ n22;
        n15 = n2 ^ n26;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n3 ^= nArray[33]) ^ (n4 ^= nArray[34]);
        n7 = (n2 ^= nArray[32]) | (n5 ^= nArray[35]);
        n8 = n2 ^ n3;
        n9 = n7 ^ n6;
        n10 = n4 | n9;
        n11 = n2 ^ n5;
        n12 = n3 | n4;
        n13 = n5 & n10;
        n14 = n8 & n12;
        n15 = n14 ^ n13;
        n16 = n14 & n15;
        n17 = n4 ^ n5;
        n18 = n12 ^ n16;
        n19 = n3 & n11;
        n20 = n11 ^ n18;
        n21 = ~n20;
        n22 = n21 ^ n19;
        n23 = n17 ^ n22;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[36]) | (n5 ^= nArray[39]);
        n7 = (n4 ^= nArray[38]) ^ n5;
        n8 = ~(n3 ^= nArray[37]);
        n24 = n2 ^ n4;
        n10 = n2 | n8;
        n11 = n5 & n24;
        n12 = n6 & n7;
        n13 = n3 | n11;
        n15 = n7 ^ n10;
        n25 = n12 ^ n13;
        n16 = n6 ^ n25;
        n17 = n15 ^ n16;
        n18 = n3 & n5;
        n9 = ~n25;
        n23 = n18 ^ n17;
        n26 = n25 | n23;
        n22 = n10 & n26;
        n21 = n4 ^ n22;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[40]) | (n4 ^= nArray[42]);
        n7 = n2 ^ (n3 ^= nArray[41]);
        n8 = (n5 ^= nArray[43]) ^ n6;
        n21 = n7 ^ n8;
        n10 = n4 ^ n21;
        n11 = n3 ^ n10;
        n12 = n3 | n10;
        n13 = n6 & n11;
        n14 = n8 ^ n12;
        n25 = n7 | n14;
        n23 = n25 ^ n13;
        n17 = n2 | n5;
        n18 = n14 ^ n23;
        n19 = n3 ^ n18;
        n9 = ~n14;
        n15 = n17 ^ n19;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[44]) ^ (n4 ^= nArray[46]);
        n7 = n2 | (n5 ^= nArray[47]);
        n8 = n2 & n5;
        n24 = n6 & n7;
        n10 = (n3 ^= nArray[45]) | n8;
        n11 = n2 & n3;
        n12 = n5 ^ n24;
        n13 = n4 | n11;
        n14 = n3 ^ n12;
        n25 = n5 & n10;
        n16 = n7 ^ n25;
        n9 = n13 ^ n14;
        n18 = n5 | n9;
        n19 = n2 | n12;
        n20 = n3 & n18;
        n15 = n13 ^ n16;
        n21 = n19 ^ n20;
        n23 = n10 ^ n24;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[48]) | (n3 ^= nArray[49]);
        n7 = n3 | (n4 ^= nArray[50]);
        n8 = n2 ^ n7;
        n24 = n3 ^ (n5 ^= nArray[51]);
        n10 = n5 | n8;
        n11 = n5 & n6;
        n9 = n8 ^ n11;
        n13 = n9 & n24;
        n14 = n24 & n10;
        n25 = n4 ^ n11;
        n16 = n3 & n4;
        n17 = n24 ^ n13;
        n18 = n16 | n8;
        n19 = n25 ^ n14;
        n20 = n2 & n10;
        n26 = n16 | n17;
        n15 = n18 ^ n13;
        n23 = n20 ^ n26;
        n21 = ~n19;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n3 ^= nArray[53]) ^ (n5 ^= nArray[55]);
        n7 = n3 | n5;
        n8 = (n2 ^= nArray[52]) & n6;
        n24 = (n4 ^= nArray[54]) ^ n7;
        n10 = n8 ^ n24;
        n21 = ~n10;
        n12 = n2 ^ n6;
        n13 = n5 | n21;
        n14 = n3 | n10;
        n25 = n5 ^ n13;
        n16 = n3 | n12;
        n17 = n8 | n21;
        n18 = n12 | n25;
        n19 = n6 ^ n16;
        n15 = n14 ^ n18;
        n23 = n12 ^ n13;
        n9 = n17 ^ n19;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[56]) & (n5 ^= nArray[59]);
        n7 = (n3 ^= nArray[57]) ^ (n4 ^= nArray[58]);
        n8 = n2 ^ n5;
        n24 = n6 ^ n7;
        n10 = n3 | n4;
        n23 = ~n24;
        n12 = n8 & n10;
        n13 = n3 & n23;
        n14 = n2 | n4;
        n25 = n12 ^ n13;
        n16 = n3 | n5;
        n17 = n4 ^ n16;
        n18 = n14 ^ n25;
        n15 = ~n18;
        n20 = n23 & n8;
        n9 = n17 ^ n12;
        n22 = n2 ^ n3;
        n27 = n15 ^ n20;
        n21 = n22 ^ n27;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[60]) & (n4 ^= nArray[62]);
        n7 = ~(n5 ^= nArray[63]);
        n8 = n2 & n7;
        n24 = (n3 ^= nArray[61]) | n6;
        n10 = n2 & n3;
        n11 = n4 ^ n24;
        n9 = n8 ^ n11;
        n13 = n4 | n9;
        n14 = n5 | n10;
        n25 = n2 ^ n13;
        n16 = n24 & n9;
        n23 = n14 ^ n25;
        n18 = n3 ^ n23;
        n19 = n6 ^ n23;
        n20 = n4 ^ n10;
        n26 = n16 | n18;
        n22 = n7 | n19;
        n21 = n20 ^ n22;
        n15 = n2 ^ n26;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n3 ^= nArray[65]) ^ (n4 ^= nArray[66]);
        n7 = (n2 ^= nArray[64]) | (n5 ^= nArray[67]);
        n8 = n2 ^ n3;
        n9 = n7 ^ n6;
        n10 = n4 | n9;
        n11 = n2 ^ n5;
        n12 = n3 | n4;
        n13 = n5 & n10;
        n14 = n8 & n12;
        n15 = n14 ^ n13;
        n16 = n14 & n15;
        n17 = n4 ^ n5;
        n18 = n12 ^ n16;
        n19 = n3 & n11;
        n20 = n11 ^ n18;
        n21 = ~n20;
        n22 = n21 ^ n19;
        n23 = n17 ^ n22;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[68]) | (n5 ^= nArray[71]);
        n7 = (n4 ^= nArray[70]) ^ n5;
        n8 = ~(n3 ^= nArray[69]);
        n24 = n2 ^ n4;
        n10 = n2 | n8;
        n11 = n5 & n24;
        n12 = n6 & n7;
        n13 = n3 | n11;
        n15 = n7 ^ n10;
        n25 = n12 ^ n13;
        n16 = n6 ^ n25;
        n17 = n15 ^ n16;
        n18 = n3 & n5;
        n9 = ~n25;
        n23 = n18 ^ n17;
        n26 = n25 | n23;
        n22 = n10 & n26;
        n21 = n4 ^ n22;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[72]) | (n4 ^= nArray[74]);
        n7 = n2 ^ (n3 ^= nArray[73]);
        n8 = (n5 ^= nArray[75]) ^ n6;
        n21 = n7 ^ n8;
        n10 = n4 ^ n21;
        n11 = n3 ^ n10;
        n12 = n3 | n10;
        n13 = n6 & n11;
        n14 = n8 ^ n12;
        n25 = n7 | n14;
        n23 = n25 ^ n13;
        n17 = n2 | n5;
        n18 = n14 ^ n23;
        n19 = n3 ^ n18;
        n9 = ~n14;
        n15 = n17 ^ n19;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[76]) ^ (n4 ^= nArray[78]);
        n7 = n2 | (n5 ^= nArray[79]);
        n8 = n2 & n5;
        n24 = n6 & n7;
        n10 = (n3 ^= nArray[77]) | n8;
        n11 = n2 & n3;
        n12 = n5 ^ n24;
        n13 = n4 | n11;
        n14 = n3 ^ n12;
        n25 = n5 & n10;
        n16 = n7 ^ n25;
        n9 = n13 ^ n14;
        n18 = n5 | n9;
        n19 = n2 | n12;
        n20 = n3 & n18;
        n15 = n13 ^ n16;
        n21 = n19 ^ n20;
        n23 = n10 ^ n24;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[80]) | (n3 ^= nArray[81]);
        n7 = n3 | (n4 ^= nArray[82]);
        n8 = n2 ^ n7;
        n24 = n3 ^ (n5 ^= nArray[83]);
        n10 = n5 | n8;
        n11 = n5 & n6;
        n9 = n8 ^ n11;
        n13 = n9 & n24;
        n14 = n24 & n10;
        n25 = n4 ^ n11;
        n16 = n3 & n4;
        n17 = n24 ^ n13;
        n18 = n16 | n8;
        n19 = n25 ^ n14;
        n20 = n2 & n10;
        n26 = n16 | n17;
        n15 = n18 ^ n13;
        n23 = n20 ^ n26;
        n21 = ~n19;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n3 ^= nArray[85]) ^ (n5 ^= nArray[87]);
        n7 = n3 | n5;
        n8 = (n2 ^= nArray[84]) & n6;
        n24 = (n4 ^= nArray[86]) ^ n7;
        n10 = n8 ^ n24;
        n21 = ~n10;
        n12 = n2 ^ n6;
        n13 = n5 | n21;
        n14 = n3 | n10;
        n25 = n5 ^ n13;
        n16 = n3 | n12;
        n17 = n8 | n21;
        n18 = n12 | n25;
        n19 = n6 ^ n16;
        n15 = n14 ^ n18;
        n23 = n12 ^ n13;
        n9 = n17 ^ n19;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[88]) & (n5 ^= nArray[91]);
        n7 = (n3 ^= nArray[89]) ^ (n4 ^= nArray[90]);
        n8 = n2 ^ n5;
        n24 = n6 ^ n7;
        n10 = n3 | n4;
        n23 = ~n24;
        n12 = n8 & n10;
        n13 = n3 & n23;
        n14 = n2 | n4;
        n25 = n12 ^ n13;
        n16 = n3 | n5;
        n17 = n4 ^ n16;
        n18 = n14 ^ n25;
        n15 = ~n18;
        n20 = n23 & n8;
        n9 = n17 ^ n12;
        n22 = n2 ^ n3;
        n27 = n15 ^ n20;
        n21 = n22 ^ n27;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[92]) & (n4 ^= nArray[94]);
        n7 = ~(n5 ^= nArray[95]);
        n8 = n2 & n7;
        n24 = (n3 ^= nArray[93]) | n6;
        n10 = n2 & n3;
        n11 = n4 ^ n24;
        n9 = n8 ^ n11;
        n13 = n4 | n9;
        n14 = n5 | n10;
        n25 = n2 ^ n13;
        n16 = n24 & n9;
        n23 = n14 ^ n25;
        n18 = n3 ^ n23;
        n19 = n6 ^ n23;
        n20 = n4 ^ n10;
        n26 = n16 | n18;
        n22 = n7 | n19;
        n21 = n20 ^ n22;
        n15 = n2 ^ n26;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n3 ^= nArray[97]) ^ (n4 ^= nArray[98]);
        n7 = (n2 ^= nArray[96]) | (n5 ^= nArray[99]);
        n8 = n2 ^ n3;
        n9 = n7 ^ n6;
        n10 = n4 | n9;
        n11 = n2 ^ n5;
        n12 = n3 | n4;
        n13 = n5 & n10;
        n14 = n8 & n12;
        n15 = n14 ^ n13;
        n16 = n14 & n15;
        n17 = n4 ^ n5;
        n18 = n12 ^ n16;
        n19 = n3 & n11;
        n20 = n11 ^ n18;
        n21 = ~n20;
        n22 = n21 ^ n19;
        n23 = n17 ^ n22;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[100]) | (n5 ^= nArray[103]);
        n7 = (n4 ^= nArray[102]) ^ n5;
        n8 = ~(n3 ^= nArray[101]);
        n24 = n2 ^ n4;
        n10 = n2 | n8;
        n11 = n5 & n24;
        n12 = n6 & n7;
        n13 = n3 | n11;
        n15 = n7 ^ n10;
        n25 = n12 ^ n13;
        n16 = n6 ^ n25;
        n17 = n15 ^ n16;
        n18 = n3 & n5;
        n9 = ~n25;
        n23 = n18 ^ n17;
        n26 = n25 | n23;
        n22 = n10 & n26;
        n21 = n4 ^ n22;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[104]) | (n4 ^= nArray[106]);
        n7 = n2 ^ (n3 ^= nArray[105]);
        n8 = (n5 ^= nArray[107]) ^ n6;
        n21 = n7 ^ n8;
        n10 = n4 ^ n21;
        n11 = n3 ^ n10;
        n12 = n3 | n10;
        n13 = n6 & n11;
        n14 = n8 ^ n12;
        n25 = n7 | n14;
        n23 = n25 ^ n13;
        n17 = n2 | n5;
        n18 = n14 ^ n23;
        n19 = n3 ^ n18;
        n9 = ~n14;
        n15 = n17 ^ n19;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[108]) ^ (n4 ^= nArray[110]);
        n7 = n2 | (n5 ^= nArray[111]);
        n8 = n2 & n5;
        n24 = n6 & n7;
        n10 = (n3 ^= nArray[109]) | n8;
        n11 = n2 & n3;
        n12 = n5 ^ n24;
        n13 = n4 | n11;
        n14 = n3 ^ n12;
        n25 = n5 & n10;
        n16 = n7 ^ n25;
        n9 = n13 ^ n14;
        n18 = n5 | n9;
        n19 = n2 | n12;
        n20 = n3 & n18;
        n15 = n13 ^ n16;
        n21 = n19 ^ n20;
        n23 = n10 ^ n24;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[112]) | (n3 ^= nArray[113]);
        n7 = n3 | (n4 ^= nArray[114]);
        n8 = n2 ^ n7;
        n24 = n3 ^ (n5 ^= nArray[115]);
        n10 = n5 | n8;
        n11 = n5 & n6;
        n9 = n8 ^ n11;
        n13 = n9 & n24;
        n14 = n24 & n10;
        n25 = n4 ^ n11;
        n16 = n3 & n4;
        n17 = n24 ^ n13;
        n18 = n16 | n8;
        n19 = n25 ^ n14;
        n20 = n2 & n10;
        n26 = n16 | n17;
        n15 = n18 ^ n13;
        n23 = n20 ^ n26;
        n21 = ~n19;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n3 ^= nArray[117]) ^ (n5 ^= nArray[119]);
        n7 = n3 | n5;
        n8 = (n2 ^= nArray[116]) & n6;
        n24 = (n4 ^= nArray[118]) ^ n7;
        n10 = n8 ^ n24;
        n21 = ~n10;
        n12 = n2 ^ n6;
        n13 = n5 | n21;
        n14 = n3 | n10;
        n25 = n5 ^ n13;
        n16 = n3 | n12;
        n17 = n8 | n21;
        n18 = n12 | n25;
        n19 = n6 ^ n16;
        n15 = n14 ^ n18;
        n23 = n12 ^ n13;
        n9 = n17 ^ n19;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[120]) & (n5 ^= nArray[123]);
        n7 = (n3 ^= nArray[121]) ^ (n4 ^= nArray[122]);
        n8 = n2 ^ n5;
        n24 = n6 ^ n7;
        n10 = n3 | n4;
        n23 = ~n24;
        n12 = n8 & n10;
        n13 = n3 & n23;
        n14 = n2 | n4;
        n25 = n12 ^ n13;
        n16 = n3 | n5;
        n17 = n4 ^ n16;
        n18 = n14 ^ n25;
        n15 = ~n18;
        n20 = n23 & n8;
        n9 = n17 ^ n12;
        n22 = n2 ^ n3;
        n27 = n15 ^ n20;
        n21 = n22 ^ n27;
        n2 = n21 << 13 | n21 >>> 19;
        n4 = n15 << 3 | n15 >>> 29;
        n3 = n23 ^ n2 ^ n4;
        n5 = n9 ^ n4 ^ n2 << 3;
        n3 = n3 << 1 | n3 >>> 31;
        n5 = n5 << 7 | n5 >>> 25;
        n2 = n2 ^ n3 ^ n5;
        n4 = n4 ^ n5 ^ n3 << 7;
        n2 = n2 << 5 | n2 >>> 27;
        n4 = n4 << 22 | n4 >>> 10;
        n6 = (n2 ^= nArray[124]) & (n4 ^= nArray[126]);
        n7 = ~(n5 ^= nArray[127]);
        n8 = n2 & n7;
        n24 = (n3 ^= nArray[125]) | n6;
        n10 = n2 & n3;
        n11 = n4 ^ n24;
        n9 = n8 ^ n11;
        n13 = n4 | n9;
        n14 = n5 | n10;
        n25 = n2 ^ n13;
        n16 = n24 & n9;
        n23 = n14 ^ n25;
        n18 = n3 ^ n23;
        n19 = n6 ^ n23;
        n20 = n4 ^ n10;
        n26 = n16 | n18;
        n22 = n7 | n19;
        n21 = n20 ^ n22;
        n15 = n2 ^ n26;
        n2 = n21;
        n3 = n23;
        n4 = n15;
        n5 = n9;
        byte[] byArray2 = new byte[]{(byte)(n2 ^= nArray[128]), (byte)(n2 >>> 8), (byte)(n2 >>> 16), (byte)(n2 >>> 24), (byte)(n3 ^= nArray[129]), (byte)(n3 >>> 8), (byte)(n3 >>> 16), (byte)(n3 >>> 24), (byte)(n4 ^= nArray[130]), (byte)(n4 >>> 8), (byte)(n4 >>> 16), (byte)(n4 >>> 24), (byte)(n5 ^= nArray[131]), (byte)(n5 >>> 8), (byte)(n5 >>> 16), (byte)(n5 >>> 24)};
        return byArray2;
    }

    public static byte[] blockDecrypt(byte[] byArray, int n, Object object) {
        int[] nArray = (int[])object;
        int n2 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n3 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n4 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n5 = byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 24;
        int n6 = (n2 ^= nArray[128]) & (n3 ^= nArray[129]);
        int n7 = n2 | n3;
        int n8 = (n4 ^= nArray[130]) | n6;
        int n9 = (n5 ^= nArray[131]) & n7;
        int n10 = n8 ^ n9;
        int n11 = n3 ^ n9;
        int n12 = n5 ^ n10;
        int n13 = ~n12;
        int n14 = n11 | n13;
        int n15 = n3 ^ n5;
        int n16 = n2 | n5;
        int n17 = n2 ^ n14;
        int n18 = n4 ^ n11;
        int n19 = n4 & n16;
        int n20 = n5 | n17;
        int n21 = n6 | n15;
        int n22 = n18 ^ n20;
        int n23 = n19 ^ n21;
        n4 = (n23 ^= nArray[126]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[124]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[127]) ^ (n17 ^= nArray[125]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n2 ^ n4;
        n7 = ~n4;
        n8 = n3 & n6;
        n9 = n3 | n7;
        int n24 = n5 | n8;
        n11 = n3 ^ n5;
        n12 = n2 & n9;
        n13 = n2 | n7;
        n14 = n12 ^ n24;
        n17 = n11 ^ n13;
        n22 = ~n14;
        int n25 = n3 & n22;
        n18 = n6 & n24;
        n19 = n6 ^ n25;
        n20 = n12 ^ n18;
        n21 = n5 | n7;
        int n26 = n2 ^ n17;
        n10 = n26 ^ n20;
        n23 = n21 ^ n19;
        n4 = (n23 ^= nArray[122]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[120]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[123]) ^ (n17 ^= nArray[121]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n2 & n5;
        n7 = n4 ^ n6;
        n8 = n2 ^ n5;
        n9 = n3 & n7;
        n24 = n2 & n4;
        n22 = n8 ^ n9;
        n12 = n2 & n22;
        n13 = n6 ^ n22;
        n14 = n3 | n24;
        n15 = ~n3;
        n17 = n13 ^ n14;
        n25 = n15 | n12;
        n18 = n22 | n17;
        n10 = n7 ^ n25;
        n20 = n7 ^ n18;
        n21 = n3 ^ n5;
        n23 = n21 ^ n20;
        n4 = (n23 ^= nArray[118]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[116]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[119]) ^ (n17 ^= nArray[117]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n3 | n5;
        n7 = n4 | n5;
        n8 = n2 & n6;
        n9 = n3 ^ n7;
        n24 = n4 ^ n5;
        n11 = ~n8;
        n12 = n2 & n9;
        n17 = n24 ^ n12;
        n14 = n17 | n11;
        n15 = n2 ^ n12;
        n16 = n6 ^ n14;
        n25 = n5 ^ n9;
        n18 = n4 | n15;
        n10 = n8 ^ n25;
        n20 = n2 ^ n9;
        n23 = n16 ^ n18;
        n22 = n20 ^ n14;
        n4 = (n23 ^= nArray[114]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[112]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[115]) ^ (n17 ^= nArray[113]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n4 | n5;
        n7 = n2 | n5;
        n8 = n4 ^ n7;
        n9 = n3 ^ n7;
        n24 = n2 ^ n5;
        n11 = n9 & n8;
        n12 = n3 & n6;
        n23 = n24 ^ n11;
        n14 = n2 ^ n8;
        n22 = n12 ^ n8;
        n16 = n22 | n24;
        n25 = n14 & n16;
        n18 = n2 & n23;
        n19 = n6 ^ n24;
        n17 = n3 ^ n25;
        n21 = n3 | n18;
        n10 = n19 ^ n21;
        n4 = (n23 ^= nArray[110]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[108]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[111]) ^ (n17 ^= nArray[109]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n2 ^ n5;
        n7 = n4 ^ n5;
        n8 = n2 & n4;
        n9 = n3 | n7;
        n22 = n6 ^ n9;
        n11 = n2 | n4;
        n12 = n5 | n22;
        n13 = ~n5;
        n14 = n3 & n11;
        n15 = n13 | n8;
        n16 = n3 & n12;
        n25 = n11 & n7;
        n10 = n14 ^ n15;
        n17 = n25 ^ n16;
        n20 = n4 & n10;
        n21 = n22 ^ n17;
        n26 = n15 ^ n20;
        n23 = n21 ^ n26;
        n4 = (n23 ^= nArray[106]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[104]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[107]) ^ (n17 ^= nArray[105]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n2 ^ n3;
        n7 = n3 | n5;
        n8 = n2 & n4;
        n9 = n4 ^ n7;
        n24 = n2 | n9;
        n11 = n6 & n24;
        n12 = n5 | n8;
        n13 = n3 ^ n11;
        n14 = n12 ^ n11;
        n15 = n9 | n8;
        n16 = n5 & n13;
        n23 = ~n14;
        n17 = n15 ^ n16;
        n19 = n2 | n23;
        n20 = n11 ^ n17;
        n10 = n6 ^ n9;
        n26 = n4 ^ n20;
        n22 = n19 ^ n26;
        n4 = (n23 ^= nArray[102]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[100]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[103]) ^ (n17 ^= nArray[101]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n4 ^ n5;
        n7 = n2 | n3;
        n8 = n3 | n4;
        n9 = n4 & n6;
        n24 = n7 ^ n6;
        n11 = n2 | n9;
        n23 = ~n24;
        n13 = n3 ^ n5;
        n14 = n8 & n13;
        n15 = n5 | n23;
        n17 = n14 ^ n11;
        n25 = n2 | n24;
        n18 = n17 ^ n25;
        n19 = n8 ^ n15;
        n20 = n2 ^ n4;
        n10 = n19 ^ n18;
        n26 = n24 & n18;
        int n27 = n19 | n26;
        n22 = n20 ^ n27;
        n4 = (n23 ^= nArray[98]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[96]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[99]) ^ (n17 ^= nArray[97]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n2 & n3;
        n7 = n2 | n3;
        n8 = n4 | n6;
        n9 = n5 & n7;
        n10 = n8 ^ n9;
        n11 = n3 ^ n9;
        n12 = n5 ^ n10;
        n13 = ~n12;
        n14 = n11 | n13;
        n15 = n3 ^ n5;
        n16 = n2 | n5;
        n17 = n2 ^ n14;
        n18 = n4 ^ n11;
        n19 = n4 & n16;
        n20 = n5 | n17;
        n21 = n6 | n15;
        n22 = n18 ^ n20;
        n23 = n19 ^ n21;
        n4 = (n23 ^= nArray[94]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[92]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[95]) ^ (n17 ^= nArray[93]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n2 ^ n4;
        n7 = ~n4;
        n8 = n3 & n6;
        n9 = n3 | n7;
        n24 = n5 | n8;
        n11 = n3 ^ n5;
        n12 = n2 & n9;
        n13 = n2 | n7;
        n14 = n12 ^ n24;
        n17 = n11 ^ n13;
        n22 = ~n14;
        n25 = n3 & n22;
        n18 = n6 & n24;
        n19 = n6 ^ n25;
        n20 = n12 ^ n18;
        n21 = n5 | n7;
        n26 = n2 ^ n17;
        n10 = n26 ^ n20;
        n23 = n21 ^ n19;
        n4 = (n23 ^= nArray[90]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[88]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[91]) ^ (n17 ^= nArray[89]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n2 & n5;
        n7 = n4 ^ n6;
        n8 = n2 ^ n5;
        n9 = n3 & n7;
        n24 = n2 & n4;
        n22 = n8 ^ n9;
        n12 = n2 & n22;
        n13 = n6 ^ n22;
        n14 = n3 | n24;
        n15 = ~n3;
        n17 = n13 ^ n14;
        n25 = n15 | n12;
        n18 = n22 | n17;
        n10 = n7 ^ n25;
        n20 = n7 ^ n18;
        n21 = n3 ^ n5;
        n23 = n21 ^ n20;
        n4 = (n23 ^= nArray[86]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[84]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[87]) ^ (n17 ^= nArray[85]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n3 | n5;
        n7 = n4 | n5;
        n8 = n2 & n6;
        n9 = n3 ^ n7;
        n24 = n4 ^ n5;
        n11 = ~n8;
        n12 = n2 & n9;
        n17 = n24 ^ n12;
        n14 = n17 | n11;
        n15 = n2 ^ n12;
        n16 = n6 ^ n14;
        n25 = n5 ^ n9;
        n18 = n4 | n15;
        n10 = n8 ^ n25;
        n20 = n2 ^ n9;
        n23 = n16 ^ n18;
        n22 = n20 ^ n14;
        n4 = (n23 ^= nArray[82]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[80]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[83]) ^ (n17 ^= nArray[81]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n4 | n5;
        n7 = n2 | n5;
        n8 = n4 ^ n7;
        n9 = n3 ^ n7;
        n24 = n2 ^ n5;
        n11 = n9 & n8;
        n12 = n3 & n6;
        n23 = n24 ^ n11;
        n14 = n2 ^ n8;
        n22 = n12 ^ n8;
        n16 = n22 | n24;
        n25 = n14 & n16;
        n18 = n2 & n23;
        n19 = n6 ^ n24;
        n17 = n3 ^ n25;
        n21 = n3 | n18;
        n10 = n19 ^ n21;
        n4 = (n23 ^= nArray[78]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[76]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[79]) ^ (n17 ^= nArray[77]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n2 ^ n5;
        n7 = n4 ^ n5;
        n8 = n2 & n4;
        n9 = n3 | n7;
        n22 = n6 ^ n9;
        n11 = n2 | n4;
        n12 = n5 | n22;
        n13 = ~n5;
        n14 = n3 & n11;
        n15 = n13 | n8;
        n16 = n3 & n12;
        n25 = n11 & n7;
        n10 = n14 ^ n15;
        n17 = n25 ^ n16;
        n20 = n4 & n10;
        n21 = n22 ^ n17;
        n26 = n15 ^ n20;
        n23 = n21 ^ n26;
        n4 = (n23 ^= nArray[74]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[72]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[75]) ^ (n17 ^= nArray[73]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n2 ^ n3;
        n7 = n3 | n5;
        n8 = n2 & n4;
        n9 = n4 ^ n7;
        n24 = n2 | n9;
        n11 = n6 & n24;
        n12 = n5 | n8;
        n13 = n3 ^ n11;
        n14 = n12 ^ n11;
        n15 = n9 | n8;
        n16 = n5 & n13;
        n23 = ~n14;
        n17 = n15 ^ n16;
        n19 = n2 | n23;
        n20 = n11 ^ n17;
        n10 = n6 ^ n9;
        n26 = n4 ^ n20;
        n22 = n19 ^ n26;
        n4 = (n23 ^= nArray[70]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[68]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[71]) ^ (n17 ^= nArray[69]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n4 ^ n5;
        n7 = n2 | n3;
        n8 = n3 | n4;
        n9 = n4 & n6;
        n24 = n7 ^ n6;
        n11 = n2 | n9;
        n23 = ~n24;
        n13 = n3 ^ n5;
        n14 = n8 & n13;
        n15 = n5 | n23;
        n17 = n14 ^ n11;
        n25 = n2 | n24;
        n18 = n17 ^ n25;
        n19 = n8 ^ n15;
        n20 = n2 ^ n4;
        n10 = n19 ^ n18;
        n26 = n24 & n18;
        n27 = n19 | n26;
        n22 = n20 ^ n27;
        n4 = (n23 ^= nArray[66]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[64]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[67]) ^ (n17 ^= nArray[65]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n2 & n3;
        n7 = n2 | n3;
        n8 = n4 | n6;
        n9 = n5 & n7;
        n10 = n8 ^ n9;
        n11 = n3 ^ n9;
        n12 = n5 ^ n10;
        n13 = ~n12;
        n14 = n11 | n13;
        n15 = n3 ^ n5;
        n16 = n2 | n5;
        n17 = n2 ^ n14;
        n18 = n4 ^ n11;
        n19 = n4 & n16;
        n20 = n5 | n17;
        n21 = n6 | n15;
        n22 = n18 ^ n20;
        n23 = n19 ^ n21;
        n4 = (n23 ^= nArray[62]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[60]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[63]) ^ (n17 ^= nArray[61]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n2 ^ n4;
        n7 = ~n4;
        n8 = n3 & n6;
        n9 = n3 | n7;
        n24 = n5 | n8;
        n11 = n3 ^ n5;
        n12 = n2 & n9;
        n13 = n2 | n7;
        n14 = n12 ^ n24;
        n17 = n11 ^ n13;
        n22 = ~n14;
        n25 = n3 & n22;
        n18 = n6 & n24;
        n19 = n6 ^ n25;
        n20 = n12 ^ n18;
        n21 = n5 | n7;
        n26 = n2 ^ n17;
        n10 = n26 ^ n20;
        n23 = n21 ^ n19;
        n4 = (n23 ^= nArray[58]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[56]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[59]) ^ (n17 ^= nArray[57]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n2 & n5;
        n7 = n4 ^ n6;
        n8 = n2 ^ n5;
        n9 = n3 & n7;
        n24 = n2 & n4;
        n22 = n8 ^ n9;
        n12 = n2 & n22;
        n13 = n6 ^ n22;
        n14 = n3 | n24;
        n15 = ~n3;
        n17 = n13 ^ n14;
        n25 = n15 | n12;
        n18 = n22 | n17;
        n10 = n7 ^ n25;
        n20 = n7 ^ n18;
        n21 = n3 ^ n5;
        n23 = n21 ^ n20;
        n4 = (n23 ^= nArray[54]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[52]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[55]) ^ (n17 ^= nArray[53]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n3 | n5;
        n7 = n4 | n5;
        n8 = n2 & n6;
        n9 = n3 ^ n7;
        n24 = n4 ^ n5;
        n11 = ~n8;
        n12 = n2 & n9;
        n17 = n24 ^ n12;
        n14 = n17 | n11;
        n15 = n2 ^ n12;
        n16 = n6 ^ n14;
        n25 = n5 ^ n9;
        n18 = n4 | n15;
        n10 = n8 ^ n25;
        n20 = n2 ^ n9;
        n23 = n16 ^ n18;
        n22 = n20 ^ n14;
        n4 = (n23 ^= nArray[50]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[48]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[51]) ^ (n17 ^= nArray[49]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n4 | n5;
        n7 = n2 | n5;
        n8 = n4 ^ n7;
        n9 = n3 ^ n7;
        n24 = n2 ^ n5;
        n11 = n9 & n8;
        n12 = n3 & n6;
        n23 = n24 ^ n11;
        n14 = n2 ^ n8;
        n22 = n12 ^ n8;
        n16 = n22 | n24;
        n25 = n14 & n16;
        n18 = n2 & n23;
        n19 = n6 ^ n24;
        n17 = n3 ^ n25;
        n21 = n3 | n18;
        n10 = n19 ^ n21;
        n4 = (n23 ^= nArray[46]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[44]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[47]) ^ (n17 ^= nArray[45]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n2 ^ n5;
        n7 = n4 ^ n5;
        n8 = n2 & n4;
        n9 = n3 | n7;
        n22 = n6 ^ n9;
        n11 = n2 | n4;
        n12 = n5 | n22;
        n13 = ~n5;
        n14 = n3 & n11;
        n15 = n13 | n8;
        n16 = n3 & n12;
        n25 = n11 & n7;
        n10 = n14 ^ n15;
        n17 = n25 ^ n16;
        n20 = n4 & n10;
        n21 = n22 ^ n17;
        n26 = n15 ^ n20;
        n23 = n21 ^ n26;
        n4 = (n23 ^= nArray[42]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[40]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[43]) ^ (n17 ^= nArray[41]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n2 ^ n3;
        n7 = n3 | n5;
        n8 = n2 & n4;
        n9 = n4 ^ n7;
        n24 = n2 | n9;
        n11 = n6 & n24;
        n12 = n5 | n8;
        n13 = n3 ^ n11;
        n14 = n12 ^ n11;
        n15 = n9 | n8;
        n16 = n5 & n13;
        n23 = ~n14;
        n17 = n15 ^ n16;
        n19 = n2 | n23;
        n20 = n11 ^ n17;
        n10 = n6 ^ n9;
        n26 = n4 ^ n20;
        n22 = n19 ^ n26;
        n4 = (n23 ^= nArray[38]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[36]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[39]) ^ (n17 ^= nArray[37]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n4 ^ n5;
        n7 = n2 | n3;
        n8 = n3 | n4;
        n9 = n4 & n6;
        n24 = n7 ^ n6;
        n11 = n2 | n9;
        n23 = ~n24;
        n13 = n3 ^ n5;
        n14 = n8 & n13;
        n15 = n5 | n23;
        n17 = n14 ^ n11;
        n25 = n2 | n24;
        n18 = n17 ^ n25;
        n19 = n8 ^ n15;
        n20 = n2 ^ n4;
        n10 = n19 ^ n18;
        n26 = n24 & n18;
        n27 = n19 | n26;
        n22 = n20 ^ n27;
        n4 = (n23 ^= nArray[34]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[32]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[35]) ^ (n17 ^= nArray[33]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n2 & n3;
        n7 = n2 | n3;
        n8 = n4 | n6;
        n9 = n5 & n7;
        n10 = n8 ^ n9;
        n11 = n3 ^ n9;
        n12 = n5 ^ n10;
        n13 = ~n12;
        n14 = n11 | n13;
        n15 = n3 ^ n5;
        n16 = n2 | n5;
        n17 = n2 ^ n14;
        n18 = n4 ^ n11;
        n19 = n4 & n16;
        n20 = n5 | n17;
        n21 = n6 | n15;
        n22 = n18 ^ n20;
        n23 = n19 ^ n21;
        n4 = (n23 ^= nArray[30]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[28]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[31]) ^ (n17 ^= nArray[29]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n2 ^ n4;
        n7 = ~n4;
        n8 = n3 & n6;
        n9 = n3 | n7;
        n24 = n5 | n8;
        n11 = n3 ^ n5;
        n12 = n2 & n9;
        n13 = n2 | n7;
        n14 = n12 ^ n24;
        n17 = n11 ^ n13;
        n22 = ~n14;
        n25 = n3 & n22;
        n18 = n6 & n24;
        n19 = n6 ^ n25;
        n20 = n12 ^ n18;
        n21 = n5 | n7;
        n26 = n2 ^ n17;
        n10 = n26 ^ n20;
        n23 = n21 ^ n19;
        n4 = (n23 ^= nArray[26]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[24]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[27]) ^ (n17 ^= nArray[25]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n2 & n5;
        n7 = n4 ^ n6;
        n8 = n2 ^ n5;
        n9 = n3 & n7;
        n24 = n2 & n4;
        n22 = n8 ^ n9;
        n12 = n2 & n22;
        n13 = n6 ^ n22;
        n14 = n3 | n24;
        n15 = ~n3;
        n17 = n13 ^ n14;
        n25 = n15 | n12;
        n18 = n22 | n17;
        n10 = n7 ^ n25;
        n20 = n7 ^ n18;
        n21 = n3 ^ n5;
        n23 = n21 ^ n20;
        n4 = (n23 ^= nArray[22]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[20]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[23]) ^ (n17 ^= nArray[21]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n3 | n5;
        n7 = n4 | n5;
        n8 = n2 & n6;
        n9 = n3 ^ n7;
        n24 = n4 ^ n5;
        n11 = ~n8;
        n12 = n2 & n9;
        n17 = n24 ^ n12;
        n14 = n17 | n11;
        n15 = n2 ^ n12;
        n16 = n6 ^ n14;
        n25 = n5 ^ n9;
        n18 = n4 | n15;
        n10 = n8 ^ n25;
        n20 = n2 ^ n9;
        n23 = n16 ^ n18;
        n22 = n20 ^ n14;
        n4 = (n23 ^= nArray[18]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[16]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[19]) ^ (n17 ^= nArray[17]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n4 | n5;
        n7 = n2 | n5;
        n8 = n4 ^ n7;
        n9 = n3 ^ n7;
        n24 = n2 ^ n5;
        n11 = n9 & n8;
        n12 = n3 & n6;
        n23 = n24 ^ n11;
        n14 = n2 ^ n8;
        n22 = n12 ^ n8;
        n16 = n22 | n24;
        n25 = n14 & n16;
        n18 = n2 & n23;
        n19 = n6 ^ n24;
        n17 = n3 ^ n25;
        n21 = n3 | n18;
        n10 = n19 ^ n21;
        n4 = (n23 ^= nArray[14]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[12]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[15]) ^ (n17 ^= nArray[13]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n2 ^ n5;
        n7 = n4 ^ n5;
        n8 = n2 & n4;
        n9 = n3 | n7;
        n22 = n6 ^ n9;
        n11 = n2 | n4;
        n12 = n5 | n22;
        n13 = ~n5;
        n14 = n3 & n11;
        n15 = n13 | n8;
        n16 = n3 & n12;
        n25 = n11 & n7;
        n10 = n14 ^ n15;
        n17 = n25 ^ n16;
        n20 = n4 & n10;
        n21 = n22 ^ n17;
        n26 = n15 ^ n20;
        n23 = n21 ^ n26;
        n4 = (n23 ^= nArray[10]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[8]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[11]) ^ (n17 ^= nArray[9]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n2 ^ n3;
        n7 = n3 | n5;
        n8 = n2 & n4;
        n9 = n4 ^ n7;
        n24 = n2 | n9;
        n11 = n6 & n24;
        n12 = n5 | n8;
        n13 = n3 ^ n11;
        n14 = n12 ^ n11;
        n15 = n9 | n8;
        n16 = n5 & n13;
        n23 = ~n14;
        n17 = n15 ^ n16;
        n19 = n2 | n23;
        n20 = n11 ^ n17;
        n10 = n6 ^ n9;
        n26 = n4 ^ n20;
        n22 = n19 ^ n26;
        n4 = (n23 ^= nArray[6]) << 10 | n23 >>> 22;
        n2 = (n22 ^= nArray[4]) << 27 | n22 >>> 5;
        n4 = n4 ^ (n10 ^= nArray[7]) ^ (n17 ^= nArray[5]) << 7;
        n2 = n2 ^ n17 ^ n10;
        n5 = n10 << 25 | n10 >>> 7;
        n3 = n17 << 31 | n17 >>> 1;
        n5 = n5 ^ n4 ^ n2 << 3;
        n3 = n3 ^ n2 ^ n4;
        n4 = n4 << 29 | n4 >>> 3;
        n2 = n2 << 19 | n2 >>> 13;
        n6 = n4 ^ n5;
        n7 = n2 | n3;
        n8 = n3 | n4;
        n9 = n4 & n6;
        n24 = n7 ^ n6;
        n11 = n2 | n9;
        n23 = ~n24;
        n13 = n3 ^ n5;
        n14 = n8 & n13;
        n15 = n5 | n23;
        n17 = n14 ^ n11;
        n25 = n2 | n24;
        n18 = n17 ^ n25;
        n19 = n8 ^ n15;
        n20 = n2 ^ n4;
        n10 = n19 ^ n18;
        n26 = n24 & n18;
        n27 = n19 | n26;
        n2 = n22 = n20 ^ n27;
        n3 = n17;
        n4 = n23;
        n5 = n10;
        byte[] byArray2 = new byte[]{(byte)(n2 ^= nArray[0]), (byte)(n2 >>> 8), (byte)(n2 >>> 16), (byte)(n2 >>> 24), (byte)(n3 ^= nArray[1]), (byte)(n3 >>> 8), (byte)(n3 >>> 16), (byte)(n3 >>> 24), (byte)(n4 ^= nArray[2]), (byte)(n4 >>> 8), (byte)(n4 >>> 16), (byte)(n4 >>> 24), (byte)(n5 ^= nArray[3]), (byte)(n5 >>> 8), (byte)(n5 >>> 16), (byte)(n5 >>> 24)};
        return byArray2;
    }

    private static final boolean areEqual(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static final String intToString(int n) {
        char[] cArray = new char[8];
        int n2 = 7;
        while (n2 >= 0) {
            cArray[n2] = HEX_DIGITS[n & 0xF];
            n >>>= 4;
            --n2;
        }
        return new String(cArray);
    }

    private static final String toString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n * 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byte by = byArray[n2++];
            cArray[n3++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[by & 0xF];
        }
        return new String(cArray);
    }

    private static final String toString(int[] nArray) {
        int n = nArray.length;
        char[] cArray = new char[n * 8];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = nArray[n2];
            cArray[n3++] = HEX_DIGITS[n4 >>> 28 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 24 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 20 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 16 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 12 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 8 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 >>> 4 & 0xF];
            cArray[n3++] = HEX_DIGITS[n4 & 0xF];
            ++n2;
        }
        return new String(cArray);
    }
}

