/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/*   (c) 1993.  The Regents of the University of California.  All rights   */
/*   reserved.                                                             */
/*                                                                         */
/*   This work was produced at the University of California, Lawrence      */
/*   Livermore National Laboratory (UC LLNL) under contract no.            */
/*   W-7405-ENG-48 (Contract 48) between the U.S. Department of Energy     */
/*   (DOE) and The Regents of the University of California (University)    */
/*   for the operation of UC LLNL.  Copyright is reserved to the           */
/*   University for purposes of controlled dissemination,                  */
/*   commercialization through formal licensing, or other disposition      */
/*   under terms of Contract 48; DOE policies, regulations and orders;     */
/*   and U.S. statutes.  The rights of the Federal Government are          */
/*   reserved under Contract 48 subject to the restrictions agreed upon    */
/*   by the DOE and University.                                            */
/*                                                                         */
/*                                                                         */
/*                              DISCLAIMER                                 */
/*                                                                         */
/*   This software was prepared as an account of work sponsored by an      */
/*   agency of the United States Government.  Neither the United States    */
/*   Government nor the University of California nor any of their          */
/*   employees, makes any warranty, express or implied, or assumes any     */
/*   liability or responsibility for the accuracy, completeness, or        */
/*   usefulness of any information, apparatus, product, or process         */
/*   disclosed, or represents that its specific commercial products,       */
/*   process, or service by trade name, trademark, manufacturer, or        */
/*   otherwise, does not necessarily constitute or imply its               */
/*   endorsement, recommendation, or favoring by the United States         */
/*   Government or the University of California. The views and opinions    */
/*   of the authors expressed herein do not necessarily state or reflect   */
/*   those of the United States Government or the University of            */
/*   California, and shall not be used for advertising or product          */
/*   endorsement purposes.                                                 */
/*                                                                         */
/*   Permission to use, copy, modify and distribute this software and its  */
/*   documentation for any non-commercial purpose, without fee, is         */
/*   hereby granted, provided that the above copyright notice and this     */
/*   permission notice appear in all copies of the software and            */
/*   supporting documentation, and that all UC LLNL identification in      */
/*   the user interface remain unchanged.  The title to copyright LLNL     */
/*   XFTP shall at all times remain with The Regents of the University     */
/*   of California and users agree to preserve same. Users seeking the     */
/*   right to make derivative works with LLNL XFTP for commercial          */
/*   purposes may obtain a license from the Lawrence Livermore National    */
/*   Laboratory's Technology Transfer Office, P.O. Box 808, L-795,         */
/*   Livermore, CA 94550.                                                  */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/

#include <stdio.h>
#include <sys/param.h>
#include <Xm/Xm.h>
#include "xftp.h"
#include "xfer.h"

extern struct st_host_info hinfo[];
extern int max_ftp_retries;
extern int diagnostics;
extern struct del_ctrl_block del_ctrl;
extern int beep_when_ops_done;


/*
 * clean_up_zap_ctrl - Clean up the control structure used by the Zap
 *                     work proc.
 */
clean_up_zap_ctrl()
{
    struct entry_link *ptr;

    while (del_ctrl.head[0]) {
        XtFree(del_ctrl.head[0]->entry);
        ptr = del_ctrl.head[0];
        del_ctrl.head[0] = del_ctrl.head[0]->next;
        XtFree((char *)ptr);
    }
}


/*
 * cb_zap_entries - Work proc for zapping directory entries.
 */
cb_zap_entries()
{
    struct entry_link *ptr;
    char *path;
    char msg[MAXPATHLEN+40];

    /* Are we done? */
    if (del_ctrl.head[0] == NULL)
        goto done;

    /* Did user push abort button? */
    if (mp_abort_requested()) {
        hide_abort_dialog();
        warning_error("Deletions(s) aborted");
        goto done;
    }

    /* Let user know where we are */
    update_mp_monitor(del_ctrl.head[0]->entry);

    /* Create full path */
    path = XtMalloc(strlen(hinfo[del_ctrl.host].wd)
        +strlen(del_ctrl.head[0]->entry)+2);
    strcpy(path, hinfo[del_ctrl.host].wd);
    strcat(path, "/");
    strcat(path, del_ctrl.head[0]->entry);

    /* Zap entry */
    switch (remote_zap(del_ctrl.host, path)) {
    case -3:
    	XtFree(path);
        goto lost;
    case -1:
        switch (remote_delete(del_ctrl.host, path, True)) {
        case -3:
    		XtFree(path);
			goto lost;
        case -1:
            sprintf(msg, "Unable to delete %s", del_ctrl.head[0]->entry);
            warning_error(msg);
            break;
        case 0:
            if (diagnostics >= NORMAL) {
                sprintf(msg, "*** Successfully deleted:  %s\n",
					del_ctrl.head[0]->entry);
                write_log(msg);
            }
        }
        break;
    case 0:
        if (diagnostics >= NORMAL) {
            sprintf(msg, "*** Successfully deleted:  %s\n",
				del_ctrl.head[0]->entry);
            write_log(msg);
        }
    }
    XtFree(path);
    ptr = del_ctrl.head[0];
    del_ctrl.head[0] = del_ctrl.head[0]->next;
    XtFree(ptr->entry);
    XtFree((char *)ptr);
    return False;

done:

    clean_up_zap_ctrl();
    hide_mp_monitor();
	if (mp_abort_requested())
		hide_abort_dialog();
    enable_controls(True);
    if (update_dir_displays(del_ctrl.host, False) < 0)
        goto lost;
    update_xfer_controls();
    update_host_controls(del_ctrl.host);
    if (beep_when_ops_done)
        beep();
    restore_prev_cursor();
    return True;

lost:

    clean_up_zap_ctrl();
    hide_mp_monitor();
	if (mp_abort_requested())
		hide_abort_dialog();
    enable_controls(True);
    clear_selected_entries(del_ctrl.host);
    restore_prev_cursor();
    lost_connection(del_ctrl.host);
    if (beep_when_ops_done)
        beep();
    return True;
}


/*
 * remote_zap - Zap file/directory from remote host.  "host" is
 *              the host id.  Returns 0 if successful, -3 for
 *              broken connection, and -1 for other errors.
 */
remote_zap(host, path)
int host;
char *path;
{
    char reply[MAXFTPREPLY];
    char cmd[MAXPATHLEN+6];
    int code;
	int retries = 0;
	int scode;

retry:

    /* Send ZAP command to FTP server */
    sprintf(cmd, "ZAP %s", path);
    if (send_ftp_cmd(host, cmd) < 0)
        return -1;

    /* Get response from FTP server */
	scode = get_ftp_reply(host, reply, MAXFTPREPLY, &code, MAXT, True);
    switch (scode) {
    case 2:
        return 0;
    case 4:
        if (code >= 450 && code < 460 && retries++ < max_ftp_retries) {
			if (diagnostics >= VERBOSE)
				write_log("*** \"Zap\" failed.  Will retry.\n");
            goto retry;
        }
		if (diagnostics < VERBOSE)
			print_ftp_reply(host, reply);
        return -1;
    case -3:
        return -3;
    case -2:
        report_client_timeout(host);
    default:
		if (scode > 0 && diagnostics < VERBOSE && code != 550)
			print_ftp_reply(host, reply);
        return -1;
    }
}

