/*
 * Written by Dan Heller.  Copyright 1991, O'Reilly && Associates.
 * This program is freely distributable without licensing fees and
 * is provided without guarantee or warrantee expressed or implied.
 * This program is -not- in the public domain.
 *
 * This routine is a slightly modified version of the ForceUpdate()
 * function listed in Chapter 20 of Heller's "Motif Programming Manual".
 *
 * This function is a superset of XmUpdateDisplay() in that it will
 * ensure that a window's contents are visible before returning.
 * The monitoring of window states is necessary because attempts to
 * map a window is subject to the whim of the window manager -- this
 * introduces a significant delay before the window is actually mapped
 * and exposed.
 *
 * This function is intended to be called after XtPopup(), XtManageChild()
 * or XMapRaised() on a widget (or window, for XMapRaised()).  Don't use
 * this for other situations as it might sit and process other unrelated
 * events until the widget becomes visible.
 */

#include <Xm/Xm.h>


force_update(w)
Widget w;  /* This widget must be visible before the function returns */
{
	Widget diashell, topshell;
	Window diawindow, topwindow;
	XtAppContext cxt = XtWidgetToApplicationContext(w);
	Display *dpy;
	XWindowAttributes xwa;
	XEvent event;

	/* Locate the shell we are interested in */
	for (diashell=w; !XtIsShell(diashell); diashell=XtParent(diashell))
		;

	/* Locate its primary window's shell (which may be the same) */
	for (topshell = diashell; !XtIsTopLevelShell(topshell);
    		topshell = XtParent(topshell))
    	;

	/* If the dialog shell (or its primary shell window) is not realized,
	 * don't bother ... nothing can possibly happen
	 */
	if (XtIsRealized(diashell) && XtIsRealized(topshell)) {
		dpy = XtDisplay(topshell);
		diawindow = XtWindow(diashell);
		topwindow = XtWindow(topshell);

		/* Wait for the dialog to be mapped.  It's guaranteed to become so */
		while (XGetWindowAttributes(dpy, diawindow, &xwa),
			xwa.map_state != IsViewable) {

			/* ...if the primary is (or becomes) unviewable or unmapped,
			 * it's probably iconic, and nothing will happen.
			 */
			if (XGetWindowAttributes(dpy, topwindow, &xwa) &&
				xwa.map_state != IsViewable)
				break;

			/* we are guaranteed there will be an event of some kind */
			XtAppNextEvent(cxt, &event);
			XtDispatchEvent(&event);
		}
	}

	/* The next XSync() will get an expose event */
	XmUpdateDisplay(topshell);
}

