		/* display.c - a xview previer for xyplot */
		/*  ronnie@goshawk.lanl.gov 1992 */

#define YES	(1)
#define NO	(0)

#include <ctype.h>
#include <X11/Xlib.h>
#include <xview/xview.h>
#include <xview/frame.h>
#include <xview/canvas.h>
#include <xview/win_event.h>
#include <xview/xv_xrect.h>
#include <xview/svrimage.h>
#include <xview/icon.h>

typedef struct coordinate {
	int x,y;
} coordinate;


float Scale;			/* how to rescale the fixed coordinates */
int Width, Height;		/* dimensions of the canvas */
Frame RootFrame;		/* the root frame */
FILE *DataFile;			/* the temporary file with the data */
char *Prog;
int Erase = -1;			/* how many times to erase */
int Page = 0;			/* which page to draw */

short i_image[] = {
#include "display.icon"
};

main(ac,av)
char *av[];
int ac;
{
	Frame frame;
	Canvas canvas;
	Server_image icon_image;
	Icon icon;
	void paint(),pressed();

	xv_init(XV_INIT_ARGC_PTR_ARGV,&ac,av,NULL);
	Prog = av[0];
	
	frame = (Frame) xv_create(NULL,FRAME,
		XV_WIDTH, 450,
		XV_HEIGHT, 400,
		FRAME_LABEL,Prog,	/* display program name */
		NULL);
	
	RootFrame = frame;

	canvas = (Canvas) xv_create(frame,
		CANVAS,
		CANVAS_REPAINT_PROC, paint,
		CANVAS_X_PAINT_WINDOW, TRUE,
		NULL);

	icon_image = (Server_image) xv_create(NULL, SERVER_IMAGE,
		XV_WIDTH, 64,
		XV_HEIGHT, 64,
		SERVER_IMAGE_BITS, i_image,
		NULL);
	
	icon = (Icon) xv_create(frame, ICON,
		ICON_TRANSPARENT, TRUE,
		ICON_IMAGE, icon_image,
		NULL);
	xv_set(frame, FRAME_ICON, icon, NULL);

	xv_set(canvas_paint_window(canvas),
		WIN_EVENT_PROC, pressed,
		WIN_CONSUME_EVENTS,
		   WIN_MOUSE_BUTTONS, NULL,
		NULL);

	xv_main_loop(frame);
	exit(0);
}


void
paint(canvas,win,dpy,xwin,area)
Canvas canvas;
Xv_window win;
Display *dpy;
Window xwin;
Xv_xrectlist *area;
{
	extern float Scale;
	extern int Width,Height;
	GC gc;
	coordinate lleft,uright,current,center,start;
	int code,drawing,eread;
	char label[256],dashes[20];
	char *getstring();
	static int once=NO;

	gc = DefaultGC(dpy,DefaultScreen(dpy));
	Width = (int) xv_get(win,XV_WIDTH);
	Height = (int) xv_get(win,XV_HEIGHT);
	Scale = (Width>Height) ? Height : Width;
	XClearWindow(dpy,xwin);

    eread = 0;
    if (Page==0) drawing = YES; else drawing = NO;
    while( (code = getletter()) != EOF)
    switch(code)
        {
        case 'e':                               /* clear screen */
		if (!once) ++Erase;
		++eread;
		if (eread==Page) drawing=YES; else drawing= NO;
                break;
        case 's':
                getcoord(&lleft);               /* set up space area */
                getcoord(&uright);
                break;
        case 'm': 
                getcoord(&current);             /* read in current point */
                break;
        case 'p':
                getcoord(&current);             /* plot a point */
		if (drawing) 
			XDrawPoint(dpy,xwin,gc,current.x,current.y);
                break;
        case 'l':  
                getcoord(&current);             /* plot a line  */
                /* continue into case 'n' */
        case 'n':                   
                getcoord(&start);         /* line from current to next*/
		if (drawing)
		     XDrawLine(dpy,xwin,gc,current.x,current.y,start.x,start.y);
		current=start;
                break;
        case 't':      
		/* will not work with input method */
                getstring(label);     /* put a label in the graph */
                break;
        case 'a':                               /* draw an arc */
                getcoord(&center);
                getcoord(&start);
                getcoord(&start);
                break;
        case 'c':                               /* draw a circle */
                getcoord(&center);
                break;
        case 'f':
                getstring(label);                    /* change linestyle */
                if(strncmp(label,"solid",5)==0) {
			XSetLineAttributes(
			     dpy,gc,0,LineSolid,CapButt,JoinMiter);
		}
                else if(strncmp(label,"dotted",6)==0) {
			dashes[0]= 1; dashes[1]=3;
			XSetDashes(dpy,gc,0,dashes,2);
			XSetLineAttributes(
			     dpy,gc,0,LineOnOffDash,CapButt,JoinMiter);
                } 
                else if(strncmp(label,"shortdashed",11)==0) {
			dashes[0]= 5; dashes[1]=5;
			XSetDashes(dpy,gc,0,dashes,2);
			XSetLineAttributes(
			     dpy,gc,0,LineOnOffDash,CapButt,JoinMiter);
                } 
                else if(strncmp(label,"longdashed",10)==0) {
			dashes[0]= 10; dashes[1]=3;
			XSetDashes(dpy,gc,0,dashes,2);
			XSetLineAttributes(
			     dpy,gc,0,LineOnOffDash,CapButt,JoinMiter);
                } 
                else if(strncmp(label,"dotdashed",9)==0) {
			dashes[0]= 1; dashes[1]=2;dashes[2]=3;dashes[3]=2;
			XSetDashes(dpy,gc,0,dashes,4);
			XSetLineAttributes(
			     dpy,gc,0,LineOnOffDash,CapButt,JoinMiter);
                } 
                else if(strncmp(label,"dashdotdotted",13)==0) {
			dashes[0]= 3; dashes[1]=2;dashes[2]=1;dashes[3]=2;
			dashes[4]=5;
			XSetDashes(dpy,gc,0,dashes,5);
			XSetLineAttributes(
			     dpy,gc,0,LineOnOffDash,CapButt,JoinMiter);
                } 
                break;
        default:
                fprintf(stderr,"%s:  Unknown Code: %c\n",Prog,code);
    }

    once = YES;  /* the routine has been called once */
}


void
pressed(win,ev,arg)
Xv_window win;
Event *ev;
Notify_arg arg;
{
	/* hack to see if it is in window */
	if (   event_x(ev) < 0 || event_x(ev) > (int)xv_get(win,XV_WIDTH) ||
	       event_y(ev) < 0 || event_y(ev) > (int)xv_get(win,XV_HEIGHT)
	) return;
	/* if inside continue */

	if (event_action(ev) == ACTION_SELECT && event_is_up(ev)) {
		if (Erase) {
			/* clear the xv_window */
			XClearWindow(
				XV_DISPLAY_FROM_WINDOW(win),
				(Window) xv_get(win, XV_XID)
			);
			--Erase;
			++Page;
			/* repaint the canvas */
			paint( (Canvas) NULL,
			    win,
			    XV_DISPLAY_FROM_WINDOW(win),
			    (Window) xv_get(win, XV_XID),
			    (Xv_xrectlist *) NULL);
		} else 
			xv_destroy_safe(RootFrame);
	}
}

getcoord(point)
coordinate *point;
{
	int a, b, c, d;
	float x,y;
	extern float Scale;
	extern int Width, Height;

	a = getletter();
	b = getletter();
	c = getletter();
	d = getletter();


	x = (b<<8 | a)/4096.0*Scale;
	y = Height - (d<<8 | c)/4096.0*Scale; 
	point->x = (int)x;
	point->y = (int)y;
}

getint()
{
	int a, b;

	a = getletter();
	b = getletter();

	return( b << 8 | a);
}

getletter()
{
	static int reading = NO;
	static int ReadOnce = NO;
	int c;

	if (ReadOnce) {
		c = getc(DataFile);
		if (c != EOF ) return(c);
		else {
			rewind(DataFile);
			return(c);
		}
	} else if (reading) {
		c=getc(stdin);
		if (c != EOF) {
			putc(c,DataFile);
			return(c);
		} else {
			ReadOnce = YES;
			rewind(DataFile);
			return(EOF);
		}
	} else {
		DataFile = tmpfile();
		if (DataFile == NULL) {
		   fprintf(stderr,"%s: Cannot open data file\n",Prog);
		   xv_destroy_safe(RootFrame);
		}
		reading = YES;
		return(getletter());
	}
}

char *
getstring(s)
char *s;
{
	char *a;

	a = s;
	while( (*s=getletter()) && *s != EOF && *s != '\n' && isprint(*s)) ++s;
	if (*s == EOF || !isprint(*s)) a=NULL ; else *s = '\0';
	return(a);
}
