
/*

________________________________________________________________

        invertHisto
        $Id: invertHisto.c,v 1.16 1995/08/23 14:55:40 svein Exp $
        Copyright 1990, Blab, UiO
        Image processing lab, Department of Informatics
        University of Oslo
        E-mail: blab@ifi.uio.no
________________________________________________________________
  
  Permission to use, copy, modify and distribute this software and its
  documentation for any purpose and without fee is hereby granted, 
  provided that this copyright notice appear in all copies and that 
  both that copyright notice and this permission notice appear in supporting
  documentation and that the name of B-lab, Department of Informatics or
  University of Oslo not be used in advertising or publicity pertaining 
  to distribution of the software without specific, written prior permission.

  B-LAB DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL B-LAB
  BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
  OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

*/

static char *Id = "$Id: invertHisto.c,v 1.16 1995/08/23 14:55:40 svein Exp $, Blab, UiO";



#include <xite/includes.h>
#include <xite/blab.h>
#include <xite/biff.h>
#include <xite/histo.h>

/*F:invertHisto*

________________________________________________________________

		invertHisto
________________________________________________________________

Name:		invertHisto - invert a histogram transformation

Syntax:         | #include <xite/histo.h>
                |
                | void invertHisto( histogram histo,
                |    histogram invHisto );
Description:    Invert a scaled cumulative histogram - calculate
                the histogram that has approximately the inverse
                effect used as histogram transformation.  'scal-
                ed' implies all values in the interval [0..255].
                Input and output may NOT be identical.

                | histo - input scaled cumulative histogram
                | invHisto - output inverted transformation

Return value:

Author:		Tor L|nnestad

Id:             $Id: invertHisto.c,v 1.16 1995/08/23 14:55:40 svein Exp $
________________________________________________________________
*/

#ifndef FUNCPROTO
void invertHisto(histo,invHisto)
  histogram histo,invHisto;
#else /* FUNCPROTO */
void invertHisto(int *histo, int *invHisto)
#endif /* FUNCPROTO */
{
  int n;
  for (n=0; n LE 255; invHisto[n ++] = 0);
  for (n=0; n LE 255; n++) invHisto[histo[n]] = n;
  for (n=1; n LE 255; n++)
    if (invHisto[n] == 0) invHisto[n] = invHisto[n-1];
}

