%{
#include "bezier.h"

extern int     atoi();
extern double  atof();

extern Tokenval  tokenval;
extern FILE     *bezier_file;
%}
%%

"bezier_patches:"       {return PATCHES;}
"bezier_curves:"        {return CURVES;}
"vertices:"             {return NVERTICES;}
"patches:"              {return NPATCHES;}
"curves:"               {return NCURVES;}
"vertex_list:"          {return VERTEX_LIST;}
"patch_list:"           {return PATCH_LIST;}
"curve_list:"           {return CURVE_LIST;}

-?[0-9]+                {tokenval.intval = atoi(yytext);
                         return INTEGER;
                        }
-?[0-9]+"."[0-9]*([eE][-+]?[0-9]+)?  {tokenval.floatval = atof(yytext);
                                      return FLOAT;
                                     }

[ \n\t]                 {}
#.*$                    { /* This is a comment */ }
.                       { return yytext[0]; /* We found something wrong */ }

%%

int
yywrap()
{
    return 1;
}
