#include <stdio.h>

#include <sipp.h>
#include <primitives.h>


#define RESOLUTION 9

Surf_desc teapot_surf = {
    0.4, 
    0.5,
    0.1, 
    {0.9, 0.6, 0.6}
};


main(argc, argv)
    int argc;
    char **argv;
{
    Object  *teapot;
    Object  *handle;
    Object  *spout;
    Object  *body;
    Object  *lid;
    FILE    *infile;
    int      siz;
    FILE    *image;

    if (argc > 1) {
        siz = atoi(argv[1]);
    } else {
        siz = 256;
    }

    sipp_init();

    infile = fopen("tpt_handle.bez", "r");
    handle = sipp_bezier(infile, RESOLUTION, &teapot_surf, basic_shader);
    fclose(infile);

    infile = fopen("tpt_spout.bez", "r");
    spout = sipp_bezier(infile, RESOLUTION, &teapot_surf, basic_shader);
    fclose(infile);

    infile = fopen("tpt_body.bez", "r");
    body = sipp_bezier(infile, RESOLUTION, &teapot_surf, basic_shader);
    fclose(infile);

    infile = fopen("tpt_lid.bez", "r");
    lid = sipp_bezier(infile, RESOLUTION, &teapot_surf, basic_shader);
    fclose(infile);

    teapot = object_create();
    object_add_subobj(teapot, body);
    object_add_subobj(teapot, lid);
    object_add_subobj(teapot, handle);
    object_add_subobj(teapot, spout);

    object_install(teapot);

    lightsource_push(1.0, 1.0, 1.0, 1.0);
/*    lightsource_push(-1.0, 1.0, -1.0, 1.0);*/
    view_from(0.75, 1.5, 3.5);
    view_at(0.0, 0.4, 0.0);
    view_up(0.0, 1.0, 0.0);
    view_focal(0.25);
    image = fopen("teapot.ppm", "w");
    render_image(siz, siz, image);
}
