#ifndef lint
static       char    rcsid[] = "$Header: insert.c,v 1.2 90/12/12 15:30:21 zhang Exp $";
#endif

/*
 * $Log:	insert.c,v $
 * 
 * Revision 1.1  90/06/17  03:34:51  zhang
 * Initial revision
 * 
 * Revision 1.2  90/12/12  15:30:21  zhang
 * Add backend for RADIANCE output
 */

#include "defs.h"

/*
 * an INSERT does not have thickness, but it has extrusion
 */

/*
 * the data structure for INSERT is defined in defs.h
 */

#ifdef	NEVER_DEFINED
typedef	struct	insert	{
	INT	attribflag;		/* attributes follow flag, default 0 */
	CHAR	*blockname;		/* block name */ 
					 * used when the block */
	BLOCK	*block;			/* pointer to the block */
	FLOAT	point[3];		/* insertion point */
	FLOAT	xscale;			/* X scale factor, default 1 */
	FLOAT	yscale;			/* Y scale factor, default 1 */
	FLOAT	zscale;			/* Z scale factor, default 1 */
	FLOAT	angle;			/* rotation angle, default 0 */
	INT	columncount;		/* repeat column counts, default 1 */
	FLOAT	columnspace;		/* repeat column spacing, default 0 */
	INT	rowcount;		/* repeat row counts, default 1 */
	FLOAT	rowspace;		/* repeat column spacing, default 0 */
/*	ATTRIB	*attriblist		 * attributes list, if any *
					 * not used now */
} INSERT;
#endif

/*
 * parse an INSERT
 */

ENTITY	*InsertDxfParse(layerlist)
LAYER	**layerlist;
{
	ENTITY	*entity;
	INSERT	*insert;
	OPTIONS	*seqendoptions;
	INT	attribset = 0;
	INT	nameset = 0;
	INT	pointset = 0;
	INT	xscaleset = 0;
	INT	yscaleset = 0;
	INT	zscaleset = 0;
	INT	angleset = 0;
	INT	columncountset = 0;
	INT	columnspaceset = 0;
	INT	rowcountset = 0;
	INT	rowspaceset = 0;
	INT	defaultflag = 0;

	entity = Malloc(ENTITY, 1);
	insert = Malloc(INSERT, 1);
	entity->type = ENTITY_INSERT;
	entity->data = (VOID *) insert;

	entity->layer = LayerDxfParse(layerlist);

	insert->attribflag = 0;
	insert->xscale = 1.0;
	insert->yscale = 1.0;
	insert->zscale = 1.0;
	insert->angle = 0.0;
	insert->columncount = 1;
	insert->columnspace = 0.0;
	insert->rowcount = 1;
	insert->rowspace = 0.0;

	/*
	 * not used now
	 * insert->attrib = NULL;
	 */

	do {
		GetNextGroup();
		switch(Group->code) {
		case 2:
			/*
			 * block name
			 */

			if (nameset != 0)
				DXFERR("duplicated block name for an INSERT %s", "\n");

			nameset = 1;
			insert->block = BlockSearch(Group->string);
			if (insert->block == NULL) {

				/*
				 * save block name for later processing
				 * during output
				 */

				insert->blockname = Malloc(CHAR,
						strlen(Group->string) + 1);
				(VOID) strcpy(insert->blockname, Group->string);
			}

			break;

		case 66:
			/*
			 * attributes follow flag
			 */

			if (attribset != 0)
				DXFERR("duplicated attributes follow flag for an INSERT %s", "\n");

			attribset = 1;
			insert->attribflag = Group->intnum;
			break;

		case 10:
			/*
			 * insert point
			 * 10, 20, 30
			 */

			if (pointset != 0)
				DXFERR("duplicated insertion point for an INSERT %s", "\n");

			pointset = 1;
			CoordDxfParse(0, insert->point);
			break;

		case 41:
			/*
			 * X scale factor
			 */

			if (xscaleset != 0)
				DXFERR("duplicated X scale factor for an INSERT %s", "\n");

			xscaleset = 1;
			insert->xscale = Group->fltnum;
			break;

		case 42:
			/*
			 * Y scale factor
			 */

			if (yscaleset != 0)
				DXFERR("duplicated Y scale factor for an INSERT %s", "\n");

			yscaleset = 1;
			insert->yscale = Group->fltnum;
			break;

		case 43:
			/*
			 * Z scale factor
			 */

			if (zscaleset != 0)
				DXFERR("duplicated Z scale factor for an INSERT %s", "\n");

			zscaleset = 1;
			insert->zscale = Group->fltnum;
			break;

		case 50:
			/*
			 * rotation angle
			 */

			if (angleset != 0)
				DXFERR("duplicated rotation angle for an INSERT %s", "\n");

			angleset = 1;
			insert->angle = DEG_TO_RAD(Group->fltnum);
			break;

		case 70:
			/*
			 * column counts
			 */

			if (columncountset != 0)
				DXFERR("duplicated column counts for an INSERT %s", "\n");

			columncountset = 1;
			insert->columncount = Group->intnum;
			break;

		case 71:
			/*
			 * row counts
			 */

			if (rowcountset != 0)
				DXFERR("duplicated row counts for an INSERT %s", "\n");

			rowcountset = 1;
			insert->rowcount = Group->intnum;
			break;

		case 44:
			/*
			 * column spaceing
			 */

			if (columnspaceset != 0)
				DXFERR("duplicated column spacing for an INSERT %s", "\n");

			columnspaceset = 1;
			insert->columnspace = Group->fltnum;
			break;

		case 45:
			/*
			 * row spaceing
			 */

			if (rowspaceset != 0)
				DXFERR("duplicated row spacing for an INSERT %s", "\n");
			rowspaceset = 1;
			insert->rowspace = Group->fltnum;
			break;

		default:
			if (OptionsDxfParse(&entity->options) == 0)
				defaultflag = 1;
			break;
		}
	} while (defaultflag == 0);

	/*
	 * parse attributes, if any
	 */

	if (insert->attribflag != 0) {
		do
			(VOID) AttribDxfParse(layerlist);
		while (CmpGroupString(Group, 0, "SEQEND") == 0);

		(VOID) LayerDxfParse(layerlist);
		while (OptionsDxfParse(&seqendoptions) != 0)
			free(seqendoptions);

		GetNextGroup();
	}

	/*
	 * check if block name, insertion point are all defined
	 */

	if (pointset == 0)
		DXFERR("undefined insertion point for an INSERT %s", "\n");

	if (nameset == 0)
		DXFERR("undefined block name for an INSERT %s", "\n");

	return(entity);
}

/*
 * output an INSERT into DEF/NFF/DEF/RAD file
 */

VOID	InsertDefOutput(entity)
ENTITY	*entity;
{
	INT	i, j;
	INSERT	*insert;
	BLOCK	*block;
	FLOAT	*extrusion;
	MATRIX	matrix[2];
	MATRIX	insertmatrix[2];
	MATRIX	shiftmatrix[2];
	MATRIX	scalematrix[2];
	MATRIX	rotatematrix[2];
	MATRIX	extrusionmatrix[2];

	insert = (INSERT *) entity->data;
	block = insert->block;

	if (block == NULL) {
		block = insert->block = BlockSearch(insert->blockname);
		if (block == NULL)
			GENERR("undefined BLOCK %s\n", insert->blockname);
		free(insert->blockname);
		insert->blockname = NULL;
	}

	/*
	 * set up matrics
	 */

	extrusion = OptionsExtrusion(entity->options);

	MatrixExtrusion(extrusionmatrix, extrusion);
	MatrixRotate(rotatematrix, ZAxis, - insert->angle);
	MatrixScale(scalematrix, insert->xscale, insert->yscale, insert->zscale);
	for (i = 0; i < insert->columncount; i++)
		for (j = 0; j < insert->rowcount; j++) {
			MatrixTranslate(shiftmatrix, - block->basepoint[0],
						     - block->basepoint[1],
						     - block->basepoint[2]);
			MatrixTranslate(insertmatrix,
					insert->point[0] +
						(FLOAT) i * insert->columnspace,
					insert->point[1] +
						(FLOAT) j * insert->rowspace,
					insert->point[2]);
			MatrixMultiply(scalematrix, shiftmatrix, matrix);
			MatrixMultiply(rotatematrix, matrix, matrix);
			MatrixMultiply(extrusionmatrix, matrix, matrix);
			MatrixMultiply(insertmatrix, matrix, matrix);
#ifdef	DEBUG
			fprintf(stderr, "\nshift\n");
			MatrixPrint(shiftmatrix[0]);
			fprintf(stderr, "rotate\n");
			MatrixPrint(rotatematrix[0]);
			fprintf(stderr, "scale\n");
			MatrixPrint(scalematrix[0]);
			fprintf(stderr, "extrusion\n");
			MatrixPrint(extrusionmatrix[0]);
			fprintf(stderr, "insert\n");
			MatrixPrint(extrusionmatrix[0]);
			fprintf(stderr, "insert x extrusion x scale x rotate x shift\n");
			MatrixPrint(matrix[0]);
#endif

			StackPush(insert, matrix);

			if (OutFileType == FILE_DEF)
				BlockDefOutput(insert->block);
			else
			if (OutFileType == FILE_NFF)
				BlockNffOutput(insert->block);
			else
			if (OutFileType == FILE_DXF)
				BlockDxfOutput(insert->block);
			else
			if (OutFileType == FILE_RAD)
				BlockRadOutput(insert->block);

			StackPop();
		}
}
