/* vectorlist.h: lineaire lijsten van VECTORs */

#ifndef _VECTORLIST_H_
#define _VECTORLIST_H_

#include "vector.h"
#include "List.h"

typedef struct VECTORLIST {
	struct VECTOR *vector;
	struct VECTORLIST *next;
} VECTORLIST;

#define VectorListCreate	(VECTORLIST *)ListCreate

#define VectorListAdd(vectorlist, vector)	\
        (VECTORLIST *)ListAdd((LIST *)vectorlist, (void *)vector)

#define VectorListCount(vectorlist) \
        ListCount((LIST *)vectorlist)

#define VectorListGet(vectorlist, index) \
        (VECTOR *)ListGet((LIST *)vectorlist, index)

#define VectorListNext(pvectorlist) \
        (VECTOR *)ListNext((LIST **)pvectorlist)

#define VectorListRemove(vectorlist, vector) \
        (VECTORLIST *)ListRemove((LIST *)vectorlist, (void *)vector)

#define VectorListIterate(vectorlist, proc) \
        ListIterate((LIST *)vectorlist, (void (*)(void *))proc)

#define VectorListDestroy(vectorlist) \
        ListDestroy((LIST *)vectorlist)

extern struct VECTOR *VectorListFind(struct VECTORLIST *vl, struct VECTOR *vector);

#endif /* _VECTORLIST_H_ */
