/* polygon.h */

#ifndef _POLYGON_H_
#define _POLYGON_H_

#include "patch.h"
#include "ray.h"

extern	PATCH *PolygonIntersect(PATCH *poly, RAY *ray, float mindist, float *maxdist);
extern int PointInPolygon(PATCH *poly, POINT *p);

/* returns (u,v) parameters for the point in the polygon 
 * ref: Eric Haines, Essential Ray-tracing algorithms, in A. Glassner, Introduction to
 * Ray-Tracing, p 59 */
extern void PolygonUV(PATCH *poly, POINT *point, VEC2D *uv);
extern void QuadUV(PATCH *poly, POINT *point, VEC2D *uv);
extern void TriangleUV(PATCH *poly, POINT *point, VEC2D *uv);

#endif /*_POLYGON_H_*/
