/* mbx.h 1.2 */
/*
    Copyright 1992, 1993 O'Reilly and Associates, Inc.  Permission to
    use, copy, and modify this program is hereby granted, as long as
    this copyright notice appears in each copy of the program source
    code.
*/

#include <X11/extensions/multibuf.h>

#if NeedFunctionPrototypes
extern int		ora_create_mbx_buffers(
    Display*			/* IN:  display */,
    Window			/* IN:  window */,
    int				/* IN:  number of  buffers */,
    Multibuffer*		/* OUT: buffers */
);
#endif

int
ora_create_mbx_buffers( dpy, window, num_buffers, buffers )
    Display	*dpy;
    Window	window;
    int		num_buffers;
    Multibuffer	*buffers;
{
    int		first_event, first_error, num;
    
    if ( !XmbufQueryExtension( dpy, &first_event, &first_error ) ) {
        fprintf( stderr, "No multi-buffer extension on %s\n",
		 XDisplayString( dpy ) );
	return 0;
    }

    num = XmbufCreateBuffers( dpy, window, num_buffers,
			      MultibufferUpdateActionBackground,
			      MultibufferUpdateHintFrequent,
			      buffers );
    if ( num != num_buffers ) {
        fprintf( stderr, "Can't create %d buffers\n", num_buffers );
	if ( num > 0 )
	    XmbufDestroyBuffers( dpy, window );
	return 0;
    }

    return num;
}
