/* materiallist.h: lineaire lijsten van MATERIALs */

#ifndef _MATERIALLIST_H_
#define _MATERIALLIST_H_

#include "material.h"
#include "List.h"

typedef struct MATERIALLIST {
	struct MATERIAL *material;
	struct MATERIALLIST *next;
} MATERIALLIST;

#define MaterialListCreate	(MATERIALLIST *)ListCreate

#define MaterialListAdd(materiallist, material)	\
        (MATERIALLIST *)ListAdd((LIST *)materiallist, (void *)material)

#define MaterialListCount(materiallist) \
        ListCount((LIST *)materiallist)

#define MaterialListGet(materiallist, index) \
        (MATERIAL *)ListGet((LIST *)materiallist, index)

#define MaterialListNext(pmateriallist) \
        (MATERIAL *)ListNext((LIST **)pmateriallist)

#define MaterialListRemove(materiallist, material) \
        (MATERIALLIST *)ListRemove((LIST *)materiallist, (void *)material)

#define MaterialListIterate(materiallist, proc) \
        ListIterate((LIST *)materiallist, (void (*)(void *))proc)

#define MaterialListIterate1B(materiallist, proc, data) \
        ListIterate1B((LIST *)materiallist, (void (*)(void *, void *))proc, (void *)data)

#define MaterialListDestroy(materiallist) \
        ListDestroy((LIST *)materiallist)

#define MaterialListPrint(out, materiallist) \
        MaterialListIterate1B(materiallist, MaterialPrint, out)

extern MATERIAL *MaterialLookup(MATERIALLIST *MaterialLib, char *name);

#endif /* _MATERIALLIST_H_ */
