%{
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "readrad.h"
#include "color.h"
#include "point.h"
#include "pointlist.h"
#include "vector.h"
#include "vectorlist.h"
#include "vertex.h"
#include "vertexlist.h"
#include "patch.h"
#include "patchlist.h"
#include "material.h"
#include "materiallist.h"
#include "geom.h"
#include "geomlist.h"
#include "camera.h"

#include "error.h"

#include "y.tab.h"

static char *strsave(char *);
static void handlehash(char *), skipcomments(char *);

%}
alpha	[a-zA-Z]
special	[\.\_-]
digit	[0-9]
exp	[Ee][-+]?{digit}+
string	{alpha}({alpha}|{digit}|{special})*
filename "/"?"/"?(("."|".."|{string})"/")*{string}
%%
[ \t]		{ ; }
\n		{ lineno++; }
^#.*$		{ handlehash(yytext); }
"/*".*"*/"	{ skipcomments(yytext); }
newmtl          { return tNEWMTL; }
Ka              { return tKa; }
Kd              { return tKd; }
Ks              { return tKs; }
Ed              { return tEd; }
Ns              { return tNs; }
usemtl          { return tUSEMTL; }
list		{ return tLIST; }
end		{ return tEND; }
surface		{ return tSURFACE; }
v               { return tVERTEX; }
n               { return tNORMAL; }
f               { return tFACE; }
eyep            { return tEYEP; }
lookp           { return tLOOKP; }
up              { return tUP; }
fov             { return tFOV; }
screen          { return tSCREEN; }
([0-9]+\.?|[0-9]*\.[0-9]+)([eE][+-]?[0-9]+)? {
		  sscanf(yytext, "%f", &yylval.val); return tNUMBER; }
{string}	   {yylval.string = strsave(yytext); return tSTRING;}
.		{ return yytext[0]; }
%%
int yywrap(void) {return 1;} 

/* dit kan aanleiding geven tot zeer vreemde fouten als in yacc.y regels 
 * voorkomen waarbij meer dan NRBUFS tSTRING verwacht wordt !!!!! */
#define MAXBUF 128
#define NRBUFS 4
static char *strsave(char *s)
{
        static char buf[NRBUFS][MAXBUF];
        static int index;
        char *b;

        b = buf[index]; index = (index + 1)%NRBUFS;
        sprintf(b, "%s", s);
        return b;
}

/*
 * Skip over comments.
 */
static void skipcomments(char *text)
{
/* fprintf(stderr, "skipcomments(%s)\n", text);  */
}

/*
 * Deal with ccp-produced lines of the form:
 * # n "filename"
 * and
 * # n
 * Where filename is the name of the file being processed, and n is
 * the current line number in that file.
 */
void handlehash(char *buf)
{
	int i;
	extern char yyfilename[];

	/*
	 * Complain if the line was not of the form #n "filename"
	 */
	if ((i = sscanf(buf,"#%d \"%[^\"]s\"", &lineno, yyfilename)) == 0 &&
	    (i = sscanf(buf,"# line %d \"%[^\"]s\"",&lineno,yyfilename))==0) {
		Error(NULL, "Unknown '#' control (%s).\n",buf);
		return;
	}
	if (i == 1 && (strchr(buf,'"') != NULL)) {
		/*
		 * Filename was given as ""
		 */
		(void)strcpy(yyfilename, "stdin");
	}
}




