/* geomlist.c */

#include "geomlist.h"
#include "geom.h"

float *GeomListBounds(GEOMLIST *geomlist, float *bounds)
{
	GEOM *geom;

	BoundsInit(bounds);
	while ((geom = GeomListNext(&geomlist)))
		BoundsEnlarge(bounds, GeomBounds(geom));
	return bounds;
}

PATCH *GeomListIntersect(GEOMLIST *geomlist, RAY *ray, float mindist, float *maxdist, int ShadowTesting)
{
	PATCH *p, *patch;
	GEOM *geom;

	patch = (PATCH *)NULL;
	while ((geom = GeomListNext(&geomlist))) {
		if ((p=GeomIntersect(geom, ray, mindist, maxdist, ShadowTesting))) {
			if (ShadowTesting) 
				return p; 
			else 
				patch = p;
		}
	}
	return patch;
}

PATCHLIST *BuildPatchList(GEOMLIST *world, PATCHLIST *patchlist)
{
	GEOM *geom;

	while ((geom = GeomListNext(&world))) {
		if (GeomIsAggregate(geom))
			patchlist = BuildPatchList(GeomPrimList(geom), patchlist);
		else
			patchlist = PatchListMerge(patchlist, GeomPatchList(geom));
	}

	return patchlist;
}

void GeomListPrint(FILE *out, GEOMLIST *geomlist)
{
	GeomListIterate1B(geomlist, GeomPrint, out);
}
