/* canvas.h: behandelt events afkomstig van een canvas widget */

#ifndef _CANVAS_H_INCLUDED_
#define _CANVAS_H_INCLUDED_

#include <Xm/Xm.h>

/* behandelt canvas window resize */
extern void CanvasResizeCallback(Widget canvas, XtPointer client_data, XtPointer call_data);

/* behandelt expose events van een canvas widget */
extern void CanvasExposeCallback(Widget canvas, XtPointer client_data, XtPointer call_data);

/* handles GraphicsExpose events on the canvas window */
extern void CanvasExposeEvent(Widget canvas, XtPointer client_data, XEvent *event);

/* behandelt mouse events op een canvas widget */
extern void CanvasMouseEvent(Widget canvas, XtPointer client_data, XEvent *event);

/* bepaalt hoe gereageerd wordt op muisbewgingen, indrukken/loslaten van muisknop ... */
extern void CanvasInit(Widget canvas);
extern void CanvasPushMode(int canvasmode);
extern void CanvasPullMode(void);

/* muis bewegen terwijl muisknop ingedrukt verandert camerapositie/kijkrichting */
#define CANVASMODE_NORMAL	1
#define CANVASMODE_WORKING	2	/* idem, maar met andere cursor */
/* muisknop loslaten selecteert de patch waar de pointer op het ogenblik naar wijst */
#define CANVASMODE_SELECT_PATCH	3
#define CANVASMODE_RENDER	4

#endif /*_CANVAS_H_INCLUDED_*/
