/* camera.h */

#ifndef _CAMERA_H_
#define _CAMERA_H_

#include "point.h"
#include "vector.h"
#include "color.h"

typedef struct CAMERA {
	POINT eyep, lookp;
	VECTOR updir;
	float viewdist;
	float fov, hfov, vfov;
	float near, far;	/* near en far clipping plane afstand */
	int hres, vres;
	VECTOR X, Y, Z;		/* eye coordinate system */
	RGB background;
	int changed;	/* TRUE indien onlangs de camera veranderd werd */
} CAMERA;

extern CAMERA Camera, AltCamera;

extern void CameraDestroy(CAMERA *cam);
extern CAMERA *CameraCreate(void);

extern CAMERA *CameraSet(CAMERA *cam, 
			 POINT *eyep, POINT *lookp, VECTOR *updir, 
			 float fov, int hres, int vres, RGB *background);

/* verwisselt ingestelde camera met alternatief - wordt gebruikt 
 * voor het creeren van bewegende beelden met alternerende camera
 * - vnl voor testdoeleinden. */
extern CAMERA *CameraAlternate(CAMERA *cam);

/* alternatieve camera instellen */
extern void CameraSetAlternate(CAMERA *cam);

extern CAMERA *CameraSetFov(CAMERA *cam, float fov);
extern CAMERA *CameraSetUpdir(CAMERA *cam, float x, float y, float z);
extern CAMERA *CameraSetLookp(CAMERA *cam, float x, float y, float z);
extern CAMERA *CameraSetEyep(CAMERA *cam, float x, float y, float z);

extern void CameraPrint(FILE *out, CAMERA *Camera);

extern CAMERA *CameraMoveForward(CAMERA *cam, float step);
extern CAMERA *CameraMoveRight(CAMERA *cam, float step);
extern CAMERA *CameraMoveUp(CAMERA *cam, float step);
extern CAMERA *CameraTurnRight(CAMERA *cam, float angle);
extern CAMERA *CameraTurnUp(CAMERA *cam, float angle);
extern CAMERA *CameraTilt(CAMERA *cam, float angle);
extern CAMERA *CameraZoom(CAMERA *cam, float amount);

#define MAXCAMSTACK 20
extern void CameraPush(CAMERA *cam);
extern CAMERA *CameraPop(CAMERA *cam);

#endif /*CAMERA_H_*/
