/* Memory.h: geheugenbeheer */

#ifndef _mEMORY_H_
#define _mEMORY_H_

/*
 * de volende routines voor geheugenbeheer testen of fouten (en
 * zorgen ervoor dat het programma verlaten wordt indien er fouten
 * zijn) en voorzien in beperkte geheugenbeheer debug mogelijkheden
 * (te activeren door Memory.c met #define DEBUG te compileren).
 */

/* alloceer nrbytes bytes en geef een wijzer naar het gealoceerde geheugen 
 * terug */
extern char *Alloc(int nrbytes);

/* geef de nrbytes bytes geheugen waar buf een wijzer nar is terug vrij
 * (tweede argument is enkel nodig voor het bijwerken van het totaal
 * aantal bytes gealloceerd geheugen */
extern void Free(char *buf, int nrbytes);

/* maar de geheugenzone van size bytes, waar buf een wijzer naar is
 * extra bytes langer (of korter als extra negatief is). De nieuwe
 * lengte is size+extra */
extern char *Realloc(char *buf, int size, int extra);

/* geeft het aantal met bovenstaande routines gealloceerde bytes terug */
extern int GetMemoryUsage(void);

/* ------------------------------------------------------------------ */
/* Een eigen memory management systeem bovenop de standaard C storage 
 * allocator. Doel: overhead (zowel in tijd als geheugenruimte) wegwerken door
 * gebruik te maken van het feit dat we erg veel kleine stukjes geheugen 
 * nodig hebben van allemaal gelijke grootte. */

#ifdef MEMMAN_HEADERS

/* each cell is preceeded by a header containing a pointer to the
 * storage page (bunch) containing the cell */
typedef struct CELLHDR {
	struct STORAGE *page;
} CELLHDR;

/* size of header that comes before the cells - contains one pointer */
#define HEADERSIZE	sizeof(struct CELLHDR)

/* max. number of cells per page - should be a multiple of 8 */
#define MAXCELLSPERPAGE	480

/* minimum cell size */
#define MINCELLSIZE	4

/* should be a multiple of (MINCELLSIZE+HEADERSIZE)*8 */
#define PAGESIZE (MAXCELLSPERPAGE * (MINCELLSIZE + HEADERSIZE))

#else /*MEMMAN_HEADERS*/

/* max. number of cells per page */
#define MAXCELLSPERPAGE	960

/* minimum cell size */
#define MINCELLSIZE	4

#define PAGESIZE (MAXCELLSPERPAGE * MINCELLSIZE)

#endif /*MEMMAN_HEADERS*/

/* size of the allocmap bitmap */
#define ALLOCMAPSIZE (MAXCELLSPERPAGE/8)


typedef struct STORAGE {
	struct STORAGE *next, *prev;
	unsigned int cellsfilled, maxcells, cellsize, nextfree;
	unsigned char allocmap[ALLOCMAPSIZE];
	unsigned char base[PAGESIZE];
} STORAGE;

/* Allocate a new cell with given cellsize from the STORAGE chain */
extern unsigned char *New(unsigned int cellsize, STORAGE **stor);

/* Dispose the cell pointed to by cellptr from the STORAGE chain */
extern void Dispose(unsigned char *cellptr, STORAGE **stor);

#endif /*_mEMORY_H_*/
