/*
 *	Program:	None
 *	Module:		MxMatrix.h
 *	Programmer:	John Buchanan
 *
 *	Description:
 *			A variety of routines to handle matrices.
 *	
 */
#define MX_STKLEN 200


extern void MxCopy();		/* Copy a to b */
extern void MxTranspose();	/* Transpose a to r */
extern void MxIdentity();	/* Store the identity in a */
extern void MxScalarMultiply();	/* multiply a by scalar s, put result in r */
extern void MxVectorMultiply(); /* Multiply vector p by a into q */
extern void MxNegate();		/* Negate a into r */
extern void MxAdd();		/* Add a + b into r*/
extern void MxTranslate();
extern void MxScale();
extern void MxRotateD();	/* create rotation matrix degrees*/
extern void MxRotateR();	/* create rotation matrix radians */
extern void MxSubstract();	/* substract b from a into r */
extern void MxMultiply();	/* multiply a and b into r */
extern void MxDivide();		/* multibly a by inverse of b into r*/
extern void MxReverseDivide();  /* multiply inverse of a by b into r */
extern int  MxStackInit();	/* Initialize the matrix stack */
extern char *MxPush();		/* Push a matrix onto the stack */
extern char *MxPop();		/* Pop a matrix from the stack */
extern float MxTransform();	/* transform a by m into b */
extern float MxInvert();	/* invert a into r return det(a) */
extern float MxDeterminant();   /* return the determinant of (a) */
extern void MxPrint();		/* print the matrix to stdout */
extern void MxGet();		/* get the matrix row at a time */
extern void VecCopy();	/* Copy vector p into q */
extern float VecDot();	/* Return dot product of p and q */
extern void VecSubstract();
extern void VecAdd();
extern void VecCross();
extern void VecNormalize();
extern float VecLength();
