.TH movietool L "28 Aug 1989"
.SH NAME
Movietool \- a display tool for sequences of
.I Sun rasterfiles
providing "video animation" in a Sun window.
.SH SYNOPSIS
.I movietool
.I [SunView Generic Args]
.I [-zoom factor] 
.br
.I 	[-sub x y w h]
.I [-ident]
.I [-XOR]
.I [-encoded]
.br
.I 	rasterfile[s]
.SH DESCRIPTION
.I Movietool
displays a sequence of color or monochrome raster files (see man 5 rasterfile)
in real-time or near-real-time.
On a Sun 3/50M with 4 MB of RAM, monochrome images of 600 by 800 pixels
may be played at about 16 frames per second.
.SH ARGUMENTS
After the SunView generic arguments (see generic_args(1)),
Movietool takes the following arguments:

.IP "-z[oom] factor"
does raster replication to magnify your rasterfiles.
The
.I factor
must be 2, 3 or 4.

.IP "-s[ub] x y w h"
picks a 
.I subregion
of your rasterfiles starting at pixel (x,y) of width=w and height=h.

.IP "-i[dent]"
Use 
.I identical colormaps
for all (color) frames,
thereby reducing memory and time consumption.
The color map of the first frame is used throughout.

.IP "-X[OR]"
For a sequence of rasterfiles, store the
.I XOR
of successive rasters.
When playing a sequence, the updating takes place by means of XOR-ing
what is on the screen.
Since most of the XOR'ed pixels are presumably zero,
this provides the possibility for very fast updating of the screen.
However, the frame buffers that I have tried,
/dev/bwtwo1,
/dev/cgfour0,
/dev/cgtwo0 with GP2,
/dev/cgthree0 and
/dev/cgsix0
do not appear to do XOR's efficiently.

.IP "-e[ncoded]"
With this option,
the rasterfiles' data are stored as byte-encoded data
(provided the rasterfile format was
.I  RT_BYTE_ENCODED
).
This could typically reduce memory consumption by
.I 50-80 %,
providing much smoother animation, or longer sequences,
with a given amount of available RAM.
The decoding process of course requires more of the CPU
than a simple copy operation,
so there is a tradeoff to be made here.

.IP "rasterfile[s]"
argument[s] must be in the
.I rasterfile(5)
format.
Files not conforming to this format are just ignored.

.SH "CONTROL PANEL"
There are
.I Play
(animate the sequence),
.I Step
(single step through the movie),
.I Clear
(clear display canvas), and
.I Eject
(finish up) buttons on the control panel.
If only a single rasterfile is to be displayed,
the control panel will be absent.
.LP
While the movie is playing,
the mouse cursor shows an hour-glass in the control panel,
and the movie may only be interrupted by pressing the
.I STOP
button located at the top left-hand corner of the keyboard
(\fIL1\fP button on many keyboards).
Since the display-canvas is non-retained and attempts to use the overlay
plane on the framebuffer (if available),
damage to the window is not repaired while the movie is playing.
To repair, interrupt the movie and restart it.
.LP
If the
.I -XOR
option has been selected,
the first line of the panel also features a switch between
XOR-ing and a normal copy,
as well as the possibility to view the XOR'ed raster.
.LP
Second line features a 
.I Frame
slider indicating framenumber as the movie proceeds,
which in addition may be used to position at a particular frame.
The file name corresponding to the current frame is displayed
(except when Playing).
.LP
Third line shows,
and allows selection of,
play 
.I Direction: forward
or
.I backward.
Fourth line controls repetition of the movie: The
.I Repeat
button allows repetition as indicated by Direction.
If
.I Auto-reverse
is flipped on,
the movie turns around at either end.
In this case, the Repeat button is disabled.
.LP
Finally, the
.I Frames/sec
slider lets you select the speed of the movie.
By choosing the maximum value, you get whatever maximum performance
your system will deliver.
At lower values delays will be imposed,
but if the actual speed is lower than the value selected,
the slider will flick to the current number of frames per second.
Note that the system's time-of-day clock is so coarse that at above 16
frames/sec it is hard to provide proper timing.
.SH PICTURE DISPLAY
The raster image will always be centered on the display canvas,
provided the canvas is large enough.
In case your image is larger than the available canvas,
the scroll bars allow you to select part of the image.
.SH CAPACITY
On a 3/60C, the rate at which rasters can be displayed on the screen
seems to be about 6-8 Mega-pixels per second,
which may easily be 25-50 frames per second for small images.
Monochrome images generally play 8 times faster than color images of
the same size.
On a SPARCstation-1 with GX graphics accelerator,
rasters of full-screen size may be played at about 50 frames per second.
If the Movietool is shrunk to display just the interesting region of
the rasterfiles (or when using the
.I -sub
argument),
the display may become significantly faster.
The most important limitation to long image sequences is the amount
of RAM available to hold the memory-pixrects containing the images.
When paging to the disk sets in, 
you will notice immediately !
.SH AUTHOR
.nf
Author: Ole H. Nielsen
        Lab of Applied Physics, Bygn. 307
        Technical University of Denmark, DK-2800 Lyngby
        E-mail: ohnielse@ltf.dth.dk

Copyright 1989 by Ole H. Nielsen.
This software may be distributed freely provided that:
1) this copyright notice is kept intact,
2) you do not try to sell this software for a profit,
3) you provide the full source code.
