/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/*
 * raw.c - interface with dump format.
 *
 * Author:      Raul Rivero
 *              Mathematics Dept.
 *              University of Oviedo
 * Date:        Sun Feb 2 1992
 * Copyright (c) 1992, Raul Rivero
 *
 */

#include <lug.h>
#include <lugfnts.h>

read24bitmap( xsize, ysize, rhandle, ghandle, bhandle, bitmap )
int xsize, ysize;
FILE *rhandle, *ghandle, *bhandle;
bitmap_hdr *bitmap;
{
  long totalsize;

  /* Fill the new header */
  bitmap->magic = LUGUSED;
  bitmap->xsize = xsize;
  bitmap->ysize = ysize;
  totalsize = xsize * ysize;
  bitmap->depth = 24;
  bitmap->colors = ( 1 << bitmap->depth );

  /* Allocate buffers */
  bitmap->r = (byte *) Malloc( totalsize );
  bitmap->g = (byte *) Malloc( totalsize );
  bitmap->b = (byte *) Malloc( totalsize );

  /* Read the bitmap info */
  Fread( bitmap->r, xsize, ysize, rhandle );
  Fread( bitmap->g, xsize, ysize, ghandle );
  Fread( bitmap->b, xsize, ysize, bhandle );
}

read_raw_file( name, bitmap )
char *name;
bitmap_hdr *bitmap;
{
  int xsize, ysize;

  fprintf( stderr, "Enter image size ( x y ): " );
  scanf( "%d %d", &xsize, &ysize);

  /* Read the bitmap */
  read_8bitmap_file( name, bitmap, xsize, ysize);
}

read_8bitmap_file( name, bitmap, xsize, ysize )
char *name;
bitmap_hdr *bitmap;
int xsize, ysize;
{
  FILE *handle;

  /* Open the file descriptor */
  if ( name != NULL )
    handle = Fopen( name, "rb" );
  else handle = stdin;

  /* Read the bitmap */
  read8bitmap( handle, bitmap, xsize, ysize );
  rm_compress();

  /* Close the file */
  Fclose( handle );
}

read8bitmap( handle, bitmap, xsize, ysize )
int xsize, ysize;
FILE *handle;
bitmap_hdr *bitmap;
{
  long totalsize;

  /* Fill the new header */
  bitmap->magic = LUGUSED;
  bitmap->xsize = xsize;
  bitmap->ysize = ysize;
  totalsize = xsize * ysize;
  bitmap->depth = 8;
  bitmap->colors = ( 1 << bitmap->depth );
  bitmap->cmap = (byte *) create_bw_pallete();

  /* Allocate buffers */
  bitmap->r = (byte *) Malloc( totalsize );

  /* Read the bitmap info */
  Fread( bitmap->r, xsize, ysize, handle );
}

write24bitmap( rhandle, ghandle, bhandle, bitmap )
FILE *rhandle, *ghandle, *bhandle;
bitmap_hdr *bitmap;
{
  if ( bitmap->magic != LUGUSED )
    error( 19 );

  if ( bitmap->depth < 24 ) {
    write8bitmap( rhandle, bitmap );
    return 1;
  }

  /* Write the bitmap info */
  Fwrite( bitmap->r, bitmap->xsize, bitmap->ysize, rhandle );
  Fwrite( bitmap->g, bitmap->xsize, bitmap->ysize, ghandle );
  Fwrite( bitmap->b, bitmap->xsize, bitmap->ysize, bhandle );
}

write_raw_file( name, bitmap )
char *name;
bitmap_hdr *bitmap;
{
  write_8bitmap_file( name, bitmap );
}

write_8bitmap_file( name, bitmap )
char *name;
bitmap_hdr *bitmap;
{
  FILE *handle;

  /* Open the file descriptor */
  if ( name != NULL )
    handle = Fopen( name, "wb" );
  else handle = stdout;

  /* Write the bitmap */
  write8bitmap( handle, bitmap );

  /* Close the file */
  Fclose( handle );
}

write8bitmap( handle, bitmap )
FILE *handle;
bitmap_hdr *bitmap;
{
  if ( bitmap->magic != LUGUSED )
    error( 19 );

  /* Write the bitmap info */
  Fwrite( bitmap->r, bitmap->xsize, bitmap->ysize, handle );
}
