#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/SeparatoG.h>
#include <Xm/MenuShell.h>
#include <Xm/MainW.h>
#include <stdio.h>

/* Test to demonstrate de behaviour of XmGetPostedFromWidget.
 */

void
PrintPostedFrom(Widget w)
{
    Widget pf = XmGetPostedFromWidget(w);

    printf("XmGetPostedFromWidget(%s)=%s\n",
	   XtName(w),
	   pf ? XtName(pf) : "(null)");
}
void
PopdownCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    printf("popdown\n");
}

void
DisarmCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    printf("disarm\n");
}

void
PushCB(Widget w, XtPointer client_data, XtPointer call_data)
{
    Widget mp = (Widget)client_data;

    PrintPostedFrom(mp);
}

int
main(int argc, char **argv)
{
    XtAppContext theApp;
    Widget shell, toplevel, menubar, filepane;
    Widget button, button1, button2, sep;
    Widget saveAsPane, button3, button4, button5;
    Widget button6, button7, editpane;
    Widget one, two, three;
    Widget option, optpane;
    Widget opt1, opt2;
    Arg args[6];
    int ac;
    Widget ms1, ms2;
    Widget wa, mb, md, mp, mo;

    shell = XtVaAppInitialize(&theApp, "mainW", NULL, 0,
				 &argc, argv, NULL, NULL);

    toplevel = XmCreateMainWindow(shell, "MainWindow", NULL, 0);
    XtManageChild(toplevel);

    printf("after creation:\n");

    wa = XtVaCreateWidget("work_area", xmRowColumnWidgetClass, toplevel,
			  XmNrowColumnType, XmWORK_AREA,
			  NULL);

    PrintPostedFrom(wa);

    mb = XtVaCreateWidget("menu_bar", xmRowColumnWidgetClass, toplevel,
			  XmNrowColumnType, XmMENU_BAR,
			  NULL);

    PrintPostedFrom(mb);

    ms1 = XtVaCreatePopupShell("ms1", xmMenuShellWidgetClass, toplevel,
			       XmNwidth, 1,
			       XmNheight, 1,
			       NULL);


    md = XtVaCreateWidget("menu_pulldown", xmRowColumnWidgetClass, ms1,
			  XmNrowColumnType, XmMENU_PULLDOWN,
			  NULL);

    PrintPostedFrom(md);

    ms2 = XtVaCreatePopupShell("ms2", xmMenuShellWidgetClass, toplevel,
			       XmNwidth, 1,
			       XmNheight, 1,
			       NULL);

    mp = XtVaCreateWidget("menu_popup", xmRowColumnWidgetClass, ms2,
			  XmNrowColumnType, XmMENU_POPUP,
			  NULL);

    PrintPostedFrom(mp);

    mo = XtVaCreateWidget("menu_option", xmRowColumnWidgetClass, toplevel,
			  XmNrowColumnType, XmMENU_OPTION,
			  NULL);

    PrintPostedFrom(mo);

    printf("\n");

    menubar = XmCreateMenuBar(toplevel,
			      "menuBar",
			      NULL,0);

    filepane = XmCreatePulldownMenu(menubar,
				    "file_pane",
				    NULL,0);

    button = XtVaCreateManagedWidget("File",
				     xmCascadeButtonGadgetClass,
				     menubar,
				     XmNsubMenuId, filepane,
				     NULL);

    editpane = XmCreatePulldownMenu(menubar,
				    "pane2",
				    NULL, 0);

    button6 = XtVaCreateManagedWidget("Edit",
				      xmCascadeButtonGadgetClass,
				      menubar,
				      XmNsubMenuId, editpane,
				      NULL);

    button7 = XtVaCreateManagedWidget("Cut",
				      xmPushButtonGadgetClass,
				      editpane,
				      NULL);

    button1 = XtVaCreateManagedWidget("Open",
				      xmPushButtonGadgetClass,
				      filepane,
				      NULL);

    XtAddCallback(XtParent(filepane), XmNpopdownCallback, PopdownCB, NULL);

    XtAddCallback(button1, XmNactivateCallback, PushCB, (Widget)filepane);

    XtAddCallback(button1, XmNdisarmCallback, DisarmCB, NULL);

    sep = XtVaCreateManagedWidget("sep",
				  xmSeparatorGadgetClass,
                                  filepane,
                                  NULL);

    button2 = XtVaCreateManagedWidget("Close",
				      xmPushButtonWidgetClass,
				      filepane,
				      NULL);

    saveAsPane = XmCreatePulldownMenu(filepane,
				      "save_as_pane",
				      NULL, 0);

    button3 = XtVaCreateManagedWidget("Save As",
				      xmCascadeButtonWidgetClass,
				      filepane,
				      XmNsubMenuId, saveAsPane,
				      NULL);

    button4 = XtVaCreateManagedWidget("MS Word",
				      xmPushButtonWidgetClass,
				      saveAsPane,
				      NULL);

    button5 = XtVaCreateManagedWidget("LaTeX",
				      xmPushButtonWidgetClass,
				      saveAsPane,
				      NULL);

    XtAddCallback(button5, XmNactivateCallback, PushCB, (Widget)saveAsPane);

    XtManageChild(menubar);

    one = XtVaCreateManagedWidget("form", xmFormWidgetClass, toplevel,
				  NULL);

    optpane = XmCreatePulldownMenu(toplevel, "optpane", NULL, 0);

    opt1 = XtVaCreateManagedWidget("true",
				   xmPushButtonWidgetClass,
				   optpane,
				   NULL);

    opt2 = XtVaCreateManagedWidget("false",
				   xmPushButtonWidgetClass,
				   optpane,
				   NULL);

    ac = 0;
    XtSetArg(args[ac], XmNsubMenuId, optpane); ac++;
    XtSetArg(args[ac], XmNlabelString, XmStringCreateLocalized("Guess:")); ac++;
    XtSetArg(args[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
    XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_NONE); ac++;

    option = XmCreateOptionMenu(one, "option", args, ac);

    XtManageChild(option);

    two = XtVaCreateManagedWidget("option", xmPushButtonWidgetClass, one,
				  XmNtopAttachment, XmATTACH_WIDGET,
				  XmNtopWidget, option,
				  XmNbottomAttachment, XmATTACH_FORM,
				  XmNleftAttachment, XmATTACH_NONE,
				  XmNrightAttachment, XmATTACH_FORM,
				  NULL);

    XtAddCallback(two, XmNactivateCallback, PushCB, (Widget)option);
    XtAddCallback(two, XmNactivateCallback, PushCB, (Widget)optpane);

    three = XtVaCreateManagedWidget("menu", xmPushButtonWidgetClass, one,
				    XmNtopAttachment, XmATTACH_WIDGET,
				    XmNtopWidget, option,
				    XmNbottomAttachment, XmATTACH_FORM,
				    XmNleftAttachment, XmATTACH_FORM,
				    XmNrightAttachment, XmATTACH_WIDGET,
				    XmNrightWidget, two,
				    NULL);

    XtAddCallback(three, XmNactivateCallback, PushCB, (Widget)menubar);
    XtAddCallback(three, XmNactivateCallback, PushCB, (Widget)filepane);
    XtAddCallback(three, XmNactivateCallback, PushCB, (Widget)saveAsPane);

    XmMainWindowSetAreas(toplevel, menubar, NULL, NULL, NULL, one);

    XtRealizeWidget(shell);

    XtAppMainLoop(theApp);

    exit(0);
}

