/**
 * 
 * $Id: SpinBP.h,v 1.1 1997/02/27 05:11:23 miers Exp $
 *
 * Copyright (C) 1997 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

#ifndef XM_SPINBP_H
#define XM_SPINBP_H

#include <Xm/LabelP.h>
#include <Xm/ManagerP.h>
#include <Xm/SpinB.h>

#ifdef __cplusplus
extern "C" {
#endif

/* SpinBox constraints */
typedef struct _XmSpinBoxConstraint
{
    XmStringTable values;
    int position;
    int num_values;
    int minimum_value;
    int maximum_value;
    int increment_value;
    short decimal_points;
    unsigned char sb_child_type;
    unsigned char arrow_sensitivity;
} XmSpinBoxConstraintPart, *XmSpinBoxConstraint;

typedef struct _XmSpinBoxConstraintRec
{
    XmManagerConstraintPart manager;
    XmSpinBoxConstraintPart spinBox;
} XmSpinBoxConstraintRec, *XmSpinBoxConstraintPtr;

/* SpinBox class structure */
typedef struct _XmSpinBoxClassPart
{
    XtPointer extension;
} XmSpinBoxClassPart;

typedef struct _XmSpinBoxClassRec
{
    CoreClassPart core_class;
    CompositeClassPart composite_class;
    ConstraintClassPart constraint_class;
    XmManagerClassPart manager_class;
    XmSpinBoxClassPart spinBox_class;
} XmSpinBoxClassRec;

extern XmSpinBoxClassRec xmSpinBoxClassRec;

/* SpinBox instance record */
typedef struct _XmSpinBoxPart
{
    Dimension arrow_size;
    Dimension margin_width;
    Dimension margin_height;
    Dimension spacing;
    unsigned int initial_delay;
    unsigned int repeat_delay;
    XtCallbackList modify_verify_cb;
    XtCallbackList value_changed_cb;
    XRectangle up_arrow_rect;
    XRectangle down_arrow_rect;
    Widget textw;
    int boundary;
    int last_hit;
    int make_change;
    Dimension ideal_height;
    Dimension ideal_width;
    GC arrow_gc;
    GC insensitive_gc;
    Mask dim_mask;
    XtIntervalId spin_timer;
    Boolean up_arrow_pressed;
    Boolean down_arrow_pressed;
    unsigned char arrow_layout;
    unsigned char default_arrow_sensitivity;
    Dimension detail_shadow_thickness;
} XmSpinBoxPart;

/* Widget's instance record declaration */
typedef struct _XmSpinBoxRec 
{
    CorePart core;
    CompositePart composite;
    ConstraintPart constraint;
    XmManagerPart manager;
    XmSpinBoxPart spinBox;
} XmSpinBoxRec;

/* standard macros */
#define SB_ChildIsNumeric(w) \
    ((w)->sb_child_type == (unsigned char) XmNUMERIC)

#define SB_GetConstraintRec(w) \
    ((XmSpinBoxConstraint)(&((XmSpinBoxConstraintPtr) \
    (w)->core.constraints)->spinBox))

#define SB_MaxPosition(w) \
    (((w)->maximum_value - (w)->minimum_value) / (w)->increment_value)

#define SB_CurrentValue(w) \
    ((w)->minimum_value + ((w)->position * (w)->increment_value))

#define SB_WithChild(w) \
    ((w)->spinBox.textw != NULL)

#define SB_ChildCount(w) \
    ((w)->composite.num_children)

#ifdef __cplusplus
}
#endif

#endif /* XM_SPINBP_H */

