 /*
  * Khoros: $Id: xp2_main.c,v 1.2 1991/12/18 08:57:24 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: xp2_main.c,v 1.2 1991/12/18 08:57:24 dkhoros Exp $";
#endif

 /*
  * $Log: xp2_main.c,v $
 * Revision 1.2  1991/12/18  08:57:24  dkhoros
 * HellPatch3
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include 	"xprism2.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: xp2_main.c
   >>>>                         
   >>>>   description: Main Driver for 2D plotting package xprism2
   >>>>                        
   >>>>      routines: 
   >>>>			main()
   >>>>			set_gwin_attr_2D()
   >>>>			start_cmd_plot_2D()
   >>>>			change_xprism2_forms()
   >>>>               
   >>>> modifications: Aug 9, 1990 by John M. Salas
   >>>>         - Restructred code so that all parameters are set in
   >>>>           init_xprism2() by the user via vgparms or their
   >>>>           defaults set if not specified.  All paramters are
   >>>>           passed to other functions in structure xprism2_args.
   >>>>
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



/******************************************************************
*                                                                  
*                                                                  
*     >>>>>>>>>>>           M A I N           <<<<<<<<<<<<             
*                                                                  
*                                                                  
********************************************************************/


main(argc, argv)

int	argc;
char	*argv[];
{
	xprism2_struct *xprism2_args;
	xvf_form *form_master;

        Master 	  master;
	char      *mesg, *filename;
	int       i, marker_type, line_type, did_overlays = false;
	int	  num_aval, whichband, cmplx;
	XObject   *tmp_list;
	Widget    *xvf_create_help2();
	Arg 	   arg[MaxArgs];
	unsigned long pixel;

	/*
	 *  Xprism2 startup
	 */
 
	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();
	PROG_NAME = xvf_strcpy(program);


/*
   Get the arguments off the command line and initialize all parameters.
*/
	xprism2_args = (xprism2_struct *)
		       calloc((unsigned)1, (unsigned)sizeof(xprism2_struct));

	          /* called by main, fd, struct */
		  /* ans input: FALSE, fd, xprism2_args */
	init_xprism2(TRUE, -1, xprism2_args);
	consolidate_args();

	/* initialize the display and the forms */
	display = xvf_initialize(ac, av, program);
	if (display == NULL) 		/* If an error on the open */
	{
	   mesg = xvf_strcpy("Could not open connection to server\n");
	   fprintf(stderr,"\nxprism:\n\t%s.\n",mesg);
	   free(mesg);
	   khoros_close();
	}
	xve_init();

	/* see if the display is monochrome & set flag accordingly */
	if ( XDisplayPlanes(display, screen) > 1)
	   mono_display = false;
	else
	   mono_display = true;
 
	/* various & sundry global initializations */
	gwin = NULL;
	(void) set_global_indir(xprism2_args->indir);
	(void) set_global_outdir(xprism2_args->outdir);
	gwin_attr = (VPGraphicsWindowAttributes *)
		    malloc (sizeof (VPGraphicsWindowAttributes));

	set_gwin_attr_2D(xprism2_args);

	/* Grabs colors from X for plots */
	X3D_allocate_named_colors(display, colornames, Colors, PLOT_COLORNUM, 
				  false, X3D_WHITE);
	rootwindow = XDefaultRootWindow(display);

	/* create the Forms */
	if (!(form_master = xvf_create_form(xprism2_args->form_file, av, ac, 
					    SIMPLE, NULL, -1, -1)))
	{
	    khoros_close();
	}

 	/*	
	 *  initialize the xprism information structure 
	 *  Note this is done AFTER call to xvf_create_form
	 */
	_xvf_init_Master(form_master, &master);
 
	change_xprism2_forms(form_master, xprism2_args, &master);

	/*
	 * set the workspace canvas, and give it a black background
	 */
	_xvf_get_Master(form_master, &master);

	i = 0;
	pixel = BlackPixel(display, DefaultScreen(display));
        XtSetArg(arg[i],XtNbackground, pixel);			i++;
        XtSetArg(arg[i],XtNwidth, 512);				i++;
        XtSetArg(arg[i],XtNheight, 512);			i++;
        XtSetArg(arg[i],XtNhorizDistance, 3);			i++;
        XtSetArg(arg[i],XtNvertDistance, 3);			i++;
        XtSetArg(arg[i],XtNborderWidth, 0);			i++;
	canvas = XtCreateManagedWidget("canvas", simpleWidgetClass,
			master.canvas, arg, i);

	if ( xprism2_args->plots_specified )
	{
	    start_cmd_plot_2D(xprism2_args);
	    update_tics(form_master, master.options->tics); 
	}
	if (gwin != NULL)
	{
	    if (xprism2_args->annotation_in_file != NULL)
	    {
                  filename = vfullpath(xprism2_args->annotation_in_file, 
                                       global_indir, NULL);
                  if (tmp_list = read_overlays(canvas, filename))
                     obj_list = tmp_list;
                  free(filename);
		  did_overlays = true;
	     }
	}


	/*
	 * if on monochrome display, begin with a default of linemarker
	 */
	if (mono_display == true)
	{
	     /* change default type to linemarker */
	     xvf_change_input(form_master, 
	     		      master.xprism->input_file->change_plot_type_index,
		              xvf_toggleval_chng, "4", 0);
	     master.xprism->input_file->change_plot_type_val = PLOT_LINEMARKER;
	     xvf_change_input(form_master, 
	     		      master.xprism->input_function->change_plot_type_index,
		              xvf_toggleval_chng, "4", 0);
	     master.xprism->input_function->change_plot_type_val = PLOT_LINEMARKER;

	     xvf_change_input(form_master, 
			      master.options->attributes->change_plot_type_index,
		              xvf_toggleval_chng, "4", 0);
	     master.options->attributes->change_plot_type_val = PLOT_LINEMARKER;

	     /* turn off "Colors" pane */
	     xvf_change_input(form_master,
			      master.options->colors_gb_index,
			      xvf_activation_chng, "0", 0);
	}

	/*
	 * map the master form
	 */
	xvf_change_active(form_master,true);

	/*
	 *  start up the forms here
	 */
	do
	{
	   /*
	    *  get the form information structure indicating
	    * selections & and input provided by the user
	    */
	   form_master = xvf_run_form();
	   if (form_master == NULL) break;

	   _xvf_get_Master(form_master, &master);


	   if (master.quit) ;

	   else if (master.info)
	   {
	      if (gwin != NULL)
	      {
		 /*
		  * provide info about the plot
		  */
	         plot_information();
	      }
	      else
	      {
	          mesg =
	       xvf_strcpy("Please use Xprism to create a graphics workspace\n");
		  xvf_error_wait(mesg, "Main", NULL);
		  free(mesg);
	      }
	   }

             /* allow the user to hide plots */
           else if (master.hide)
           {
              if (gwin != NULL)
	      {
                 hide_plots(&num_aval);
		 if (num_aval > 0)
		 {
	            mesg = xvf_strcpy("Do you want to RESET the Min/Max of the Plot Area?\n This will reset the Min/Max for the currently displayed plots");
                    if (xvf_warn_wait(mesg, "RESET AXES", "YES","NO"))
	            {
                        find_wc_min_max();
	                reset_world_coordinates();
	            }
		 }
	         update_tics(form_master, master.options->tics); 
	         plot_routine();
	      }
              else
                  xvf_error_wait(" No plots available to hide!\n",
                                 "Xprism Error", NULL);
           }

             /* allow the user to delete plots */
           else if (master.delete)
           {
              if (gwin != NULL)
	      {
                 delete_plots();
		 if (gwin != NULL)
		 {
	             mesg = xvf_strcpy("Do you want to RESET the Min/Max of the Plot Area?\n This will reset the Min/Max for the currently displayed plots");
                     if (xvf_warn_wait(mesg, "RESET AXES", "YES","NO"))
	             {
                         find_wc_min_max();
	                 reset_world_coordinates();
	             }
	             update_tics(form_master, master.options->tics); 
	             plot_routine();
	         }
	      }
              else
                  xvf_error_wait(" No plots available to delete!\n",
                                 "Xprism Error", NULL);
           }
               /* refresh the plot area */
           else if (master.refresh)
           {
              if (gwin != NULL)
                  plot_routine();
              else
                  xvf_error_wait(" Nothing displayed to refresh!\n",
                                 "Xprism Error", NULL);
           }

              /* clear the workspace */
           else if (master.clear)
           {
               if (gwin != NULL)
               {
                   freegwin();
                   gwin = NULL;
               }
               else
                   xvf_error_wait("No workspace to clear!\n",
                                  "xprism_input", NULL);
           }

	   else if (master.reset_axes)
	   {
              if (gwin != NULL)
	      {
                 reset_axes();
	         update_tics(form_master, master.options->tics); 
	         plot_routine();
	      }
              else
                  xvf_error_wait(" No plots currently displayed!\n",
                                 "Xprism Error", NULL);
	   }

	   else if (master.xprism_selected)
	   {
	     marker_type = xprism2_args->marker_type;

	     line_type = xprism2_args->line_type;
	
	     whichband = xprism2_args->whichband;
	     cmplx = xprism2_args->cmplx;

	      run_xprism_2D(form_master, master.xprism, marker_type, line_type,
			    whichband, cmplx);

	      if (gwin != NULL)
	      {
	          update_tics(form_master, master.options->tics); 

	          if ((xprism2_args->annotation_in_file != NULL) &&
		      !(did_overlays))
	          {
                       filename = vfullpath(xprism2_args->annotation_in_file, 
                                            global_indir, NULL);
                       if (tmp_list = read_overlays(canvas, filename))
                        obj_list = tmp_list;
                       free(filename);
	          }
	      }
	   }
	   else if (master.xvoverlay_selected)
	      run_xvoverlay(form_master, master.xvoverlay);

	   else if (master.output_selected)
	      run_output(form_master, master.output);

	   else if (master.answer_selected)
	      run_answer(form_master, master.answer, &master, &xprism2_args);

	   else if (master.options_selected) 
	   {
              run_options_2D(form_master, master.options);
	   }

	   xvf_clear_selections(form_master->db, form_master->line_num);


	} while (!master.quit);


	/* unmap the workspace, and destroy gwin structure */
	if (gwin != NULL)
	{
	   freegwin();
	}
	XSync(display, 0); XCloseDisplay(display); 
	khoros_close();

} /* end main */



/**************************************************************
*
* MODULE NAME: set_gwin_attr_2D
*
*     PURPOSE: This module is get graphics workspace attributes
*		for xprism2 from command line arguments, and set
*		them in the gwin_attr struct
*
*       INPUT: - arguments to xprism2
*
*      OUTPUT: plot(s) displayed as specified
*
* CALLED FROM: main
*
* MODIFIED: Aug 12, 1990 by John M. Salas
*		- Restructured code since all the defaults are set
*		  in init_xprism2() and are passed in the structure
*		  xprism2_args.  Nolonger had to set defaults here.
*
**************************************************************/

set_gwin_attr_2D(xprism2_args)
xprism2_struct *xprism2_args;

{
  xp2_area_info_struct *area_info;

  int i, plot_area;
  char     *title, *xaxis, *yaxis;
  int       axes, grid, auto_scale, legend, box, rescale_relabel,
	    fonts[6], colors[MAX_COLORS], numlabels, machtype, clear_labels;
  Coord     scale, tics;

  for ( plot_area = 1 ; plot_area <= xprism2_args->number_areas ; plot_area++ )
  {
     area_info = xprism2_args->area_info[plot_area - 1];

     if ( area_info != NULL )
     {
	/* initialize fonts */
	fonts[TITLE] = area_info->title_font;
	fonts[XAXIS] = area_info->xaxis_font;
	fonts[YAXIS] = area_info->yaxis_font;
	fonts[LEGEND]= area_info->legend_font;
	fonts[NUMBERS] = area_info->numbers_font;
        fonts[ZAXIS] = area_info->yaxis_font; /* set a default, doesn't matter,
						 since we never use it */

	/* set labels according to cmd line or default */

	title = xvf_strcpy(area_info->title);
	
	xaxis = xvf_strcpy(area_info->xaxis);

	yaxis = xvf_strcpy(area_info->yaxis);

	/* set colors for labels, axes, grid, etc */
	colors[TITLE_COLOR]  = area_info->title_color;
	colors[XTITLE_COLOR] = area_info->xaxis_label_color;
	colors[YTITLE_COLOR] = area_info->yaxis_label_color;
	colors[XAXIS_COLOR]  = area_info->xaxis_color;
	colors[YAXIS_COLOR]  = area_info->yaxis_color;
	colors[XNUMS_COLOR]  = area_info->num_xaxis_color;
	colors[YNUMS_COLOR]  = area_info->num_yaxis_color;
	colors[GRID_COLOR]   = area_info->grid_color;
	colors[LEGEND_COLOR] = area_info->legend_color;
	colors[ZTITLE_COLOR] = 0;
	colors[ZAXIS_COLOR]  = 0;
	colors[ZNUMS_COLOR]  = 0;

        /* set box for axes */
	box = area_info->box;

        /* set machine type for axes */
	machtype = area_info->machine_type;

        /* set numerical labels for axes */
	numlabels = area_info->numerical_labels;

        /* set axes or rescaling by default */
	rescale_relabel = area_info->rescale_relabel;

        /* set the clear_labels flag to false */
	clear_labels = area_info->clear_labels;

	/* set axes  */
	axes = area_info->axes;

	/* set legend  */
	legend = area_info->legend;

	/* set grid  */
	grid = area_info->grid;

	/* set auto_scale  */
	auto_scale = area_info->auto_scale;

	/* set scale  */
/* all axes scale code is commented out until it can be reworked
	scale.x = area_info->scale.x;
	scale.y = area_info->scale.y;
	scale.z = -1;
*/

	scale.x = 0;
	scale.y = 0;
	scale.z = -1;

        /* set minor tics */
	tics.x = area_info->x_tics;
	tics.y = area_info->y_tics;
	tics.z = -1;

	init_gwin_attr( 1, title, xaxis, yaxis, NULL, grid, auto_scale, axes,
			box, legend, scale, fonts, colors, tics, numlabels,
			rescale_relabel, machtype, clear_labels, 0.0, 0.0,
			0.0, 0.0);

	free(title);
	title = NULL;

	free(xaxis);
	xaxis = NULL;

	free(yaxis);
	yaxis = NULL;

    }
  }
}

/**************************************************************
*
* MODULE NAME: start_cmd_plot_2D
*
*     PURPOSE: This module is used to start xprism from 
*	       input files and/or functions entered as
*	       command line arguments 
*
*       INPUT: xprism2_args - arguments to xprism2
*
*      OUTPUT: plot(s) displayed as specified
*
* CALLED FROM: main
*
* MODIFIED: Aug 12, 1990 by John M. Salas
*		- Restructured code since all the defaults are set
*
**************************************************************/

start_cmd_plot_2D(xprism2_args)
xprism2_struct *xprism2_args;

{

  xp2_area_info_struct *area_info;
  xp2_plot_info_struct *plot_info;

  XPlot *plot, *get_input_file(), *get_function();

  char *function, temp[512], *xrange, error[1024];	
  int data_format, data_type, first_gwin = TRUE, plot_area, plot_number;

  for ( plot_area = 1 ; plot_area <= xprism2_args->number_areas ; plot_area++ )
  {

    area_info = xprism2_args->area_info[plot_area - 1];

    for ( plot_number = 1 ; area_info != NULL &&
	  plot_number <= area_info->number_plots ; plot_number++ )
    {

      plot_info = area_info->plot_info[plot_number - 1];

      if ( plot_info != NULL )
      {
	if ( plot_info->i_file != NULL )
	{
/*
   Translate command line representation of data_format to xvplot.
*/
	    if ( plot_info->data_format == MAX_DATA_FORMAT )
	    {
	      data_format = Y_ONLY;
	    }
	    else
	    {
	      data_format = XY_PAIRS;
	    }
/*
   Translate command line representation of data_type to xvplot.
*/
	    if ( plot_info->data_type == MAX_DATA_TYPE )
	    {
	      data_type = VFF_TYP_FLOAT;
	    }
	    else if ( plot_info->data_type == (MAX_DATA_TYPE - 1) )
	    {
	      data_type = VFF_TYP_4_BYTE;
	    }
	    else
	    {
	      data_type = plot_info->data_type;
	    }

	    plot = get_input_file(plot_info->i_file,
				  plot_info->plot_type + PLOT_2D,
				  data_format, plot_info->machine_type,
				  data_type, 0, plot_info->whichband,
				  plot_info->cmplx);

	    if (plot == NULL) 
	    {
	      khoros_close();
	    }

	}
	else if ( plot_info->func_str != NULL )
	{
	    sprintf(temp, "f(x) = %s", plot_info->func_str);
	    function = xvf_strcpy(temp);
	    sprintf(temp,"x = (%s,%s,%s)", plot_info->func_xmin, 
		    plot_info->func_xmax, plot_info->func_ptnum);
	    xrange = xvf_strcpy(temp);
	    plot = get_function(plot_info->plot_type + PLOT_2D, 
				function, xrange, NULL, error);

	    free(function);
	    function = NULL;

	    free(xrange);
	    xrange = NULL;

	    if (plot == NULL) 
	    {
	      fprintf(stderr,"%s", error);
	      khoros_close();
	    }

	}

	if ( first_gwin )
	{
	    first_gwin = FALSE;

	    gwin = create_new_gwin(plot, plot_info->plot_type + PLOT_2D, 
				   plot_info->marker_type,
				   plot_info->line_type,
				   plot_info->step_size,
				   plot_info->begin_point,
				   plot_info->end_point,
				   plot_info->plot_color,
				   plot_info->step_size,
				   plot_info->begin_point,
				   plot_info->end_point,
				   plot_info->legend_str,
				   plot_info->active);
	}
	else
	{
	    assign_plot_to_gwin(plot, plot_info->plot_type + PLOT_2D, 
				plot_info->marker_type,
				plot_info->line_type,
				plot_info->step_size,
				plot_info->begin_point,
				plot_info->end_point,
				plot_info->plot_color,
				plot_info->step_size,
				plot_info->begin_point,
				plot_info->end_point,
				plot_info->legend_str,
				plot_info->active);
	    reset_world_coordinates();
	}

	if (gwin == NULL) 
	{
	  fprintf(stderr, "This should not have happened, no user input\n");
	  fprintf(stderr, "was specified, but I could of sworn I got some.\n");
	  khoros_close();
	}
      }

      area_info->plot_info[plot_number - 1] = NULL;

    }


    if ( area_info->numerical_scale_specified_xmin &&
	 area_info->numerical_scale_specified_xmax &&
	 area_info->numerical_scale_specified_xint )
    {
      set_gwin_min_max_intv_x(RESCALE, area_info->xmin, area_info->xmax,
			      area_info->major_xint);
    }

    if ( area_info->numerical_scale_specified_ymin &&
	 area_info->numerical_scale_specified_ymax &&
	 area_info->numerical_scale_specified_yint )
    {
      set_gwin_min_max_intv_y(RESCALE, area_info->ymin, area_info->ymax,
			      area_info->major_yint);
    }

    if ( area_info->numerical_relabel_specified_xmin &&
	 area_info->numerical_relabel_specified_xmax &&
	 area_info->numerical_relabel_specified_xint )
    {
      set_gwin_min_max_intv_x(RELABEL, area_info->xlabel_min,
			      area_info->xlabel_max,
			      area_info->major_xlabel_int);
    }

    if ( area_info->numerical_relabel_specified_ymin &&
	 area_info->numerical_relabel_specified_ymax &&
	 area_info->numerical_relabel_specified_yint )
    {
      set_gwin_min_max_intv_y(RELABEL, area_info->ylabel_min,
			      area_info->ylabel_max,
			      area_info->major_ylabel_int);
    }

    free(area_info);
    xprism2_args->area_info[plot_area - 1] = NULL;

  }
}

/**************************************************************
*
* MODULE NAME: change_xprism2_forms
*
*     PURPOSE: This module is changes values in the xprism2 forms
*	       according to command line arguments
*
*       INPUT: xprism2_args - arguments to xprism2
*
*      OUTPUT: plot(s) displayed as specified
*
* CALLED FROM: main
*
* MODIFIED: Aug 14, 1990 by John M. Salas
*		- Restructured code to set all the form values
*		  using either the defaults, command line or
*		  answer file specifications.
*
**************************************************************/

change_xprism2_forms(form, xprism2_args, master)
xvf_form        *form;
xprism2_struct 	*xprism2_args;
Master 	   	*master;
{
  xp2_area_info_struct *area_info;

  int plot_area;
  char temp[100], *fontstring,  *color;
  char *font_type_string(), *color_string();
    
  for ( plot_area = 1 ; plot_area <= xprism2_args->number_areas ; plot_area++ )
  {

    area_info = xprism2_args->area_info[plot_area - 1];

    if ( area_info != NULL )
    {
/*
   PLOT SUBFORM INPUT FILE PANE
*/
	sprintf(temp, "%d", area_info->begin_point);
	xvf_change_input(form, master->xprism->input_file->begin_point_index,
			 xvf_intval_chng, temp, 0);
	xvf_change_input(form,master->xprism->input_function->begin_point_index,
			 xvf_intval_chng, temp, 0);
	xvf_change_input(form, master->options->attributes->begin_point_index,
			 xvf_intval_chng, temp, 0);
	master->xprism->input_file->begin_point = area_info->begin_point;
	master->xprism->input_function->begin_point = area_info->begin_point;
	master->options->attributes->begin_point = area_info->begin_point;

	sprintf(temp, "%d", area_info->end_point);
	xvf_change_input(form, master->xprism->input_file->end_point_index,
			 xvf_intval_chng, temp, 0);
	xvf_change_input(form, master->xprism->input_function->end_point_index,
			 xvf_intval_chng, temp, 0);
	xvf_change_input(form, master->options->attributes->end_point_index,
			 xvf_intval_chng, temp, 0);
	master->xprism->input_file->end_point = area_info->end_point;
	master->xprism->input_function->end_point = area_info->end_point;
	master->options->attributes->end_point = area_info->end_point;

	sprintf(temp, "%d", area_info->step_size);
	xvf_change_input(form, master->xprism->input_file->step_size_index,
			 xvf_intval_chng, temp, 0);
	xvf_change_input(form, master->xprism->input_function->step_size_index,
			 xvf_intval_chng, temp, 0);
	xvf_change_input(form, master->options->attributes->step_size_index,
			 xvf_intval_chng, temp, 0);
	master->xprism->input_file->step_size = area_info->step_size;
	master->xprism->input_function->step_size = area_info->step_size;
	master->options->attributes->step_size = area_info->step_size;

  /* change the plot type toggle */
	sprintf(temp, "%d", area_info->plot_type + 1);
	xvf_change_input(form,
			 master->xprism->input_file->change_plot_type_index,
			 xvf_toggleval_chng, temp, 0);
	xvf_change_input(form,
			 master->xprism->input_function->change_plot_type_index,
			 xvf_toggleval_chng, temp, 0);
	xvf_change_input(form,
			 master->options->attributes->change_plot_type_index,
			 xvf_toggleval_chng, temp, 0);
	master->xprism->input_file->change_plot_type_val =
		area_info->plot_type + PLOT_2D;
	master->xprism->input_function->change_plot_type_val =
		area_info->plot_type + PLOT_2D;
	master->options->attributes->change_plot_type_val =
		area_info->plot_type + PLOT_2D;

	sprintf(temp, "%d", area_info->data_format);
	xvf_change_input(form, master->xprism->input_file->data_format_index,
			 xvf_toggleval_chng, temp, 0);
	master->xprism->input_file->data_format_val = area_info->data_format;

	sprintf(temp, "%d", area_info->data_type);
	xvf_change_input(form, master->xprism->input_file->data_type_index,
			 xvf_toggleval_chng, temp, 0);
	master->xprism->input_file->data_type_val = area_info->data_type;

	xvf_change_input(form,
			 master->xprism->input_file->machine_type_index + 1,
			 xvf_title_chng,
			 machine_defs[area_info->machine_type].hosttype, 20);

/*
   PLOT SUBFORM INPUT FUNCTION PANE
*/

	sprintf(temp, "%s", area_info->func_xmin);
	xvf_change_input(form, master->xprism->input_function->x_min_index,
		   xvf_stringval_chng, temp, 0);
	master->xprism->input_function->x_min =
		xvf_strcpy(area_info->func_xmin);

	sprintf(temp, "%s", area_info->func_xmax);
	xvf_change_input(form, master->xprism->input_function->x_max_index,
		   xvf_stringval_chng, temp, 0);
	master->xprism->input_function->x_max =
		xvf_strcpy(area_info->func_xmax);

	sprintf(temp, "%s", area_info->func_ptnum);
	xvf_change_input(form, master->xprism->input_function->xnum_pts_index,
		   xvf_stringval_chng, temp, 0);
	master->xprism->input_function->xnum_pts =
		xvf_strcpy(area_info->func_ptnum);

/*
   PLOT SUBFORM ATTRIBUTES PANE
*/

  /* change the line type */
	sprintf(temp, "%d", area_info->line_type);
	xvf_change_input(form,
			 master->options->attributes->change_line_type_index,
			 xvf_toggleval_chng, temp, 0);
	master->options->attributes->change_line_type_val = area_info->line_type;

  /* change the marker type */
	sprintf(temp, "%d", area_info->marker_type);
	xvf_change_input(form,
			 master->options->attributes->change_marker_type_index,
			 xvf_toggleval_chng, temp, 0);
	master->options->attributes->change_marker_type_val =
		area_info->marker_type;

/*
   OPTION SUBFORM LABELS PANE
*/

  /* put in the title */
	xvf_change_input(form, master->options->label->title_index,
			 xvf_stringval_chng, area_info->title, 0);
  
  /* put in the x axis */
	xvf_change_input(form, master->options->label->xaxis_index,
			 xvf_stringval_chng, area_info->xaxis, 0);

  /* put in the y axis */
	xvf_change_input(form, master->options->label->yaxis_index,
			 xvf_stringval_chng, area_info->yaxis, 0);

  /* change the title font type */
	fontstring = font_type_string(area_info->title_font);
	xvf_change_input(form,master->options->label->title_font_index+1,
			 xvf_title_chng,fontstring,20);
	free(fontstring);
	fontstring = NULL;

  /* change the X Axis font type */
	fontstring = font_type_string(area_info->xaxis_font);
	xvf_change_input(form,master->options->label->xaxis_font_index+1,
			 xvf_title_chng,fontstring,20);
	free(fontstring);
	fontstring = NULL;

  /* change the Y Axis font type */
	fontstring = font_type_string(area_info->yaxis_font);
	xvf_change_input(form,master->options->label->yaxis_font_index+1,
			 xvf_title_chng,fontstring,20);
	free(fontstring);
	fontstring = NULL;

  /* change the Numbers font type */
	fontstring = font_type_string(area_info->numbers_font);
	xvf_change_input(form,master->options->label->num_font_index+1,
			 xvf_title_chng,fontstring,20);
	free(fontstring);
	fontstring = NULL;

  /* change the Legends font type */
	fontstring = font_type_string(area_info->legend_font);
	xvf_change_input(form,master->options->label->legend_font_index+1,
			 xvf_title_chng,fontstring,20);
	free(fontstring);
	fontstring = NULL;

/*
   OPTION SUBFORM LABELS PANE

   NOTE: UPDATE TICS SET MINIMUM, MAXIMUM, and INTERVAL.
*/

/* axes code commented out until it can be reworked
	sprintf(temp, "%d", area_info->scale.x);
	xvf_change_input(form, master->options->tics->change_xaxes_scale_index,
			 xvf_toggleval_chng, temp, 0);
	master->options->tics->change_xaxes_scale_val = area_info->scale.x;

	sprintf(temp, "%d", area_info->scale.y);
	xvf_change_input(form, master->options->tics->change_yaxes_scale_index,
			 xvf_toggleval_chng, temp, 0);
	master->options->tics->change_yaxes_scale_val = area_info->scale.y;
*/

	sprintf(temp, "%d", area_info->grid);
	xvf_change_input(form, master->options->tics->grid_index,
			 xvf_logicalval_chng, temp, 0);

	sprintf(temp, "%d", ! area_info->clear_labels);
	xvf_change_input(form, master->options->tics->clear_labels_index,
			 xvf_logicalval_chng, temp, 0);


	sprintf(temp, "%d", area_info->box);
	xvf_change_input(form, master->options->tics->box_index,
			 xvf_logicalval_chng, temp, 0);

	sprintf(temp, "%d", area_info->axes);
	xvf_change_input(form, master->options->tics->axes_index,
			 xvf_logicalval_chng, temp, 0);

	sprintf(temp, "%d", area_info->numerical_labels);
	xvf_change_input(form, master->options->tics->num_labels_index,
			 xvf_logicalval_chng, temp, 0);

	sprintf(temp, "%d", area_info->legend);
	xvf_change_input(form, master->options->tics->legend_index,
			 xvf_logicalval_chng, temp, 0);

	sprintf(temp, "%d", area_info->auto_scale);
	xvf_change_input(form, master->options->tics->auto_scale_index,
			 xvf_logicalval_chng, temp, 0);

	sprintf(temp, "%d", area_info->rescale_relabel);
	xvf_change_input(form, master->options->tics->change_labeling_index,
			 xvf_toggleval_chng, temp, 0);
	master->options->tics->change_labeling_val = area_info->rescale_relabel;

  /* change value listed for number of minor tics on the X axis */
	sprintf(temp, "%d", area_info->x_tics);
	xvf_change_input(form, master->options->tics->minor_xtics_index,
			 xvf_intval_chng, temp, 0);

  /* change value listed for number of minor tics on the Y axis */
	sprintf(temp, "%d", area_info->y_tics);
	xvf_change_input(form, master->options->tics->minor_ytics_index,
			 xvf_intval_chng, temp, 0);
	
/*
   OPTION SUBFORM COLORS PANE
*/

	color = color_string(area_info->title_color);
	xvf_change_input(form, master->options->colors->title_index+1,
			 xvf_title_chng, color, 25);
	free(color);
	color = NULL;

	color = color_string(area_info->xaxis_label_color);
	xvf_change_input(form, master->options->colors->xaxis_label_index+1,
			 xvf_title_chng, color, 25);
	free(color);
	color = NULL;

	color = color_string(area_info->yaxis_label_color);
	xvf_change_input(form, master->options->colors->yaxis_label_index+1,
			 xvf_title_chng, color, 25);
	free(color);
	color = NULL;

	color = color_string(area_info->xaxis_color);
	xvf_change_input(form, master->options->colors->xaxis_index+1,
			 xvf_title_chng, color, 25);
	free(color);
	color = NULL;

	color = color_string(area_info->yaxis_color);
	xvf_change_input(form, master->options->colors->yaxis_index+1,
			 xvf_title_chng, color, 25);
	free(color);
	color = NULL;

	color = color_string(area_info->num_xaxis_color);
	xvf_change_input(form, master->options->colors->xaxis_nums_index+1,
			 xvf_title_chng, color, 25);
	free(color);
	color = NULL;

	color = color_string(area_info->num_yaxis_color);
	xvf_change_input(form, master->options->colors->yaxis_nums_index+1,
			 xvf_title_chng, color, 25);
	free(color);
	color = NULL;

	color = color_string(area_info->grid_color);
	xvf_change_input(form, master->options->colors->grid_index+1,
			 xvf_title_chng, color, 25);
	free(color);
	color = NULL;

	color = color_string(area_info->legend_color);
	xvf_change_input(form, master->options->colors->legend_index+1,
			 xvf_title_chng, color, 25);
	free(color);
	color = NULL;

    }
  }

/*
   PLOT SUBFORM ENVIRONMENT PANE
*/

  /* change Global Input directory */
  xvf_change_input(form, master->xprism->environment->input_path_index,
		   xvf_stringval_chng, xprism2_args->indir, 0);
  master->xprism->environment->input_path = xvf_strcpy(xprism2_args->indir);
			
  /* change Global Output directory on Plot subform, Env pane */
  xvf_change_input(form, master->xprism->environment->output_path_index,
		   xvf_stringval_chng, xprism2_args->outdir, 0);
  master->xprism->environment->output_path = xvf_strcpy(xprism2_args->outdir);

/*
   ANNOTATION SUBFORM FILE PANE
*/

  if ( xprism2_args->annotation_in_file != NULL )
  {
    xvf_change_input(form, master->xvoverlay->ovfile->ov_input_index,
		     xvf_inputfile_chng, xprism2_args->annotation_in_file, 0);
    master->xvoverlay->ovfile->ov_input =
		xvf_strcpy(xprism2_args->annotation_in_file);
  }

  if ( xprism2_args->annotation_out_file != NULL )
  {
    xvf_change_input(form, master->xvoverlay->ovfile->ov_output_index,
		     xvf_outputfile_chng, xprism2_args->annotation_out_file, 0);
    master->xvoverlay->ovfile->ov_output =
		xvf_strcpy(xprism2_args->annotation_out_file);
  }

/*
   OUTPUT SUBFORM FILES PANE
*/

  if ( xprism2_args->explicit_imagefile != NULL )
  {
    xvf_change_input(form, master->output->file->expl_filename_index,
		     xvf_outputfile_chng, xprism2_args->explicit_imagefile, 0);
    master->output->file->expl_filename = 
		xvf_strcpy(xprism2_args->explicit_imagefile);
  }

  if ( xprism2_args->implicit_imagefile != NULL )
  {
    xvf_change_input(form, master->output->file->impl_filename_index,
		     xvf_outputfile_chng, xprism2_args->implicit_imagefile, 0);
    master->output->file->impl_filename = 
		xvf_strcpy(xprism2_args->implicit_imagefile);
  }
  if ( xprism2_args->colormap_imagefile != NULL )
  {
    xvf_change_input(form, master->output->file->cm_filename_index,
		     xvf_outputfile_chng, xprism2_args->colormap_imagefile, 0);
    master->output->file->cm_filename = 
		xvf_strcpy(xprism2_args->colormap_imagefile);
  }

  if ( xprism2_args->screendump_file != NULL )
  {
    xvf_change_input(form, master->output->file->dump_filename_index,
		     xvf_outputfile_chng, xprism2_args->screendump_file, 0);
    master->output->file->dump_filename = 
		xvf_strcpy(xprism2_args->screendump_file);
  }

/*
   OUTPUT SUBFORM POSTSCRIPT PANE
*/

  if ( xprism2_args->postscr_printer != NULL )
  {
    xvf_change_input(form, master->output->postscr->printer_index,
		     xvf_stringval_chng, xprism2_args->postscr_printer, 0);
    master->output->postscr->printer = 
		xvf_strcpy(xprism2_args->postscr_printer);
  }

  if ( xprism2_args->postscr_file != NULL )
  {
    xvf_change_input(form, master->output->postscr->filename_index,
		     xvf_outputfile_chng, xprism2_args->postscr_file, 0);
    master->output->postscr->filename = 
		xvf_strcpy(xprism2_args->postscr_file);
  }

  sprintf(temp, "%d", xprism2_args->postscr_flush);
  xvf_change_input(form, master->output->postscr->flush_index,
		   xvf_logicalval_chng, temp, 0);
  master->output->postscr->flush = xprism2_args->postscr_flush;

  sprintf(temp, "%d", xprism2_args->postscr_invert);
  xvf_change_input(form, master->output->postscr->invert_index,
		   xvf_logicalval_chng, temp, 0);
  master->output->postscr->invert = xprism2_args->postscr_invert;

  sprintf(temp, "%d", xprism2_args->postscr_landscape);
  xvf_change_input(form, master->output->postscr->landscape_index,
		   xvf_logicalval_chng, temp, 0);
  master->output->postscr->landscape = xprism2_args->postscr_landscape;

  sprintf(temp, "%d", xprism2_args->postscr_mono);
  xvf_change_input(form, master->output->postscr->mono_index,
		   xvf_logicalval_chng, temp, 0);
  master->output->postscr->mono = xprism2_args->postscr_mono;

  sprintf(temp, "%g", xprism2_args->postscr_width);
  xvf_change_input(form, master->output->postscr->width_index,
		   xvf_floatval_chng, temp, 0);
  master->output->postscr->width = xprism2_args->postscr_width;

  sprintf(temp, "%g", xprism2_args->postscr_height);
  xvf_change_input(form, master->output->postscr->height_index,
		   xvf_floatval_chng, temp, 0);
  master->output->postscr->height = xprism2_args->postscr_height;

  sprintf(temp, "%g", xprism2_args->postscr_xoffset);
  xvf_change_input(form, master->output->postscr->x_offset_index,
		   xvf_floatval_chng, temp, 0);
  master->output->postscr->x_offset = xprism2_args->postscr_xoffset;

  sprintf(temp, "%g", xprism2_args->postscr_yoffset);
  xvf_change_input(form, master->output->postscr->y_offset_index,
		   xvf_floatval_chng, temp, 0);
  master->output->postscr->y_offset = xprism2_args->postscr_yoffset;

  sprintf(temp, "%d", xprism2_args->postscr_output_type);
  xvf_change_input(form, master->output->postscr->output_type_index,
		   xvf_toggleval_chng, temp, 0);
  master->output->postscr->output_type_val = xprism2_args->postscr_output_type;

/*
   OUTPUT SUBFORM IMAGEN PANE
*/

  if ( xprism2_args->imagen_printer != NULL )
  {
    xvf_change_input(form, master->output->imagen->printer_index,
		     xvf_stringval_chng, xprism2_args->imagen_printer, 0);
    master->output->imagen->printer = 
		xvf_strcpy(xprism2_args->imagen_printer);
  }

  if ( xprism2_args->imagen_file != NULL )
  {
    xvf_change_input(form, master->output->imagen->filename_index,
		     xvf_outputfile_chng, xprism2_args->imagen_file, 0);
    master->output->imagen->filename = 
		xvf_strcpy(xprism2_args->imagen_file);
  }

  sprintf(temp, "%d", xprism2_args->imagen_flush);
  xvf_change_input(form, master->output->imagen->flush_index,
		   xvf_logicalval_chng, temp, 0);
  master->output->imagen->flush = xprism2_args->imagen_flush;

  sprintf(temp, "%d", xprism2_args->imagen_invert);
  xvf_change_input(form, master->output->imagen->invert_index,
		   xvf_logicalval_chng, temp, 0);
  master->output->imagen->invert = xprism2_args->imagen_invert;

  sprintf(temp, "%g", xprism2_args->imagen_width);
  xvf_change_input(form, master->output->imagen->width_index,
		   xvf_floatval_chng, temp, 0);
  master->output->imagen->width = xprism2_args->imagen_width;

  sprintf(temp, "%g", xprism2_args->imagen_height);
  xvf_change_input(form, master->output->imagen->height_index,
		   xvf_floatval_chng, temp, 0);
  master->output->imagen->height = xprism2_args->imagen_height;

  sprintf(temp, "%g", xprism2_args->imagen_xoffset);
  xvf_change_input(form, master->output->imagen->x_offset_index,
		   xvf_floatval_chng, temp, 0);
  master->output->imagen->x_offset = xprism2_args->imagen_xoffset;

  sprintf(temp, "%g", xprism2_args->imagen_yoffset);
  xvf_change_input(form, master->output->imagen->y_offset_index,
		   xvf_floatval_chng, temp, 0);
  master->output->imagen->y_offset = xprism2_args->imagen_yoffset;

  sprintf(temp, "%d", xprism2_args->imagen_output_type);
  xvf_change_input(form, master->output->imagen->output_type_index,
		   xvf_toggleval_chng, temp, 0);
  master->output->imagen->output_type_val = xprism2_args->imagen_output_type;

/*
   OUTPUT SUBFORM HPGL PANE
*/

  if ( xprism2_args->hpgl_printer != NULL )
  {
    xvf_change_input(form, master->output->hpgl->printer_index,
		     xvf_stringval_chng, xprism2_args->hpgl_printer, 0);
    master->output->hpgl->printer = 
		xvf_strcpy(xprism2_args->hpgl_printer);
  }

  if ( xprism2_args->hpgl_file != NULL )
  {
    xvf_change_input(form, master->output->hpgl->filename_index,
		     xvf_outputfile_chng, xprism2_args->hpgl_file, 0);
    master->output->hpgl->filename = 
		xvf_strcpy(xprism2_args->hpgl_file);
  }

  sprintf(temp, "%d", xprism2_args->hpgl_flush);
  xvf_change_input(form, master->output->hpgl->flush_index,
		   xvf_logicalval_chng, temp, 0);
  master->output->hpgl->flush = xprism2_args->hpgl_flush;

  sprintf(temp, "%d", xprism2_args->hpgl_landscape);
  xvf_change_input(form, master->output->hpgl->landscape_index,
		   xvf_logicalval_chng, temp, 0);
  master->output->hpgl->landscape = xprism2_args->hpgl_landscape;

  sprintf(temp, "%g", xprism2_args->hpgl_width);
  xvf_change_input(form, master->output->hpgl->width_index,
		   xvf_floatval_chng, temp, 0);
  master->output->hpgl->width = xprism2_args->hpgl_width;

  sprintf(temp, "%g", xprism2_args->hpgl_height);
  xvf_change_input(form, master->output->hpgl->height_index,
		   xvf_floatval_chng, temp, 0);
  master->output->hpgl->height = xprism2_args->hpgl_height;

  sprintf(temp, "%g", xprism2_args->hpgl_xoffset);
  xvf_change_input(form, master->output->hpgl->x_offset_index,
		   xvf_floatval_chng, temp, 0);
  master->output->hpgl->x_offset = xprism2_args->hpgl_xoffset;

  sprintf(temp, "%g", xprism2_args->hpgl_yoffset);
  xvf_change_input(form, master->output->hpgl->y_offset_index,
		   xvf_floatval_chng, temp, 0);
  master->output->hpgl->y_offset= xprism2_args->hpgl_yoffset;

/*
   OUTPUT SUBFORM LN03 PANE
*/

  if ( xprism2_args->ln03_printer != NULL )
  {
    xvf_change_input(form, master->output->ln03->printer_index,
		     xvf_stringval_chng, xprism2_args->ln03_printer, 0);
    master->output->ln03->printer = 
		     xvf_strcpy(xprism2_args->ln03_printer);
  }

  if ( xprism2_args->ln03_file != NULL )
  {
    xvf_change_input(form, master->output->ln03->filename_index,
		     xvf_outputfile_chng, xprism2_args->ln03_file, 0);
    master->output->ln03->filename = 
		     xvf_strcpy(xprism2_args->ln03_file);
  }

  sprintf(temp, "%d", xprism2_args->ln03_invert);
  xvf_change_input(form, master->output->ln03->invert_index,
		   xvf_logicalval_chng, temp, 0);
  master->output->ln03->invert = xprism2_args->ln03_invert;

/*
   ANSWER FILE PANE
*/
  if ( xprism2_args->output_answer_file != NULL )
  {
    xvf_change_input(form, master->answer->ans_file->out_answer_file_index,
		     xvf_outputfile_chng, xprism2_args->output_answer_file, 0);
    master->answer->ans_file->out_answer_file =
		xvf_strcpy(xprism2_args->output_answer_file);
  }

}
