 /*
  * Khoros: $Id: run_xprism2.c,v 1.5 1992/03/25 17:29:45 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: run_xprism2.c,v 1.5 1992/03/25 17:29:45 dkhoros Exp $";
#endif

 /*
  * $Log: run_xprism2.c,v $
 * Revision 1.5  1992/03/25  17:29:45  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xprism2.h"	


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: run_xprism2.c  
   >>>>
   >>>>   description: This file contains thje routines to drive
   >>>>			the plot pane.
   >>>>  
   >>>>      routines:
   >>>> 		run_xprism_2D()
   >>>> 		run_environment()
   >>>> 		run_input_file()
   >>>> 		run_transforms ()
   >>>>   
   >>>> modifications:	
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#define MAXNAMELENGTH 30


/************************************************************
*
*  MODULE NAME: run_xprism_2D
*
*      PURPOSE: Drives the Xprism subform -- 
*		Called after the user clicks on an action
*		button on one of the "Xprism" subform's panes.
*
*	 INPUT:   form - pointer to the form tree
*                 xprism_info - pointer to the Xprism Subform
*				information structure
*       OUTPUT: none
*
*    CALLED BY: main
*
*   WRITTEN BY: Mark Young, & Mike Lang
*
*
*************************************************************/

void run_xprism_2D(form, xprism_info, marker_type, line_type, whichband, cmplx)

xvf_form	*form;
Master_xprism   *xprism_info;
int		marker_type, line_type, whichband, cmplx;
{

	_xvf_get_xprism(form, xprism_info);

	if (xprism_info->quit)
	   xvf_change_active(form, false);

	/*
	 * action came from the 'input_file' pane
	 */
	else if (xprism_info->input_file_selected)
	    run_input_file(form, xprism_info->input_file, 
                           marker_type, line_type, whichband, cmplx);

	/*
	 * action came from the 'input_function' pane
	 */
	else if (xprism_info->input_function_selected)
	    run_input_function(form, xprism_info->input_function,
                               marker_type, line_type);

	/*
	 * action came from the 'transforms' pane
	 */
	else if (xprism_info->transforms_selected)
	    run_transforms(form, xprism_info->transforms);

	/*
	 * action came from the 'environment' pane
	 */
	else if (xprism_info->environment_selected)
	    run_environment(form, xprism_info->environment);



}   /* end run_xprism */



/************************************************************
*
*  MODULE NAME: run_environment
*
*      PURPOSE: Drives the Environment pane of the Xprism subform -- 
*		Called after the user clicks on "Set Environment",
*		it sets the Global Input Directory (global_indir)
*		and the Global Output Directory (global_outdir)
*		which have been previously set by the user on the
*		Environment pane, and passed back by xvforms
*		in the "form.environment" structure 
*		
*	INPUT:  form - pointer to the form tree
*		environ_info - pointer to the Environment Pane 
*				information structure
*
*       OUTPUT: none
*
*    CALLED BY: Main
*
*   WRITTEN BY: Danielle Argiro, Mark Young, & Mike Lang
*
*
*************************************************************/


run_environment(form, environ_info)

xvf_form	*form;
xprism_environment *environ_info;
{
	_xvf_get_environment(form, environ_info);

	if (global_indir != NULL)
	   free(global_indir);
	global_indir = xvf_strcpy(environ_info->input_path);

	if (global_outdir != NULL)
	   free(global_outdir);
	global_outdir = xvf_strcpy(environ_info->output_path);

	XVF_FILE_DIR = xvf_strcpy(global_indir);
}



/************************************************************
*
*  MODULE NAME: run_input_file
*
*
*      PURPOSE: Drives the Input pane of the Xprism form -- 
*		Called after the user clicks on "Plot",
*		It first determines which type of plot is desired
*		according to the plot type; then, according to whether 
*		the user has selected "Input Type" as a file or a function,
*		it reads the file or parses the function in order to
*		create the appropriate plot structure.  It then plots
*		the information provided, alone in a graphics workspace
*		if this was the first operation, or on top of the other
*		plots already there if it was not.
*
*	INPUT:  form - pointer to the form tree
*		input_info - pointer to the Input Pane information structure
*
*       OUTPUT: A new plot displayed in the graphics workspace
*
*    CALLED BY: main
*
*   WRITTEN BY: Danielle Argiro and Mark Young
*
*
*************************************************************/

run_input_file(form, input_file_info, marker_type, line_type, whichband, cmplx)

xvf_form *form;
xprism_input_file *input_file_info;
int		marker_type, line_type, whichband, cmplx;
{
	XPlot *plot, *get_input_file();
	int  plot_type;
        XawListReturnStruct *machine_list_return;
        char *prompt1 = "Pick Input Raw Data Machine Type";
        char *label1 = "Machine Type List";
        char *mach_name, **machine_list, *mesg;
        int num_machines, col_num = 1, current, machorder();
        int i;
        int machine_type, data_type, begin_point, end_point, data_format;
	int mach_type_index, step_size;

	_xvf_get_input_file(form, input_file_info);


        /*
         *  toggles start at 1, since PLOT_2D does not start at 1 we need to
         *  add it's offset -1 to get the appropriate 2D plot type.
         */

        plot_type = input_file_info->change_plot_type_val + (PLOT_2D - 1);
        switch(input_file_info->data_type_val)
        {
           case 1:  /* BYTE */
              data_type = VFF_TYP_1_BYTE;
              break;
           case 2:  /* BYTE */
              data_type = VFF_TYP_2_BYTE;
              break;
           case 3:  /* BYTE */
              data_type = VFF_TYP_4_BYTE;
              break;
           case 4:  /* BYTE */
              data_type = VFF_TYP_FLOAT;
              break;
           default:
              xvf_error_wait("An unknown data type has been encountered.  Please select a valid data type", "run_input_file", NULL);
              break;
        }

        step_size = input_file_info->step_size;
        begin_point = input_file_info->begin_point;
        end_point = input_file_info->end_point;

        switch(input_file_info->data_format_val)
        {
           case 1:
              data_format = XY_PAIRS;
              break;
           case 2:
              data_format = Y_ONLY;
              break;
           default:
              xvf_error_wait("An unknown data format has been encountered.  Please select a valid data format", "run_io_input", NULL);
              break;

        }


	/*
	 * user clicked on pane action button 'machine_type'
	 */

         /* since we do not save the machine type */

	if (input_file_info->machine_type)
	{
	    machine_list = getmachlist(&i);
            machine_list_return = xvf_run_list_wait(machine_list,
                                                    i-1,
                                                    col_num, prompt1,
                                                    label1, &current, False);
            if (machine_list_return == NULL) return;
            mach_name = VStrcpy(machine_list_return->string);

            xvf_change_input(form, input_file_info->machine_type_index+1,
                                xvf_title_chng, mach_name, MAXNAMELENGTH);

	    machine_type = machorder(mach_name);
	    mach_type_index = find_machtype_index(mach_name);
            if (machine_type == 255)
            {
               xvf_error_wait("An unknown machine type has been encountered. Please select a valid machine type", "run_input_file", NULL);
               gwin_attr->machine_type_index = mach_type_index;
               return;
            }
            gwin_attr->machine_type_index = mach_type_index;
            return;
	}

	/*
	 * user clicked on pane action button 'plot_file'
	 */

	else if (input_file_info->plot_file)
	{

            plot = get_input_file(input_file_info->filename, PLOT_2D, 
		                  data_format, gwin_attr->machine_type_index, 
				  data_type, -1, whichband, cmplx);
	}
        
        /*
         *  Create the graphics workspace if necessary, or add the
         *  plot to the already-existent workspace
         */

        if (plot == NULL)
           return;

        if (end_point > plot->size            ||
            begin_point > plot->size          ||
            step_size > plot->size            ||
	    (end_point <  begin_point         &&
             end_point > 0 && begin_point >0) ||
            step_size == 0)
	{
	     freeplot(plot);
             mesg = xvf_strcpy("The Begin point, End point or Step Size was specified incorrectly.\n\nPlease check the Begin point, End point and Step Size, andPlot Data again");
                xvf_error_wait(mesg, "run_input_file", NULL);
                free(mesg);
		return;
	}

        if (gwin == NULL)
            gwin = create_new_gwin(plot, plot_type, marker_type, line_type, 
                   step_size, begin_point, end_point, 0,
                   step_size, begin_point, end_point, NULL, 1);
        else
	{
            assign_plot_to_gwin(plot, plot_type, marker_type, line_type, 
                   step_size, begin_point, end_point, 0,
                   step_size, begin_point, end_point, NULL, 1);

            mesg = xvf_strcpy("Do you want to RESET the Min/Max of the Plot Area to the New Plot's min/max?");
            if (xvf_warn_wait(mesg, "RESET AXES", "YES","NO"))
            {
                gwin->num_tics.x = 6;
                gwin->num_tics.y = 6;
                set_world_coordinates(plot->WCmin, plot->WCmax, gwin->num_tics);
            }
            free(mesg);
	}

        /*
         * Finally, plot the information
         */
        plot_routine();
        return;
}




/********************************************************
*
*  Routine Name:  run_input_function
*
*       Purpose:  drives the pane 'input_function'
*
*         Input:  form - pointer to the form tree 
*		  input_function_info  - information structure for pane 'input_function'
*        Output:  action of the application program
*
*     Called By:  run_xprism()
*
*   Automatically Generated By:  conductor
*
********************************************************/


run_input_function(form, input_function_info, marker_type, line_type)

xvf_form *form;
xprism_input_function *input_function_info;
int marker_type;
int line_type;
{

        XPlot *plot, *get_function();
        int  plot_type;
	char *function, *mesg, *x_range, error[1024]; 
	char temp[2048];
        int begin_point, end_point;
        int step_size;

	_xvf_get_input_function(form, input_function_info);

	/*
	 * user clicked on pane action button 'plot_function'
	 */

        plot_type = input_function_info->change_plot_type_val + (PLOT_2D - 1);

        step_size = input_function_info->step_size;
        begin_point = input_function_info->begin_point;
        end_point = input_function_info->end_point;

	if (input_function_info->plot_function)
	{
            if (gwin != NULL)
            {
                if (gwin->plotnum > 19)
                {
                    mesg = xvf_strcpy("Sorry... we only allow 20 plots in the workspace\n");
                    xvf_error_wait(mesg, "run_input_function", NULL);
                    free(mesg);
                    return;
                }
            }
           sprintf(temp,"f(x) = %s",input_function_info->function);
           function = xvf_strcpy(temp);
           sprintf(temp,"x = (%s,%s,%s)",input_function_info->x_min,
                                         input_function_info->x_max,
                                         input_function_info->xnum_pts);
           x_range = xvf_strcpy(temp);
           plot = get_function(plot_type, function, x_range, NULL, error);
        }

        /*
         *  Create the graphics workspace if necessary, or add the
         *  plot to the already-existent workspace
         */

        if (plot == NULL)
	{
           xvf_error_wait(error, "run_input_function", NULL);
           return;
	}

        if( end_point > plot->size          ||
            begin_point > plot->size        ||
            step_size > plot->size          ||
	    (end_point < begin_point        && 
	     end_point > 0 	 	    &&
	     begin_point >0)                ||
             step_size == 0)
	{
	     freeplot(plot);
             mesg = xvf_strcpy("The Begin point, End point or Step Size was specified incorrectly.\n\nPlease check the Begin point, End point and Step Size, andPlot Function again");
                xvf_error_wait(mesg, "display_data_sampling", NULL);
                free(mesg);
		return;
	}

        if (gwin == NULL)
            gwin = create_new_gwin(plot, plot_type, marker_type, line_type, 
                   step_size, begin_point, end_point, 0,
                   step_size, begin_point, end_point, NULL, 1);
        else
	{
            assign_plot_to_gwin(plot, plot_type, marker_type, line_type, 
                   step_size, begin_point, end_point, 0,
                   step_size, begin_point, end_point, NULL, 1);
 
            mesg = xvf_strcpy("Do you want to RESET the Min/Max of the Plot Area to the New Plots's min/max?");
           if (xvf_warn_wait(mesg, "RESET AXES", "YES","NO"))
           {
               gwin->num_tics.x = 6;
               gwin->num_tics.y = 6;
               set_world_coordinates(plot->WCmin, plot->WCmax, gwin->num_tics);
           }
           free(mesg);
	}
        /*
         * Finally, plot the information
         */
        plot_routine();
        return;


}

/************************************************************
*
*  MODULE NAME: run_transforms 
*
*
*      PURPOSE: Drives the Transforms pane of the Xprism form -- 
*		Called after the user clicks on "Transform Plot(s)",
*		It rotates, scales, translates, according to which
*		options are activated.  It then redisplays the plot(s).
*
*	INPUT:  form - pointer to the form tree
*		transform_info - pointer to the Transforms Pane 
*				 information structure
*
*       OUTPUT: A new plot displayed in the graphics workspace
*
*    CALLED BY: main
*
*   WRITTEN BY: Danielle Argiro and Mark Young
*
*
*************************************************************/

run_transforms(form, transform_info)

xvf_form	    *form;
xprism_transforms   *transform_info;
{
	char *mesg;
	float xval, yval;
	int trans_type;
	XPlot *plot;


	if (gwin == NULL)
	{
	   mesg = xvf_strcpy("Cannot do transforms unless plot(s) are displayed!\n");
           xvf_error_wait(mesg, "run_transform", NULL);
           free(mesg);
	   return;
	}

	_xvf_get_transforms(form, transform_info);

	if(transform_info->transform_plots)
	{
	    xval = transform_info->x_val;
            yval = transform_info->y_val;
            trans_type = transform_info->trans_type_val;


	    /* rotate */
	    if (trans_type == ROTATE)
	    {
	        if ((xval > 360) || (yval > 360))
                {
                    mesg = xvf_strcpy("Can't rotate by more than 360 degrees\n");
                    xvf_error_wait(mesg, "run_transform", NULL);
                    free(mesg);
                    return;
                }
	         if ((xval < -360) || (yval < -360))
                {
                    mesg = xvf_strcpy("Can't rotate by less than -360 degrees\n");
                    xvf_error_wait(mesg, "run_transform", NULL);
                    free(mesg);
                    return;
                }
	        plot = get_a_plot("Select a plot to rotate" , "Rotate Plot", 
			    APPEND_PLOT_TYPE);
		if (plot == NULL) return;
	        rotate_2D(xval, plot);
	    }

	
	    /* scale */
	    else if (trans_type == SCALE)
	    {
	        if ((xval == 0) || (yval == 0))
                {
                    mesg = xvf_strcpy("Can't scale by 0 \n");
                    xvf_error_wait(mesg, "run_transform", NULL);
                    free(mesg);
                    return;
                }
	        plot = get_a_plot("Select a plot to scale" , "Scale Plot", 
			    APPEND_PLOT_TYPE);
		if (plot == NULL) return;
	        scale_2D(xval, yval, plot);
	    }

	
	    /* translate */
	    else if (trans_type == TRANSLATE)
	    {
	        plot = get_a_plot("Select a plot to translate","Translate Plot",
			    APPEND_PLOT_TYPE);
		if (plot == NULL) return;
	        translate_2D(xval,yval, plot);
	    }

	    reset_world_coordinates();
	    plot_routine();
	}

} /* end run_transforms */

