 /*
  * Khoros: $Id: gw_man3.c,v 1.2 1991/10/02 00:12:15 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: gw_man3.c,v 1.2 1991/10/02 00:12:15 khoros Exp $";
#endif

 /*
  * $Log: gw_man3.c,v $
 * Revision 1.2  1991/10/02  00:12:15  khoros
 * HellPatch2
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "writer.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>    Ghostwriter Routine to Generate *.3 file           <<<<
   >>>>                                                       <<<<
   >>>>                gw_generate_man3file()                 <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



/************************************************************
*
*  Routine Name: gw_generate_man3file
*
*      Purpose:  This routine creates a man3 file 
*
*        Input: database -  pointer to the internal database struct
*		prog_spec-  pointer to the internal specification struct
*		name     -  name of the program being generated
*
*    Called by: lwriter()
*
*   Written By:  Danielle Argiro
*
*************************************************************/

int  gw_generate_man3file(database, prog_spec, name, path, type)
char **database;
char **prog_spec;
char *name;
char *path;
char *type;
{
     int i;
     char c, datestring[26], month[4], nummonth[4], day[3], year[3];
     char *copyright;
     time_t  clock;
     FILE *file, *tmpfile;
     char  manfile[15], temp[MaxLength], *fullpath, resp, *filepath;

     /*
      *  determine name of man3 file 
      */
     sprintf(manfile, "l%s.3", name);

     /*
      *  see if man3 file already exists.  If so, prompt to over-write,
      *  return true if the answer is NO
      */
     fullpath = vfullpath(manfile, path, NULL);
     if (!writer->force)
     {
         if (tmpfile = fopen(fullpath, "r"))
         {
            fprintf(stderr, "\nOverwrite file '%s'?  [y/n]: ", fullpath);
   	    fgets(temp, MaxLength, stdin); 
	    sscanf(temp, "%c", &resp);
	    if ((resp != 'y') && (resp != 'Y')) return(true);
         }
      }

     /*
      *  create & open man3 file  
      */
     if ((file = fopen(fullpath, "w"))== NULL)
     {
          fprintf(stderr, "\nghostwriter:\n");
          fprintf(stderr, "  Could not create file '%s'\n", fullpath);
          return(false);
     }

     /*
      *  print out first line of man3 page with time & date
      */
     clock = (time_t) time(NULL);
     strcpy (datestring, ctime(&clock));
     month[0]=datestring[4]; month[1]=datestring[5];
     month[2]=datestring[6]; month[3]='\0';
     if (strcmp (month, "Jan") == 0)
         strcpy (nummonth, "01");
     if (strcmp (month, "Feb") == 0)
         strcpy (nummonth, "02");
     if (strcmp (month, "Mar") == 0)
         strcpy (nummonth, "03");
     if (strcmp (month, "Apr") == 0)
         strcpy (nummonth, "04");
     if (strcmp (month, "May") == 0)
         strcpy (nummonth, "05");
     if (strcmp (month, "Jun") == 0)
         strcpy (nummonth, "06");
     if (strcmp (month, "Jul") == 0)
         strcpy (nummonth, "07");
     if (strcmp (month, "Aug") == 0)
         strcpy (nummonth, "08");
     if (strcmp (month, "Sep") == 0)
         strcpy (nummonth, "09");
     if (strcmp (month, "Oct") == 0)
         strcpy (nummonth, "10");
     if (strcmp (month, "Nov") == 0)
         strcpy (nummonth, "11");
     if (strcmp (month, "Dec") == 0)
         strcpy (nummonth, "12");
     day[0]=datestring[8]; day[1]=datestring[9]; day[2]='\0';
     year[0]=datestring[22]; year[1]=datestring[23]; year[2]='\0';
     sprintf(temp, ".TH l%s 3  %s/%s/%s", name, nummonth, day, year);
     temp[(xvf_strlen(temp))-1] = '\0';
     fprintf(file, "%s", temp);
     fprintf(file, "\n");

     /*
      *   print out name and description
      */
     fprintf(file, ".SH LIBRARY ROUTINE\n");
     if (writer->format == NO_TEXT_FORMATTER)
	fprintf(file, ".nf\n");
     fprintf(file, "l%s \\- ", name);

     /*
      * This part eats the white space at the beginning of the short
      * description and then prints the description minus the space.
      */
     if (xvf_strlen(prog_spec[ShortLibDesc]) > 0)  {
        i=0;
        c = prog_spec[ShortLibDesc][0];
        while ((c == ' ')||(c == '\t')||(c == '\n')) {
           i = i+1;
           c = prog_spec[ShortLibDesc][i];
        }
        if (xvf_strlen( &(prog_spec[ShortLibDesc][i]) ) > 0)  {
           fprintf(file, "%s", &(prog_spec[ShortLibDesc][i]) );
        }
     }
     else {
         fprintf(file, "\n", name);
     }

     if (writer->format == NO_TEXT_FORMATTER)
        fprintf(file, ".fi\n");

     /*
      *   print info on library call to man3 file
      */
     fprintf(file, ".SH LIBRARY CALL\n");
     fprintf(file, ".in +.5i\n");
     fprintf(file, ".nf\n");
     fprintf(file, "#include \"vinclude.h\"\n");
     if (xvf_strlen(prog_spec[LibraryDef]) > 0) 
          fprintf(file, "%s", prog_spec[LibraryDef]);
     else
     {
        fprintf(file, "if (! (l%s()))\n", name);
        fprintf(file, "\t    exit(1);\n\n");			
     }
     fprintf(file, ".fi\n");
     fprintf(file, ".in -.5i\n");

     /*
      *   print info on input to man3 file
      */
     fprintf(file, ".SH INPUT\n");
     if (writer->format == NO_TEXT_FORMATTER) {
        fprintf(file, ".nf\n");
        fprintf(file, "Input to l%s :\n", name);
     }
     if (xvf_strlen(prog_spec[LibraryInput]) > 0) 
          fprintf(file, "%s", prog_spec[LibraryInput]);
     else fprintf(file, "\n");
     if (writer->format == NO_TEXT_FORMATTER)
        fprintf(file, ".fi\n");

     /*
      *   print info on output to man3 file
      */
     fprintf(file, ".SH OUTPUT\n");
     if (writer->format == NO_TEXT_FORMATTER) {
        fprintf(file, ".nf\n");
        fprintf(file, "Output from l%s :\n", name);
     }
     if (xvf_strlen(prog_spec[LibraryOutput]) > 0) 
          fprintf(file, "%s", prog_spec[LibraryOutput]);
     else fprintf(file, "\n");
     if (writer->format == NO_TEXT_FORMATTER)
        fprintf(file, ".fi\n");

     /*
      *   print info on modifications to man3 file
      */
     fprintf(file, ".SH MODIFICATIONS\n");
     if (writer->format == NO_TEXT_FORMATTER) {
        fprintf(file, ".nf\n");
        fprintf(file, "Modifications to l%s :\n", name);
     }
     if (xvf_strlen(prog_spec[LibraryMods]) > 0) 
          fprintf(file, "%s", prog_spec[LibraryMods]);
     else fprintf(file, "\n");
     if (writer->format == NO_TEXT_FORMATTER)
        fprintf(file, ".fi\n");

     /*
      *   print out description 
      */
     fprintf(file, ".SH DESCRIPTION\n");
     if (writer->format == NO_TEXT_FORMATTER) {
        fprintf(file, ".nf\n");
        fprintf(file, "l%s :\n", name);
     }
     if (xvf_strlen(prog_spec[Man3LongDesc]) > 0) 
          fprintf(file, "%s", prog_spec[Man3LongDesc]);
     else fprintf(file, "\n");
     if (writer->format == NO_TEXT_FORMATTER)
        fprintf(file, ".fi\n");

     /*
      *   print out 'see also' 
      */
     fprintf(file, ".SH SEE ALSO\n");
     fprintf(file, "%s(1), intro(3), vipl(3), verror(3), vutils(3)\n", name);
     if (writer->format == NO_TEXT_FORMATTER)
        fprintf(file, ".nf\n-and-\n");
     if (xvf_strlen(prog_spec[Man3SeeAlso]) > 0)
         fprintf(file, "%s", prog_spec[Man3SeeAlso]);
     else fprintf(file, "\n");
     if (writer->format == NO_TEXT_FORMATTER)
        fprintf(file, ".fi\n");

     /*
      *   print out restrictions
      */
     fprintf(file, ".SH RESTRICTIONS \n");
     if (writer->format == NO_TEXT_FORMATTER)
        fprintf(file, ".nf\n+++++\n");
     if (xvf_strlen(prog_spec[Man3Restrictions]) > 0)
         fprintf(file, "%s", prog_spec[Man3Restrictions]);
     else fprintf(file, "\n");
     if (writer->format == NO_TEXT_FORMATTER)
        fprintf(file, ".fi\n");
 
     /*
      *   print out author
      */
     fprintf(file, ".SH AUTHOR \n");
     if (xvf_strlen(prog_spec[Authors]) > 0)
         fprintf(file, "%s", prog_spec[Authors]);
     fprintf(file, ".sp\n");

     /*
      * print the copyright.
      */
     fprintf (file, ".SH COPYRIGHT\n");
     if ((writer->cp_flag) && (writer->cp != NULL))
        filepath = xvf_strcpy(writer->cp);
     else
	filepath = xvf_strcpy("KHOROS_HOME/repos/utils/cpright.ghost");  
     copyright = gw_copyright(filepath,"short");
     if (copyright != NULL) 
         fprintf(file, "%s\n", copyright);

     fclose(file);
     fprintf(stderr, "ghostwriter:  done generating '%s'\n", fullpath);
     return(true);
}


