 /*
  * Khoros: $Id: glyphlist.c,v 1.1 1991/05/10 15:57:48 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: glyphlist.c,v 1.1 1991/05/10 15:57:48 khoros Exp $";
#endif

 /*
  * $Log: glyphlist.c,v $
 * Revision 1.1  1991/05/10  15:57:48  khoros
 * Initial revision
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 *
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "cantata.h"


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>								<<<<
   >>>>	    file name:  glyphlist.c				<<<<
   >>>>								<<<<
   >>>>   description:						<<<<
   >>>>								<<<<
   >>>>      routines:  xvl_add_to_glyphlist()			<<<<
   >>>>                 xvl_copy_glyphlist()			<<<<
   >>>>                 xvl_delete_from_glyphlist()		<<<<
   >>>>                 xvl_check_if_glyphlist()		<<<<
   >>>>                 xvl_destroy_glyphlist()			<<<<
   >>>>								<<<<
   >>>> modifications:						<<<<
   >>>>								<<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */



/************************************************************
*
*  Routine Name: xvl_add_to_glyphlist
*
*      Purpose:  Adds a glyph to the glyph list.  This is done by
*		 adding the glyph to the end of the glyph list
*		 (if the list currently exists).  The new list
*		 is then passed back to the calling routine.
*		 The routine first scans the list to make sure the
*		 glyph is not already on the list, if so then we
*		 return the original glyph list.
*
*
*	 Input:  glyph      -  The glyph to be added to the glyph list
*		 glyphlist  -  The current glyph list
*
*       Output:  returns the modified glyph list.
*
*
*   Written By:   Mark Young
*
*************************************************************/


GlyphList *xvl_add_to_glyphlist(glyph, glyphlist)

Glyph	   *glyph;
GlyphList  *glyphlist;
{
	GlyphList *entry, *current, *last;


	entry = (GlyphList *) XtMalloc(sizeof(GlyphList));
	entry->glyph = glyph;

	if (glyphlist == NULL)
	{
	   glyphlist = entry;
	   glyphlist->next = NULL;
	}
	else
	{
	   current = glyphlist;
	   while (current != NULL)
	   {
	      /*
	       *  Make sure that the glyph is not already on the list.
	       */
	      if (current->glyph == glyph)
	      {
		 free(entry);
		 return(glyphlist);
	      }
	      last = current;
	      current = current->next;
	   }
	   last->next = entry;
	   entry->next = NULL;
	}
	return(glyphlist);
}



/************************************************************
*
*  Routine Name: xvl_copy_glyphlist
*
*      Purpose:  Copies a glyph list.  This is done by
*		 adding the glyphs from one list to a new list.
*
*
*	 Input:  glyph	   -  The glyph to be added to the glyph list
*		 glyphlist -  The current glyph list
*
*       Output:  returns the new glyph list.
*
*
*   Written By:   Mark Young
*
*************************************************************/


GlyphList *xvl_copy_glyphlist(glyphlist)

GlyphList  *glyphlist;
{
	GlyphList *newlist = NULL;


	while (glyphlist != NULL)
	{
	   newlist = xvl_add_to_glyphlist(glyphlist->glyph, newlist);
	   glyphlist = glyphlist->next;
	}
	return(newlist);
}



/************************************************************
*
*  Routine Name: xvl_delete_from_glyphlist
*
*      Purpose:  Delete a glyph from the glyph list.  This is done by
*		 deleting the glyph from the linked list.  The new
*		 list is then passed back to the calling routine.
*
*
*	 Input:   glyph      -  The glyph to be deleted from the glyph list
*		  glyphlist  -  The current glyph list
*
*       Output:   returns the modified glyph list.
*
*
*   Written By:   Mark Young
*
*************************************************************/


GlyphList *xvl_delete_from_glyphlist(glyph, glyphlist)

Glyph	   *glyph;
GlyphList  *glyphlist;
{
	GlyphList *current, *last;


	if (glyphlist == NULL)
	   return(NULL);

	if (glyphlist->glyph == glyph)
	{
	   current   = glyphlist;
	   glyphlist = glyphlist->next;
	   free(current);
	   return(glyphlist);
	}
	else
	{
	   current = last = glyphlist;
	   while (current->glyph != glyph && current->next != NULL)
	   {
	      last = current;
	      current = current->next;
	   }

	   if (current->glyph == glyph)
	   {
	      last->next = current->next;
	      free(current);
	   }
	   return(glyphlist);
	}
}



/************************************************************
*
*  Routine Name: xvl_check_if_glyphlist
*
*      Purpose:  Checks to see if a glyph is already on the list.
*		 This is done by racing thru the glyph list until
*		 the desired glyph is found or the end of the list
*		 is encountered.
*
*
*	 Input:   glyph      -  The glyph to check for on the glyph list
*		  glyphlist  -  The current glyph list
*
*       Output:   returns True if on the list otherwise return False
*
*
*   Written By:   Mark Young
*
*************************************************************/


int xvl_check_if_glyphlist(glyph, glyphlist)

Glyph	   *glyph;
GlyphList  *glyphlist;
{
	GlyphList *current;


	current = glyphlist;
	while (current != NULL)
	{
	   if (current->glyph == glyph)
	      return(True);

	   current = current->next;
	}
	return(False);
}



/************************************************************
*
*  Routine Name: xvl_destroy_glyphlist
*
*      Purpose:  Destroys the glyph list by walking thru the
*		 glyph list and free each entry.
*
*	 Input:  glyphlist - the glyph list to be deleted
*
*       Output:  None
*
*
*   Written By:   Mark Young
*
*************************************************************/


xvl_destroy_glyphlist(glyphlist)

GlyphList *glyphlist;
{
	GlyphList  *temp;

	while (glyphlist != NULL)
	{
	   temp = glyphlist->next;
	   free(glyphlist);
	   glyphlist = temp;
	}
}
