 /*
  * Khoros: $Id: inform.c,v 1.2 1991/12/18 09:16:40 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: inform.c,v 1.2 1991/12/18 09:16:40 dkhoros Exp $";
#endif

 /*
  * $Log: inform.c,v $
 * Revision 1.2  1991/12/18  09:16:40  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xvutils.h"	


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    	    file name: inform.c                       <<<<
   >>>>                                                       <<<<
   >>>>		Creates an Information Widget		      <<<<
   >>>>                                                       <<<<
   >>>>                xvf_inform_wait()		      <<<<              
   >>>>                xvf_create_info()		      <<<<              
   >>>>                xvf_info_ok()		      	      <<<<              
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/************************************************************
*
*  Routine Name:  xvf_inform_wait(info_strings, num_strings, label, button)
*
*      Purpose:   creates an information form which must be
*		  acknowledged by the user before going on.
*
*                 NOTE: this routine will grab all events 
*                 while running. 
*
*        Input:   info_strings - an array of information strings to display
*                 num_strings  - number of information strings in array
*                 label        - short label for top of widget.
*                                NULL will cause display of default "INFO".
*		  button       - label for button.
*
*       Output:   waits for user to acknowledge message.
*
*    Called By:   the application program
*
*   Written By:   Danielle Argiro & Stephanie Hallett
*
*
*************************************************************/


int xvf_inform_wait(info_strings, num_strings, label, button)
char *info_strings[];
int   num_strings;
char *label;
char *button;
{
   int status;

   if (xvf_display == NULL)
   {
	fprintf(stderr, "It's a mystery to me!\n");
	return(true);
   }
   status = xvf_create_info(info_strings, num_strings, label,button);

   if (status == false)
      return(false);

   return(true);
}


/************************************************************
*
*  Routine Name:  
*	xvf_create_info(info_strings,num_strings,info_label,button)
*
*      Purpose:   Does the  actual creation of an info widget. 
*		  The info widget consists of a form widget with a 
*		  label, "num_strings" lines of text, and an 
*		  acknowledgement button.
*
*        Input:   info_strings  - an array of information strings
*		  num_strings   - the number of information strings
*                 info_label    - short label for top of widget
*                                 NULL will casue default of "INFORMATION"
*		  button        - label for acknowledgement button
*                                 NULL will cause default of "OK"
*
*       Output:   wait to user to acknowledge message.
*
*    Called By:   xvf_error_wait() or the application program
*
*   Written By:   Danielle Argiro Stephanie Hallett
*
*************************************************************/

int xvf_create_info(info_strings, num_strings, info_label,button)
char *info_strings[];
int  num_strings;
char *info_label;
char *button;
{
   Widget toplevel;	/* toplevel widget for message */
   Widget back;		/* backplane for message */
   Widget label;	/* label describing type of message */
   Widget ok;	 	/* button to get rid of error message */
   Widget text;		/* text widget to display message */
   Widget offset;       /* offset widget to set spacing */
   Arg    arg[25];
   int	  i, j, width, max_width=0, ok_width, label_width;
   char name[MaxLength];
   char *top_name, *cap_top_name;

   /*
    * create identifying widget name
    */
   sprintf(name,"%d_inform",Inform_cnt);
   Inform_cnt++;
   top_name = xvf_strcpy(name);
   cap_top_name = xvf_cap_first_letter(top_name);

   /*
    *  figure out how long the longest string is (in pixels)
    */
    for (j = 0; j < num_strings; j++)
    {
	width = xvf_strlen(info_strings[j])*xvf_font_width;
	if (width > max_width) max_width = width;
    }
    if (button == NULL)
    {
      ok_width = 3*xvf_font_width;
      button = xvf_strcpy("Ok");
    }
    else
      ok_width = (xvf_strlen(button)+1)*xvf_font_width;

    if (info_label == NULL)
    {
      label_width = 12*xvf_font_width;
      info_label = xvf_strcpy("Information");
    }
    else
      label_width = (xvf_strlen(info_label)+1)*xvf_font_width;


   /*
    * create the information box's toplevel widget, and add it
    * to the list of toplevels that is used with journal playback.
    */
   i = 0;
   XtSetArg(arg[i], XtNscreen, xvf_screen); 		i++;
   XtSetArg(arg[i], XtNargc, xvf_ac); 	          	i++;
   XtSetArg(arg[i], XtNargv, xvf_av);	          	i++; 
   XtSetArg(arg[i], XtNwinGravity, StaticGravity);	i++; 
   toplevel = XtAppCreateShell(top_name,cap_top_name,
			applicationShellWidgetClass, xvf_display, arg, i);
   xvf_add_toplevel(toplevel);

   /*
    * create the backplane widget
    */
   i = 0;
   XtSetArg(arg[i],XtNmappedWhenManaged,True);          i++; 
   XtSetArg(arg[i],XtNborderWidth,1);			i++;	
   XtSetArg(arg[i],XtNdefaultDistance,4);		i++;
   back = XtCreateManagedWidget("form_back",formWidgetClass,
	toplevel,arg,i);

   /*
    * create the label widget
    */
   i = 0;
   width = max_width - ok_width - 3*xvf_font_width;
   if (width < label_width) width = label_width;
   if (xvf_font != NULL)
   {
        XtSetArg(arg[i],XtNfont,xvf_font);              	i++;
   }
   XtSetArg(arg[i],XtNlabel,xvf_strcpy(info_label)); 		i++;
   XtSetArg(arg[i], XtNwidth, (Dimension) width); 		i++;
   XtSetArg(arg[i],XtNmappedWhenManaged,True);			i++;
   XtSetArg(arg[i],XtNborderWidth,0);				i++;
   label = XtCreateManagedWidget("info_wid", labelWidgetClass,back,arg,i);

   offset = label;

   /*
    * create the text widget
    */
   for (j = 0; j < num_strings; j++)
   {
       i = 0;
       XtSetArg(arg[i],XtNlabel, info_strings[j]);		i++;
       XtSetArg(arg[i],XtNfromVert, offset);			i++;
       XtSetArg(arg[i],XtNleftMargin, LEFT_MARGIN);		i++;
       XtSetArg(arg[i],XtNborderWidth, 0);			i++;
       XtSetArg(arg[i],XtNwidth, max_width);			i++;
       if (xvf_font != NULL)
       {
           XtSetArg(arg[i],XtNfont,xvf_font);              	i++;
       }
       text = XtCreateManagedWidget(info_strings[j],
                labelWidgetClass, back, arg, i);
       offset = text;
   }

   /*
    * create the acknowledgment button 
    */
   i = 0;
   XtSetArg(arg[i],XtNfromHoriz,label);			i++;
   XtSetArg(arg[i],XtNlabel,xvf_strcpy(button));        i++;
   XtSetArg(arg[i], XtNwidth, (Dimension) ok_width);    i++;
   if (xvf_font != NULL)
   {
        XtSetArg(arg[i],XtNfont,xvf_font);            	i++;
   }
   ok = XtCreateManagedWidget("ok_wid",
	commandWidgetClass,back,arg,i);
   XtAddCallback(ok,XtNcallback,xvf_info_ok,toplevel);

   XtRealizeWidget(toplevel);
   XFlush(XtDisplay(toplevel));

   xvf_add_protocol_handler(toplevel, "WM_DELETE_WINDOW", xvf_info_ok,
                            toplevel);
   return(true);
}

/* callback for info form */

void xvf_info_ok(widget, clientData, callData)
Widget widget;
caddr_t clientData, callData;
{
   Widget toplevel;

   toplevel = (Widget) clientData;

   /*
    * delete the information box's toplevel from the list 
    * used by journal playback before destroying it
    */
   xvf_add_protocol_handler(toplevel, "WM_DELETE_WINDOW", xvf_info_ok,
                                toplevel);
   xvf_delete_toplevel(toplevel);
   XtUnmapWidget(toplevel);
   XtDestroyWidget(toplevel);
}


