 /*
  * Khoros: $Id: LN03.c,v 1.2 1991/10/02 00:14:06 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: LN03.c,v 1.2 1991/10/02 00:14:06 khoros Exp $";
#endif

 /*
  * $Log: LN03.c,v $
 * Revision 1.2  1991/10/02  00:14:06  khoros
 * HellPatch2
 *
  */ 


/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.

 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: LN03.c
   >>>>                    
   >>>>   description: LN03 printer Utilities 
   >>>>               
   >>>>      routines: 
   >>>>			X3D_set_LN03()			      <<<<
   >>>>			LN03_DrawLine()			      <<<<
   >>>>			LN03_DrawLines()		      <<<<
   >>>>			LN03_DrawSegments()		      <<<<
   >>>>			LN03_DrawRectangle()		      <<<<
   >>>>			LN03_DrawArc()			      <<<<
   >>>>			LN03_FillPolygon()		      <<<<
   >>>>			LN03_set_line_width()		      <<<<
   >>>>			LN03_set_line_type()		      <<<<
   >>>>			LN03_set_draw()			      <<<<
   >>>>			LN03_set_fill()			      <<<<
   >>>>			LN03_close_device()		      <<<<
   >>>>			LN03_DrawPolygon()		      <<<<
   >>>>			LN03_DrawText()			      <<<<
   >>>>			LN03_FillArc()			      <<<<
   >>>>			LN03_FillRectangle()		      <<<<
   >>>>              
   >>>> modifications:
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "X3D.h"

/************************************************************
*
*  MODULE NAME:  X3D_set_LN03
*
*      PURPOSE:  This routine sets the display, the window, and
*		 the graphics contexts for future calls to the
*		 xvgraphics library using this id
*
*        INPUT:  id - xvgraphics id
*		 display - the display to which all graphics will go
*		 window  - the window that all graphics will appear in
*
*    CALLED BY:  application program
*
*   WRITTEN BY:  Mike Lang & Mark Young
*
*
*************************************************************/

X3D_set_LN03(id, display, window) 

int     id;
Display *display;
Window  window;
{
   /* not yet */
}



/************************************************************
*
*  MODULE NAME:  LN03_DrawLine
*
*      PURPOSE: Draw a single line for an LN03 device
*
*        INPUT:  graphics - graphics structure
*
*       OUTPUT: displays a line to an LN03 printer
*
*    CALLED BY: graphics routines
*
*   WRITTEN BY: Mike Lang & Mark Young
*
*************************************************************/

void LN03_DrawLine (graphics, p1x, p1y, p2x, p2y)

X3DGraphics *graphics;
short   p1x, p1y, p2x, p2y;
{
   /* not yet */
}



/************************************************************
*
*  MODULE NAME:  LN03_DrawLines
*
*      PURPOSE:  Draw a series of lines for an LN03 device
*
*        INPUT:  graphics - graphics structure
*
*       OUTPUT: displays a a set of lines to an LN03 printer
*
*    CALLED BY: graphics routines
*
*   WRITTEN BY: Mike Lang & Mark Young
*
*************************************************************/

void LN03_DrawLines (graphics, points, size, coordmode)

X3DGraphics *graphics;
int     coordmode, size;
XPoint  *points;
{
   /* not yet */
}



/************************************************************
*
*  MODULE NAME:  LN03_DrawSegments
*
*      PURPOSE:  Draw a series of disjoint segments for an LN03 device
*
*        INPUT:  graphics - graphics structure
*
*       OUTPUT: displays a a set of segments to an LN03 printer
*
*    CALLED BY: graphics routines
*
*   WRITTEN BY: Mike Lang & Mark Young
*
*************************************************************/

void LN03_DrawSegments (graphics, segments, seg_num)

X3DGraphics *graphics;
int	 seg_num;
XSegment *segments;
{
   /* not yet */
}



/************************************************************
*
*  MODULE NAME:  LN03_DrawRectangle
*
*      PURPOSE:  Draw a rectangle to an LN03 device
*
*        INPUT:  graphics - graphics structure
*
*       OUTPUT: displays a rectangle to an LN03 printer
*
*    CALLED BY: graphics routines
*
*   WRITTEN BY: Mike Lang & Mark Young
*
*************************************************************/

void LN03_DrawRectangle (graphics, x, y, w, h)

X3DGraphics *graphics;
int      x, y;
unsigned int w, h;
{
   /* not yet */
}



/************************************************************
*
*  MODULE NAME:  LN03_DrawArc
*
*      PURPOSE:  Draw an arc (circle) for an LN03 device
*
*        INPUT:  graphics - graphics structure
*
*    CALLED BY: graphics routines
*
*   WRITTEN BY: Mike Lang & Mark Young
*
*************************************************************/

void LN03_DrawArc (graphics, x, y, w, h, ang1, ang2) 

X3DGraphics *graphics;
int      x, y, ang1, ang2;
unsigned int     w, h;
{
   /* not yet */
}



/************************************************************
*
*  MODULE NAME:  LN03_FillPolygon
*
*      PURPOSE: Fill a polygon for an LN03 device
*
*        INPUT:  graphics - graphics structure
*
*       OUTPUT: displays a filled polygon to an LN03 printer
*
*    CALLED BY: graphics routines
*
*   WRITTEN BY: Mike Lang & Mark Young
*
*************************************************************/

void LN03_FillPolygon (graphics, points, size, shape, coordmode) 

X3DGraphics *graphics;
int     size, shape, coordmode;
XPoint	*points;
{
   /* not yet */
}



/************************************************************
*
*  MODULE NAME:  LN03_close_device
*
*      PURPOSE:  
*
*        INPUT:  graphics - graphics structure
*
*    CALLED BY:  application program
*
*   WRITTEN BY:  Mike Lang & Mark Young
*
*
*************************************************************/


void LN03_close_device(graphics)

X3DGraphics *graphics;
{
   /* not yet */
}



/************************************************************
*
*  MODULE NAME:  LN03_set_line_width
*
*      PURPOSE: Set the linr width before drawing.
*
*        INPUT:  graphics context
*	         line_width as specified in xvgraphics.h
*
*    CALLED BY:  application program
*
*   WRITTEN BY:  Mike Lang & Tom Sauer
*
*
*************************************************************/


void LN03_set_line_width(graphics, line_width)

X3DGraphics  *graphics;
int	     line_width;
{
   /* not yet */
}



/************************************************************
*
*  MODULE NAME:  LN03_set_line_type
*
*      PURPOSE:  sets the line type before drawing
*
*        INPUT:  graphics context
*	         line_type as specified in xvgraphics.h
*
*    CALLED BY:  application program
*
*   WRITTEN BY:  Tom Sauer
*
*
*************************************************************/


void LN03_set_line_type(graphics, line_type)

X3DGraphics  *graphics;
int	     line_type;
{
   /* not yet */
}



/************************************************************
*
*  MODULE NAME:  LN03_set_draw
*
*      PURPOSE:  Set the foreground draw color.
*
*        INPUT:  graphics - graphics context
*	         fg	  - foreground color
*		 override - whether the foreground color can
*			    be overriden.
*
*    CALLED BY:  application program
*
*   WRITTEN BY:  Mark Young
*
*
*************************************************************/

void LN03_set_draw(graphics, fg, override)

X3DGraphics     *graphics;
XColor		*fg;
int		override;
{
}



/************************************************************
*
*  MODULE NAME:  LN03_set_fill
*
*      PURPOSE:  Set the background fill color.
*
*        INPUT:  graphics - graphics context
*	         bg	  - background color
*		 override - whether the background color can
*			    be overriden.
*
*    CALLED BY:  application program
*
*   WRITTEN BY:  Mark Young
*
*
*************************************************************/

void LN03_set_fill(graphics, bg, override)

X3DGraphics     *graphics;
XColor		*bg;
int		override;
{
}



/************************************************************
*
*  MODULE NAME:  LN03_DrawPolygon
*
*      PURPOSE:  Draw a filled polygon.
*
*        INPUT:  graphics - graphics structure
*	         points   - points to be drawn
*	         size     - number of points
*
*   WRITTEN BY:
*
*
*************************************************************/

void LN03_DrawPolygon(graphics, points, size)

X3DGraphics     *graphics;
XPoint		*points;
int		size;
{
   /* not yet */
}



/************************************************************
*
*  MODULE NAME:  LN03_DrawText
*
*      PURPOSE:  Draw text at the given position.
*
*        INPUT:  graphics - graphics structure
*	         x	  - x position
*	         y	  - y position
*		 font	  - font to be used
*	         text	  - text to be printed
*	         size	  - size of text array
*
*   WRITTEN BY:
*
*
*************************************************************/

void LN03_DrawText(graphics, x, y, font, text, size)

X3DGraphics     *graphics;
char		*font, *text;
int		x, y, size;
{
   /* not yet */
}



/************************************************************
*
*  MODULE NAME:  LN03_FillArc
*
*      PURPOSE: Draw a filled arc.
*
*        INPUT:  graphics - graphics structure
*	         x	  - of upper left corner
*	         y	  - of upper left corner
*	         w	  - width of Arc
*	         h	  - height of Arc
*	         arc1	  - start angle
*	         arc2	  - end angle
*
*   WRITTEN BY:
*
*
*************************************************************/

void LN03_FillArc(graphics, x, y, w, h, ang1, ang2)

X3DGraphics	*graphics;
int		x, y, ang1, ang2;
unsigned int	w, h;
{
   /* just return */
}



/************************************************************
*
*  MODULE NAME:  LN03_FillRectangle
*
*      PURPOSE:  Draw a filled rectangle.
*
*        INPUT:  graphics - graphics structure
*	         x	  - of upper left corner
*	         y	  - of upper left corner
*	         w	  - width of rectangle
*	         h	  - height of rectangle
*
*   WRITTEN BY:
*
*
*************************************************************/

void LN03_FillRectangle(graphics, x, y, w, h)

X3DGraphics     *graphics;
int		x, y, w, h;
{
   /* just return */
}
