 /*
  * Khoros: $Id: vgamth.c,v 1.1 1991/05/10 15:51:07 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vgamth.c,v 1.1 1991/05/10 15:51:07 khoros Exp $";
#endif

 /*
  * $Log: vgamth.c,v $
 * Revision 1.1  1991/05/10  15:51:07  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vgamth.c
 >>>>
 >>>>      Program Name: vgamth
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Generate a binary image by thresholding a color image.
 >>>>	
 >>>>	
 >>>>            Author: Tom Sauer
 >>>>
 >>>> Date Last Updated: Tue Mar  5 22:39:43 1991
 >>>>
 >>>>          Routines: main- the main program for vgamth
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vgamth.h"


/****************************************************************
 *
 * Routine Name:  main program for vgamth
 *
 *       Input:  
 *        -i  input image 
 *        -o  resulting image 
 *        -b  high threshold for map column #1   (0 < value < 255)
 *        -c  low threshold for map column #1   (0 < value < 255)
 *        -d  high threshold for map column #2   (0 < value < 255)
 *        -e  low threshold for map column #2   (0 < value < 255)
 *        -f  high threshold for map column #3   (0 < value < 255)
 *        -g  low threshold for map column #3   (0 < value < 255)
 *        -v  non-zero output value   (0 < value < 255)
 *
 *
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
    struct xvimage *img1, *readimage();
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
    img1 = readimage(vgamth->i_file);
    if (img1 == NULL) exit(1);

    CHECKINPUT(program,img1);   /* Verify input image */
/* -main_before_lib_call_end */

/* -main_library_call */
    if(! lvgamth(img1,vgamth->b_int,vgamth->c_int,vgamth->d_int,vgamth->e_int,
                 vgamth->f_int,vgamth->g_int,vgamth->c_flag,vgamth->b_flag,
                 vgamth->g_flag,vgamth->f_flag,vgamth->e_flag,vgamth->d_flag,
                 vgamth->v_flag, vgamth->v_int))
    {
        (void) fprintf(stderr, "lvgamth Failed\n");
        exit(1);
    }
/* -main_library_call_end */

/* -main_after_lib_call */
    writeimage(vgamth->o_file,img1);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vgamth 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vgamth :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tGenerate a binary image by thresholding a color image.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr,"\t-o  resulting image  (outfile)\n");
	fprintf(stderr,"\t-b  high threshold for map column #1  (integer, 0 to 255)\n");
	fprintf(stderr,"\t-c  low threshold for map column #1  (integer, 0 to 255)\n");
	fprintf(stderr,"\t-d  high threshold for map column #2  (integer, 0 to 255)\n");
	fprintf(stderr,"\t-e  low threshold for map column #2  (integer, 0 to 255)\n");
	fprintf(stderr,"\t-f  high threshold for map column #3  (integer, 0 to 255)\n");
	fprintf(stderr,"\t-g  low threshold for map column #3  (integer, 0 to 255)\n");
	fprintf(stderr,"\t-v  non-zero output value  (integer, 0 to 255)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vgamth\n");
	fprintf(stderr, "\t[-U] Gives the usage for vgamth\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vgamth.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vgamth.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vgamth
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting image \n        {outfile}: "; 
char	*b_pstr = 
	"\nEnter: (b) high threshold for map column #1 \n        {integer, 0 to 255}: "; 
char	*c_pstr = 
	"\nEnter: (c) low threshold for map column #1 \n        {integer, 0 to 255}: "; 
char	*d_pstr = 
	"\nEnter: (d) high threshold for map column #2 \n        {integer, 0 to 255}: "; 
char	*e_pstr = 
	"\nEnter: (e) low threshold for map column #2 \n        {integer, 0 to 255}: "; 
char	*f_pstr = 
	"\nEnter: (f) high threshold for map column #3 \n        {integer, 0 to 255}: "; 
char	*g_pstr = 
	"\nEnter: (g) low threshold for map column #3 \n        {integer, 0 to 255}: "; 
char	*v_pstr = 
	"\nEnter: (v) non-zero output value \n        {integer, 0 to 255}: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vgamth", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vgamth.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vgamth: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vgamth.ans");
		}

	     }

	}

	/*
	 * allocate the vgamth structure
	 */
	vgamth = (vgamth_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vgamth_struct));

	/*
	 * get required arguments for vgamth
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vgamth->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vgamth->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgamth->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vgamth->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vgamth->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgamth->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vgamth->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgamth->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vgamth->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vgamth->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgamth->b_flag = vget_int(fid, prompt_flag,
			"-b", b_pstr, &(vgamth->b_int),
			128, 0, 255)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgamth->b_flag))
		{
		    fprintf(stderr, "\t\tb is required, please re-enter: \n");
		    vgamth->b_flag = vget_int(fid, prompt_flag,
		    "-b", b_pstr, &(vgamth->b_int),
		    128, 0, 255);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-b' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgamth->c_flag = vget_int(fid, prompt_flag,
			"-c", c_pstr, &(vgamth->c_int),
			128, 0, 255)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgamth->c_flag))
		{
		    fprintf(stderr, "\t\tc is required, please re-enter: \n");
		    vgamth->c_flag = vget_int(fid, prompt_flag,
		    "-c", c_pstr, &(vgamth->c_int),
		    128, 0, 255);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-c' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgamth->d_flag = vget_int(fid, prompt_flag,
			"-d", d_pstr, &(vgamth->d_int),
			128, 0, 255)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgamth->d_flag))
		{
		    fprintf(stderr, "\t\td is required, please re-enter: \n");
		    vgamth->d_flag = vget_int(fid, prompt_flag,
		    "-d", d_pstr, &(vgamth->d_int),
		    128, 0, 255);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-d' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgamth->e_flag = vget_int(fid, prompt_flag,
			"-e", e_pstr, &(vgamth->e_int),
			128, 0, 255)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgamth->e_flag))
		{
		    fprintf(stderr, "\t\te is required, please re-enter: \n");
		    vgamth->e_flag = vget_int(fid, prompt_flag,
		    "-e", e_pstr, &(vgamth->e_int),
		    128, 0, 255);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-e' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgamth->f_flag = vget_int(fid, prompt_flag,
			"-f", f_pstr, &(vgamth->f_int),
			128, 0, 255)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgamth->f_flag))
		{
		    fprintf(stderr, "\t\tf is required, please re-enter: \n");
		    vgamth->f_flag = vget_int(fid, prompt_flag,
		    "-f", f_pstr, &(vgamth->f_int),
		    128, 0, 255);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-f' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgamth->g_flag = vget_int(fid, prompt_flag,
			"-g", g_pstr, &(vgamth->g_int),
			128, 0, 255)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgamth->g_flag))
		{
		    fprintf(stderr, "\t\tg is required, please re-enter: \n");
		    vgamth->g_flag = vget_int(fid, prompt_flag,
		    "-g", g_pstr, &(vgamth->g_int),
		    128, 0, 255);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-g' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vgamth->v_flag = vget_int(fid, prompt_flag,
			"-v", v_pstr, &(vgamth->v_int),
			128, 0, 255)))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vgamth->v_flag))
		{
		    fprintf(stderr, "\t\tv is required, please re-enter: \n");
		    vgamth->v_flag = vget_int(fid, prompt_flag,
		    "-v", v_pstr, &(vgamth->v_int),
		    128, 0, 255);

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-v' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}


}



