 /*
  * Khoros: $Id: vstats.c,v 1.3 1991/12/18 09:28:03 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: vstats.c,v 1.3 1991/12/18 09:28:03 dkhoros Exp $";
#endif

 /*
  * $Log: vstats.c,v $
 * Revision 1.3  1991/12/18  09:28:03  dkhoros
 * HellPatch3
 *
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vstats.c
 >>>>
 >>>>      Program Name: vstats
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	vstats computes statistics of an input xviff image.
 >>>>	
 >>>>	

 >>>>            Author: Donna Koechner, John Rasure
 >>>>
 >>>> Date Last Updated: Fri Nov  8 15:26:49 1991
 >>>>
 >>>>          Routines: main- the main program for vstats
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vstats.h"


/****************************************************************
 *
 * Routine Name:  main program for vstats
 *
 *       Input:  
 *        -i  input image 
 *
 *
 *        [-m] statistics operation masking image
 *        [-f] output ASCII file
 *        [-o] VIFF format output file
 *        [-all] if yes, all stats saved
 *        [-mu] if yes, mean is a band of output
 *        [-var] if yes, variance is a band of output
 *        [-sd] if yes, std deviation is a band of output
 *        [-rms] if yes, rms is a band of output
 *        [-vmax] if yes, maximum value is a band of output
 *        [-xmax] if yes, x coord of max value is a band of output
 *        [-ymax] if yes, y coord of max value is a band of output
 *        [-vmin] if yes, minimum value is a band of output
 *        [-xmin] if yes, x coord of min value is a band of output
 *        [-ymin] if yes, y coord of min value is a band of output
 *        [-in] if yes, integral value is a band of output
 *        [-pin] if yes, pos part of integral is a band of output
 *        [-nin] if yes, neg part of integral is a band of output
 *        [-pts] if yes, num contributing pts is a band of output
 *        [-ppts] if yes, num positive pts is a band of output
 *        [-npts] if yes, num negative pts is a band of output
 *        [-sk] if yes, skewness is a band of output
 *        [-kur] if yes, kurtosis is a band of output
 *        [-ent] if yes, entropy is a band of output
 *        [-con] if yes, contrast is a band of output
 *        [-b] if yes, Compute each data band statistics separately
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct xvimage  *img1,*img2,*img3,*createimage(),*readimage();
struct lvstat   **stats, *new_stats;
FILE            *printdev;
int             i, p,
                num_bands,              /* number of bands in input image */
                opt_index,              /* bands index for output image */
                process_dir;            /* 1=bands, 2=combine bands */

int             num_opts;               /* num opts selected for VIFF output */
float           *viff_out;              /* pointer to viff output */
char            *program = "vstats";
char            comment[512];
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
if (check_args()) exit(1);

READINPUT(img1) ;
READMASK(img2) ;
CHECKINPUT(program, img1) ;
MATCHINPUT(program, img1, img2) ;


/*
 * Check to see that at least one stat is specified for the VIFF output file 
 */
if ( vstats->o_flag     && !vstats->all_logic   && !vstats->mu_logic    &&
    !vstats->var_logic  && !vstats->sd_logic    && !vstats->rms_logic   &&
    !vstats->vmin_logic && !vstats->xmin_logic  && !vstats->ymin_logic  &&
    !vstats->vmax_logic && !vstats->xmax_logic  && !vstats->ymax_logic  &&
    !vstats->in_logic   && !vstats->pin_logic   && !vstats->nin_logic   &&
    !vstats->pts_logic  && !vstats->ppts_logic  && !vstats->npts_logic  &&
    !vstats->sk_logic   && !vstats->kur_logic   && !vstats->ent_logic   &&
    !vstats->con_logic )
{
  (void)fprintf(stderr,"%s: If VIFF output file is selected, at least",program);
  (void)fprintf(stderr,"one statistic should be selected\n");
  exit(1);
}

/*
 * If all flag is TRUE and any other stat flag is TRUE, set all flag to FALSE
 */
if (vstats->all_logic   && (vstats->mu_logic   || vstats->var_logic  || 
    vstats->sd_logic    || vstats->rms_logic   || vstats->vmin_logic || 
    vstats->xmin_logic  || vstats->ymin_logic  || vstats->vmax_logic || 
    vstats->xmax_logic  || vstats->ymax_logic  || vstats->in_logic   || 
    vstats->pin_logic   || vstats->nin_logic   || vstats->pts_logic  || 
    vstats->ppts_logic  || vstats->npts_logic  || vstats->sk_logic   || 
    vstats->kur_logic   || vstats->ent_logic   || vstats->con_logic ) )
{
  vstats->all_logic = FALSE;
}

if (vstats->f_flag) 
{
  if (! vwrite_ascii(vstats->f_file, &printdev))
  {
    (void) fprintf(stderr, "%s:  Can't open ascii output file: \\n",program);
    exit(1);
  }
}
else if (!vstats->f_flag && !vstats->o_flag) {
  printdev = stdout;
  vstats->f_flag = TRUE;
}

if (vstats->b_logic == 1)  /* calculate stats of each band separately */
{
  process_dir = 1;      /* DSP_BAND */
  num_bands = img1->num_data_bands;
}
else if (vstats->b_logic == 0)  /* single set of stats for entire file */
{
  process_dir = 2;
  num_bands = 1;
}
else
{
  (void)fprintf(stderr,"%s: unknown band (-b) option value: %d\n",
                program, vstats->b_logic);
  exit(1);
}

stats = (struct lvstat **) malloc(num_bands * sizeof(struct lvstat *));
if (stats == NULL)
{
  (void)fprintf(stderr,"%s: No memory available for statistics structure\n",
                program);
  exit(1);
}

for (i = 0 ; i < num_bands; i++)
{
  stats[i] = (struct lvstat *) malloc(sizeof(struct lvstat));
  if (stats[i] == NULL)
  {
    (void)fprintf(stderr,"%s: No memory available for statistics structure\n",
                  program);
    exit(1);
  }
}
/* -main_before_lib_call_end */

/* -main_library_call */
if (! lvstats(img1,img2,vstats->m_flag,stats,process_dir))
{
  (void) fprintf(stderr,"%s: lvstats Failed\n",program);
  exit(1);
}
/* -main_library_call_end */

/* -main_after_lib_call */
if (vstats->f_flag)
{
  (void) fprintf(printdev,"\nImage Statistics for File Name: %s\n",
                 vstats->i_file);

  if (vstats->m_flag)
  {
    (void) fprintf(printdev,"Masking File Name: %s\n",
                   vstats->m_file);
  }
  (void)fprintf(printdev,"\n");
  
  for (p=0 ; p < num_bands; p++)
  {
    new_stats = stats[p];
    if (vstats->b_logic)
      (void)fprintf(printdev,"\n*******  Statistics for Band #%d  ****** \n\n",
                    p);

    (void) fprintf(printdev,"  Mean: %g\n",new_stats->mean);
    (void) fprintf(printdev,"  Variance: %g\n",new_stats->var);
    (void) fprintf(printdev,"  Std. Dev: %g\n",new_stats->sdev);
    (void) fprintf(printdev,"  RMS:  %g\n",new_stats->rms);
    (void) fprintf(printdev,"  Peaks:\n");

    if ((img1->startx >= 0) || (img1->starty >= 0))
    /* image is a subimage, so print out location of both it and its parent */
    {
      (void) fprintf(printdev,"    High: %g at (X,Y) subimage location: (%d,%d)",
                     new_stats->fmax,new_stats->maxx,new_stats->maxy);
      (void) fprintf(printdev,": image location: (%d,%d)\n",
                     (new_stats->maxx + img1->startx),
                     (new_stats->maxy + img1->starty));
      (void) fprintf(printdev,"    Low : %g at (X,Y) subimage location: (%d,%d)",
                     new_stats->fmin,new_stats->minx,new_stats->miny);
      (void) fprintf(printdev,": image location: (%d,%d)\n",
                     (new_stats->minx + img1->startx),
                     (new_stats->miny + img1->starty));
    }
    else         /* image is not a subimage */
    {
      (void) fprintf(printdev,"    High: %g at (X,Y) location: (%d,%d)\n",
                     new_stats->fmax,new_stats->maxx,new_stats->maxy);
      (void) fprintf(printdev,"    Low : %g at (X,Y) location: (%d,%d)\n",
                     new_stats->fmin,new_stats->minx,new_stats->miny);
    }

    (void) fprintf(printdev,"  Total integral under the image: %g\n",
                   new_stats->integ);
    (void) fprintf(printdev,"  Positive part of integral under the image: %g\n",
                   new_stats->pinteg);
    (void) fprintf(printdev,"  Negative part of integral under the image: %g\n",
                   new_stats->ninteg);
    (void) fprintf(printdev,"  Contributing points: %d\n",new_stats->cpts);
    (void) fprintf(printdev,"  Number of positive points in image: %d\n",
                   new_stats->pos);
    (void) fprintf(printdev,"  Number of negative points in image: %d\n",
                   new_stats->neg);
    if(new_stats->var == 0){
      (void) fprintf(printdev,"  Skewness:  Not calculated (variance = 0)\n");
      (void) fprintf(printdev,"  Kurtosis:  Not calculated (variance = 0)\n");
    }
    else {
      (void) fprintf(printdev,"  Skewness:  %g\n",new_stats->skewness);
      (void) fprintf(printdev,"  Kurtosis:  %g\n",new_stats->kurtosis);
    }
    if ( img1->data_storage_type == VFF_TYP_1_BYTE)
    {
      (void) fprintf(printdev,"  Entropy:  %g\n",new_stats->entropy);
      (void) fprintf(printdev,"  Contrast:  %g\n",new_stats->contrast);
    }
  }
}

if (vstats->o_flag)  /* if VIFF output file was specified */
{
  img3 = createimage((unsigned long) 1,                 /* col_size */
                     (unsigned long) num_bands,         /* row_size */
                     (unsigned long) VFF_TYP_FLOAT,     /* data_storage_type */
                     (unsigned long) 1,                 /* num_of_images */
                     (unsigned long) ALL_OPTS,          /* num_data_bands */
                     comment,                           /* comment */
                     (unsigned long) 0,                 /* map_row_size */
                     (unsigned long) 0,                 /* map_col_size */
                     (unsigned long) VFF_MS_NONE,       /* map_scheme */
                     (unsigned long) VFF_MAPTYP_NONE,   /* map_storage_type */
                     (unsigned long) VFF_LOC_IMPLICIT,  /* location_type */
                     (unsigned long) 0                  /* location_dim */
                    );

  if (img3 == NULL)
  {
    (void) fprintf(stderr,"%s: output file allocation failed\n",program);
    exit(1);
  }

  (void)sprintf(comment,"Image Statistics for File:  %s\n",
                vbasename(vstats->i_file));
  append_comment(img3->comment, comment);

  if(vstats->m_flag)
  {
    (void)sprintf(comment,"Masking File:  %s\n", vbasename(vstats->m_file));
    append_comment(img3->comment, comment);
  }

  append_comment(img3->comment, "\n");

  num_opts = 0;
    
  if(vstats->all_logic || vstats->mu_logic)        
  {
    (void)sprintf(comment,"Band %2d: Mean\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(vstats->all_logic || vstats->var_logic)
  {
    (void)sprintf(comment,"Band %2d: Variance\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(vstats->all_logic || vstats->sd_logic)
  {
    (void)sprintf(comment,"Band %2d: Std Dev\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(vstats->all_logic || vstats->rms_logic)
  {
    (void)sprintf(comment,"Band %2d: RMS\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(vstats->all_logic || vstats->vmax_logic)
  {
    (void)sprintf(comment,"Band %2d: Max Val\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(vstats->all_logic || vstats->xmax_logic)
  {
    (void)sprintf(comment,"Band %2d: X Pos of Max Val\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(vstats->all_logic || vstats->ymax_logic)
  {
    (void)sprintf(comment,"Band %2d: Y Pos of Max Val\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(vstats->all_logic || vstats->vmin_logic)
  {
    (void)sprintf(comment,"Band %2d: Min Val\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(vstats->all_logic || vstats->xmin_logic)
  {
    (void)sprintf(comment,"Band %2d: X Pos of Min Val\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(vstats->all_logic || vstats->ymin_logic)
  {
    (void)sprintf(comment,"Band %2d: Y Pos of Min Val\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(vstats->all_logic || vstats->in_logic)
  {
    (void)sprintf(comment,"Band %2d: Total Integral\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(vstats->all_logic || vstats->pin_logic)
  {
    (void)sprintf(comment,"Band %2d: Pos Part of Integ\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(vstats->all_logic || vstats->nin_logic)
  {
    (void)sprintf(comment,"Band %2d: Neg Part of Integ\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(vstats->all_logic || vstats->pts_logic)
  {
    (void)sprintf(comment,"Band %2d: Total Contrib Pts\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(vstats->all_logic || vstats->ppts_logic)
  {
    (void)sprintf(comment,"Band %2d: Pos Contrib Pts\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(vstats->all_logic || vstats->npts_logic)
  {
    (void)sprintf(comment,"Band %2d: Neg Contrib Pts\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(vstats->all_logic || vstats->sk_logic)
  {
    (void)sprintf(comment,"Band %2d: Skewness\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(vstats->all_logic || vstats->kur_logic)
  {
    (void)sprintf(comment,"Band %2d: Kurtosis\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(vstats->all_logic || vstats->ent_logic)
  {
    (void)sprintf(comment,"Band %2d: Entropy\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  if(vstats->all_logic || vstats->con_logic)
  {
    (void)sprintf(comment,"Band %2d: Contrast\n",num_opts);
    append_comment(img3->comment, comment);
    num_opts ++;
  }

  img3->num_data_bands = num_opts;

 /*
  * allocate for float array to contain stat data 
  */

  viff_out = (float *)malloc((unsigned int)(num_opts * num_bands 
              * sizeof(float)));
  if (viff_out == NULL)
  {
    (void)fprintf(stderr,"%s: cannot allocate for output info\n");
  }

  for (i=0; i<num_bands; i++)
  {
    opt_index = 0;
    new_stats = stats[i];

    if (vstats->all_logic || vstats->mu_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->mean;
      opt_index ++;
    }

    if (vstats->all_logic || vstats->var_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->var;
      opt_index ++;
    }

    if (vstats->all_logic || vstats->sd_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->sdev;
      opt_index ++;
    }

    if (vstats->all_logic || vstats->rms_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->rms;
      opt_index ++;
    }

    if (vstats->all_logic || vstats->vmax_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->fmax;
      opt_index ++;
    }

    if (vstats->all_logic || vstats->xmax_logic)
    {
      viff_out[i + (opt_index*num_bands)] = (float) new_stats->maxx;
      opt_index ++;
    }

    if (vstats->all_logic || vstats->ymax_logic)
    {
      viff_out[i + (opt_index*num_bands)] = (float) new_stats->maxy;
      opt_index ++;
    }

    if (vstats->all_logic || vstats->vmin_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->fmin;
      opt_index ++;
    }

    if (vstats->all_logic || vstats->xmin_logic)
    {
      viff_out[i + (opt_index*num_bands)] = (float) new_stats->minx;
      opt_index ++;
    }

    if (vstats->all_logic || vstats->ymin_logic)
    {
      viff_out[i + (opt_index*num_bands)] = (float) new_stats->miny;
      opt_index ++;
    }

    if (vstats->all_logic || vstats->in_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->integ;
      opt_index ++;
    }

    if (vstats->all_logic || vstats->pin_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->pinteg;
      opt_index ++;
    }

    if (vstats->all_logic || vstats->nin_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->ninteg;
      opt_index ++;
    }

    if (vstats->all_logic || vstats->pts_logic)
    {
      viff_out[i + (opt_index*num_bands)] = (float) new_stats->cpts;
      opt_index ++;
    }

    if (vstats->all_logic || vstats->ppts_logic)
    {
      viff_out[i + (opt_index*num_bands)] = (float) new_stats->pos;
      opt_index ++;
    }

    if (vstats->all_logic || vstats->npts_logic)
    {
      viff_out[i + (opt_index*num_bands)] = (float) new_stats->neg;
      opt_index ++;
    }

    if (vstats->all_logic || vstats->sk_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->skewness;
      opt_index ++;
    }

    if (vstats->all_logic || vstats->kur_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->kurtosis;
      opt_index ++;
    }

    if (vstats->all_logic || vstats->ent_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->entropy;
      opt_index ++;
    }

    if (vstats->all_logic || vstats->con_logic)
    {
      viff_out[i + (opt_index*num_bands)] = new_stats->contrast;
      opt_index ++;
    }

  }  /* end of for loop throught image bands */


  img3->imagedata = (char *)viff_out;

  writeimage(vstats->o_file,img3);


}  /* end or writing stat data to output file */

for (i=0; i<num_bands; i++)       
{
  free((struct lvstat *)stats[i]);
}
free((struct lvstat **)stats);
if (vstats->f_flag == TRUE && printdev != stdout) fclose(printdev);
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vstats 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vstats :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tvstats computes statistics of an input xviff image.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-m]  statistics operation masking image (infile) [null]\n");
	fprintf(stderr,"\t[-f]  output ASCII file (outfile) [null]\n");
	fprintf(stderr,"\t[-o]  VIFF format output file (outfile) [null]\n");
	fprintf(stderr,"\t[-all]  if yes, all stats saved (boolean) [true]\n");
	fprintf(stderr,"\t[-mu]  if yes, mean is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-var]  if yes, variance is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-sd]  if yes, std deviation is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-rms]  if yes, rms is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-vmax]  if yes, maximum value is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-xmax]  if yes, x coord of max value is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-ymax]  if yes, y coord of max value is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-vmin]  if yes, minimum value is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-xmin]  if yes, x coord of min value is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-ymin]  if yes, y coord of min value is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-in]  if yes, integral value is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-pin]  if yes, pos part of integral is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-nin]  if yes, neg part of integral is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-pts]  if yes, num contributing pts is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-ppts]  if yes, num positive pts is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-npts]  if yes, num negative pts is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-sk]  if yes, skewness is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-kur]  if yes, kurtosis is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-ent]  if yes, entropy is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-con]  if yes, contrast is a band of output (boolean) [false]\n");
	fprintf(stderr,"\t[-b]  if yes, Compute each data band statistics separately (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vstats\n");
	fprintf(stderr, "\t[-U] Gives the usage for vstats\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vstats.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vstats.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vstats
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image \n        {infile}: "; 
char	*m_pstr = 
	"\nEnter: (m) statistics operation masking image \n        {infile}: "; 
char	*f_pstr = 
	"\nEnter: (f) output ASCII file \n        {outfile}: "; 
char	*o_pstr = 
	"\nEnter: (o) VIFF format output file \n        {outfile}: "; 
char	*all_pstr = 
	"\nEnter: (all) if yes, all stats saved \n        {boolean, (y/n)  [yes] }: "; 
char	*mu_pstr = 
	"\nEnter: (mu) if yes, mean is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*var_pstr = 
	"\nEnter: (var) if yes, variance is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*sd_pstr = 
	"\nEnter: (sd) if yes, std deviation is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*rms_pstr = 
	"\nEnter: (rms) if yes, rms is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*vmax_pstr = 
	"\nEnter: (vmax) if yes, maximum value is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*xmax_pstr = 
	"\nEnter: (xmax) if yes, x coord of max value is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*ymax_pstr = 
	"\nEnter: (ymax) if yes, y coord of max value is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*vmin_pstr = 
	"\nEnter: (vmin) if yes, minimum value is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*xmin_pstr = 
	"\nEnter: (xmin) if yes, x coord of min value is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*ymin_pstr = 
	"\nEnter: (ymin) if yes, y coord of min value is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*in_pstr = 
	"\nEnter: (in) if yes, integral value is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*pin_pstr = 
	"\nEnter: (pin) if yes, pos part of integral is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*nin_pstr = 
	"\nEnter: (nin) if yes, neg part of integral is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*pts_pstr = 
	"\nEnter: (pts) if yes, num contributing pts is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*ppts_pstr = 
	"\nEnter: (ppts) if yes, num positive pts is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*npts_pstr = 
	"\nEnter: (npts) if yes, num negative pts is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*sk_pstr = 
	"\nEnter: (sk) if yes, skewness is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*kur_pstr = 
	"\nEnter: (kur) if yes, kurtosis is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*ent_pstr = 
	"\nEnter: (ent) if yes, entropy is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*con_pstr = 
	"\nEnter: (con) if yes, contrast is a band of output \n        {boolean, (y/n)  [no] }: "; 
char	*b_pstr = 
	"\nEnter: (b) if yes, Compute each data band statistics separately \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vstats", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vstats.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vstats: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vstats.ans");
		}

	     }

	}

	/*
	 * allocate the vstats structure
	 */
	vstats = (vstats_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vstats_struct));

	/*
	 * get required arguments for vstats
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vstats->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vstats->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vstats->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vstats->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vstats->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vstats
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vstats->m_flag = vget_infile(fid, prompt_flag,
	"-m", m_pstr, &(vstats->m_file))
;

	vstats->f_flag = vget_outfile(fid, prompt_flag,
	"-f", f_pstr, &(vstats->f_file))
;

	vstats->o_flag = vget_outfile(fid, prompt_flag,
	"-o", o_pstr, &(vstats->o_file))
;

	vstats->all_flag = vget_logic(fid, prompt_flag,
	"-all", all_pstr, &(vstats->all_logic), 1);

	vstats->mu_flag = vget_logic(fid, prompt_flag,
	"-mu", mu_pstr, &(vstats->mu_logic), 0);

	vstats->var_flag = vget_logic(fid, prompt_flag,
	"-var", var_pstr, &(vstats->var_logic), 0);

	vstats->sd_flag = vget_logic(fid, prompt_flag,
	"-sd", sd_pstr, &(vstats->sd_logic), 0);

	vstats->rms_flag = vget_logic(fid, prompt_flag,
	"-rms", rms_pstr, &(vstats->rms_logic), 0);

	vstats->vmax_flag = vget_logic(fid, prompt_flag,
	"-vmax", vmax_pstr, &(vstats->vmax_logic), 0);

	vstats->xmax_flag = vget_logic(fid, prompt_flag,
	"-xmax", xmax_pstr, &(vstats->xmax_logic), 0);

	vstats->ymax_flag = vget_logic(fid, prompt_flag,
	"-ymax", ymax_pstr, &(vstats->ymax_logic), 0);

	vstats->vmin_flag = vget_logic(fid, prompt_flag,
	"-vmin", vmin_pstr, &(vstats->vmin_logic), 0);

	vstats->xmin_flag = vget_logic(fid, prompt_flag,
	"-xmin", xmin_pstr, &(vstats->xmin_logic), 0);

	vstats->ymin_flag = vget_logic(fid, prompt_flag,
	"-ymin", ymin_pstr, &(vstats->ymin_logic), 0);

	vstats->in_flag = vget_logic(fid, prompt_flag,
	"-in", in_pstr, &(vstats->in_logic), 0);

	vstats->pin_flag = vget_logic(fid, prompt_flag,
	"-pin", pin_pstr, &(vstats->pin_logic), 0);

	vstats->nin_flag = vget_logic(fid, prompt_flag,
	"-nin", nin_pstr, &(vstats->nin_logic), 0);

	vstats->pts_flag = vget_logic(fid, prompt_flag,
	"-pts", pts_pstr, &(vstats->pts_logic), 0);

	vstats->ppts_flag = vget_logic(fid, prompt_flag,
	"-ppts", ppts_pstr, &(vstats->ppts_logic), 0);

	vstats->npts_flag = vget_logic(fid, prompt_flag,
	"-npts", npts_pstr, &(vstats->npts_logic), 0);

	vstats->sk_flag = vget_logic(fid, prompt_flag,
	"-sk", sk_pstr, &(vstats->sk_logic), 0);

	vstats->kur_flag = vget_logic(fid, prompt_flag,
	"-kur", kur_pstr, &(vstats->kur_logic), 0);

	vstats->ent_flag = vget_logic(fid, prompt_flag,
	"-ent", ent_pstr, &(vstats->ent_logic), 0);

	vstats->con_flag = vget_logic(fid, prompt_flag,
	"-con", con_pstr, &(vstats->con_logic), 0);

	vstats->b_flag = vget_logic(fid, prompt_flag,
	"-b", b_pstr, &(vstats->b_logic), 1);


}



