 /*
  * Khoros: $Id: venhance.h,v 1.1 1991/05/10 15:49:22 khoros Exp $
  */

 /*
  * $Log: venhance.h,v $
 * Revision 1.1  1991/05/10  15:49:22  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: venhance.h
 >>>>            Author: Marcelo Teran
 >>>> Date Last Updated: Tue Mar  5 22:32:44 1991
 >>>> 
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/

#ifndef _venhance_h_
#define _venhance_h_

#include "vinclude.h"


/* -include_includes */
/* -include_includes_end */

char	**av,		/* argv and argc used by gparams */
	*program,	/* a pointer to the program name argv[0] */
	*calloc();
int	ac;

/****************************************************************
*
*                    venhance Argument Structure
*
****************************************************************/

typedef struct _venhance  {

/*
 *  input image filename (Required infile)
 */
char	*i_file;	/* input image filename FILENAME */
int	 i_flag;	/* input image filename FLAG */

/*
 *  output image filename (Required outfile)
 */
char	*o_file;	/* output image filename FILENAME */
int	 o_flag;	/* output image filename FLAG */

/*
 *  window width of local area (Required integer)
 */
int	 w_int; 	/* window width of local area INT */
int	 w_flag;	/* window width of local area FLAG */

/*
 *  window height of local area (Required integer)
 */
int	 h_int; 	/* window height of local area INT */
int	 h_flag;	/* window height of local area FLAG */

/*
 *  specifies scale factor (Required float)
 */
float	 k_float;	/* specifies scale factor FLOAT */
int	 k_flag;   	/* specifies scale factor FLAG */

/*
 *  specifies minimum standard deviation (Required float)
 */
float	 v_float;	/* specifies minimum standard deviation FLOAT */
int	 v_flag;   	/* specifies minimum standard deviation FLAG */

}  venhance_struct;

venhance_struct *venhance;

/* -include_additions */
/* -include_additions_end */

/* -include_macros */
/*
The following define checks for proper values of:
num_of_images = 1
num_data_bands = 1
data_storage_type = VFF_TYP_1_BYTE
map_enable = VFF_MAP_OPTIONAL
*/

#define CHECKINPUT(program, img1) \
        (void) proper_num_images(program,img1,1,TRUE); \
        \
        (void) proper_num_bands(program,img1,1,TRUE); \
        \
        (void) propertype(program,img1,VFF_TYP_1_BYTE,TRUE); \
        \
        (void) proper_map_enable(program,img1,VFF_MAP_OPTIONAL,TRUE)
/* -include_macros_end */

#endif
